/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.IOException;
import java.io.InputStream;

final class MessageClientKeyExchangeRSA
extends HandshakeMessage {
    private byte[] encryptedSecret;
    private ProtocolVersion protocolVersion;

    MessageClientKeyExchangeRSA(byte[] byArray, ProtocolVersion protocolVersion) {
        this.encryptedSecret = byArray;
        this.protocolVersion = protocolVersion;
    }

    MessageClientKeyExchangeRSA(InputStream inputStream, ProtocolVersion protocolVersion) throws IOException {
        if (protocolVersion.equals(ProtocolVersion.TLS10)) {
            this.encryptedSecret = Util.readBytesLength16(inputStream, maxClientKeyExchangeMessageLength);
            if (this.encryptedSecret == null) {
                throw new IOException(Resources.getMessage("279"));
            }
        } else {
            this.encryptedSecret = new byte[inputStream.available()];
            Util.readFully(this.encryptedSecret, inputStream);
        }
    }

    void initMessage() {
        this.initBuffer(48);
        try {
            if (this.protocolVersion.equals(ProtocolVersion.TLS10)) {
                Util.writeBytesLength16(this.encryptedSecret, this.buffer);
            } else {
                this.buffer.write(this.encryptedSecret);
            }
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    byte[] getEncryptedSecret() {
        return this.encryptedSecret;
    }

    int getHandshakeType() {
        return 16;
    }
}

