/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.ciphersuite.CipherSuites;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.MapCipher;
import com.certicom.tls.record.handshake.MessageSSL2Error;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;

final class MessageClientMasterKey
extends HandshakeMessage {
    private HandshakeHandler handler;
    private PublicKey peerKey;
    private byte[] secret;
    private int cipher;
    private byte[] clear_key = null;
    private byte[] encrypted_key = null;
    private byte[] iv_key = null;

    MessageClientMasterKey(HandshakeHandler handshakeHandler, PublicKey publicKey) {
        this.handler = handshakeHandler;
        this.peerKey = publicKey;
    }

    MessageClientMasterKey(ByteArrayInputStream byteArrayInputStream) throws IOException, IllegalArgumentException, HandshakeWouldBlockException {
        int n = Util.readUInt24(byteArrayInputStream);
        this.cipher = MapCipher.mapCipherToTLS(n);
        CipherSuite cipherSuite = CipherSuites.TLS_NULL_WITH_NULL_NULL;
        try {
            cipherSuite = CipherSuiteSupport.getCipherSuite(this.cipher);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.handleError();
        }
        int n2 = Util.readUInt16(byteArrayInputStream);
        int n3 = Util.readUInt16(byteArrayInputStream);
        int n4 = Util.readUInt16(byteArrayInputStream);
        if (n2 > 16 || n3 > maxSSL2MasterKeyComponentLength || n4 > 8) {
            throw new IOException(Resources.getMessage("279"));
        }
        this.clear_key = new byte[n2];
        Util.readFully(this.clear_key, byteArrayInputStream);
        this.encrypted_key = new byte[n3];
        Util.readFully(this.encrypted_key, byteArrayInputStream);
        this.iv_key = new byte[n4];
        Util.readFully(this.iv_key, byteArrayInputStream);
    }

    void setClientMasterKey(HandshakeHandler handshakeHandler, PrivateKey privateKey) throws IOException, IllegalArgumentException, InvalidKeyException, HandshakeWouldBlockException {
        Object object;
        int n;
        int n2;
        boolean bl = false;
        CipherSuite cipherSuite = CipherSuites.TLS_NULL_WITH_NULL_NULL;
        try {
            cipherSuite = CipherSuiteSupport.getCipherSuite(this.cipher);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.handleError();
        }
        Vector vector = handshakeHandler.getConnectionImpl().getEnabledCipherSuitesVector();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            if (!vector.contains(cipherSuite)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.handleError();
        }
        n2 = cipherSuite.getCipherKeyLength() - cipherSuite.getCipherKeyMaterialLength();
        if (cipherSuite.equals(CipherSuites.TLS_RSA_WITH_RC4_128_MD5) && this.clear_key.length != 0 || cipherSuite.equals(CipherSuites.TLS_RSA_EXPORT_WITH_RC4_40_MD5) && this.clear_key.length != n2) {
            handshakeHandler.fireSSL2ErrorException(Resources.getMessage("244") + Resources.getMessage("247"));
        }
        if (this.encrypted_key.length != (n = (((RSAPrivateKey)privateKey).getModulus().bitLength() + 7) / 8)) {
            handshakeHandler.fireSSL2ErrorException(Resources.getMessage("244") + Resources.getMessage("248"));
        }
        if (this.iv_key.length != 0) {
            handshakeHandler.fireSSL2ErrorException(Resources.getMessage("244") + Resources.getMessage("249"));
        }
        byte[] byArray = null;
        try {
            object = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            SecureRandom secureRandom = TLSSystem.getRandomNumberGenerator();
            ((Cipher)object).init(2, (Key)privateKey, secureRandom);
            byArray = ((Cipher)object).doFinal(this.encrypted_key, 0, this.encrypted_key.length);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        ProtocolVersion protocolVersion = handshakeHandler.getProtocolVersion();
        object = handshakeHandler.removePKCS1Padding(byArray);
        if (this.clear_key.length + ((Object)object).length != cipherSuite.getCipherKeyLength()) {
            handshakeHandler.fireSSL2ErrorException(Resources.getMessage("244") + Resources.getMessage("250"));
        }
        this.secret = new byte[this.clear_key.length + ((Object)object).length + this.iv_key.length];
        System.arraycopy(this.clear_key, 0, this.secret, 0, this.clear_key.length);
        System.arraycopy(object, 0, this.secret, this.clear_key.length, ((Object)object).length);
        System.arraycopy(this.iv_key, 0, this.secret, this.clear_key.length + ((Object)object).length, this.iv_key.length);
        handshakeHandler.setPremasterSecret(this.secret);
        handshakeHandler.setMasterSecret(this.secret);
    }

    private void handleError() throws IOException, HandshakeWouldBlockException {
        MessageSSL2Error messageSSL2Error = new MessageSSL2Error(1);
        this.handler.write(messageSSL2Error);
        this.handler.flush();
        this.handler.handleSSL2Error(2, 1);
    }

    void initMessage() {
        try {
            byte[] byArray;
            Object object;
            CipherSuite cipherSuite = this.handler.getPendingCipherSuite();
            ProtocolVersion protocolVersion = this.handler.getProtocolVersion();
            this.cipher = cipherSuite.getTag();
            int n = MapCipher.mapCipherToSSL2(this.cipher);
            int n2 = cipherSuite.getCipherKeyLength();
            int n3 = 0;
            int n4 = cipherSuite.getCipherKeyMaterialLength();
            int n5 = n2 - n4;
            int n6 = (((RSAPublicKey)this.peerKey).getModulus().bitLength() + 7) / 8;
            byte[] byArray2 = new byte[n2 + n3];
            TLSSystem.getRandomNumberGenerator().nextBytes(byArray2);
            this.handler.setPremasterSecret(byArray2);
            this.handler.generateMasterSecret();
            byte[] byArray3 = new byte[n5];
            System.arraycopy(byArray2, 0, byArray3, 0, n5);
            byte[] byArray4 = new byte[n4];
            System.arraycopy(byArray2, n5, byArray4, 0, n4);
            this.initBufferVersion2(9 + n5 + n6 + n3);
            Util.writeUInt24(n, this.buffer);
            Util.writeUInt16(n5, this.buffer);
            Util.writeUInt16(n6, this.buffer);
            Util.writeUInt16(n3, this.buffer);
            this.buffer.write(byArray3);
            if (this.handler.getHelloProtocol().equals(ProtocolVersion.SSL20)) {
                byte[] byArray5 = byArray4;
                object = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                ((Cipher)object).init(1, (Key)this.peerKey, TLSSystem.getRandomNumberGenerator());
                byArray = ((Cipher)object).doFinal(byArray5, 0, byArray5.length);
            } else {
                byte[] byArray6 = this.handler.addPKCS1Type2Padding(n6, byArray4);
                object = Cipher.getInstance("RSA/ECB/NoPadding");
                ((Cipher)object).init(1, (Key)this.peerKey, TLSSystem.getRandomNumberGenerator());
                byArray = ((Cipher)object).doFinal(byArray6, 0, byArray6.length);
            }
            this.buffer.write(byArray);
            object = new byte[n3];
            System.arraycopy(byArray2, n2, object, 0, n3);
            this.buffer.write((byte[])object);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            WeblogicHandler.debugEaten(invalidKeyException);
        }
        catch (HandshakeWouldBlockException handshakeWouldBlockException) {
            WeblogicHandler.debugEaten(handshakeWouldBlockException);
        }
    }

    byte[] getSecret() {
        return this.secret;
    }

    int getCipherSuiteTag() {
        return this.cipher;
    }

    int getHandshakeType() {
        return 2;
    }

    public int getMessageType() {
        return 0;
    }
}

