/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.record.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

final class MessageRandom {
    private byte[] randomBytes;

    MessageRandom(InputStream inputStream) throws IOException {
        this.randomBytes = new byte[32];
        Util.readFully(this.randomBytes, inputStream);
    }

    MessageRandom(byte[] byArray) {
        this.randomBytes = byArray;
    }

    MessageRandom() {
        this.initialize(32);
    }

    MessageRandom(int n) {
        this.initialize(n);
    }

    byte[] getRandomBytes() {
        return this.randomBytes;
    }

    private void initialize(int n) {
        try {
            byte[] byArray = new byte[n - 4];
            TLSSystem.getRandomNumberGenerator().nextBytes(byArray);
            long l = System.currentTimeMillis() / 1000L;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
            byteArrayOutputStream.write(Util.toUInt32((int)l));
            byteArrayOutputStream.write(byArray);
            this.randomBytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    byte[] toByteArray() {
        return this.getRandomBytes();
    }
}

