/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.MessageRandom;
import java.io.IOException;
import java.io.InputStream;

final class MessageServerHello
extends HandshakeMessage {
    private SessionID sessionID;
    private int cipherSuiteTag;
    private MessageRandom random;
    private ProtocolVersion protocolVersion;

    MessageServerHello(SessionID sessionID, int n, MessageRandom messageRandom, ProtocolVersion protocolVersion) {
        this.sessionID = sessionID;
        this.cipherSuiteTag = n;
        this.random = messageRandom;
        this.protocolVersion = protocolVersion;
    }

    MessageServerHello(InputStream inputStream) throws IOException {
        this.protocolVersion = new ProtocolVersion(inputStream);
        this.random = new MessageRandom(inputStream);
        this.sessionID = new SessionID(inputStream);
        this.cipherSuiteTag = inputStream.read() << 8;
        this.cipherSuiteTag |= inputStream.read();
        inputStream.read();
    }

    void initMessage() {
        this.initBuffer(68);
        try {
            byte[] byArray = this.protocolVersion.toByteArray();
            byte[] byArray2 = this.random.toByteArray();
            byte[] byArray3 = this.sessionID.toByteArray();
            this.buffer.write(byArray);
            this.buffer.write(byArray2);
            this.buffer.write(byArray3);
            this.buffer.write(this.cipherSuiteTag >> 8);
            this.buffer.write(this.cipherSuiteTag);
            this.buffer.write(0);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    SessionID getSessionID() {
        return this.sessionID;
    }

    MessageRandom getRandom() {
        return this.random;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    int getCipherSuiteTag() {
        return this.cipherSuiteTag;
    }

    int getHandshakeType() {
        return 2;
    }
}

