/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.MapCipher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;

final class MessageServerHelloVersion2
extends HandshakeMessage {
    private byte[] ConnectionID;
    private int cipherSuiteTag;
    private ProtocolVersion protocolVersion = new ProtocolVersion(0, 2);
    private int session_ID_hit;
    private int cert_length;
    private int cipher_spec_length = 0;
    private CipherSuite[] cipherSuites;
    private int CertificateType;
    private X509Certificate ServerCertificate;

    MessageServerHelloVersion2(byte[] byArray, int n, CipherSuite[] cipherSuiteArray, X509Certificate x509Certificate) {
        this.ConnectionID = byArray;
        this.cipherSuites = cipherSuiteArray;
        this.session_ID_hit = n;
        this.ServerCertificate = x509Certificate;
    }

    boolean IsValidConnectionID(int n) {
        return n > 15 && n < 33;
    }

    MessageServerHelloVersion2(InputStream inputStream, Vector vector) throws IOException {
        this.session_ID_hit = inputStream.read();
        this.CertificateType = Util.readUInt8(inputStream);
        this.protocolVersion = new ProtocolVersion(inputStream);
        int n = Util.readUInt16(inputStream);
        int n2 = Util.readUInt16(inputStream);
        int n3 = Util.readUInt16(inputStream);
        if (!this.IsValidConnectionID(n3)) {
            throw new IOException("ConnectionID length invalid");
        }
        if (n > 0) {
            try {
                byte[] byArray = new byte[n];
                Util.readFully(byArray, inputStream);
                this.ServerCertificate = new X509V3CertImpl(byArray);
            }
            catch (CertificateException certificateException) {
                WeblogicHandler.debugEaten(certificateException);
                throw new IOException(certificateException.getMessage());
            }
        }
        Vector<CipherSuite> vector2 = new Vector<CipherSuite>(n2 / 3);
        for (int i = 0; i < n2; i += 3) {
            try {
                int n4 = Util.readUInt24(inputStream);
                CipherSuite cipherSuite = CipherSuiteSupport.getCipherSuite(MapCipher.mapCipherToTLS(n4));
                if (!vector.contains(cipherSuite)) continue;
                vector2.addElement(cipherSuite);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
        }
        this.cipherSuites = new CipherSuite[vector2.size()];
        vector2.copyInto(this.cipherSuites);
        this.ConnectionID = new byte[n3];
        Util.readFully(this.ConnectionID, inputStream);
    }

    int getHandshakeType() {
        return 4;
    }

    public int getMessageType() {
        return 0;
    }

    byte[] getConnectionID() {
        return this.ConnectionID;
    }

    int getCertificateType() {
        return this.CertificateType;
    }

    CipherSuite[] getCipherSuites() {
        return this.cipherSuites;
    }

    public X509Certificate getCertificateChain() {
        return this.ServerCertificate;
    }

    int getSession_ID_hit() {
        return this.session_ID_hit;
    }

    void initMessage() {
        int n = 11 + this.ConnectionID.length + this.cert_length + this.cipher_spec_length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        int n2 = 0;
        this.initBufferVersion2(n);
        try {
            this.buffer.write(this.session_ID_hit);
            if (this.session_ID_hit != 0) {
                this.buffer.write(0);
            } else {
                this.buffer.write(1);
            }
            if (this.session_ID_hit == 0) {
                byArray = new byte[n];
                byArray = this.ServerCertificate.getEncoded();
                n2 = byArray.length;
                for (int i = 0; i < this.cipherSuites.length; ++i) {
                    int n3 = MapCipher.mapCipherToSSL2(this.cipherSuites[i].getTag());
                    Util.writeUInt24(n3, byteArrayOutputStream);
                }
            }
            this.buffer.write(this.protocolVersion.toByteArray());
            Util.writeUInt16(n2, this.buffer);
            Util.writeUInt16(byteArrayOutputStream.size(), this.buffer);
            Util.writeUInt16(this.ConnectionID.length, this.buffer);
            if (n2 != 0) {
                this.buffer.write(byArray);
            }
            if (byteArrayOutputStream.size() != 0) {
                this.buffer.write(byteArrayOutputStream.toByteArray());
            }
            this.buffer.write(this.ConnectionID);
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
        }
    }
}

