/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.spec.DHParameters;
import com.certicom.tls.provider.spec.DHPublicKey;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

final class MessageServerKeyExchangeDH
extends HandshakeMessage {
    private DHPublicKey key;
    private DHParameters params;
    private BigInteger p;
    private BigInteger g;
    private BigInteger y;
    private byte[] message;
    private byte[] signature;

    MessageServerKeyExchangeDH(byte[] byArray, byte[] byArray2) {
        this.message = byArray;
        this.signature = byArray2;
    }

    MessageServerKeyExchangeDH(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byArray = Util.readBytesLength16(byteArrayInputStream, maxServerKeyExchangeComponentLength);
        if (byArray == null) {
            throw new IOException(Resources.getMessage("280"));
        }
        byArray2 = Util.readBytesLength16(byteArrayInputStream, maxServerKeyExchangeComponentLength);
        if (byArray2 == null) {
            throw new IOException(Resources.getMessage("280"));
        }
        byArray3 = Util.readBytesLength16(byteArrayInputStream, maxServerKeyExchangeComponentLength);
        if (byArray3 == null) {
            throw new IOException(Resources.getMessage("280"));
        }
        this.p = new BigInteger(1, byArray);
        this.g = new BigInteger(1, byArray2);
        this.y = new BigInteger(1, byArray3);
        byteArrayInputStream.reset();
        this.message = new byte[byArray.length + byArray2.length + byArray3.length + 6];
        Util.readFully(this.message, byteArrayInputStream);
        if (byteArrayInputStream.available() > 0) {
            this.signature = Util.readBytesLength16(byteArrayInputStream, maxServerKeyExchangeComponentLength);
            if (this.signature == null) {
                throw new IOException(Resources.getMessage("280"));
            }
        }
        this.key = new DHPublicKey(this.y, this.p, this.g);
        this.params = new DHParameters(this.p, this.g);
    }

    void initMessage() {
        try {
            this.initBuffer(this.message.length + this.signature.length);
            this.buffer.write(this.message);
            this.buffer.write(this.signature);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    BigInteger getP() {
        return this.p;
    }

    BigInteger getG() {
        return this.g;
    }

    BigInteger getY() {
        return this.y;
    }

    DHPublicKey getDHPublicKey() {
        return this.key;
    }

    DHParameters getDHParameters() {
        return this.params;
    }

    byte[] getDHMessage() {
        return this.message;
    }

    byte[] getSignature() {
        return this.signature;
    }

    int getHandshakeType() {
        return 12;
    }
}

