/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;

final class MessageServerKeyExchangeRSA
extends HandshakeMessage {
    private RSAPublicKey publicKey;
    private byte[] message;
    private byte[] signature;

    MessageServerKeyExchangeRSA(byte[] byArray, byte[] byArray2) {
        this.message = byArray;
        this.signature = byArray2;
    }

    MessageServerKeyExchangeRSA(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byArray = Util.readBytesLength16(byteArrayInputStream, maxServerKeyExchangeComponentLength);
        if (byArray == null) {
            throw new IOException(Resources.getMessage("280"));
        }
        byArray2 = Util.readBytesLength16(byteArrayInputStream, maxServerKeyExchangeComponentLength);
        if (byArray2 == null) {
            throw new IOException(Resources.getMessage("280"));
        }
        byteArrayInputStream.reset();
        this.message = new byte[byArray.length + byArray2.length + 4];
        Util.readFully(this.message, byteArrayInputStream);
        this.signature = Util.readBytesLength16(byteArrayInputStream, 0);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.publicKey = (RSAPublicKey)keyFactory.createPublicKey(bigInteger, bigInteger2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            throw new IOException(noSuchAlgorithmException.toString());
        }
    }

    void initMessage() {
        try {
            this.initBuffer(this.message.length + this.signature.length);
            this.buffer.write(this.message);
            this.buffer.write(this.signature);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    int getHandshakeType() {
        return 12;
    }

    byte[] getRSAMessage() {
        return this.message;
    }

    byte[] getSignature() {
        return this.signature;
    }
}

