/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.security.cert.internal.x509.PrincipalImpl;
import com.certicom.tls.TLSSessionDB;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.KeyPairGenerator;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.provider.spec.DHParameters;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MapCipher;
import com.certicom.tls.record.handshake.MessageCertificate;
import com.certicom.tls.record.handshake.MessageCertificateRequest;
import com.certicom.tls.record.handshake.MessageClientHello;
import com.certicom.tls.record.handshake.MessageClientHelloVersion2;
import com.certicom.tls.record.handshake.MessageFinished;
import com.certicom.tls.record.handshake.MessageRandom;
import com.certicom.tls.record.handshake.MessageSSL2Error;
import com.certicom.tls.record.handshake.MessageServerHello;
import com.certicom.tls.record.handshake.MessageServerHelloDone;
import com.certicom.tls.record.handshake.MessageServerHelloVersion2;
import com.certicom.tls.record.handshake.MessageServerKeyExchangeDH;
import com.certicom.tls.record.handshake.MessageServerKeyExchangeRSA;
import com.certicom.tls.record.handshake.ServerStateSentFinished;
import com.certicom.tls.record.handshake.ServerStateSentHelloDone;
import com.certicom.tls.record.handshake.ServerStateSentSSL2HelloDone;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;

final class ServerStateNoHandshake
extends HandshakeState
implements CryptoNames {
    ServerStateNoHandshake(HandshakeHandler handshakeHandler) {
        super(handshakeHandler);
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, HandshakeWouldBlockException {
        switch (handshakeMessage.getHandshakeType()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CLIENT_HELLO \nEnd.\n");
                }
                MessageClientHello messageClientHello = null;
                if (handshakeMessage instanceof MessageClientHelloVersion2) {
                    if (((MessageClientHelloVersion2)handshakeMessage).getProtocolVersion().equals(ProtocolVersion.SSL20) || this.handler.getProtocolVersion().equals(ProtocolVersion.SSL20)) {
                        this.handleVersion2(handshakeMessage);
                        return;
                    }
                    messageClientHello = ((MessageClientHelloVersion2)handshakeMessage).createTLSClientHello();
                } else {
                    messageClientHello = (MessageClientHello)handshakeMessage;
                }
                byte[] byArray = messageClientHello.getRandom().getRandomBytes();
                MessageRandom messageRandom = new MessageRandom();
                byte[] byArray2 = messageRandom.getRandomBytes();
                this.handler.setClientRandom(byArray);
                this.handler.setServerRandom(byArray2);
                ProtocolVersion protocolVersion = this.chooseProtocolVersion(messageClientHello);
                protocolVersion.resetRecord();
                this.handler.setProtocolVersion(protocolVersion);
                if (this.resumeSession(messageClientHello, protocolVersion, messageRandom)) {
                    return;
                }
                TLSSessionImpl tLSSessionImpl = this.handler.getPendingSession();
                TLSSessionImpl tLSSessionImpl2 = new TLSSessionImpl(tLSSessionImpl.getPeerID(), this.handler.getSessionDB(), new SessionID(TLSSystem.getRandomNumberGenerator()));
                CipherSuite cipherSuite = this.matchCipherSuites(messageClientHello.getCipherSuites());
                tLSSessionImpl2.setCacheOn(tLSSessionImpl.getCacheOn());
                this.sendServerHello(tLSSessionImpl2, cipherSuite, messageRandom);
                int n = cipherSuite.getKeyAgreementAlgorithm();
                this.handler.setPendingCipherSuite(cipherSuite);
                this.handler.setPendingSession(tLSSessionImpl2);
                if (n == 2 || n == 3 || n == 10 || n == 11 || n == 4 || n == 1 || n == 9) {
                    this.doDHServerGreetings(n);
                } else if (n == 5) {
                    this.doECDSAServerGreetings();
                } else if (n == 12) {
                    this.doECDH_RSAServerGreetings();
                } else if (n == 6 || n == 7 || n == 8) {
                    this.doRSAServerGreetings(n);
                }
                if (this.handler.getNeedClientAuth() && n != 1 && n != 9) {
                    int n2 = 0;
                    byte[] byArray3 = new byte[5];
                    if (CipherSuiteSupport.isCryptoAlgAvail("RSA_SIGNATURE")) {
                        byArray3[n2++] = 1;
                    }
                    if (CipherSuiteSupport.isCryptoAlgAvail("SHA1withDSA")) {
                        byArray3[n2++] = 2;
                    }
                    if (CipherSuiteSupport.isCryptoAlgAvail("RSA_SIGNATURE") && (n == 12 || n == 5)) {
                        byArray3[n2++] = 6;
                    }
                    if (CipherSuiteSupport.isCryptoAlgAvail("ECDSA") && (n == 5 || n == 12)) {
                        byArray3[n2++] = 7;
                    }
                    if (CipherSuiteSupport.isCryptoAlgAvail("ECDSA")) {
                        byArray3[n2++] = 5;
                    }
                    byte[] byArray4 = new byte[n2];
                    System.arraycopy(byArray3, 0, byArray4, 0, n2);
                    CertificateSupport certificateSupport = this.handler.getCertificateSupport();
                    X509Certificate[] x509CertificateArray = certificateSupport.getTrustedCertificates();
                    Vector<Principal> vector = new Vector<Principal>();
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        vector.addElement(x509CertificateArray[i].getSubjectDN());
                    }
                    Object[] objectArray = new PrincipalImpl[vector.size()];
                    vector.copyInto(objectArray);
                    MessageCertificateRequest messageCertificateRequest = new MessageCertificateRequest((PrincipalImpl[])objectArray, byArray4);
                    if (this.handler.returnDebugFlag()) {
                        System.out.print("Type: CERTIFICATE_REQUEST ");
                    }
                    this.handler.write(messageCertificateRequest);
                }
                this.handler.write(new MessageServerHelloDone());
                this.handler.flush();
                break;
            }
            default: {
                this.handler.fireAlert(2, 10);
            }
        }
    }

    void handleVersion2(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, HandshakeWouldBlockException {
        Object object;
        MessageClientHelloVersion2 messageClientHelloVersion2 = (MessageClientHelloVersion2)handshakeMessage;
        byte[] byArray = messageClientHelloVersion2.getChallenge();
        byte[] byArray2 = new MessageRandom(16).toByteArray();
        this.handler.setChallengeLength(byArray.length);
        this.handler.setClientRandom(byArray);
        this.handler.setServerRandom(byArray2);
        ProtocolVersion protocolVersion = this.handler.getHelloProtocol();
        ProtocolVersion protocolVersion2 = messageClientHelloVersion2.getProtocolVersion();
        if (protocolVersion.equals(ProtocolVersion.SSL20) && protocolVersion2.equals(ProtocolVersion.SSL20) || protocolVersion.equals(ProtocolVersion.SSL20) && protocolVersion2.isRollBack()) {
            protocolVersion.resetRecord();
            this.handler.setProtocolVersion(protocolVersion);
        } else if (protocolVersion2.equals(ProtocolVersion.SSL20) && protocolVersion.isSSL2Hello()) {
            protocolVersion2.resetRecord();
            this.handler.setProtocolVersion(protocolVersion2);
        } else {
            object = new MessageSSL2Error(1);
            this.handler.write((HandshakeMessage)object);
            this.handler.flush();
            this.handler.handleSSL2Error(2, 1);
        }
        if (this.resumeSessionVersion2(messageClientHelloVersion2, protocolVersion2, byArray2)) {
            return;
        }
        object = this.handler.getPendingSession();
        TLSSessionImpl tLSSessionImpl = new TLSSessionImpl(((TLSSessionImpl)object).getPeerID(), this.handler.getSessionDB(), new SessionID(TLSSystem.getRandomNumberGenerator()));
        tLSSessionImpl.setCacheOn(((TLSSessionImpl)object).getCacheOn());
        this.handler.setPendingSession(tLSSessionImpl);
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        X509Certificate[] x509CertificateArray = certificateSupport.getAuthChain("RSA", 0);
        PrivateKey privateKey = certificateSupport.getPrivateKey(x509CertificateArray[0]);
        CipherSuite[] cipherSuiteArray = this.matchCipherSuiteList(messageClientHelloVersion2.getCipherSuites());
        if (cipherSuiteArray == null) {
            MessageSSL2Error messageSSL2Error = new MessageSSL2Error(1);
            this.handler.write(messageSSL2Error);
            this.handler.flush();
            this.handler.handleSSL2Error(2, 1);
            return;
        }
        this.sendServerHelloVersion2(cipherSuiteArray, byArray2, 0, x509CertificateArray[0]);
        this.handler.setState(new ServerStateSentSSL2HelloDone(this.handler, privateKey));
    }

    private boolean resumeSession(MessageClientHello messageClientHello, ProtocolVersion protocolVersion, MessageRandom messageRandom) throws IOException, HandshakeWouldBlockException {
        TLSSessionDB tLSSessionDB = this.handler.getSessionDB();
        SessionID sessionID = messageClientHello.getSessionID();
        TLSSessionImpl tLSSessionImpl = (TLSSessionImpl)tLSSessionDB.get(sessionID);
        CipherSuite cipherSuite = null;
        if (tLSSessionImpl != null) {
            int n;
            cipherSuite = tLSSessionImpl.getCipher();
            CipherSuite[] cipherSuiteArray = this.handler.getEnabledCipherSuites();
            boolean bl = false;
            for (n = 0; n < cipherSuiteArray.length; ++n) {
                if (!cipherSuiteArray[n].equals(cipherSuite)) continue;
                bl = true;
            }
            n = 1;
            ProtocolVersion protocolVersion2 = tLSSessionImpl.getProtocolVersion();
            if (protocolVersion2.equals(protocolVersion)) {
                n = 1;
            }
            if (bl && n != 0) {
                this.handler.setPendingSession(tLSSessionImpl);
                this.handler.setPendingCipherSuite(cipherSuite);
                this.handler.setMasterSecret(tLSSessionImpl.getMasterSecret());
                this.handler.generateSecurityParameters();
                this.sendServerHello(tLSSessionImpl, cipherSuite, messageRandom);
                this.handler.changeCipherSpec();
                MessageFinished messageFinished = new MessageFinished(this.handler.getVerifyData(false));
                this.handler.write(messageFinished);
                this.handler.flush();
                this.handler.setState(new ServerStateSentFinished(this.handler));
                return true;
            }
        }
        return false;
    }

    private boolean resumeSessionVersion2(MessageClientHelloVersion2 messageClientHelloVersion2, ProtocolVersion protocolVersion, byte[] byArray) throws IOException, HandshakeWouldBlockException {
        TLSSessionDB tLSSessionDB = this.handler.getSessionDB();
        SessionID sessionID = new SessionID(messageClientHelloVersion2.getSessionID());
        TLSSessionImpl tLSSessionImpl = (TLSSessionImpl)tLSSessionDB.get(sessionID);
        CipherSuite cipherSuite = null;
        if (tLSSessionImpl != null) {
            int n;
            cipherSuite = tLSSessionImpl.getCipher();
            CipherSuite[] cipherSuiteArray = this.handler.getEnabledCipherSuites();
            boolean bl = false;
            for (n = 0; n < cipherSuiteArray.length; ++n) {
                if (!cipherSuiteArray[n].equals(cipherSuite)) continue;
                bl = true;
            }
            n = 0;
            ProtocolVersion protocolVersion2 = tLSSessionImpl.getProtocolVersion();
            if (protocolVersion2.equals(ProtocolVersion.SSL20) && (protocolVersion.equals(ProtocolVersion.SSL20) || protocolVersion.isRollBack())) {
                n = 1;
            }
            if (bl && n != 0) {
                this.sendServerHelloVersion2(null, byArray, 1, null);
                this.handler.setPendingSession(tLSSessionImpl);
                this.handler.setPendingCipherSuite(cipherSuite);
                this.handler.setMasterSecret(tLSSessionImpl.getMasterSecret());
                this.handler.generateSecurityParameters();
                this.handler.setState(new ServerStateSentSSL2HelloDone(this.handler));
                return true;
            }
        }
        return false;
    }

    private void doECDSAServerGreetings() throws IOException, HandshakeWouldBlockException {
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        X509Certificate[] x509CertificateArray = certificateSupport.getAuthChain("ECDSA", 0);
        PrivateKey privateKey = certificateSupport.getPrivateKey(x509CertificateArray[0]);
        MessageCertificate messageCertificate = new MessageCertificate(x509CertificateArray);
        this.handler.write(messageCertificate);
        this.handler.setState(new ServerStateSentHelloDone(this.handler, privateKey));
    }

    private void doECDH_RSAServerGreetings() throws IOException, HandshakeWouldBlockException {
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        X509Certificate[] x509CertificateArray = certificateSupport.getAuthChain("HYBRID", 0);
        PrivateKey privateKey = certificateSupport.getPrivateKey(x509CertificateArray[0]);
        MessageCertificate messageCertificate = new MessageCertificate(x509CertificateArray);
        this.handler.write(messageCertificate);
        this.handler.setState(new ServerStateSentHelloDone(this.handler, privateKey));
    }

    private void doDHServerGreetings(int n) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, HandshakeWouldBlockException {
        Object object;
        Object object2;
        Object object3;
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        PrivateKey privateKey = null;
        if (n != 1 && n != 9) {
            object3 = n == 10 || n == 11 ? certificateSupport.getAuthChain("RSA", 0) : certificateSupport.getAuthChain("SHA1withDSA", 0);
            privateKey = certificateSupport.getPrivateKey(object3[0]);
            object2 = new MessageCertificate((X509Certificate[])object3);
            this.handler.write((HandshakeMessage)object2);
        }
        object3 = null;
        object3 = n == 3 || n == 9 || n == 11 ? new DHParameters(512) : new DHParameters();
        object2 = KeyPairGenerator.getInstance("DiffieHellman");
        ((KeyPairGenerator)object2).initialize((DHParameters)object3, TLSSystem.getRandomNumberGenerator());
        KeyPair keyPair = ((KeyPairGenerator)object2).genKeyPair();
        PrivateKey privateKey2 = keyPair.getPrivate();
        byte[] byArray = keyPair.getPublic().getEncoded();
        byte[] byArray2 = new byte[]{};
        if (n == 10 || n == 11) {
            object = this.signKeyExchangeData(privateKey, this.handler.getClientRandom(), this.handler.getServerRandom(), byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Util.writeBytesLength16((byte[])object, byteArrayOutputStream);
            byArray2 = byteArrayOutputStream.toByteArray();
        } else if (n != 1 && n != 9) {
            object = Signature.getInstance("DSA");
            ((Signature)object).initSign(privateKey, TLSSystem.getRandomNumberGenerator());
            ((Signature)object).update(this.handler.getClientRandom());
            ((Signature)object).update(this.handler.getServerRandom());
            ((Signature)object).update(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Util.writeBytesLength16(((Signature)object).sign(), byteArrayOutputStream);
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        object = new MessageServerKeyExchangeDH(byArray, byArray2);
        this.handler.write((HandshakeMessage)object);
        this.handler.setState(new ServerStateSentHelloDone(this.handler, privateKey2));
    }

    private void doRSAServerGreetings(int n) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, HandshakeWouldBlockException {
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        X509Certificate[] x509CertificateArray = certificateSupport.getAuthChain("RSA", 0);
        PrivateKey privateKey = certificateSupport.getPrivateKey(x509CertificateArray[0]);
        MessageCertificate messageCertificate = new MessageCertificate(x509CertificateArray);
        this.handler.write(messageCertificate);
        if (n == 7 || n == 8) {
            PrivateKey privateKey2 = privateKey;
            int n2 = ((RSAPublicKey)x509CertificateArray[0].getPublicKey()).getModulus().bitLength();
            KeyPair keyPair = null;
            if (n2 > 1024 && n == 8) {
                keyPair = certificateSupport.getRSAExportKey(1024);
            } else if (n2 > 512 && n == 7) {
                keyPair = certificateSupport.getRSAExportKey(512);
            }
            if (keyPair != null) {
                privateKey = keyPair.getPrivate();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
                Util.writeBytesLength16(Util.toUnsignedInteger(rSAPublicKey.getModulus()), byteArrayOutputStream);
                Util.writeBytesLength16(Util.toUnsignedInteger(rSAPublicKey.getPublicExponent()), byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = this.handler.getClientRandom();
                byte[] byArray3 = this.handler.getServerRandom();
                byte[] byArray4 = this.signKeyExchangeData(privateKey2, byArray2, byArray3, byArray);
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                Util.writeBytesLength16(byArray4, byteArrayOutputStream2);
                byte[] byArray5 = byteArrayOutputStream2.toByteArray();
                MessageServerKeyExchangeRSA messageServerKeyExchangeRSA = new MessageServerKeyExchangeRSA(byArray, byArray5);
                this.handler.write(messageServerKeyExchangeRSA);
            }
        }
        this.handler.setState(new ServerStateSentHelloDone(this.handler, privateKey));
    }

    private byte[] signKeyExchangeData(PrivateKey privateKey, byte[] byArray, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray4 = this.hashRandomAndParams("MD5", byArray, byArray2, byArray3);
        byte[] byArray5 = this.hashRandomAndParams("SHA", byArray, byArray2, byArray3);
        byte[] byArray6 = new byte[byArray4.length + byArray5.length];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
        int n = (((RSAPrivateKey)privateKey).getModulus().bitLength() + 7) / 8;
        byte[] byArray7 = this.handler.addPKCS1Padding(n, byArray6);
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(1, (Key)privateKey, TLSSystem.getRandomNumberGenerator());
        return cipher.doFinal(byArray7, 0, byArray7.length);
    }

    private byte[] hashRandomAndParams(String string, byte[] byArray, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        messageDigest.update(byArray3);
        return messageDigest.digest();
    }

    private void sendServerHello(TLSSessionImpl tLSSessionImpl, CipherSuite cipherSuite, MessageRandom messageRandom) throws IOException {
        MessageServerHello messageServerHello = new MessageServerHello(tLSSessionImpl.getSessionID(), cipherSuite.getTag(), messageRandom, this.handler.getProtocolVersion());
        if (this.handler.returnDebugFlag()) {
            System.out.print("Type: SERVER_HELLO ");
        }
        this.handler.write(messageServerHello);
    }

    private void sendServerHelloVersion2(CipherSuite[] cipherSuiteArray, byte[] byArray, int n, X509Certificate x509Certificate) throws IOException, HandshakeWouldBlockException {
        MessageServerHelloVersion2 messageServerHelloVersion2 = new MessageServerHelloVersion2(byArray, n, cipherSuiteArray, x509Certificate);
        if (this.handler.returnDebugFlag()) {
            System.out.print("Type: SSL2 SERVER_HELLO ");
        }
        this.handler.write(messageServerHelloVersion2);
        this.handler.flush();
    }

    private ProtocolVersion chooseProtocolVersion(MessageClientHello messageClientHello) throws IOException, HandshakeWouldBlockException {
        ProtocolVersion protocolVersion = this.handler.getHelloProtocol();
        ProtocolVersion protocolVersion2 = messageClientHello.getProtocolVersion();
        this.handler.setPeerHelloProtocol(protocolVersion2);
        if (protocolVersion2.equals(ProtocolVersion.SSL30) && (protocolVersion.equals(ProtocolVersion.SSL30) || protocolVersion.equals(ProtocolVersion.TLS10) && protocolVersion.isRollBack() || protocolVersion.equals(ProtocolVersion.SSL20) && protocolVersion.isRollForward())) {
            return protocolVersion2;
        }
        if (protocolVersion2.equals(ProtocolVersion.TLS10) && (protocolVersion.equals(ProtocolVersion.TLS10) || protocolVersion.equals(ProtocolVersion.SSL20) && protocolVersion.isRollForward() || protocolVersion.equals(ProtocolVersion.SSL30) && protocolVersion.isRollForward())) {
            return protocolVersion2;
        }
        if (protocolVersion2.equals(ProtocolVersion.TLS10) && protocolVersion.equals(ProtocolVersion.SSL30)) {
            return protocolVersion;
        }
        if (protocolVersion2.equals(ProtocolVersion.SSL20) && (protocolVersion.equals(ProtocolVersion.SSL20) || protocolVersion.isRollBack())) {
            return protocolVersion2;
        }
        this.handler.fireAlert(2, 70);
        return null;
    }

    private CipherSuite matchCipherSuites(CipherSuite[] cipherSuiteArray) throws NoSuchAlgorithmException {
        CipherSuite[] cipherSuiteArray2 = this.handler.getEnabledCipherSuites();
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        for (int i = 0; i < cipherSuiteArray2.length; ++i) {
            if (certificateSupport.getAuthChain(cipherSuiteArray2[i].getCertificateType(), 0) == null && !cipherSuiteArray2[i].getCertificateType().equals("Anonymous")) continue;
            for (int j = 0; j < cipherSuiteArray.length; ++j) {
                if (!cipherSuiteArray2[i].equals(cipherSuiteArray[j])) continue;
                return cipherSuiteArray2[i];
            }
        }
        throw new NoSuchAlgorithmException();
    }

    private CipherSuite[] matchCipherSuiteList(CipherSuite[] cipherSuiteArray) {
        CipherSuite[] cipherSuiteArray2 = this.handler.getEnabledCipherSuites();
        int n = 0;
        Vector<CipherSuite> vector = new Vector<CipherSuite>(cipherSuiteArray.length);
        CertificateSupport certificateSupport = this.handler.getCertificateSupport();
        if (certificateSupport.getAuthChain("RSA", 0) == null) {
            return null;
        }
        for (int i = 0; i < cipherSuiteArray2.length; ++i) {
            for (int j = 0; j < cipherSuiteArray.length; ++j) {
                if (!cipherSuiteArray2[i].equals(cipherSuiteArray[j]) || MapCipher.isSSL2Cipher(cipherSuiteArray[j].getTag()) != 1) continue;
                vector.addElement(cipherSuiteArray2[i]);
                ++n;
            }
        }
        if (n != 0) {
            Object[] objectArray = new CipherSuite[n];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }
}

