/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.record.Util;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageCertificateVerify;
import com.certicom.tls.record.handshake.MessageFinished;
import com.certicom.tls.record.handshake.ServerStateNoHandshake;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

public final class ServerStateReceivedClientKeyExchange
extends HandshakeState
implements CryptoNames {
    Object clientCertificate = null;
    MessageDigest md5MessageDigest = null;
    MessageDigest shaMessageDigest = null;
    boolean receivedCertVerify = false;

    ServerStateReceivedClientKeyExchange(HandshakeHandler handshakeHandler, Object object, Object object2, Object object3) {
        super(handshakeHandler);
        this.clientCertificate = object;
        this.md5MessageDigest = (MessageDigest)object2;
        this.shaMessageDigest = (MessageDigest)object3;
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, HandshakeWouldBlockException {
        ProtocolVersion protocolVersion = this.handler.getProtocolVersion();
        switch (handshakeMessage.getHandshakeType()) {
            case 1: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CLIENT_HELLO: ServerStateReceivedClientKeyExchange, assuming client is restarting the handshake for the server gated crypto");
                }
                ServerStateNoHandshake serverStateNoHandshake = new ServerStateNoHandshake(this.handler);
                this.handler.setState(serverStateNoHandshake);
                ((HandshakeState)serverStateNoHandshake).handle(handshakeMessage);
                break;
            }
            case 15: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CERTIFICATE_VERIFY \nEnd.");
                }
                this.receivedCertVerify = true;
                if (this.clientCertificate == null) {
                    this.handler.fireAlert(2, 10);
                }
                byte[] byArray = null;
                byte[] byArray2 = null;
                X509Certificate[] x509CertificateArray = (X509Certificate[])this.clientCertificate;
                PublicKey publicKey = x509CertificateArray[0].getPublicKey();
                ByteArrayInputStream byteArrayInputStream = ((MessageCertificateVerify)handshakeMessage).getSignature();
                byte[] byArray3 = Util.readBytesLength16(byteArrayInputStream, HandshakeMessage.maxCertificateVerifySignatureLength);
                if (byArray3 == null) {
                    throw new IOException(Resources.getMessage("281"));
                }
                if (publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                    if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 1) {
                        byArray = this.md5MessageDigest.digest();
                        byArray2 = this.shaMessageDigest.digest();
                    } else if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 0) {
                        byArray = this.handler.getV3CertificateVerifyMD5Hash(this.md5MessageDigest);
                        byArray2 = this.handler.getV3CertificateVerifySHAHash(this.shaMessageDigest);
                    }
                    if (this.verifyMessageRSASignature(publicKey, byArray, byArray2, byArray3)) break;
                    this.handler.fireAlert(2, 51);
                    break;
                }
                if (publicKey.getAlgorithm().equalsIgnoreCase("DSA")) {
                    if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 1) {
                        byArray2 = this.shaMessageDigest.digest();
                    } else if (protocolVersion.getMajor() == 3 && protocolVersion.getMinor() == 0) {
                        byArray2 = this.handler.getV3CertificateVerifySHAHash(this.shaMessageDigest);
                    }
                    Signature signature = Signature.getInstance("RawDSA");
                    signature.initVerify(publicKey);
                    signature.update(byArray2);
                    if (signature.verify(byArray3)) break;
                    this.handler.fireAlert(2, 51);
                    break;
                }
                if (publicKey.getAlgorithm().startsWith("EC")) {
                    byArray = this.md5MessageDigest.digest();
                    byArray2 = this.shaMessageDigest.digest();
                    Signature signature = Signature.getInstance("RawECDSA");
                    signature.initVerify(publicKey);
                    signature.update(byArray2);
                    if (signature.verify(byArray3)) break;
                    this.handler.fireAlert(2, 51);
                    break;
                }
                this.handler.fireAlert(2, 47);
                break;
            }
            case 20: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("FINISHED \nEnd.");
                }
                if (!this.receivedCertVerify && this.clientCertificate != null && ((X509Certificate[])this.clientCertificate).length > 0 && !this.handler.getECDSA_fixed_ECDHFlag()) {
                    this.handler.fireAlert(2, 10);
                }
                this.handler.changeCipherSpec();
                MessageFinished messageFinished = new MessageFinished(this.handler.getVerifyData(this.handler.isClient()));
                if (this.handler.returnDebugFlag()) {
                    System.out.print("Type: FINISHED ");
                }
                this.handler.write(messageFinished);
                this.handler.flush();
                this.handler.completeHandshake();
                break;
            }
            default: {
                this.handler.fireAlert(2, 10);
            }
        }
    }

    private boolean verifyMessageRSASignature(PublicKey publicKey, byte[] byArray, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(2, (Key)publicKey, TLSSystem.getRandomNumberGenerator());
        byte[] byArray4 = cipher.doFinal(byArray3, 0, byArray3.length);
        byte[] byArray5 = this.handler.removePKCS1Padding(byArray4);
        return this.handler.isEqual(byArray5, 0, 16, byArray, 0, byArray.length) && this.handler.isEqual(byArray5, 16, 20, byArray2, 0, byArray2.length);
    }
}

