/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.KeyAgreement;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.spec.DHPrivateKey;
import com.certicom.tls.provider.spec.DHPublicKey;
import com.certicom.tls.record.alert.Alert;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageCertificate;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeDH;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeECDH;
import com.certicom.tls.record.handshake.MessageClientKeyExchangeRSA;
import com.certicom.tls.record.handshake.ServerStateNoHandshake;
import com.certicom.tls.record.handshake.ServerStateReceivedClientKeyExchange;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

public final class ServerStateSentHelloDone
extends HandshakeState
implements CryptoNames {
    private PrivateKey kaPrivateKey;
    private X509Certificate[] clientCertChain = null;
    private MessageDigest md5;
    private MessageDigest sha;
    private PublicKey peerkaPublicKey = null;

    ServerStateSentHelloDone(HandshakeHandler handshakeHandler, PrivateKey privateKey) {
        super(handshakeHandler);
        this.kaPrivateKey = privateKey;
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, HandshakeWouldBlockException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        switch (handshakeMessage.getHandshakeType()) {
            case 1: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CLIENT_HELLO: ServerStateSentHelloDone, assuming client is restarting the handshake for the server gated crypto");
                }
                ServerStateNoHandshake serverStateNoHandshake = new ServerStateNoHandshake(this.handler);
                this.handler.setState(serverStateNoHandshake);
                ((HandshakeState)serverStateNoHandshake).handle(handshakeMessage);
                break;
            }
            case 11: {
                X509Certificate[][] x509CertificateArray;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CERTIFICATE \nEnd");
                }
                MessageCertificate messageCertificate = (MessageCertificate)handshakeMessage;
                this.clientCertChain = messageCertificate.getCertificateChain();
                CertificateSupport certificateSupport = this.handler.getCertificateSupport();
                if (!certificateSupport.isClientTrusted(x509CertificateArray = new X509Certificate[][]{this.clientCertChain}, this.handler.getPendingCipherSuite().getDescription(), this.handler.getProtocolVersion(), this.handler.getConnectionImpl().getCertificateCallbackRef(), this.handler.getConnectionImpl().getSSLSocket())) {
                    if (this.clientCertChain.length == 0) {
                        this.handler.fireAlert(2, 40);
                    } else {
                        this.handler.fireAlert(2, 42);
                    }
                }
                this.handler.getPendingSession().setPeerCertChain(x509CertificateArray[0]);
                CipherSuite cipherSuite = this.handler.getPendingCipherSuite();
                int n = cipherSuite.getKeyAgreementAlgorithm();
                if (n != 5 && n != 12 || this.clientCertChain.length == 0) break;
                this.peerkaPublicKey = messageCertificate.getCertificateChain()[0].getPublicKey();
                break;
            }
            case 16: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("CLIENT_KEY_EXCHANGE \nEnd.");
                }
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    CipherSuite cipherSuite = this.handler.getPendingCipherSuite();
                    int n = cipherSuite.getKeyAgreementAlgorithm();
                    if (this.clientCertChain != null) {
                        this.md5 = this.handler.getMD5Clone();
                        this.sha = this.handler.getSHAClone();
                    }
                    if (this.clientCertChain != null && this.clientCertChain.length != 0 && (n == 5 || n == 12)) {
                        if (handshakeMessage.getMessageLength() == 4) {
                            this.handler.setECDSA_fixed_ECDHFlag(true);
                        } else {
                            object7 = (MessageClientKeyExchangeECDH)handshakeMessage;
                            object6 = ((MessageClientKeyExchangeECDH)object7).getY();
                            if (object6 == null) {
                                this.handler.setECDSA_fixed_ECDHFlag(true);
                            }
                        }
                        object7 = this.handler.getCertificateSupport();
                        if (!((CertificateSupport)object7).validateECDSA_fixed_ECDH(this.handler.getECDSA_fixed_ECDHFlag(), this.clientCertChain, this.handler.getProtocolVersion())) {
                            this.handler.fireAlert(2, 42);
                        }
                    }
                    object7 = TLSSystem.getRandomNumberGenerator();
                    if (n == 1 || n == 9 || n == 2 || n == 3 || n == 10 || n == 11 || n == 4) {
                        object6 = (DHPrivateKey)this.kaPrivateKey;
                        object5 = (MessageClientKeyExchangeDH)handshakeMessage;
                        object4 = ((MessageClientKeyExchangeDH)object5).getY();
                        object3 = new DHPublicKey(((MessageClientKeyExchangeDH)object5).getY(), ((DHPrivateKey)object6).getP(), ((DHPrivateKey)object6).getG());
                        object2 = KeyAgreement.getInstance("DiffieHellman");
                        ((KeyAgreement)object2).init((Key)object6, (SecureRandom)object7);
                        ((KeyAgreement)object2).doPhase((Key)object3, true);
                        object = ((KeyAgreement)object2).generateSecret();
                        this.handler.setPremasterSecret((byte[])object);
                    }
                    if (n == 5 || n == 12) {
                        object6 = this.kaPrivateKey;
                        if (!this.handler.getECDSA_fixed_ECDHFlag()) {
                            object4 = (MessageClientKeyExchangeECDH)handshakeMessage;
                            object5 = ((MessageClientKeyExchangeECDH)object4).getY();
                        } else {
                            object5 = this.peerkaPublicKey;
                        }
                        object4 = KeyAgreement.getInstance("ECDH");
                        ((KeyAgreement)object4).init((Key)object6, (SecureRandom)object7);
                        ((KeyAgreement)object4).doPhase((Key)object5, true);
                        object3 = new byte[20];
                        object3 = ((KeyAgreement)object4).generateSecret();
                        this.handler.setPremasterSecret((byte[])object3);
                    }
                    if (n == 6 || n == 7 || n == 8) {
                        object6 = new byte[48];
                        ((SecureRandom)object7).nextBytes((byte[])object6);
                        try {
                            object5 = (MessageClientKeyExchangeRSA)handshakeMessage;
                            object4 = ((MessageClientKeyExchangeRSA)object5).getEncryptedSecret();
                            object3 = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                            ((Cipher)object3).init(2, (Key)this.kaPrivateKey, (SecureRandom)object7);
                            object2 = ((Cipher)object3).doFinal((byte[])object4, 0, ((Object)object4).length);
                            object = new ProtocolVersion((int)object2[0], (int)object2[1]);
                            if (!this.handler.getHandshakeRollBackBug() && !this.handler.getPeerHelloProtocol().equals(object)) {
                                throw new IllegalArgumentException();
                            }
                            this.handler.setPremasterSecret((byte[])object2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.handler.setPremasterSecret((byte[])object6);
                            this.handler.generateMasterSecret();
                            this.handler.generateSecurityParameters();
                        }
                    }
                    this.handler.generateMasterSecret();
                    this.handler.generateSecurityParameters();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    WeblogicHandler.debugEaten(noSuchAlgorithmException);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    WeblogicHandler.debugEaten(cloneNotSupportedException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    WeblogicHandler.debugEaten(invalidKeyException);
                }
                this.handler.setState(new ServerStateReceivedClientKeyExchange(this.handler, this.clientCertChain, this.md5, this.sha));
                break;
            }
            default: {
                Alert alert = new Alert(2, 10);
                this.handler.fireAlert(alert);
            }
        }
    }
}

