/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageClientCertificate;
import com.certicom.tls.record.handshake.MessageFinishedVersion2;
import com.certicom.tls.record.handshake.ServerStateNoHandshake;
import java.io.IOException;

public final class ServerStateSentRequestCertificate
extends HandshakeState
implements CryptoNames {
    private byte[] Certificate_Challenge;
    private int Authenticate_Type;

    ServerStateSentRequestCertificate(HandshakeHandler handshakeHandler, byte[] byArray, int n) {
        super(handshakeHandler);
        this.Certificate_Challenge = byArray;
        this.Authenticate_Type = n;
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, HandshakeWouldBlockException {
        switch (handshakeMessage.getHandshakeType()) {
            case 8: {
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SSL_MT_CLIENT_CERTIFICATE\nEnd");
                }
                MessageClientCertificate messageClientCertificate = (MessageClientCertificate)handshakeMessage;
                int n = 0;
                n = messageClientCertificate.VerifyResponseData(this.Certificate_Challenge, this.handler);
                if (n != 0) {
                    this.handler.fireSSL2ErrorException(Resources.getMessage(Integer.toString(n)));
                    this.handler.handleSSL2Error(4, 2);
                }
                SessionID sessionID = this.handler.getPendingSessionID();
                MessageFinishedVersion2 messageFinishedVersion2 = new MessageFinishedVersion2(0, sessionID.getID());
                this.handler.write(messageFinishedVersion2);
                this.handler.flush();
                this.handler.completeHandshake();
                this.handler.setState(new ServerStateNoHandshake(this.handler));
                break;
            }
            default: {
                this.handler.fireSSL2ErrorException(Resources.getMessage("137"));
            }
        }
    }
}

