/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.record.handshake;

import com.certicom.locale.Resources;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.record.handshake.HandshakeHandler;
import com.certicom.tls.record.handshake.HandshakeMessage;
import com.certicom.tls.record.handshake.HandshakeState;
import com.certicom.tls.record.handshake.MessageClientMasterKey;
import com.certicom.tls.record.handshake.MessageFinishedVersion2;
import com.certicom.tls.record.handshake.MessageRandom;
import com.certicom.tls.record.handshake.MessageRequestCertificate;
import com.certicom.tls.record.handshake.MessageSSL2Error;
import com.certicom.tls.record.handshake.MessageServerVerify;
import com.certicom.tls.record.handshake.ServerStateNoHandshake;
import com.certicom.tls.record.handshake.ServerStateSentRequestCertificate;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

public final class ServerStateSentSSL2HelloDone
extends HandshakeState
implements CryptoNames {
    private PrivateKey privateKey;

    ServerStateSentSSL2HelloDone(HandshakeHandler handshakeHandler) {
        super(handshakeHandler);
    }

    ServerStateSentSSL2HelloDone(HandshakeHandler handshakeHandler, PrivateKey privateKey) {
        super(handshakeHandler);
        this.privateKey = privateKey;
    }

    void handle(HandshakeMessage handshakeMessage) throws IOException, HandshakeWouldBlockException {
        switch (handshakeMessage.getHandshakeType()) {
            case 2: {
                CipherSuite cipherSuite;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SSL_MT_CLIENT_MASTER_KEY\nEnd");
                }
                MessageClientMasterKey messageClientMasterKey = (MessageClientMasterKey)handshakeMessage;
                int n = messageClientMasterKey.getCipherSuiteTag();
                try {
                    cipherSuite = CipherSuiteSupport.getCipherSuite(n);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.handleError();
                    return;
                }
                try {
                    messageClientMasterKey.setClientMasterKey(this.handler, this.privateKey);
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.handleError();
                    return;
                }
                this.handler.setPendingCipherSuite(cipherSuite);
                this.handler.generateSecurityParameters();
                break;
            }
            case 3: {
                byte[] byArray;
                MessageFinishedVersion2 messageFinishedVersion2;
                byte[] byArray2;
                if (this.handler.returnDebugFlag()) {
                    System.out.println("SSL_MT_CLIENT_FINISHED\nEnd.");
                }
                if ((byArray2 = (messageFinishedVersion2 = (MessageFinishedVersion2)handshakeMessage).getID()).length != (byArray = this.handler.getServerRandom()).length) {
                    this.handler.fireSSL2ErrorException(Resources.getMessage("49"));
                    return;
                }
                int n = 0;
                for (n = 0; n < byArray.length; ++n) {
                    if (byArray[n] == byArray2[n]) continue;
                    this.handler.fireSSL2ErrorException(Resources.getMessage("49"));
                    return;
                }
                int n2 = this.handler.getChallengeLength();
                byte[] byArray3 = new byte[n2];
                byte[] byArray4 = this.handler.getClientRandom();
                System.arraycopy(byArray4, byArray4.length - n2, byArray3, 0, n2);
                MessageServerVerify messageServerVerify = new MessageServerVerify(byArray3);
                this.handler.write(messageServerVerify);
                this.handler.flush();
                if (this.handler.getNeedClientAuth()) {
                    byte[] byArray5 = new byte[n2];
                    byArray5 = new MessageRandom(n2).toByteArray();
                    MessageRequestCertificate messageRequestCertificate = new MessageRequestCertificate(1, byArray5);
                    this.handler.write(messageRequestCertificate);
                    this.handler.flush();
                    this.handler.setState(new ServerStateSentRequestCertificate(this.handler, byArray5, 1));
                    break;
                }
                SessionID sessionID = this.handler.getPendingSessionID();
                MessageFinishedVersion2 messageFinishedVersion22 = new MessageFinishedVersion2(0, sessionID.getID());
                this.handler.write(messageFinishedVersion22);
                this.handler.flush();
                this.handler.completeHandshake();
                this.handler.setState(new ServerStateNoHandshake(this.handler));
                break;
            }
            default: {
                this.handler.fireSSL2ErrorException(Resources.getMessage("137"));
            }
        }
    }

    private void handleError() throws IOException, HandshakeWouldBlockException {
        MessageSSL2Error messageSSL2Error = new MessageSSL2Error(1);
        this.handler.write(messageSSL2Error);
        this.handler.flush();
        this.handler.handleSSL2Error(2, 1);
    }
}

