/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde;

import com.octetstring.nls.Messages;
import com.octetstring.vde.Attribute;
import com.octetstring.vde.backend.standard.BackendStandard;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.BinarySyntax;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DNUtility;
import com.octetstring.vde.util.EncryptionHelper;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public class Entry
implements Serializable {
    private DirectoryString name = null;
    private DirectoryString base = null;
    private int id = -1;
    private static final DirectoryString OBJECTCLASS = new DirectoryString("objectclass");
    private static final int byte1 = 255;
    private static final int byte2 = 65280;
    private static final int byte3 = 0xFF0000;
    private static final int byte4 = -16777216;
    private Vector attributes = null;
    static /* synthetic */ Class class$com$octetstring$vde$syntax$DirectoryString;

    public Entry() {
        this.attributes = new Vector();
    }

    public Entry(byte[] entryBytes) {
        this.attributes = new Vector();
        this.readBytes(entryBytes);
    }

    public Entry(Entry entry) {
        this.id = entry.getID();
        try {
            this.setName(entry.getName(), true);
            this.setBase(entry.getBase());
        }
        catch (InvalidDNException ide) {
            // empty catch block
        }
        this.attributes = new Vector();
        Enumeration attrs = entry.getAttributes().elements();
        while (attrs.hasMoreElements()) {
            this.attributes.addElement(((Attribute)attrs.nextElement()).clone());
        }
    }

    public Entry(DirectoryString name) throws InvalidDNException {
        this.setName(name);
        this.attributes = new Vector();
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Vector attributes) {
        this.attributes = attributes;
    }

    public DirectoryString getBase() {
        return this.base;
    }

    public void setBase(DirectoryString base) {
        this.base = base;
    }

    public DirectoryString getName() {
        return this.name;
    }

    public void setName(DirectoryString name) throws InvalidDNException {
        Vector rdnComponents = DNUtility.getInstance().explodeDN(name);
        this.name = DNUtility.getInstance().createDN(rdnComponents);
        if (!rdnComponents.isEmpty()) {
            rdnComponents.removeElementAt(0);
        }
        this.setBase(DNUtility.getInstance().createDN(rdnComponents));
        if (Logger.getInstance().isLogable(9)) {
            Logger.getInstance().log(9, this, Messages.getString("Entry_Name_Constructed_for____2") + name + "'");
        }
    }

    public void setName(DirectoryString name, boolean bypassConstruct) throws InvalidDNException {
        if (bypassConstruct) {
            this.name = name;
        } else {
            this.setName(name);
        }
    }

    private static int bytesToInt(byte[] eb, int bc) {
        return (eb[bc] & 0xFF) << 24 | (eb[bc + 1] & 0xFF) << 16 | (eb[bc + 2] & 0xFF) << 8 | eb[bc + 3] & 0xFF;
    }

    public Object clone() {
        return new Entry(this);
    }

    public boolean containsKey(DirectoryString key) {
        Enumeration attrEnum = this.attributes.elements();
        while (attrEnum.hasMoreElements()) {
            Attribute thisAttr = (Attribute)attrEnum.nextElement();
            if (!thisAttr.equals(key)) continue;
            return true;
        }
        return false;
    }

    public Vector get(DirectoryString key) {
        Enumeration attrEnum = this.attributes.elements();
        while (attrEnum.hasMoreElements()) {
            Attribute thisAttr = (Attribute)attrEnum.nextElement();
            if (!thisAttr.equals(key)) continue;
            return thisAttr.values;
        }
        return null;
    }

    public byte[] getAsByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int nameLen = this.getName().length();
        int hc = this.getName().hashCode();
        baos.write((nameLen & 0xFF000000) >> 24);
        baos.write((nameLen & 0xFF0000) >> 16);
        baos.write((nameLen & 0xFF00) >> 8);
        baos.write(nameLen & 0xFF);
        baos.write((hc & 0xFF000000) >> 24);
        baos.write((hc & 0xFF0000) >> 16);
        baos.write((hc & 0xFF00) >> 8);
        baos.write(hc & 0xFF);
        baos.write(this.getName().getBytes(), 0, nameLen);
        int baseLen = this.getBase().length();
        baos.write((baseLen & 0xFF000000) >> 24);
        baos.write((baseLen & 0xFF0000) >> 16);
        baos.write((baseLen & 0xFF00) >> 8);
        baos.write(baseLen & 0xFF);
        hc = this.getBase().hashCode();
        baos.write((hc & 0xFF000000) >> 24);
        baos.write((hc & 0xFF0000) >> 16);
        baos.write((hc & 0xFF00) >> 8);
        baos.write(hc & 0xFF);
        baos.write(this.getBase().getBytes(), 0, baseLen);
        String idString = String.valueOf(this.getID());
        int idLen = idString.length();
        baos.write(idLen);
        baos.write(idString.getBytes(), 0, idLen);
        baos.write((this.attributes.size() & 0xFF00) >> 8);
        baos.write(this.attributes.size() & 0xFF);
        Enumeration keyEnum = this.attributes.elements();
        while (keyEnum.hasMoreElements()) {
            Attribute aAttr = (Attribute)keyEnum.nextElement();
            DirectoryString aKey = aAttr.type;
            baos.write(aKey.length());
            hc = aKey.hashCode();
            baos.write((hc & 0xFF000000) >> 24);
            baos.write((hc & 0xFF0000) >> 16);
            baos.write((hc & 0xFF00) >> 8);
            baos.write(hc & 0xFF);
            baos.write(aKey.getBytes(), 0, aKey.length());
            Vector vals = aAttr.values;
            baos.write((vals.size() & 0xFF00) >> 8);
            baos.write(vals.size() & 0xFF);
            Enumeration valEnum = vals.elements();
            int valLen = 0;
            while (valEnum.hasMoreElements()) {
                Syntax aVal = (Syntax)valEnum.nextElement();
                valLen = aVal.getValue().length;
                baos.write((valLen & 0xFF000000) >> 24);
                baos.write((valLen & 0xFF0000) >> 16);
                baos.write((valLen & 0xFF00) >> 8);
                baos.write(valLen & 0xFF);
                hc = aVal.hashCode();
                baos.write((hc & 0xFF000000) >> 24);
                baos.write((hc & 0xFF0000) >> 16);
                baos.write((hc & 0xFF00) >> 8);
                baos.write(hc & 0xFF);
                baos.write(aVal.getValue(), 0, valLen);
            }
        }
        byte[] entryBytes = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ioe) {
            Logger.getInstance().log(0, this, Messages.getString("Error_closing_ByteArrayOutputStream_4"));
        }
        return entryBytes;
    }

    public int getID() {
        return this.id;
    }

    public Enumeration keys() {
        return new KeyEnumeration();
    }

    public void put(DirectoryString key, Vector values) {
        this.put(key, values, true);
    }

    public void put(DirectoryString key, Vector values, boolean checkExist) {
        Attribute thisAttr = null;
        if (checkExist) {
            Enumeration attrEnum = this.attributes.elements();
            while (attrEnum.hasMoreElements()) {
                Attribute oneAttr = (Attribute)attrEnum.nextElement();
                if (!oneAttr.equals(key)) continue;
                thisAttr = oneAttr;
            }
        }
        if (thisAttr != null) {
            this.attributes.removeElement(thisAttr);
        }
        this.attributes.addElement(new Attribute(key, values));
    }

    private void readBytes(byte[] eb) {
        int bc = 0;
        int len = Entry.bytesToInt(eb, bc);
        int hcode = Entry.bytesToInt(eb, bc += 4);
        byte[] nameBytes = new byte[len];
        System.arraycopy(eb, bc += 4, nameBytes, 0, len);
        this.name = new DirectoryString(nameBytes, hcode);
        bc += len;
        len = Entry.bytesToInt(eb, bc);
        hcode = Entry.bytesToInt(eb, bc += 4);
        byte[] baseBytes = new byte[len];
        System.arraycopy(eb, bc += 4, baseBytes, 0, len);
        this.base = new DirectoryString(baseBytes, hcode);
        bc += len;
        len = eb[bc];
        byte[] idBytes = new byte[len];
        System.arraycopy(eb, ++bc, idBytes, 0, len);
        this.id = Integer.parseInt(new String(idBytes));
        int numKeys = (eb[bc += len] & 0xFF) << 8 | eb[bc + 1] & 0xFF;
        this.attributes = new Vector(numKeys);
        byte[] keyBytes = null;
        byte[] valBytes = null;
        Syntax synVal = null;
        Vector<Syntax> values = null;
        DirectoryString key = null;
        Class synClass = null;
        AttributeType at = null;
        bc += 2;
        for (int keyCount = 0; keyCount < numKeys; ++keyCount) {
            len = eb[bc];
            int keyHC = Entry.bytesToInt(eb, ++bc);
            keyBytes = new byte[len];
            System.arraycopy(eb, bc += 4, keyBytes, 0, len);
            key = new DirectoryString(keyBytes, keyHC);
            int numValues = (eb[bc += len] & 0xFF) << 8 | eb[bc + 1] & 0xFF;
            values = new Vector<Syntax>(numValues);
            bc += 2;
            at = SchemaChecker.getInstance().getAttributeType(key);
            synClass = null;
            if (at != null) {
                synClass = at.getSyntaxClass();
                if (synClass == null) {
                    synClass = class$com$octetstring$vde$syntax$DirectoryString == null ? Entry.class$("com.octetstring.vde.syntax.DirectoryString") : class$com$octetstring$vde$syntax$DirectoryString;
                }
            } else {
                synClass = class$com$octetstring$vde$syntax$DirectoryString == null ? Entry.class$("com.octetstring.vde.syntax.DirectoryString") : class$com$octetstring$vde$syntax$DirectoryString;
            }
            for (int valCount = 0; valCount < numValues; ++valCount) {
                len = Entry.bytesToInt(eb, bc);
                int valHC = Entry.bytesToInt(eb, bc += 4);
                valBytes = new byte[len];
                System.arraycopy(eb, bc += 4, valBytes, 0, len);
                synVal = null;
                try {
                    synVal = (Syntax)synClass.newInstance();
                }
                catch (Exception e) {
                    Logger.getInstance().log(0, this, Messages.getString("Unable_to_create_new_value_with_Syntax____5") + synClass.getName() + "'");
                    synVal = new DirectoryString();
                }
                synVal.setValue(valBytes, valHC);
                values.addElement(synVal);
                bc += len;
            }
            this.put(key, values, false);
        }
    }

    public void remove(DirectoryString key) {
        Attribute thisAttr = null;
        Enumeration attrEnum = this.attributes.elements();
        while (attrEnum.hasMoreElements()) {
            Attribute oneAttr = (Attribute)attrEnum.nextElement();
            if (!oneAttr.equals(key)) continue;
            thisAttr = oneAttr;
        }
        if (thisAttr != null) {
            this.attributes.removeElement(thisAttr);
        }
    }

    public void setID(int id) {
        this.id = id;
    }

    public String toDSML() {
        StringBuffer dsmlString = new StringBuffer();
        dsmlString.append("<dsml:entry dn=\"").append(this.getName()).append("\">\n");
        Vector ocs = this.get(OBJECTCLASS);
        if (ocs != null) {
            dsmlString.append("  <dsml:objectclass>\n");
            Enumeration enumOcs = ocs.elements();
            while (enumOcs.hasMoreElements()) {
                dsmlString.append("    <dsml:oc-value>").append((DirectoryString)enumOcs.nextElement());
                dsmlString.append("</dsml:oc-value>\n");
            }
            dsmlString.append("  </dsml:objectclass>\n");
        }
        Enumeration enumAttrs = this.attributes.elements();
        while (enumAttrs.hasMoreElements()) {
            Attribute nextAttr = (Attribute)enumAttrs.nextElement();
            if (nextAttr.equals(OBJECTCLASS)) continue;
            dsmlString.append("  <dsml:attr name=\"").append(nextAttr.type);
            dsmlString.append("\">\n");
            Enumeration valEnum = nextAttr.values.elements();
            while (valEnum.hasMoreElements()) {
                dsmlString.append("    <dsml:value>");
                String val = valEnum.nextElement().toString();
                if (val.indexOf("<") >= 0 || val.indexOf(">") >= 0 || val.indexOf("&") >= 0 || val.indexOf("\"") >= 0) {
                    int oldloc = 0;
                    int loc = 0;
                    StringBuffer sb = null;
                    loc = val.indexOf("<");
                    sb = new StringBuffer();
                    while (loc >= 0) {
                        if (loc - oldloc > 0) {
                            sb.append(val.substring(oldloc, loc));
                            sb.append("&lt;");
                        } else {
                            sb.append("&lt;");
                        }
                        oldloc = loc + 1;
                        loc = val.indexOf("<", oldloc);
                    }
                    sb.append(val.substring(oldloc));
                    val = sb.toString();
                    sb = new StringBuffer();
                    oldloc = 0;
                    loc = val.indexOf(">");
                    while (loc >= 0) {
                        if (loc - oldloc > 0) {
                            sb.append(val.substring(oldloc, loc));
                            sb.append("&gt;");
                        } else {
                            sb.append("&gt;");
                        }
                        oldloc = loc + 1;
                        loc = val.indexOf(">", oldloc);
                    }
                    sb.append(val.substring(oldloc));
                    val = sb.toString();
                    sb = new StringBuffer();
                    oldloc = 0;
                    loc = val.indexOf("\"");
                    while (loc >= 0) {
                        if (loc - oldloc > 0) {
                            sb.append(val.substring(oldloc, loc));
                            sb.append("&quot;");
                        } else {
                            sb.append("&quot;");
                        }
                        oldloc = loc + 1;
                        loc = val.indexOf("\"", oldloc);
                    }
                    sb.append(val.substring(oldloc));
                    val = sb.toString();
                    sb = new StringBuffer();
                    oldloc = 0;
                    loc = val.indexOf("&");
                    while (loc >= 0) {
                        if (loc - oldloc > 0) {
                            sb.append(val.substring(oldloc, loc));
                            sb.append("&amp;");
                        } else {
                            sb.append("&amp;");
                        }
                        oldloc = loc + 1;
                        loc = val.indexOf("&", oldloc);
                    }
                    sb.append(val.substring(oldloc));
                    val = sb.toString();
                }
                dsmlString.append(val);
                dsmlString.append("</dsml:value>\n");
            }
            dsmlString.append("  </dsml:attr>\n");
        }
        dsmlString.append("</dsml:entry>\n");
        return dsmlString.toString();
    }

    public String toLDIF() {
        return this.toLDIF(null, null);
    }

    public String toLDIF(String[] encryptedAttribs, EncryptionHelper encrypter) {
        return this.toLDIF(encryptedAttribs, encrypter, false);
    }

    public String toLDIF(String[] encryptedAttribs, EncryptionHelper encrypter, boolean ignoreGuid) {
        StringBuffer ldifString = new StringBuffer();
        Enumeration enumAttrs = this.attributes.elements();
        while (enumAttrs.hasMoreElements()) {
            Attribute nextAttr = (Attribute)enumAttrs.nextElement();
            DirectoryString thisAttr = nextAttr.type;
            if (BackendStandard.GUID.equals(thisAttr) && ignoreGuid) continue;
            Enumeration valEnum = nextAttr.values.elements();
            while (valEnum.hasMoreElements()) {
                ldifString.append(thisAttr);
                Syntax sval = (Syntax)valEnum.nextElement();
                byte[] decryptedValue = null;
                if (encryptedAttribs != null) {
                    decryptedValue = this.checkEncryption(thisAttr, sval, encryptedAttribs, encrypter);
                }
                if (sval instanceof BinarySyntax) {
                    ldifString.append(":: ");
                } else {
                    ldifString.append(": ");
                }
                if (decryptedValue != null) {
                    ldifString.append(sval.returnAttributeValue(decryptedValue)).append("\n");
                    continue;
                }
                ldifString.append(sval.toString()).append("\n");
            }
        }
        return ldifString.toString();
    }

    private byte[] checkEncryption(DirectoryString dsVal, Syntax sVal, String[] encryptedAttribs, EncryptionHelper encrypter) {
        if (dsVal == null || sVal == null || encryptedAttribs == null || encrypter == null) {
            return null;
        }
        String attrName = dsVal.getDirectoryString();
        for (int i = 0; i < encryptedAttribs.length; ++i) {
            String encryptedString;
            if (!encryptedAttribs[i].equals(attrName)) continue;
            try {
                encryptedString = new String(sVal.getValue(), "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                encryptedString = new String(sVal.getValue());
            }
            try {
                return encrypter.decrypt(encryptedString).getBytes("UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                return encrypter.decrypt(encryptedString).getBytes();
            }
        }
        return null;
    }

    class KeyEnumeration
    implements Enumeration {
        Enumeration atEnum = null;

        KeyEnumeration() {
            this.atEnum = Entry.this.attributes.elements();
        }

        public boolean hasMoreElements() {
            return this.atEnum.hasMoreElements();
        }

        public Object nextElement() {
            return ((Attribute)this.atEnum.nextElement()).type;
        }
    }
}

