/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde;

import com.octetstring.nls.Messages;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class EntryChange {
    private int modType;
    public DirectoryString attr;
    public Vector values;
    private static final int byte1 = 255;
    private static final int byte2 = 65280;
    private static final int byte3 = 0xFF0000;
    private static final int byte4 = -16777216;

    public EntryChange() {
    }

    public EntryChange(byte[] entryChangeBytes, boolean oldVersion) {
        this.readBytes(entryChangeBytes, oldVersion);
    }

    public EntryChange(int modType2, DirectoryString attr, Vector values) {
        this.setModType(modType2);
        this.setAttr(attr);
        this.setValues(values);
    }

    public DirectoryString getAttr() {
        return this.attr;
    }

    public void setAttr(DirectoryString newAttr) {
        this.attr = newAttr;
    }

    public int getModType() {
        return this.modType;
    }

    public void setModType(int newModType) {
        this.modType = newModType;
    }

    public Vector getValues() {
        return this.values;
    }

    public void setValues(Vector newValues) {
        this.values = newValues;
    }

    private int bytesToInt(byte[] eb, int bc) {
        return (eb[bc] & 0xFF) << 24 | (eb[bc + 1] & 0xFF) << 16 | (eb[bc + 2] & 0xFF) << 8 | eb[bc + 3] & 0xFF;
    }

    public byte[] getAsByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int hc = 0;
        baos.write(this.modType);
        DirectoryString aKey = this.attr;
        baos.write(aKey.length());
        hc = aKey.hashCode();
        baos.write((hc & 0xFF000000) >> 24);
        baos.write((hc & 0xFF0000) >> 16);
        baos.write((hc & 0xFF00) >> 8);
        baos.write(hc & 0xFF);
        baos.write(aKey.getBytes(), 0, aKey.length());
        Vector vals = this.values;
        baos.write(vals.size());
        Enumeration valEnum = vals.elements();
        int valLen = 0;
        while (valEnum.hasMoreElements()) {
            Syntax aVal = (Syntax)valEnum.nextElement();
            valLen = aVal.getValue().length;
            baos.write((valLen & 0xFF000000) >> 24);
            baos.write((valLen & 0xFF0000) >> 16);
            baos.write((valLen & 0xFF00) >> 8);
            baos.write(valLen & 0xFF);
            hc = aVal.hashCode();
            baos.write((hc & 0xFF000000) >> 24);
            baos.write((hc & 0xFF0000) >> 16);
            baos.write((hc & 0xFF00) >> 8);
            baos.write(hc & 0xFF);
            baos.write(aVal.getValue(), 0, valLen);
        }
        byte[] entryBytes = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ioe) {
            Logger.getInstance().log(0, this, Messages.getString("Error_closing_ByteArrayOutputStream_1"));
        }
        return entryBytes;
    }

    private void readBytes(byte[] eb, boolean oldVersion) {
        DirectoryString key;
        int bc = 0;
        this.modType = eb[bc];
        int len = eb[++bc];
        int keyHC = this.bytesToInt(eb, ++bc);
        byte[] keyBytes = new byte[len];
        System.arraycopy(eb, bc += 4, keyBytes, 0, len);
        this.attr = key = new DirectoryString(keyBytes, keyHC);
        Vector<Syntax> values = new Vector<Syntax>();
        int numValues = eb[bc += len];
        ++bc;
        if (numValues < 0) {
            numValues = (numValues & 0x7F) + 128;
        }
        AttributeType at = SchemaChecker.getInstance().getAttributeType(key);
        Class synClass = null;
        if (at != null) {
            synClass = at.getSyntaxClass();
            if (synClass == null) {
                synClass = DirectoryString.class;
            }
        } else {
            synClass = DirectoryString.class;
        }
        for (int valCount = 0; valCount < numValues; ++valCount) {
            if (oldVersion) {
                len = eb[bc];
                if (len < 0) {
                    len = (eb[bc] & 0x7F) + 128;
                }
                ++bc;
            } else {
                len = this.bytesToInt(eb, bc);
                bc += 4;
            }
            int valHC = this.bytesToInt(eb, bc);
            byte[] valBytes = new byte[len];
            System.arraycopy(eb, bc += 4, valBytes, 0, len);
            Syntax synVal = null;
            try {
                synVal = (Syntax)synClass.newInstance();
            }
            catch (Exception e) {
                Logger.getInstance().log(0, this, Messages.getString("Unable_to_create_new_value_with_Syntax____2") + synClass.getName() + "'");
                synVal = new DirectoryString();
            }
            synVal.setValue(valBytes);
            values.addElement(synVal);
            bc += len;
        }
        this.values = values;
    }

    public String toLDIF() {
        StringBuffer echange = new StringBuffer();
        if (this.modType == 0) {
            echange.append("add: ");
        }
        if (this.modType == 1) {
            echange.append("replace: ");
        }
        if (this.modType == 2) {
            echange.append("delete: ");
        }
        echange.append(this.attr).append("\n");
        Enumeration valEnum = this.values.elements();
        while (valEnum.hasMoreElements()) {
            echange.append(this.attr).append(": ").append(valEnum.nextElement()).append("\n");
        }
        echange.append("-\n");
        return echange.toString();
    }
}

