/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde;

import com.octetstring.vde.Entry;
import com.octetstring.vde.EntryChange;
import com.octetstring.vde.syntax.DirectoryString;

public class EntryChanges {
    public static final int CHANGE_ADD = 1;
    public static final int CHANGE_MODIFY = 2;
    public static final int CHANGE_DELETE = 3;
    public static final int CHANGE_RENAME = 4;
    private static final int byte1 = 255;
    private static final int byte2 = 65280;
    private static final int byte3 = 0xFF0000;
    private static final int byte4 = -16777216;
    private int changeType = 0;
    private Entry fullEntry = null;
    private EntryChange[] entryChanges = null;
    private DirectoryString name = null;
    private DirectoryString newname = null;

    public EntryChanges(byte[] ecBytes) {
        this.readBytes(ecBytes, false);
    }

    public EntryChanges(byte[] ecBytes, boolean oldVersion) {
        this.readBytes(ecBytes, oldVersion);
    }

    public EntryChanges(Entry fullEntry) {
        this.fullEntry = fullEntry;
        this.changeType = 1;
    }

    public EntryChanges(DirectoryString name) {
        this.name = name;
        this.changeType = 3;
    }

    public EntryChanges(DirectoryString name, EntryChange[] entryChanges) {
        this.entryChanges = entryChanges;
        this.name = name;
        this.changeType = 2;
    }

    public EntryChanges(DirectoryString name, DirectoryString newname) {
        this.name = name;
        this.newname = newname;
        this.changeType = 4;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public EntryChange[] getEntryChanges() {
        return this.entryChanges;
    }

    public Entry getFullEntry() {
        return this.fullEntry;
    }

    public DirectoryString getName() {
        return this.name;
    }

    public DirectoryString getNewName() {
        return this.newname;
    }

    private int bytesToInt(byte[] eb, int bc) {
        return (eb[bc] & 0xFF) << 24 | (eb[bc + 1] & 0xFF) << 16 | (eb[bc + 2] & 0xFF) << 8 | eb[bc + 3] & 0xFF;
    }

    public byte[] getAsByteArray() {
        byte[] fullBytes;
        byte[] changeBytes = null;
        if (this.changeType == 1) {
            fullBytes = this.fullEntry.getAsByteArray();
            changeBytes = new byte[fullBytes.length + 1];
            changeBytes[0] = 1;
            System.arraycopy(fullBytes, 0, changeBytes, 1, fullBytes.length);
        }
        if (this.changeType == 2) {
            fullBytes = this.name.getBytes();
            for (int changeno = 0; changeno < this.entryChanges.length; ++changeno) {
                byte[] currentChangeBytes = this.entryChanges[changeno].getAsByteArray();
                byte[] newArray = new byte[fullBytes.length + currentChangeBytes.length + 4];
                System.arraycopy(fullBytes, 0, newArray, 0, fullBytes.length);
                int cl = currentChangeBytes.length;
                int fbl = fullBytes.length;
                newArray[fbl] = (byte)((cl & 0xFF000000) >> 24);
                newArray[fbl + 1] = (byte)((cl & 0xFF0000) >> 16);
                newArray[fbl + 2] = (byte)((cl & 0xFF00) >> 8);
                newArray[fbl + 3] = (byte)(cl & 0xFF);
                System.arraycopy(currentChangeBytes, 0, newArray, fbl + 4, cl);
                fullBytes = newArray;
            }
            changeBytes = new byte[fullBytes.length + 6];
            changeBytes[0] = 2;
            int nl = this.name.length();
            changeBytes[1] = (byte)((nl & 0xFF000000) >> 24);
            changeBytes[2] = (byte)((nl & 0xFF0000) >> 16);
            changeBytes[3] = (byte)((nl & 0xFF00) >> 8);
            changeBytes[4] = (byte)(nl & 0xFF);
            changeBytes[5] = (byte)this.entryChanges.length;
            System.arraycopy(fullBytes, 0, changeBytes, 6, fullBytes.length);
        }
        if (this.changeType == 3) {
            fullBytes = this.name.getBytes();
            changeBytes = new byte[fullBytes.length + 5];
            changeBytes[0] = 3;
            changeBytes[1] = (byte)((fullBytes.length & 0xFF000000) >> 24);
            changeBytes[2] = (byte)((fullBytes.length & 0xFF0000) >> 16);
            changeBytes[3] = (byte)((fullBytes.length & 0xFF00) >> 8);
            changeBytes[4] = (byte)(fullBytes.length & 0xFF);
            System.arraycopy(fullBytes, 0, changeBytes, 5, fullBytes.length);
        }
        if (this.changeType == 4) {
            byte[] oldnamebytes = this.name.getBytes();
            byte[] newnamebytes = this.newname.getBytes();
            changeBytes = new byte[oldnamebytes.length + newnamebytes.length + 9];
            changeBytes[0] = 4;
            changeBytes[1] = (byte)((oldnamebytes.length & 0xFF000000) >> 24);
            changeBytes[2] = (byte)((oldnamebytes.length & 0xFF0000) >> 16);
            changeBytes[3] = (byte)((oldnamebytes.length & 0xFF00) >> 8);
            changeBytes[4] = (byte)(oldnamebytes.length & 0xFF);
            System.arraycopy(oldnamebytes, 0, changeBytes, 5, oldnamebytes.length);
            int nb = oldnamebytes.length + 5;
            changeBytes[nb] = (byte)((newnamebytes.length & 0xFF000000) >> 24);
            changeBytes[nb + 1] = (byte)((newnamebytes.length & 0xFF0000) >> 16);
            changeBytes[nb + 2] = (byte)((newnamebytes.length & 0xFF00) >> 8);
            changeBytes[nb + 3] = (byte)(newnamebytes.length & 0xFF);
            System.arraycopy(newnamebytes, 0, changeBytes, nb + 4, newnamebytes.length);
        }
        return changeBytes;
    }

    private void readBytes(byte[] cb, boolean oldVersion) {
        int bc = 0;
        this.changeType = cb[bc];
        ++bc;
        if (this.changeType == 1) {
            byte[] fullent = new byte[cb.length - bc];
            System.arraycopy(cb, bc, fullent, 0, cb.length - 1);
            this.fullEntry = new Entry(fullent);
        }
        if (this.changeType == 2) {
            int len = this.bytesToInt(cb, bc);
            int atct = cb[bc += 4];
            byte[] myName = new byte[len];
            System.arraycopy(cb, ++bc, myName, 0, len);
            this.name = new DirectoryString(myName);
            bc += len;
            this.entryChanges = new EntryChange[atct];
            for (int ct = 0; ct < atct; ++ct) {
                len = this.bytesToInt(cb, bc);
                byte[] ocb = new byte[len];
                System.arraycopy(cb, bc += 4, ocb, 0, len);
                bc += len;
                this.entryChanges[ct] = new EntryChange(ocb, oldVersion);
            }
        }
        if (this.changeType == 3) {
            int len = this.bytesToInt(cb, bc);
            byte[] myName = new byte[len];
            System.arraycopy(cb, bc += 4, myName, 0, len);
            bc += len;
            this.name = new DirectoryString(myName);
        }
        if (this.changeType == 4) {
            int len = this.bytesToInt(cb, bc);
            byte[] oldName = new byte[len];
            System.arraycopy(cb, bc += 4, oldName, 0, len);
            bc += len;
            this.name = new DirectoryString(oldName);
            len = this.bytesToInt(cb, bc);
            byte[] newName = new byte[len];
            System.arraycopy(cb, bc += 4, newName, 0, len);
            bc += len;
            this.newname = new DirectoryString(newName);
        }
    }
}

