/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde;

import com.octetstring.nls.Messages;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ServerConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class License {
    private String company = null;
    private String product = null;
    private String expirationdate = null;
    private byte[] licensehash = null;
    private boolean validated = false;
    private static final String NONCE = "octstring";

    public License(String company, String product, String expirationdate, String keyencoding) {
        this.company = company;
        this.product = product;
        this.expirationdate = expirationdate;
        this.licensehash = new byte[16];
        StringTokenizer kt = new StringTokenizer(keyencoding, ":");
        int counter = 0;
        while (kt.hasMoreTokens()) {
            this.licensehash[counter] = Integer.decode("0x" + kt.nextToken()).byteValue();
            ++counter;
        }
    }

    public License() {
        Properties licenseprop = new Properties();
        String ihome = System.getProperty("vde.home");
        String fullpath = null;
        fullpath = ihome == null ? (String)ServerConfig.getInstance().get("vde.licensefile") : ihome + "/" + (String)ServerConfig.getInstance().get("vde.licensefile");
        try {
            FileInputStream is = new FileInputStream(fullpath);
            licenseprop.load(is);
            is.close();
        }
        catch (FileNotFoundException fnfe) {
            Logger.getInstance().log(0, this, Messages.getString("License_File_Not_Found___6") + fullpath);
            return;
        }
        catch (IOException ioe) {
            Logger.getInstance().log(0, this, Messages.getString("IO_Error_Reading_License_File___7") + fullpath);
            return;
        }
        this.company = (String)licenseprop.get("company");
        this.product = (String)licenseprop.get("product");
        this.expirationdate = (String)licenseprop.get("expirationdate");
        String keyencoding = (String)licenseprop.get("key");
        this.licensehash = new byte[16];
        StringTokenizer kt = new StringTokenizer(keyencoding, ":");
        int counter = 0;
        while (kt.hasMoreTokens()) {
            this.licensehash[counter] = Integer.decode("0x" + kt.nextToken()).byteValue();
            ++counter;
        }
        MessageDigest md52 = null;
        try {
            md52 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            Logger.getInstance().log(0, this, Messages.getString("Error_Validating_License_Key._15"));
            return;
        }
        md52.update(NONCE.getBytes());
        md52.update(this.company.getBytes());
        md52.update(this.product.getBytes());
        md52.update(this.expirationdate.getBytes());
        Logger.getInstance().log(5, this, Messages.getString("Licensed_to__16") + this.company + Messages.getString("_for_product____17") + this.product + "'.");
        if (!this.expirationdate.equals("never")) {
            Logger.getInstance().log(5, this, Messages.getString("Expires_on__20") + this.expirationdate);
        }
        byte[] realhash = md52.digest();
        for (int i = 0; i < 16; ++i) {
            if (this.licensehash[i] == realhash[i]) continue;
            this.validated = false;
            return;
        }
        this.validated = true;
    }

    public boolean checkLicense(String product) {
        if (!this.validated) {
            MessageDigest md52 = null;
            try {
                md52 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                return false;
            }
            md52.update(NONCE.getBytes());
            md52.update(this.company.getBytes());
            md52.update(product.getBytes());
            md52.update(this.expirationdate.getBytes());
            byte[] realhash = md52.digest();
            for (int i = 0; i < 16; ++i) {
                if (this.licensehash[i] == realhash[i]) continue;
                return false;
            }
            this.validated = true;
        }
        if (this.validated && product.equals(product)) {
            if (this.expirationdate.equals("never")) {
                return true;
            }
            DateFormat df = DateFormat.getDateInstance(3, Locale.US);
            Date exdate = null;
            try {
                exdate = df.parse(this.expirationdate);
            }
            catch (ParseException pe) {
                return false;
            }
            Date nowdate = new Date();
            if (nowdate.after(exdate)) {
                Logger.getInstance().log(0, this, Messages.getString("License_Expired!_Contact_sales@octetstring.com!_23"));
                return false;
            }
            return true;
        }
        return false;
    }
}

