/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde;

import com.octetstring.vde.DoSManager;
import com.octetstring.vde.MessageHandler;
import com.octetstring.vde.WorkQueue;
import com.octetstring.vde.WorkQueueItem;
import com.octetstring.vde.util.Logger;

public class WorkThread
extends Thread {
    private WorkQueue wq = null;
    private MessageHandler mh = null;

    public WorkThread(WorkQueue wq) {
        this.setPriority(6);
        this.wq = wq;
        this.mh = new MessageHandler();
    }

    public WorkThread(WorkQueue wq, ThreadGroup wg, String name) {
        super(wg, name);
        this.setPriority(6);
        this.wq = wq;
        this.mh = new MessageHandler();
    }

    public void run() {
        WorkQueueItem currentItem = null;
        boolean alive = false;
        while (true) {
            try {
                while (true) {
                    if ((currentItem = this.wq.nextItem()) == null) {
                        continue;
                    }
                    this.mh.setConnection(currentItem.getConnection());
                    alive = this.mh.answerRequest(currentItem.getMessage());
                    if (alive) continue;
                    DoSManager.getInstance().unregisterConnection(currentItem.getConnection());
                    currentItem.getConnection().setUnbound(true);
                    currentItem.getConnection().close();
                }
            }
            catch (Exception e) {
                Logger.getInstance().log(0, this, e.getClass().getName() + ": " + e.getMessage());
                Logger.getInstance().printStackTraceConsole(e);
                Logger.getInstance().printStackTraceLog(e);
                DoSManager.getInstance().unregisterConnection(currentItem.getConnection());
                continue;
            }
            break;
        }
    }

    public static void executeWorkQueueItem(WorkQueueItem currentItem) {
        if (currentItem != null) {
            try {
                MessageHandler mh = new MessageHandler();
                mh.setConnection(currentItem.getConnection());
                boolean alive = mh.answerRequest(currentItem.getMessage());
                if (!alive) {
                    currentItem.getConnection().setUnbound(true);
                    currentItem.getConnection().close();
                }
            }
            catch (Exception e) {
                Logger.getInstance().log(0, currentItem, e.getClass().getName() + ": " + e.getMessage());
                Logger.getInstance().printStackTraceConsole(e);
                Logger.getInstance().printStackTraceLog(e);
            }
        }
    }
}

