/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.acl;

import com.octetstring.ldapv3.Filter;
import com.octetstring.ldapv3.SubstringFilter_substrings_Seq;
import com.octetstring.vde.Credentials;
import com.octetstring.vde.Entry;
import com.octetstring.vde.EntrySet;
import com.octetstring.vde.acl.ACL;
import com.octetstring.vde.backend.BackendHandler;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DNUtility;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.LDAPURL;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ServerConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class ACLChecker {
    private static Hashtable entryacls = null;
    private static Hashtable subtreeacls = null;
    private static ACLChecker instance = null;
    private boolean aclCheck = true;
    private DirectoryString rootUser = null;
    private static final DirectoryString ATTR_ALL = new DirectoryString("[all]");
    private static final DirectoryString ROOTENTRY = new DirectoryString("[root]");
    private static final DirectoryString EMPTY_DS = new DirectoryString("");
    private static final DirectoryString ATTR_MEMBER = new DirectoryString("member");
    private static final DirectoryString ATTR_UNIQUEMEMBER = new DirectoryString("uniquemember");
    private static final DirectoryString ATTR_MEMBERURL = new DirectoryString("memberurl");
    public static final Character PERM_ADD = new Character('a');
    public static final Character PERM_DELETE = new Character('d');
    public static final Character PERM_EXPORT = new Character('e');
    public static final Character PERM_IMPORT = new Character('i');
    public static final Character PERM_RENAMEDN = new Character('n');
    public static final Character PERM_BROWSEDN = new Character('b');
    public static final Character PERM_RETURNDN = new Character('t');
    public static final Character PERM_READ = new Character('r');
    public static final Character PERM_SEARCH = new Character('s');
    public static final Character PERM_WRITE = new Character('w');
    public static final Character PERM_OBLITERATE = new Character('o');
    public static final Character PERM_COMPARE = new Character('c');
    public static final Character PERM_MAKE = new Character('m');

    private ACLChecker() {
        if (((String)ServerConfig.getInstance().get("vde.aclcheck")).equals("0")) {
            this.aclCheck = false;
        } else {
            this.rootUser = new DirectoryString((String)ServerConfig.getInstance().get("vde.rootuser"));
            Logger.getInstance().log(7, this, "Root User is: " + this.rootUser);
        }
    }

    public static ACLChecker getInstance() {
        if (instance == null) {
            instance = new ACLChecker();
        }
        return instance;
    }

    public void addACL(DirectoryString aclLoc, ACL acl) {
        Hashtable acls = null;
        acls = acl.isScopeSubtree() ? subtreeacls : entryacls;
        Vector<ACL> aclVec = (Vector<ACL>)acls.get(aclLoc);
        if (aclVec == null) {
            aclVec = new Vector<ACL>();
            acls.put(aclLoc, aclVec);
        } else if (aclVec.contains(acl)) {
            return;
        }
        aclVec.addElement(acl);
    }

    public void deleteACL(DirectoryString aclLoc) {
        boolean writeit = false;
        if (entryacls.containsKey(aclLoc)) {
            entryacls.remove(aclLoc);
            writeit = true;
        }
        if (subtreeacls.containsKey(aclLoc)) {
            subtreeacls.remove(aclLoc);
            writeit = true;
        }
    }

    public void deleteACL(DirectoryString aclLoc, ACL acl) {
        Hashtable acls = null;
        acls = acl.isScopeSubtree() ? subtreeacls : entryacls;
        Vector aclVec = (Vector)acls.get(aclLoc);
        if (aclVec != null && aclVec.contains(acl)) {
            aclVec.removeElement(acl);
            if (aclVec.isEmpty()) {
                acls.remove(aclLoc);
            } else {
                acls.put(aclLoc, aclVec);
            }
        }
    }

    public Vector getEntryACLs(DirectoryString aclLoc) {
        Vector myAcls = (Vector)entryacls.get(aclLoc);
        return myAcls;
    }

    public Vector getSubtreeACLs(DirectoryString aclLoc) {
        Vector myAcls = (Vector)subtreeacls.get(aclLoc);
        return myAcls;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        ACLChecker.entryacls = new Hashtable<K, V>();
        ACLChecker.subtreeacls = new Hashtable<K, V>();
        br = null;
        try {
            aclfilename = (String)ServerConfig.getInstance().get("vde.aclfile");
            ihome = System.getProperty("vde.home");
            fullname = null;
            file = new File(aclfilename);
            fullname = file.isAbsolute() != false || ihome == null ? aclfilename : ihome + "/" + aclfilename;
            br = new BufferedReader(new FileReader(fullname));
        }
        catch (FileNotFoundException fnfe) {
            Logger.getInstance().log(0, this, "File containing ACLs not found");
            return;
        }
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                if (!br.ready()) {
                    br.close();
                    return;
                }
                acl = br.readLine();
                if (acl == null || acl.charAt(0) == '#' || acl.indexOf(124) == -1) continue;
                aclTok = new StringTokenizer(acl, "|");
                aclLoc = new DirectoryString(aclTok.nextToken());
                Logger.getInstance().log(7, this, "Found ACL for: " + aclLoc);
                if (aclLoc.equals(ACLChecker.ROOTENTRY)) {
                    aclLoc = ACLChecker.EMPTY_DS;
                }
                try {
                    aclLoc = DNUtility.getInstance().normalize(aclLoc);
                    aclSB = new StringBuffer();
                    while (aclTok.hasMoreTokens()) {
                        aclSB.append(aclTok.nextToken());
                        if (!aclTok.hasMoreTokens()) continue;
                        aclSB.append('|');
                    }
                    this.addACL(aclLoc, new ACL(aclSB.toString()));
                }
                catch (InvalidDNException ide) {
                    Logger.getInstance().log(0, this, "Invalid ACL Location: " + aclLoc);
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            Logger.getInstance().log(0, this, "Error reading ACL file.");
        }
        ** GOTO lbl-1000
    }

    public boolean isAllowed(Credentials creds, Character action, Entry targetEntry) {
        DirectoryString target = targetEntry.getName();
        boolean allowed = false;
        ACL matchedACL = null;
        DirectoryString matchedLoc = null;
        DirectoryString subject = null;
        if (!this.aclCheck) {
            return true;
        }
        subject = creds != null ? creds.getUser() : EMPTY_DS;
        if (creds.isRoot()) {
            return true;
        }
        Vector entryAcls = (Vector)entryacls.get(target);
        Enumeration eaEnum = null;
        if (entryAcls != null && !entryAcls.isEmpty()) {
            eaEnum = entryAcls.elements();
        }
        Enumeration aclEnum = subtreeacls.keys();
        DirectoryString aclLoc = null;
        while (aclEnum.hasMoreElements() || eaEnum != null) {
            Enumeration oneAclSet = null;
            boolean processAcl = false;
            if (eaEnum != null) {
                aclLoc = target;
                oneAclSet = eaEnum;
                processAcl = true;
            } else {
                aclLoc = (DirectoryString)aclEnum.nextElement();
                if (target.endsWith(aclLoc)) {
                    oneAclSet = ((Vector)subtreeacls.get(aclLoc)).elements();
                    processAcl = true;
                }
            }
            if (!processAcl) continue;
            while (oneAclSet.hasMoreElements()) {
                ACL oneAcl = (ACL)oneAclSet.nextElement();
                if (!oneAcl.getPermission().contains(action)) continue;
                if (oneAcl.getSubjectType() != 2) {
                    if (oneAcl.getSubjectType() != 64 || !oneAcl.isAuthzDN() || !oneAcl.getSubject().equals(subject)) {
                        if (oneAcl.getSubjectType() != 32 || !subject.equals(target)) {
                            if (oneAcl.getSubjectType() != 4 || !subject.endsWith(oneAcl.getSubject())) {
                                if (oneAcl.getSubjectType() != 16 || !this.userInGroup(subject, oneAcl.getSubject())) continue;
                            }
                        }
                    }
                }
                if (oneAcl.getTargetFilter() != null && !this.evalFilter(targetEntry, oneAcl.getTargetFilter())) continue;
                if (matchedACL == null) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (!oneAcl.isScopeSubtree()) {
                    if (!matchedACL.isScopeSubtree()) {
                        if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                            allowed = oneAcl.isGrant();
                            matchedACL = oneAcl;
                            matchedLoc = aclLoc;
                            continue;
                        }
                        if (!oneAcl.isGrant() || !matchedACL.isGrant()) {
                            allowed = false;
                            continue;
                        }
                        allowed = true;
                        continue;
                    }
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() < aclLoc.length()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() != aclLoc.length()) continue;
                if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedACL.getSubjectType() != oneAcl.getSubjectType()) continue;
                if (!matchedACL.isGrant() || !oneAcl.isGrant()) {
                    allowed = false;
                    continue;
                }
                allowed = true;
            }
            eaEnum = null;
        }
        if (Logger.getInstance().isLogable(9)) {
            if (allowed) {
                Logger.getInstance().log(9, this, "allow-" + action + "--" + creds + "-" + target);
            } else {
                Logger.getInstance().log(9, this, "deny-" + action + "--" + creds + "-" + target);
            }
        }
        return allowed;
    }

    public boolean isAllowed(Credentials creds, Character action, DirectoryString target) {
        boolean allowed = false;
        ACL matchedACL = null;
        DirectoryString matchedLoc = null;
        DirectoryString subject = null;
        if (!this.aclCheck) {
            return true;
        }
        subject = creds != null ? creds.getUser() : EMPTY_DS;
        if (creds.isRoot()) {
            return true;
        }
        Vector entryAcls = (Vector)entryacls.get(target);
        Enumeration eaEnum = null;
        if (entryAcls != null && !entryAcls.isEmpty()) {
            eaEnum = entryAcls.elements();
        }
        Enumeration aclEnum = subtreeacls.keys();
        DirectoryString aclLoc = null;
        while (aclEnum.hasMoreElements() || eaEnum != null) {
            Enumeration oneAclSet = null;
            boolean processAcl = false;
            if (eaEnum != null) {
                aclLoc = target;
                oneAclSet = eaEnum;
                processAcl = true;
            } else {
                aclLoc = (DirectoryString)aclEnum.nextElement();
                if (target.endsWith(aclLoc)) {
                    oneAclSet = ((Vector)subtreeacls.get(aclLoc)).elements();
                    processAcl = true;
                }
            }
            if (!processAcl) continue;
            while (oneAclSet.hasMoreElements()) {
                ACL oneAcl = (ACL)oneAclSet.nextElement();
                if (!oneAcl.getPermission().contains(action)) continue;
                if (oneAcl.getSubjectType() != 2) {
                    if (oneAcl.getSubjectType() != 64 || !oneAcl.isAuthzDN() || !oneAcl.getSubject().equals(subject)) {
                        if (oneAcl.getSubjectType() != 32 || !subject.equals(target)) {
                            if (oneAcl.getSubjectType() != 4 || !subject.endsWith(oneAcl.getSubject())) {
                                if (oneAcl.getSubjectType() != 16 || !this.userInGroup(subject, oneAcl.getSubject())) continue;
                            }
                        }
                    }
                }
                if (matchedACL == null) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (!oneAcl.isScopeSubtree()) {
                    if (!matchedACL.isScopeSubtree()) {
                        if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                            allowed = oneAcl.isGrant();
                            matchedACL = oneAcl;
                            matchedLoc = aclLoc;
                            continue;
                        }
                        if (!oneAcl.isGrant() || !matchedACL.isGrant()) {
                            allowed = false;
                            continue;
                        }
                        allowed = true;
                        continue;
                    }
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() < aclLoc.length()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() != aclLoc.length()) continue;
                if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedACL.getSubjectType() != oneAcl.getSubjectType()) continue;
                if (!matchedACL.isGrant() || !oneAcl.isGrant()) {
                    allowed = false;
                    continue;
                }
                allowed = true;
            }
            eaEnum = null;
        }
        if (Logger.getInstance().isLogable(9)) {
            if (allowed) {
                Logger.getInstance().log(9, this, "allow-" + action + "--" + creds + "-" + target);
            } else {
                Logger.getInstance().log(9, this, "deny-" + action + "--" + creds + "-" + target);
            }
        }
        return allowed;
    }

    public boolean isAllowed(Credentials creds, Character action, Entry targetEntry, DirectoryString attr) {
        DirectoryString target = targetEntry.getName();
        boolean allowed = false;
        ACL matchedACL = null;
        DirectoryString matchedLoc = null;
        DirectoryString subject = null;
        if (!this.aclCheck) {
            return true;
        }
        subject = creds != null ? creds.getUser() : new DirectoryString("");
        if (creds.isRoot()) {
            return true;
        }
        Vector entryAcls = (Vector)entryacls.get(target);
        Enumeration eaEnum = null;
        if (entryAcls != null && !entryAcls.isEmpty()) {
            eaEnum = entryAcls.elements();
        }
        Enumeration aclEnum = subtreeacls.keys();
        while (aclEnum.hasMoreElements() || eaEnum != null) {
            Enumeration oneAclSet = null;
            boolean processAcl = false;
            DirectoryString aclLoc = null;
            if (eaEnum != null) {
                aclLoc = target;
                oneAclSet = eaEnum;
                processAcl = true;
            } else {
                aclLoc = (DirectoryString)aclEnum.nextElement();
                if (target.endsWith(aclLoc)) {
                    oneAclSet = ((Vector)subtreeacls.get(aclLoc)).elements();
                    processAcl = true;
                }
            }
            if (!processAcl) continue;
            while (oneAclSet.hasMoreElements()) {
                ACL oneAcl = (ACL)oneAclSet.nextElement();
                if (!oneAcl.getPermission().contains(action) || !oneAcl.getAttr().contains(attr) && !oneAcl.getAttr().contains(ATTR_ALL)) continue;
                if (oneAcl.getSubjectType() != 2) {
                    if (oneAcl.getSubjectType() != 64 || !oneAcl.isAuthzDN() || !oneAcl.getSubject().equals(subject)) {
                        if (oneAcl.getSubjectType() != 32 || !subject.equals(target)) {
                            if (oneAcl.getSubjectType() != 4 || !subject.endsWith(oneAcl.getSubject())) {
                                if (oneAcl.getSubjectType() != 16 || !this.userInGroup(subject, oneAcl.getSubject())) continue;
                            }
                        }
                    }
                }
                if (oneAcl.getTargetFilter() != null && !this.evalFilter(targetEntry, oneAcl.getTargetFilter())) continue;
                if (matchedACL == null) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (!oneAcl.isScopeSubtree()) {
                    if (!matchedACL.isScopeSubtree()) {
                        if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                            allowed = oneAcl.isGrant();
                            matchedACL = oneAcl;
                            matchedLoc = aclLoc;
                            continue;
                        }
                        if (!oneAcl.isGrant() || !matchedACL.isGrant()) {
                            allowed = false;
                            continue;
                        }
                        allowed = true;
                        continue;
                    }
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() < aclLoc.length()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() != aclLoc.length()) continue;
                if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedACL.getSubjectType() != oneAcl.getSubjectType()) continue;
                if (!matchedACL.isGrant() || !oneAcl.isGrant()) {
                    allowed = false;
                    continue;
                }
                allowed = true;
            }
            eaEnum = null;
        }
        if (Logger.getInstance().isLogable(9)) {
            if (allowed) {
                Logger.getInstance().log(9, this, "allow-" + action + "-" + attr + "-" + creds + "-" + target);
            } else {
                Logger.getInstance().log(7, this, "deny-" + action + "-" + attr + "-" + creds + "-" + target);
            }
        }
        return allowed;
    }

    public boolean isAllowed(Credentials creds, Character action, DirectoryString target, DirectoryString attr) {
        boolean allowed = false;
        ACL matchedACL = null;
        DirectoryString matchedLoc = null;
        DirectoryString subject = null;
        if (!this.aclCheck) {
            return true;
        }
        subject = creds != null ? creds.getUser() : new DirectoryString("");
        if (creds.isRoot()) {
            return true;
        }
        Vector entryAcls = (Vector)entryacls.get(target);
        Enumeration eaEnum = null;
        if (entryAcls != null && !entryAcls.isEmpty()) {
            eaEnum = entryAcls.elements();
        }
        Enumeration aclEnum = subtreeacls.keys();
        while (aclEnum.hasMoreElements() || eaEnum != null) {
            Enumeration oneAclSet = null;
            boolean processAcl = false;
            DirectoryString aclLoc = null;
            if (eaEnum != null) {
                aclLoc = target;
                oneAclSet = eaEnum;
                processAcl = true;
            } else {
                aclLoc = (DirectoryString)aclEnum.nextElement();
                if (target.endsWith(aclLoc)) {
                    oneAclSet = ((Vector)subtreeacls.get(aclLoc)).elements();
                    processAcl = true;
                }
            }
            if (!processAcl) continue;
            while (oneAclSet.hasMoreElements()) {
                ACL oneAcl = (ACL)oneAclSet.nextElement();
                if (!oneAcl.getPermission().contains(action) || !oneAcl.getAttr().contains(attr) && !oneAcl.getAttr().contains(ATTR_ALL)) continue;
                if (oneAcl.getSubjectType() != 2) {
                    if (oneAcl.getSubjectType() != 64 || !oneAcl.isAuthzDN() || !oneAcl.getSubject().equals(subject)) {
                        if (oneAcl.getSubjectType() != 32 || !subject.equals(target)) {
                            if (oneAcl.getSubjectType() != 4 || !subject.endsWith(oneAcl.getSubject())) {
                                if (oneAcl.getSubjectType() != 16 || !this.userInGroup(subject, oneAcl.getSubject())) continue;
                            }
                        }
                    }
                }
                if (matchedACL == null) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (!oneAcl.isScopeSubtree()) {
                    if (!matchedACL.isScopeSubtree()) {
                        if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                            allowed = oneAcl.isGrant();
                            matchedACL = oneAcl;
                            matchedLoc = aclLoc;
                            continue;
                        }
                        if (!oneAcl.isGrant() || !matchedACL.isGrant()) {
                            allowed = false;
                            continue;
                        }
                        allowed = true;
                        continue;
                    }
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() < aclLoc.length()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedLoc.length() != aclLoc.length()) continue;
                if (matchedACL.getSubjectType() < oneAcl.getSubjectType()) {
                    matchedACL = oneAcl;
                    matchedLoc = aclLoc;
                    if (oneAcl.isGrant()) {
                        allowed = true;
                        continue;
                    }
                    allowed = false;
                    continue;
                }
                if (matchedACL.getSubjectType() != oneAcl.getSubjectType()) continue;
                if (!matchedACL.isGrant() || !oneAcl.isGrant()) {
                    allowed = false;
                    continue;
                }
                allowed = true;
            }
            eaEnum = null;
        }
        if (Logger.getInstance().isLogable(9)) {
            if (allowed) {
                Logger.getInstance().log(9, this, "allow-" + action + "-" + attr + "-" + creds + "-" + target);
            } else {
                Logger.getInstance().log(7, this, "deny-" + action + "-" + attr + "-" + creds + "-" + target);
            }
        }
        return allowed;
    }

    public boolean userInGroup(DirectoryString subject, DirectoryString group) {
        Entry groupent = null;
        try {
            groupent = BackendHandler.getInstance().getByDN(null, group);
        }
        catch (DirectoryException de) {
            Logger.getInstance().log(0, this, "Error searching for " + group + ": " + de.getMessage());
            return false;
        }
        if (groupent == null) {
            return false;
        }
        Vector vals = groupent.get(ATTR_MEMBER);
        if (vals == null) {
            vals = groupent.get(ATTR_UNIQUEMEMBER);
        }
        if (vals == null) {
            vals = groupent.get(ATTR_MEMBERURL);
            if (vals != null) {
                Enumeration gmue = vals.elements();
                while (gmue.hasMoreElements()) {
                    String strurl = ((Syntax)gmue.nextElement()).toString();
                    try {
                        LDAPURL url = LDAPURL.fromString(strurl);
                        if (!subject.endsWith(url.getBase())) {
                            return false;
                        }
                        Vector tmpesets = BackendHandler.getInstance().get(null, subject, 0, url.getFilter(), true, new Vector());
                        if (tmpesets.isEmpty() || !((EntrySet)tmpesets.firstElement()).hasMore()) continue;
                        return true;
                    }
                    catch (DirectoryException de) {
                        return false;
                    }
                }
            }
            return false;
        }
        return vals != null && vals.contains(subject);
    }

    public synchronized void writeACLFile() {
        BufferedWriter bw = null;
        try {
            ACL oneAcl;
            Enumeration rules;
            Vector list;
            DirectoryString loc;
            bw = new BufferedWriter(new FileWriter((String)ServerConfig.getInstance().get("vde.aclfile")));
            Enumeration acllocEnum = entryacls.keys();
            while (acllocEnum.hasMoreElements()) {
                loc = (DirectoryString)acllocEnum.nextElement();
                list = (Vector)entryacls.get(loc);
                rules = list.elements();
                while (rules.hasMoreElements()) {
                    oneAcl = (ACL)rules.nextElement();
                    bw.write(loc + "|" + oneAcl.toString());
                    bw.newLine();
                }
            }
            acllocEnum = subtreeacls.keys();
            while (acllocEnum.hasMoreElements()) {
                loc = (DirectoryString)acllocEnum.nextElement();
                list = (Vector)subtreeacls.get(loc);
                rules = list.elements();
                while (rules.hasMoreElements()) {
                    oneAcl = (ACL)rules.nextElement();
                    bw.write(loc + "|" + oneAcl.toString());
                    bw.newLine();
                }
            }
            bw.close();
        }
        catch (IOException ioe) {
            Logger.getInstance().printStackTrace(ioe);
        }
    }

    private boolean evalFilter(Entry entry, Filter filter) {
        DirectoryString type = null;
        Syntax val = null;
        Vector attrVals = null;
        try {
            switch (filter.getSelector()) {
                case 3: {
                    type = new DirectoryString(filter.getEqualityMatch().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                    val.setValue(filter.getEqualityMatch().getAssertionValue().toByteArray());
                    return attrVals.contains(val);
                }
                case 8: {
                    type = new DirectoryString(filter.getApproxMatch().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                    val.setValue(filter.getApproxMatch().getAssertionValue().toByteArray());
                    return attrVals.contains(val);
                }
                case 9: {
                    type = new DirectoryString(filter.getExtensibleMatch().getType().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                    val.setValue(filter.getExtensibleMatch().getMatchValue().toByteArray());
                    return attrVals.contains(val);
                }
                case 7: {
                    type = new DirectoryString(filter.getPresent().toByteArray());
                    attrVals = entry.get(type);
                    return attrVals != null && !attrVals.isEmpty();
                }
                case 5: {
                    type = new DirectoryString(filter.getGreaterOrEqual().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                    val.setValue(filter.getGreaterOrEqual().getAssertionValue().toByteArray());
                    Enumeration ve = attrVals.elements();
                    if (ve.hasMoreElements()) {
                        Syntax oneV = (Syntax)ve.nextElement();
                        return val.compareTo(oneV) >= 0;
                    }
                }
                case 6: {
                    type = new DirectoryString(filter.getLessOrEqual().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                    val.setValue(filter.getLessOrEqual().getAssertionValue().toByteArray());
                    Enumeration ve = attrVals.elements();
                    if (ve.hasMoreElements()) {
                        Syntax oneV = (Syntax)ve.nextElement();
                        return val.compareTo(oneV) <= 0;
                    }
                }
                case 4: {
                    type = new DirectoryString(filter.getSubstrings().getType().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    Syntax init = null;
                    Syntax any = null;
                    Syntax fin = null;
                    Class<?> aclass = ((Syntax)attrVals.firstElement()).getClass();
                    Iterator substrEnum = filter.getSubstrings().getSubstrings().iterator();
                    while (substrEnum.hasNext()) {
                        SubstringFilter_substrings_Seq oneSubFilter = (SubstringFilter_substrings_Seq)substrEnum.next();
                        if (oneSubFilter.getSelector() == 0) {
                            init = (Syntax)aclass.newInstance();
                            init.setValue(oneSubFilter.getInitial().toByteArray());
                            continue;
                        }
                        if (oneSubFilter.getSelector() == 1) {
                            any = (Syntax)aclass.newInstance();
                            any.setValue(oneSubFilter.getAny().toByteArray());
                            continue;
                        }
                        if (oneSubFilter.getSelector() != 2) continue;
                        fin = (Syntax)aclass.newInstance();
                        fin.setValue(oneSubFilter.getFinal_().toByteArray());
                    }
                    StringBuffer regexbuf = new StringBuffer();
                    regexbuf.append("/^");
                    if (init != null) {
                        regexbuf.append(init.normalize());
                        regexbuf.append(".*");
                    }
                    if (any != null) {
                        if (regexbuf.length() < 3) {
                            regexbuf.append(".*");
                        }
                        regexbuf.append(any.normalize());
                        regexbuf.append(".*");
                    }
                    if (fin != null) {
                        if (regexbuf.length() < 3) {
                            regexbuf.append(".*");
                        }
                        regexbuf.append(fin.normalize());
                    }
                    regexbuf.append("$/");
                    String regex = regexbuf.toString();
                    Enumeration ve = attrVals.elements();
                    Perl5Util p5u = new Perl5Util();
                    while (ve.hasMoreElements()) {
                        Syntax aval = (Syntax)ve.nextElement();
                        if (!p5u.match(regex, aval.normalize())) continue;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return !this.evalFilter(entry, filter.getNot());
                }
                case 0: {
                    Iterator andEnum = filter.getAnd().iterator();
                    while (andEnum.hasNext()) {
                        if (this.evalFilter(entry, (Filter)andEnum.next())) continue;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    Iterator orEnum = filter.getOr().iterator();
                    while (orEnum.hasNext()) {
                        if (!this.evalFilter(entry, (Filter)orEnum.next())) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        return false;
    }

    private Syntax getAttributeClass(DirectoryString type) {
        AttributeType at = null;
        at = SchemaChecker.getInstance().getAttributeType(type);
        if (at == null) {
            return new DirectoryString();
        }
        try {
            return (Syntax)at.getSyntaxClass().newInstance();
        }
        catch (Exception ie) {
            return new DirectoryString();
        }
    }
}

