/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.backend;

import com.asn1c.core.Int8;
import com.octetstring.ldapv3.Filter;
import com.octetstring.ldapv3.SubstringFilter_substrings_Seq;
import com.octetstring.nls.Messages;
import com.octetstring.vde.Attribute;
import com.octetstring.vde.Credentials;
import com.octetstring.vde.Entry;
import com.octetstring.vde.EntryChange;
import com.octetstring.vde.EntryChanges;
import com.octetstring.vde.EntryChangesListener;
import com.octetstring.vde.EntrySet;
import com.octetstring.vde.acl.ACL;
import com.octetstring.vde.acl.ACLChecker;
import com.octetstring.vde.backend.Backend;
import com.octetstring.vde.backend.BackendConfig;
import com.octetstring.vde.backend.BackendRoot;
import com.octetstring.vde.backend.BackendSchema;
import com.octetstring.vde.backend.Mapper;
import com.octetstring.vde.operation.BasePlugin;
import com.octetstring.vde.operation.LDAPResult;
import com.octetstring.vde.replication.Consumer;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.BinarySyntax;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DNUtility;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.DirectorySchemaViolation;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ServerConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class BackendHandler {
    private static BackendHandler handler = null;
    private static Hashtable handlerTable = null;
    private static BasePlugin plugin_postSearch = null;
    private static Mapper mapper = null;
    private static final DirectoryString CHANGELOG_SUFFIX = new DirectoryString("cn=ChangeLog");
    private static Vector entryChangesListeners = null;
    private static final DirectoryString ROOT_SUFFIX = new DirectoryString("");
    private static final DirectoryString SCHEMA_SUFFIX = new DirectoryString("cn=Schema");
    private static final DirectoryString CONFIG_SUFFIX = new DirectoryString("cn=Config");
    private static final DirectoryString AT_SUBTREEACI = new DirectoryString("subtreeACI");
    private static final DirectoryString AT_ENTRYACI = new DirectoryString("entryACI");
    private static final DirectoryString AT_CREATE_TIMESTAMP = new DirectoryString("createTimestamp");
    private static final DirectoryString AT_CREATOR_NAME = new DirectoryString("creatorsName");
    private static final DirectoryString AT_MODIFY_TIMESTAMP = new DirectoryString("modifyTimestamp");
    private static final DirectoryString AT_MODIFIERS_NAME = new DirectoryString("modifiersName");
    private static final DirectoryString DOT = new DirectoryString(".");
    private static final DirectoryString ALL_ATTRIBUTES = new DirectoryString("*");
    private static Vector operationalAttributes = new Vector();
    private static Hashtable replicas = null;
    private static Hashtable replicausers = null;
    private boolean wlock = false;

    private BackendHandler(Properties overrideBackendProps) {
        String nb;
        Logger.getInstance().log(5, this, Messages.getString("Initializing_Adapters_13"));
        handlerTable = new Hashtable();
        Hashtable<String, DirectoryString> schemaConfig = new Hashtable<String, DirectoryString>();
        schemaConfig.put("suffix", SCHEMA_SUFFIX);
        this.registerBackend(SCHEMA_SUFFIX, new BackendSchema(schemaConfig));
        Hashtable<String, DirectoryString> rootConfig = new Hashtable<String, DirectoryString>();
        rootConfig.put("suffix", ROOT_SUFFIX);
        this.registerBackend(ROOT_SUFFIX, new BackendRoot(rootConfig));
        Hashtable<String, DirectoryString> configConfig = new Hashtable<String, DirectoryString>();
        configConfig.put("suffix", CONFIG_SUFFIX);
        this.registerBackend(CONFIG_SUFFIX, new BackendConfig(configConfig));
        String ihome = System.getProperty("vde.home");
        Properties backendTypes = new Properties();
        try {
            String name = (String)ServerConfig.getInstance().get("vde.backendtypes");
            String fullname = null;
            File file = new File(name);
            fullname = file.isAbsolute() || ihome == null ? name : ihome + "/" + name;
            FileInputStream is = new FileInputStream(fullname);
            backendTypes.load(is);
            is.close();
        }
        catch (Exception e) {
            Logger.getInstance().log(0, this, Messages.getString("Error_parsing_Backend_Types_file._19"));
        }
        Properties schemaProp = new Properties();
        try {
            String name = (String)ServerConfig.getInstance().get("vde.server.backends");
            String fullname = null;
            File file = new File(name);
            fullname = file.isAbsolute() || ihome == null ? name : ihome + "/" + name;
            FileInputStream is = new FileInputStream(fullname);
            schemaProp.load(is);
            is.close();
        }
        catch (Exception e) {
            Logger.getInstance().log(0, this, Messages.getString("Error_parsing_Backend_properties._21"));
        }
        if (overrideBackendProps != null) {
            Iterator<Object> it = overrideBackendProps.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                schemaProp.setProperty(key, overrideBackendProps.getProperty(key));
            }
        }
        if ((nb = System.getProperty("backend.num")) == null) {
            nb = (String)schemaProp.get("backend.num");
        }
        int numBackends = new Integer(nb);
        for (int beCount = 0; beCount < numBackends; ++beCount) {
            String configKey;
            String key;
            String backendPropPrefix = "backend." + beCount;
            String backendRootProp = backendPropPrefix + ".root";
            String suffix = System.getProperty(backendRootProp);
            if (suffix == null) {
                suffix = (String)schemaProp.get(backendRootProp);
            }
            try {
                suffix = DNUtility.getInstance().normalize(new DirectoryString(suffix)).toString();
            }
            catch (InvalidDNException ide) {
                Logger.getInstance().log(0, this, "Invalid Adapter Suffix: " + suffix);
                break;
            }
            String backendTypeProp = backendPropPrefix + ".type";
            String backendType = System.getProperty(backendTypeProp);
            if (backendType == null) {
                backendType = (String)schemaProp.get(backendTypeProp);
            }
            Logger.getInstance().log(7, this, "Suffix: " + suffix + " Type: " + backendType);
            String configPropPrefix = backendPropPrefix + ".config.";
            int configPrefixLen = configPropPrefix.length();
            Enumeration<Object> keys = schemaProp.keys();
            Hashtable<String, Object> beConfig = new Hashtable<String, Object>();
            beConfig.put("suffix", new DirectoryString(suffix));
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.startsWith(configPropPrefix)) continue;
                configKey = key.substring(configPrefixLen);
                beConfig.put(configKey, schemaProp.get(key));
            }
            keys = System.getProperties().keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.startsWith(configPropPrefix)) continue;
                configKey = key.substring(configPrefixLen);
                beConfig.put(configKey, System.getProperty(key));
            }
            try {
                String myType = (String)backendTypes.get(backendType);
                if (myType == null) {
                    myType = backendType;
                }
                Constructor<?>[] cons = Class.forName(myType).getConstructors();
                Object[] args = new Object[]{beConfig};
                this.registerBackend(new DirectoryString(suffix), (Backend)cons[0].newInstance(args));
                continue;
            }
            catch (Exception e) {
                Logger.getInstance().log(0, this, Messages.getString("Error_Instantiating____39") + suffix + "': " + e.getMessage());
            }
        }
        mapper = new Mapper();
        operationalAttributes.addElement(AT_CREATOR_NAME);
        operationalAttributes.addElement(AT_CREATE_TIMESTAMP);
        operationalAttributes.addElement(AT_MODIFIERS_NAME);
        operationalAttributes.addElement(AT_MODIFY_TIMESTAMP);
        replicas = new Hashtable();
        replicausers = new Hashtable();
        String postsearchplugin = (String)ServerConfig.getInstance().get("plugin.postsearch");
        if (postsearchplugin != null && !postsearchplugin.equals("")) {
            try {
                Class<?> pluginClass = Class.forName(postsearchplugin);
                plugin_postSearch = (BasePlugin)pluginClass.newInstance();
                Logger.getInstance().log(5, this, "Inserted Plugin: " + postsearchplugin);
            }
            catch (Exception e) {
                Logger.getInstance().log(0, this, "Error instantiating: " + postsearchplugin);
            }
        }
    }

    public void addReplica(DirectoryString suffix, Consumer con) {
        replicas.put(suffix, con);
        DirectoryString bdn = con.getBinddn();
        String bpw = con.getBindpw();
        replicausers.put(bdn, bpw);
    }

    public void clearReplicas() {
        if (replicas.size() > 0) {
            replicas = new Hashtable();
        }
        if (replicausers.size() > 0) {
            replicausers = new Hashtable();
        }
    }

    public String getReplicaUser(DirectoryString dn) {
        return (String)replicausers.get(dn);
    }

    public Consumer getReplica(DirectoryString dn) {
        Consumer selected = null;
        int selLength = -1;
        DirectoryString normEntryName = null;
        try {
            normEntryName = DNUtility.getInstance().normalize(dn);
        }
        catch (InvalidDNException ide) {
            return null;
        }
        Enumeration replicaEnum = replicas.keys();
        while (replicaEnum.hasMoreElements()) {
            DirectoryString base = (DirectoryString)replicaEnum.nextElement();
            if (!normEntryName.endsWith(base) || base.length() <= selLength) continue;
            selected = (Consumer)replicas.get(base);
            selLength = base.length();
        }
        return selected;
    }

    public static BackendHandler getInstance() {
        if (handler == null) {
            handler = BackendHandler.getInstance(null);
        }
        return handler;
    }

    public static BackendHandler getInstance(Properties overrideBackendProps) {
        if (handler == null) {
            handler = new BackendHandler(overrideBackendProps);
        }
        return handler;
    }

    public Backend getBackend(DirectoryString entryName) {
        return this.pickBackend(entryName);
    }

    Hashtable getHandlerTable() {
        return handlerTable;
    }

    public synchronized void lockWrites() {
        while (this.wlock) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.wlock = true;
    }

    public synchronized void unlockWrites() {
        this.wlock = false;
        this.notifyAll();
    }

    public synchronized void checkLock() {
        while (this.wlock) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Int8 add(Credentials creds, Entry entry) throws DirectorySchemaViolation {
        Backend backend;
        ACL anACI;
        DirectoryString oneACL;
        Enumeration aclEnum;
        ACLChecker ac;
        this.checkLock();
        if (!ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_ADD, entry.getName())) {
            Logger.getInstance().log(7, this, Messages.getString("ACCESS_DENIED___41") + creds + Messages.getString("_to_ADD____42") + entry.getName() + "'");
            return LDAPResult.INSUFFICIENT_ACCESS_RIGHTS;
        }
        Vector vals = entry.get(AT_ENTRYACI);
        if (vals != null) {
            if (!ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_WRITE, entry.getName(), AT_ENTRYACI)) {
                return LDAPResult.INSUFFICIENT_ACCESS_RIGHTS;
            }
            entry.remove(AT_ENTRYACI);
            ac = ACLChecker.getInstance();
            ac.deleteACL(entry.getName());
            aclEnum = vals.elements();
            while (aclEnum.hasMoreElements()) {
                oneACL = (DirectoryString)aclEnum.nextElement();
                anACI = new ACL(oneACL.toString());
                anACI.setScopeSubtree(false);
                ac.addACL(entry.getName(), anACI);
            }
        }
        if ((vals = entry.get(AT_SUBTREEACI)) != null) {
            if (!ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_WRITE, entry.getName(), AT_SUBTREEACI)) {
                return LDAPResult.INSUFFICIENT_ACCESS_RIGHTS;
            }
            entry.remove(AT_SUBTREEACI);
            ac = ACLChecker.getInstance();
            ac.deleteACL(entry.getName());
            aclEnum = vals.elements();
            while (aclEnum.hasMoreElements()) {
                oneACL = (DirectoryString)aclEnum.nextElement();
                anACI = new ACL(oneACL.toString());
                anACI.setScopeSubtree(true);
                ac.addACL(entry.getName(), anACI);
            }
        }
        if ((backend = this.pickBackend(entry.getName())) != null) {
            Int8 results = null;
            results = creds != null ? backend.add(creds.getUser(), entry) : backend.add(null, entry);
            if (results == LDAPResult.SUCCESS && entryChangesListeners != null) {
                Enumeration ecls = entryChangesListeners.elements();
                while (ecls.hasMoreElements()) {
                    EntryChangesListener ecl = (EntryChangesListener)ecls.nextElement();
                    if (!entry.getName().endsWith(ecl.getECLBase())) continue;
                    ecl.receiveEntryChanges(new EntryChanges(entry));
                }
            }
            return results;
        }
        return LDAPResult.NO_SUCH_OBJECT;
    }

    public boolean bind(DirectoryString dn, BinarySyntax password) {
        Backend backend = this.pickBackend(dn);
        return backend.bind(dn, password);
    }

    public Int8 delete(Credentials creds, DirectoryString name) {
        this.checkLock();
        Backend backend = this.pickBackend(name);
        if (!ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_DELETE, name)) {
            Logger.getInstance().log(7, this, Messages.getString("ACCESS_DENIED___44") + creds + Messages.getString("_to_DELETE____45") + name + "'");
            return LDAPResult.INSUFFICIENT_ACCESS_RIGHTS;
        }
        Int8 results = null;
        results = creds != null ? backend.delete(creds.getUser(), name) : backend.delete(null, name);
        if (results == LDAPResult.SUCCESS && entryChangesListeners != null) {
            Enumeration ecls = entryChangesListeners.elements();
            while (ecls.hasMoreElements()) {
                EntryChangesListener ecl = (EntryChangesListener)ecls.nextElement();
                if (!name.endsWith(ecl.getECLBase())) continue;
                ecl.receiveEntryChanges(new EntryChanges(name));
            }
        }
        return results;
    }

    public boolean doBind(DirectoryString dn) {
        Backend backend = this.pickBackend(dn);
        if (backend == null) {
            return false;
        }
        boolean retval = backend.doBind();
        return retval;
    }

    public Vector get(DirectoryString binddn, DirectoryString base, int scope, Filter filter, boolean typesOnly, Vector attributes) throws DirectoryException {
        Vector<EntrySet> results = new Vector<EntrySet>();
        Vector backends = this.pickBackends(base, scope);
        if (backends == null) {
            throw new DirectoryException(32);
        }
        Filter newset = new Filter(filter);
        newset = mapper.mapfilter(base, newset);
        DirectoryString mybase = mapper.mapbase(base);
        int myscope = scope;
        Enumeration backEnum = backends.elements();
        while (backEnum.hasMoreElements()) {
            EntrySet partResults;
            Backend backend = (Backend)backEnum.nextElement();
            if (newset == null || (partResults = backend.get(binddn, mybase, myscope, newset, typesOnly, attributes)) == null || !partResults.hasMore()) continue;
            results.addElement(partResults);
        }
        return results;
    }

    public Entry getByDN(DirectoryString binddn, DirectoryString dn) throws DirectoryException {
        DirectoryString normaldn = DNUtility.getInstance().normalize(dn);
        Backend backend = this.pickBackend(normaldn);
        return backend.getByDN(binddn, normaldn);
    }

    public void modify(Credentials creds, DirectoryString name, Vector changeEntries) throws DirectoryException {
        this.checkLock();
        Enumeration changeEnum = changeEntries.elements();
        while (changeEnum.hasMoreElements()) {
            EntryChange change = (EntryChange)changeEnum.nextElement();
            int changeType = change.getModType();
            DirectoryString attr = change.getAttr();
            if (changeType == 0 && !ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_WRITE, name, attr)) {
                Logger.getInstance().log(7, this, Messages.getString("ACCESS_DENIED___47") + creds.getUser() + Messages.getString("_to_MODIFY____48") + name + Messages.getString("___ADD_ATTRIBUTE____49") + attr + "'");
                throw new DirectoryException(50);
            }
            if (changeType == 1 && !ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_OBLITERATE, name, attr)) {
                Logger.getInstance().log(7, this, Messages.getString("ACCESS_DENIED___51") + creds.getUser() + Messages.getString("_to_MODIFY____52") + name + Messages.getString("___DELETE_ATTRIBUTE____53") + attr + "'");
                throw new DirectoryException(50);
            }
            if (changeType != 2 || ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_WRITE, name, attr) && ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_OBLITERATE, name, attr)) continue;
            Logger.getInstance().log(7, this, Messages.getString("ACCESS_DENIED___55") + creds + Messages.getString("_to_MODIFY____56") + name + Messages.getString("___REPLACE_ATTRIBUTE____57") + attr + "'");
            throw new DirectoryException(50);
        }
        Backend backend = this.pickBackend(name);
        if (creds != null) {
            backend.modify(creds.getUser(), name, changeEntries);
        } else {
            backend.modify(null, name, changeEntries);
        }
        if (entryChangesListeners != null) {
            Enumeration ecls = entryChangesListeners.elements();
            while (ecls.hasMoreElements()) {
                EntryChangesListener ecl = (EntryChangesListener)ecls.nextElement();
                if (!name.endsWith(ecl.getECLBase())) continue;
                Object[] ecs = new EntryChange[changeEntries.size()];
                changeEntries.copyInto(ecs);
                ecl.receiveEntryChanges(new EntryChanges(name, (EntryChange[])ecs));
            }
        }
    }

    private Backend pickBackend(DirectoryString entryName) {
        Backend selected = null;
        int selLength = -1;
        DirectoryString normEntryName = null;
        try {
            normEntryName = DNUtility.getInstance().normalize(entryName);
        }
        catch (InvalidDNException ide) {
            return null;
        }
        Enumeration backEnum = handlerTable.keys();
        while (backEnum.hasMoreElements()) {
            DirectoryString base = (DirectoryString)backEnum.nextElement();
            if (!normEntryName.endsWith(base) || base.length() <= selLength) continue;
            selected = (Backend)handlerTable.get(base);
            selLength = base.length();
            if (!Logger.getInstance().isLogable(9)) continue;
            Logger.getInstance().log(9, this, Messages.getString("Selected__59") + selected.getClass().getName() + Messages.getString("_backend_for___60") + base);
        }
        return selected;
    }

    private Vector pickBackends(DirectoryString entryName, int scope) {
        Vector<Backend> backs = new Vector<Backend>();
        DirectoryString normEntryName = null;
        try {
            normEntryName = DNUtility.getInstance().normalize(entryName);
        }
        catch (InvalidDNException ide) {
            return null;
        }
        Enumeration backEnum = handlerTable.keys();
        boolean nonroot = false;
        while (backEnum.hasMoreElements()) {
            DirectoryString base = (DirectoryString)backEnum.nextElement();
            if (!entryName.endsWith(base) && (scope == 0 || !base.endsWith(normEntryName))) continue;
            if (base.length() != 0) {
                nonroot = true;
            }
            backs.addElement((Backend)handlerTable.get(base));
            if (!Logger.getInstance().isLogable(7)) continue;
            Logger.getInstance().log(7, this, Messages.getString("Selected_backend_for___61") + base);
        }
        if (!nonroot && entryName.length() != 0) {
            return null;
        }
        return backs;
    }

    public void registerBackend(DirectoryString base, Backend backend) {
        handlerTable.put(base, backend);
    }

    public void registerEntryChangesListener(EntryChangesListener entryChangesListener) {
        if (entryChangesListeners == null) {
            entryChangesListeners = new Vector();
        }
        entryChangesListeners.addElement(entryChangesListener);
    }

    public Int8 rename(Credentials creds, DirectoryString oldname, DirectoryString newname, DirectoryString newsuffix, boolean removeoldrdn) throws DirectoryException {
        this.checkLock();
        oldname = DNUtility.getInstance().normalize(oldname);
        Backend backend = this.pickBackend(oldname);
        Entry oldEntry = null;
        oldEntry = creds != null ? backend.getByDN(creds.getUser(), oldname) : backend.getByDN(null, oldname);
        if (oldEntry == null) {
            return LDAPResult.NO_SUCH_OBJECT;
        }
        DirectoryString newfullname = null;
        newfullname = newsuffix == null ? new DirectoryString(newname + "," + oldEntry.getBase()) : new DirectoryString(newname + "," + newsuffix);
        if (!ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_RENAMEDN, oldname) || !ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_ADD, newfullname)) {
            Logger.getInstance().log(7, this, Messages.getString("ACCESS_DENIED___64") + creds + Messages.getString("_to_RENAME____65") + oldname + Messages.getString("_to____66") + newfullname + "'");
            return LDAPResult.INSUFFICIENT_ACCESS_RIGHTS;
        }
        Backend newBackend = this.pickBackend(newfullname);
        Int8 result = null;
        Entry current = null;
        if (backend == newBackend) {
            result = creds != null ? backend.rename(creds.getUser(), oldname, newname, newsuffix, removeoldrdn) : backend.rename(null, oldname, newname, newsuffix, removeoldrdn);
        } else {
            Int8 res;
            current = (Entry)oldEntry.clone();
            current.setName(newfullname);
            if (removeoldrdn) {
                Vector rdns = DNUtility.getInstance().explodeDN(oldname);
                if (rdns.isEmpty()) {
                    return LDAPResult.NAMING_VIOLATION;
                }
                String myrdn = (String)rdns.elementAt(0);
                StringTokenizer rdntok = new StringTokenizer(myrdn, "+");
                while (rdntok.hasMoreTokens()) {
                    String nextatval = rdntok.nextToken();
                    StringTokenizer atvaltok = new StringTokenizer(nextatval, "=");
                    if (!atvaltok.hasMoreTokens()) continue;
                    String attr = atvaltok.nextToken();
                    if (!atvaltok.hasMoreTokens()) continue;
                    String value = atvaltok.nextToken();
                    DirectoryString dsattr = new DirectoryString(attr);
                    Vector vals = current.get(dsattr);
                    if (vals == null) continue;
                    Syntax synVal = null;
                    AttributeType at = SchemaChecker.getInstance().getAttributeType(dsattr);
                    synVal = at != null ? at.getSyntaxInstance() : new DirectoryString();
                    try {
                        synVal.setValue(value.getBytes("UTF8"));
                    }
                    catch (UnsupportedEncodingException uee) {
                        synVal.setValue(value.getBytes());
                    }
                    vals.removeElement(synVal);
                    if (!vals.isEmpty()) continue;
                    current.remove(dsattr);
                }
            }
            StringTokenizer rdntok = new StringTokenizer(newname.toString(), "+");
            while (rdntok.hasMoreTokens()) {
                String nextatval = rdntok.nextToken();
                StringTokenizer atvaltok = new StringTokenizer(nextatval, "=");
                if (!atvaltok.hasMoreTokens()) continue;
                String attr = atvaltok.nextToken();
                if (!atvaltok.hasMoreTokens()) continue;
                String value = atvaltok.nextToken();
                DirectoryString dsattr = new DirectoryString(attr);
                Vector<Syntax> vals = current.get(dsattr);
                if (vals == null) {
                    vals = new Vector<Syntax>();
                    current.put(dsattr, vals);
                }
                Syntax synVal = null;
                AttributeType at = SchemaChecker.getInstance().getAttributeType(dsattr);
                synVal = at != null ? at.getSyntaxInstance() : new DirectoryString();
                try {
                    synVal.setValue(value.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException uee) {
                    synVal.setValue(value.getBytes());
                }
                if (vals.contains(synVal)) continue;
                vals.addElement(synVal);
            }
            if (creds != null) {
                res = newBackend.add(creds.getUser(), current);
                if (!res.equals(LDAPResult.SUCCESS)) {
                    return res;
                }
                return backend.delete(creds.getUser(), oldname);
            }
            res = newBackend.add(null, current);
            if (!res.equals(LDAPResult.SUCCESS)) {
                return res;
            }
            return backend.delete(null, oldname);
        }
        if (result == LDAPResult.SUCCESS && entryChangesListeners != null) {
            Enumeration ecls = entryChangesListeners.elements();
            while (ecls.hasMoreElements()) {
                EntryChangesListener ecl = (EntryChangesListener)ecls.nextElement();
                if (oldname.endsWith(ecl.getECLBase()) && newname.endsWith(ecl.getECLBase())) {
                    ecl.receiveEntryChanges(new EntryChanges(oldname, newfullname));
                    continue;
                }
                if (oldname.endsWith(ecl.getECLBase())) {
                    ecl.receiveEntryChanges(new EntryChanges(oldname));
                    continue;
                }
                if (!newname.endsWith(ecl.getECLBase())) continue;
                if (current == null) {
                    current = newBackend.getByDN(null, newfullname);
                }
                if (current == null) continue;
                ecl.receiveEntryChanges(new EntryChanges(current));
            }
        }
        return result;
    }

    public Entry map(Entry original) {
        return mapper.map(original);
    }

    private static DirectoryString convertOID(DirectoryString attrname) {
        if (attrname.indexOf(DOT) == -1) {
            DirectoryString tmp = SchemaChecker.getInstance().nameFromOID(attrname);
            if (tmp == null) {
                return attrname;
            }
            return tmp;
        }
        return attrname;
    }

    public Entry postSearch(Credentials creds, Entry original, Vector returnattrs, Filter filter, int scope, DirectoryString base) {
        Enumeration aclsEnum;
        Vector<DirectoryString> dsACLs;
        DirectoryString attr;
        if (plugin_postSearch != null) {
            Entry newent = plugin_postSearch.postProcess(creds, original);
            if (newent == null) {
                return null;
            }
            original = newent;
        }
        if (original == null || !ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_BROWSEDN, original) || !ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_RETURNDN, original.getName())) {
            return null;
        }
        if (!this.scanFilter(creds, original, filter) && !this.evalFilter(creds, original, filter, true)) {
            return null;
        }
        if (returnattrs.size() == 1 && (attr = (DirectoryString)returnattrs.elementAt(0)).equals(ALL_ATTRIBUTES)) {
            returnattrs = new Vector();
        }
        Entry nent = this.map(original);
        if (scope == 0 ? !base.equals(nent.getName()) : (scope == 2 ? !nent.getName().endsWith(base) : !base.equals(nent.getBase()))) {
            return null;
        }
        Entry rent = new Entry();
        try {
            rent.setName(nent.getName(), true);
        }
        catch (DirectoryException de) {
            // empty catch block
        }
        rent.setBase(nent.getBase());
        rent.setID(nent.getID());
        Vector<DirectoryString> removelist = new Vector<DirectoryString>();
        Vector acls = null;
        if (!returnattrs.isEmpty() && returnattrs.contains(AT_ENTRYACI) && (acls = ACLChecker.getInstance().getEntryACLs(nent.getName())) != null) {
            dsACLs = new Vector<DirectoryString>();
            aclsEnum = acls.elements();
            while (aclsEnum.hasMoreElements()) {
                dsACLs.addElement(new DirectoryString(((ACL)aclsEnum.nextElement()).toString()));
            }
            nent.put(AT_ENTRYACI, dsACLs);
        }
        if (!returnattrs.isEmpty() && returnattrs.contains(AT_SUBTREEACI) && (acls = ACLChecker.getInstance().getSubtreeACLs(nent.getName())) != null) {
            dsACLs = new Vector();
            aclsEnum = acls.elements();
            while (aclsEnum.hasMoreElements()) {
                dsACLs.addElement(new DirectoryString(((ACL)aclsEnum.nextElement()).toString()));
            }
            nent.put(AT_SUBTREEACI, dsACLs);
        }
        Enumeration opatEnum = operationalAttributes.elements();
        while (opatEnum.hasMoreElements()) {
            DirectoryString opat = (DirectoryString)opatEnum.nextElement();
            if (returnattrs.isEmpty()) {
                removelist.addElement(opat);
                continue;
            }
            if (returnattrs.contains(opat)) continue;
            removelist.addElement(opat);
        }
        Vector<Attribute> attributes = new Vector<Attribute>();
        Vector curattrs = nent.getAttributes();
        Attribute curattr = null;
        for (int i = 0; i < curattrs.size(); ++i) {
            curattr = (Attribute)curattrs.elementAt(i);
            if (!returnattrs.isEmpty() && !returnattrs.contains(curattr.type) && (SchemaChecker.getInstance().getAttributeType(curattr.type) == null || !returnattrs.contains(new DirectoryString(SchemaChecker.getInstance().getAttributeType(curattr.type).getOid()))) || !ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_READ, nent, curattr.type) || !removelist.isEmpty() && removelist.contains(curattr.type)) continue;
            attributes.addElement(curattr);
        }
        rent.setAttributes(attributes);
        return rent;
    }

    private boolean canReadSearch(Credentials creds, DirectoryString name, DirectoryString attr, boolean needRead) {
        return ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_SEARCH, name, attr) && (!needRead || ACLChecker.getInstance().isAllowed(creds, ACLChecker.PERM_READ, name, attr));
    }

    private boolean evalFilter(Credentials creds, Entry entry, Filter filter, boolean first) {
        DirectoryString type = null;
        Syntax val = null;
        Vector attrVals = null;
        try {
            switch (filter.getSelector()) {
                case 3: {
                    if (first) {
                        return false;
                    }
                    type = new DirectoryString(filter.getEqualityMatch().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    if (this.canReadSearch(creds, entry.getName(), type, true)) {
                        val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                        val.setValue(filter.getEqualityMatch().getAssertionValue().toByteArray());
                        return attrVals.contains(val);
                    }
                    return false;
                }
                case 8: {
                    if (first) {
                        return false;
                    }
                    type = new DirectoryString(filter.getApproxMatch().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    if (this.canReadSearch(creds, entry.getName(), type, true)) {
                        val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                        val.setValue(filter.getApproxMatch().getAssertionValue().toByteArray());
                        return attrVals.contains(val);
                    }
                    return false;
                }
                case 9: {
                    if (first) {
                        return false;
                    }
                    type = new DirectoryString(filter.getExtensibleMatch().getType().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    if (this.canReadSearch(creds, entry.getName(), type, true)) {
                        val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                        val.setValue(filter.getExtensibleMatch().getMatchValue().toByteArray());
                        return attrVals.contains(val);
                    }
                    return false;
                }
                case 7: {
                    if (first) {
                        return false;
                    }
                    type = new DirectoryString(filter.getPresent().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    return this.canReadSearch(creds, entry.getName(), type, false);
                }
                case 5: {
                    Enumeration ve;
                    if (first) {
                        return false;
                    }
                    type = new DirectoryString(filter.getGreaterOrEqual().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    if (this.canReadSearch(creds, entry.getName(), type, true)) {
                        val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                        val.setValue(filter.getGreaterOrEqual().getAssertionValue().toByteArray());
                        ve = attrVals.elements();
                        if (ve.hasMoreElements()) {
                            Syntax oneV = (Syntax)ve.nextElement();
                            return val.compareTo(oneV) >= 0;
                        }
                    } else {
                        return false;
                    }
                }
                case 6: {
                    Enumeration ve;
                    if (first) {
                        return false;
                    }
                    type = new DirectoryString(filter.getLessOrEqual().getAttributeDesc().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    if (this.canReadSearch(creds, entry.getName(), type, true)) {
                        val = (Syntax)((Syntax)attrVals.firstElement()).getClass().newInstance();
                        val.setValue(filter.getLessOrEqual().getAssertionValue().toByteArray());
                        ve = attrVals.elements();
                        if (ve.hasMoreElements()) {
                            Syntax oneV = (Syntax)ve.nextElement();
                            return val.compareTo(oneV) <= 0;
                        }
                    } else {
                        return false;
                    }
                }
                case 4: {
                    if (first) {
                        return false;
                    }
                    type = new DirectoryString(filter.getSubstrings().getType().toByteArray());
                    attrVals = entry.get(type);
                    if (attrVals == null || attrVals.isEmpty()) {
                        return false;
                    }
                    if (this.canReadSearch(creds, entry.getName(), type, true)) {
                        Syntax init = null;
                        Syntax any = null;
                        Syntax fin = null;
                        Class<?> aclass = ((Syntax)attrVals.firstElement()).getClass();
                        Iterator substrEnum = filter.getSubstrings().getSubstrings().iterator();
                        while (substrEnum.hasNext()) {
                            SubstringFilter_substrings_Seq oneSubFilter = (SubstringFilter_substrings_Seq)substrEnum.next();
                            if (oneSubFilter.getSelector() == 0) {
                                init = (Syntax)aclass.newInstance();
                                init.setValue(oneSubFilter.getInitial().toByteArray());
                                continue;
                            }
                            if (oneSubFilter.getSelector() == 1) {
                                any = (Syntax)aclass.newInstance();
                                any.setValue(oneSubFilter.getAny().toByteArray());
                                continue;
                            }
                            if (oneSubFilter.getSelector() != 2) continue;
                            fin = (Syntax)aclass.newInstance();
                            fin.setValue(oneSubFilter.getFinal_().toByteArray());
                        }
                        StringBuffer regexbuf = new StringBuffer();
                        regexbuf.append("/^");
                        if (init != null) {
                            regexbuf.append(init.normalize());
                            regexbuf.append(".*");
                        }
                        if (any != null) {
                            if (regexbuf.length() < 3) {
                                regexbuf.append(".*");
                            }
                            regexbuf.append(any.normalize());
                            regexbuf.append(".*");
                        }
                        if (fin != null) {
                            if (regexbuf.length() < 3) {
                                regexbuf.append(".*");
                            }
                            regexbuf.append(fin.normalize());
                        }
                        regexbuf.append("$/");
                        String regex = regexbuf.toString();
                        Enumeration ve = attrVals.elements();
                        Perl5Util p5u = new Perl5Util();
                        while (ve.hasMoreElements()) {
                            Syntax aval = (Syntax)ve.nextElement();
                            if (!p5u.match(regex, aval.normalize())) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                case 2: {
                    return !this.evalFilter(creds, entry, filter.getNot(), false);
                }
                case 0: {
                    Iterator andEnum = filter.getAnd().iterator();
                    while (andEnum.hasNext()) {
                        if (this.evalFilter(creds, entry, (Filter)andEnum.next(), false)) continue;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    Iterator orEnum = filter.getOr().iterator();
                    while (orEnum.hasNext()) {
                        if (!this.evalFilter(creds, entry, (Filter)orEnum.next(), false)) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        return false;
    }

    private boolean scanFilter(Credentials creds, Entry entry, Filter filter) {
        boolean needRead = false;
        DirectoryString type = null;
        switch (filter.getSelector()) {
            case 3: {
                type = new DirectoryString(filter.getEqualityMatch().getAttributeDesc().toByteArray());
                needRead = true;
                break;
            }
            case 7: {
                type = new DirectoryString(filter.getPresent().toByteArray());
                break;
            }
            case 5: {
                type = new DirectoryString(filter.getGreaterOrEqual().getAttributeDesc().toByteArray());
                needRead = true;
                break;
            }
            case 6: {
                type = new DirectoryString(filter.getLessOrEqual().getAttributeDesc().toByteArray());
                needRead = true;
                break;
            }
            case 4: {
                type = new DirectoryString(filter.getSubstrings().getType().toByteArray());
                needRead = true;
                break;
            }
            case 9: {
                type = new DirectoryString(filter.getExtensibleMatch().getType().toByteArray());
                needRead = true;
                break;
            }
            case 8: {
                type = new DirectoryString(filter.getApproxMatch().getAttributeDesc().toByteArray());
                needRead = true;
                break;
            }
            case 2: {
                return !this.scanFilter(creds, entry, filter.getNot());
            }
            case 0: {
                Iterator andEnum = filter.getAnd().iterator();
                while (andEnum.hasNext()) {
                    if (this.scanFilter(creds, entry, (Filter)andEnum.next())) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                Iterator orEnum = filter.getOr().iterator();
                while (orEnum.hasNext()) {
                    if (this.scanFilter(creds, entry, (Filter)orEnum.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return this.canReadSearch(creds, entry.getName(), type, needRead);
    }
}

