/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.backend;

import com.octetstring.ldapv3.Filter;
import com.octetstring.nls.Messages;
import com.octetstring.vde.Entry;
import com.octetstring.vde.EntryChange;
import com.octetstring.vde.EntrySet;
import com.octetstring.vde.backend.BaseBackend;
import com.octetstring.vde.backend.GenericEntrySet;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.ObjectClass;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.schema.SchemaXMLWriter;
import com.octetstring.vde.syntax.BinarySyntax;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BackendSchema
extends BaseBackend {
    public BackendSchema(Hashtable config) {
        super(config);
    }

    public boolean bind(DirectoryString dn, BinarySyntax password) {
        return false;
    }

    public boolean doBind() {
        return false;
    }

    public EntrySet get(DirectoryString binddn, DirectoryString base, int scope, Filter filter, boolean attrsOnly, Vector attrs) throws DirectoryException {
        if (scope == 0 && base.equals(new DirectoryString("cn=schema"))) {
            Vector<Integer> entries = new Vector<Integer>();
            entries.addElement(new Integer(1));
            return new GenericEntrySet(this, entries);
        }
        return new GenericEntrySet(this, new Vector());
    }

    public Entry getByDN(DirectoryString binddn, DirectoryString dn) {
        return this.getByID(new Integer(1));
    }

    public Entry getByID(Integer id) {
        Entry schemaEntry = null;
        try {
            schemaEntry = new Entry(new DirectoryString("cn=schema"));
        }
        catch (InvalidDNException ide) {
            // empty catch block
        }
        Vector<DirectoryString> objClass = new Vector<DirectoryString>();
        objClass.addElement(new DirectoryString("top"));
        objClass.addElement(new DirectoryString("subschemaSubentry"));
        schemaEntry.put(new DirectoryString("objectclass"), objClass);
        Vector<DirectoryString> objClasses = new Vector<DirectoryString>();
        Hashtable classes = SchemaChecker.getInstance().getObjectClasses();
        Enumeration classEnum = classes.keys();
        while (classEnum.hasMoreElements()) {
            ObjectClass aClass = (ObjectClass)classes.get((DirectoryString)classEnum.nextElement());
            objClasses.addElement(new DirectoryString(aClass.toString()));
        }
        schemaEntry.put(new DirectoryString("objectclasses"), objClasses);
        Vector<DirectoryString> attrTypes = new Vector<DirectoryString>();
        Hashtable attrs = SchemaChecker.getInstance().getAttributeTypes();
        Enumeration attrEnum = attrs.keys();
        while (attrEnum.hasMoreElements()) {
            AttributeType at = (AttributeType)attrs.get((DirectoryString)attrEnum.nextElement());
            attrTypes.addElement(new DirectoryString(at.toString()));
        }
        schemaEntry.put(new DirectoryString("attributetypes"), attrTypes);
        return schemaEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(DirectoryString binddn, DirectoryString name, Vector changeEntries) throws DirectoryException {
        Vector<ObjectClass> addocs = new Vector<ObjectClass>();
        Vector<AttributeType> addats = new Vector<AttributeType>();
        Vector<DirectoryString> delocs = new Vector<DirectoryString>();
        Vector<DirectoryString> delats = new Vector<DirectoryString>();
        Enumeration ecenum = changeEntries.elements();
        boolean ce = false;
        while (ecenum.hasMoreElements()) {
            AttributeType at;
            ObjectClass oc;
            Enumeration ve;
            Vector vals;
            EntryChange oneEc = (EntryChange)ecenum.nextElement();
            int modType2 = oneEc.getModType();
            int modOp = -1;
            if (modType2 == 0) {
                if (oneEc.getAttr().equals(new DirectoryString("objectclasses"))) {
                    vals = oneEc.getValues();
                    ve = vals.elements();
                    while (ve.hasMoreElements()) {
                        try {
                            oc = new ObjectClass(((Syntax)ve.nextElement()).toString());
                            if (oc == null) {
                                throw new DirectoryException(53, Messages.getString("Bad_Value_9"));
                            }
                            addocs.addElement(oc);
                        }
                        catch (Exception e) {
                            throw new DirectoryException(53, Messages.getString("Bad_Value_10"));
                        }
                    }
                    continue;
                }
                if (!oneEc.getAttr().equals(new DirectoryString("attributetypes"))) continue;
                vals = oneEc.getValues();
                ve = vals.elements();
                while (ve.hasMoreElements()) {
                    try {
                        at = new AttributeType(((Syntax)ve.nextElement()).toString());
                        if (at == null) {
                            throw new DirectoryException(53, Messages.getString("Bad_Value_12"));
                        }
                        addats.addElement(at);
                    }
                    catch (Exception e) {
                        throw new DirectoryException(53, Messages.getString("Bad_Value_13"));
                    }
                }
                continue;
            }
            if (modType2 == 2) {
                throw new DirectoryException(53, Messages.getString("Replace_not_suported_on_object_14"));
            }
            if (modType2 != 1) continue;
            if (oneEc.getAttr().equals(new DirectoryString("objectclasses"))) {
                vals = oneEc.getValues();
                ve = vals.elements();
                while (ve.hasMoreElements()) {
                    try {
                        oc = new ObjectClass(((Syntax)ve.nextElement()).toString());
                        if (oc == null) {
                            throw new DirectoryException(53, Messages.getString("Bad_Value_16"));
                        }
                        delocs.addElement(oc.getName());
                    }
                    catch (Exception e) {
                        throw new DirectoryException(53, Messages.getString("Bad_Value_17"));
                    }
                }
                continue;
            }
            if (!oneEc.getAttr().equals(new DirectoryString("attributetypes"))) continue;
            vals = oneEc.getValues();
            ve = vals.elements();
            while (ve.hasMoreElements()) {
                try {
                    at = new AttributeType(((Syntax)ve.nextElement()).toString());
                    if (at == null) {
                        throw new DirectoryException(53, Messages.getString("Bad_Value_19"));
                    }
                    delats.addElement(at.getName());
                }
                catch (Exception e) {
                    throw new DirectoryException(53, Messages.getString("Bad_Value_20"));
                }
            }
        }
        BackendSchema backendSchema = this;
        synchronized (backendSchema) {
            try {
                Enumeration de;
                Enumeration ae;
                SchemaXMLWriter sxw = new SchemaXMLWriter();
                String filename = SchemaChecker.getInstance().getSchemaFilename();
                Document mydoc = sxw.load(filename);
                Element ds = sxw.getSchemaElement(mydoc);
                if (!addocs.isEmpty() || !delocs.isEmpty()) {
                    Hashtable ochash = SchemaChecker.getInstance().getObjectClasses();
                    if (!addocs.isEmpty()) {
                        ae = addocs.elements();
                        while (ae.hasMoreElements()) {
                            ObjectClass aoc = (ObjectClass)ae.nextElement();
                            ochash.put(aoc.getName(), aoc);
                            sxw.setObjectClass(mydoc, ds, aoc);
                        }
                    }
                    if (!delocs.isEmpty()) {
                        de = delocs.elements();
                        while (de.hasMoreElements()) {
                            DirectoryString deloc = (DirectoryString)de.nextElement();
                            ochash.remove(deloc);
                            sxw.deleteObjectClass(mydoc, ds, deloc.toString());
                        }
                    }
                }
                if (!addats.isEmpty() || !delats.isEmpty()) {
                    Hashtable athash = SchemaChecker.getInstance().getAttributeTypes();
                    if (!addats.isEmpty()) {
                        ae = addats.elements();
                        while (ae.hasMoreElements()) {
                            AttributeType aat = (AttributeType)ae.nextElement();
                            athash.put(aat.getName(), aat);
                            sxw.setAttributeType(mydoc, ds, aat);
                        }
                    }
                    if (!delats.isEmpty()) {
                        de = delats.elements();
                        while (de.hasMoreElements()) {
                            DirectoryString delat = (DirectoryString)de.nextElement();
                            athash.remove(delat);
                            sxw.deleteAttributeType(mydoc, ds, delat.toString());
                        }
                    }
                }
                sxw.write(filename, mydoc);
            }
            catch (Exception e) {
                Logger.getInstance().log(0, this, Messages.getString("Failed_to_write_schema_file___21") + e.getMessage());
                throw new DirectoryException(53, Messages.getString("Unable_to_Modify_22"));
            }
        }
    }
}

