/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.backend;

import com.octetstring.ldapv3.Filter;
import com.octetstring.nls.Messages;
import com.octetstring.vde.Entry;
import com.octetstring.vde.backend.Mapping;
import com.octetstring.vde.backend.MappingException;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Mapper {
    Hashtable maps = null;
    private File mapFilename = new File("conf/mapping.cfg");
    private Hashtable reverseDNMap = null;

    public Mapper() {
        this.maps = new Hashtable();
        this.reverseDNMap = new Hashtable();
        BufferedReader br = null;
        String filename = null;
        String ihome = System.getProperty("vde.home");
        filename = this.mapFilename.isAbsolute() || ihome == null ? this.mapFilename.toString() : ihome + "/" + this.mapFilename.toString();
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException fnfe) {
            Logger.getInstance().log(0, this, Messages.getString("Error_opening_mapping_file___4") + filename);
            return;
        }
        boolean hasMore = true;
        DirectoryString currentDN = null;
        int linecount = 0;
        while (hasMore) {
            try {
                String line = br.readLine();
                ++linecount;
                if (line != null) {
                    if (line.length() <= 0 || line.charAt(0) == '#') continue;
                    if (line.startsWith("dn:")) {
                        StringTokenizer st = new StringTokenizer(line, ":");
                        if (st.hasMoreTokens()) {
                            String junk = st.nextToken();
                            if (st.hasMoreTokens()) {
                                currentDN = new DirectoryString(st.nextToken().trim());
                                continue;
                            }
                            Logger.getInstance().log(0, this, "No DN Specified at line: " + linecount);
                            continue;
                        }
                        Logger.getInstance().log(0, this, "No DN Specified at line: " + linecount);
                        continue;
                    }
                    try {
                        Mapping oneMapping = new Mapping(line);
                        Vector<Mapping> cmaps = (Vector<Mapping>)this.maps.get(currentDN);
                        if (cmaps == null) {
                            cmaps = new Vector<Mapping>();
                            cmaps.addElement(oneMapping);
                            this.maps.put(currentDN, cmaps);
                            continue;
                        }
                        cmaps.addElement(oneMapping);
                    }
                    catch (MappingException me) {
                        Logger.getInstance().log(0, this, "Error at line#" + linecount + ": " + me.getMessage());
                    }
                    continue;
                }
                hasMore = false;
            }
            catch (IOException ioe) {
                Logger.getInstance().log(0, this, Messages.getString("IO_error_reading_mapping_file._7"));
                hasMore = false;
            }
        }
    }

    public Entry map(Entry original) {
        if (original == null || original.getName() == null) {
            return original;
        }
        Enumeration maplocs = this.maps.keys();
        Entry newentry = null;
        while (maplocs.hasMoreElements()) {
            DirectoryString loc = (DirectoryString)maplocs.nextElement();
            if (!original.getName().endsWith(loc)) continue;
            if (newentry == null) {
                newentry = (Entry)original.clone();
            }
            Vector cmaps = (Vector)this.maps.get(loc);
            Enumeration mapenum = cmaps.elements();
            while (mapenum.hasMoreElements()) {
                Mapping oneMapping = (Mapping)mapenum.nextElement();
                newentry = oneMapping.transform(newentry);
            }
        }
        if (newentry != null) {
            if (!newentry.getName().equals(original.getName())) {
                this.reverseDNMap.put(newentry.getName(), original.getName());
            }
            return newentry;
        }
        return original;
    }

    public Filter mapfilter(DirectoryString base, Filter original) {
        Enumeration maplocs = this.maps.keys();
        while (maplocs.hasMoreElements()) {
            DirectoryString loc = (DirectoryString)maplocs.nextElement();
            if (!base.endsWith(loc)) continue;
            Vector cmaps = (Vector)this.maps.get(loc);
            Enumeration mapenum = cmaps.elements();
            while (mapenum.hasMoreElements()) {
                Mapping oneMapping = (Mapping)mapenum.nextElement();
                original = oneMapping.updateFilter(original);
            }
        }
        return original;
    }

    public DirectoryString mapbase(DirectoryString base) {
        DirectoryString origdn = (DirectoryString)this.reverseDNMap.get(base);
        if (origdn == null) {
            return base;
        }
        return origdn;
    }
}

