/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.backend;

import com.asn1c.core.OctetString;
import com.octetstring.ldapv3.Filter;
import com.octetstring.ldapv3.Filter_and;
import com.octetstring.ldapv3.Filter_or;
import com.octetstring.nls.Messages;
import com.octetstring.vde.Entry;
import com.octetstring.vde.backend.MappingException;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DNUtility;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.Logger;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MatchResult;

public class Mapping {
    private static int MAPPING_NONE = 0;
    private static int MAPPING_RENAME = 1;
    private static int MAPPING_COPY = 2;
    private static int MAPPING_RAPPEND = 3;
    private static int MAPPING_CAPPEND = 4;
    private static int MAPPING_ADDVALUE = 5;
    private static int MAPPING_DELVALUE = 6;
    private static int MAPPING_REPVALUE = 7;
    private static int MAPPING_SETDN = 8;
    private static int MAPPING_SPLITVALS = 9;
    private static int MAPPING_HIDEALL = 10;
    private static final DirectoryString ATTR_DN = new DirectoryString("dn");
    private static OctetString UNMATCHABLE_TYPE = new OctetString("_unmatchable".getBytes());
    boolean reverse = false;
    int type = MAPPING_NONE;
    DirectoryString attr = null;
    DirectoryString origAttr = null;
    DirectoryString dnendswith = null;
    String setdn = null;
    Vector values = null;
    DirectoryString haveattr = null;
    Syntax haveattrval = null;
    String separator = null;

    public Mapping(String mappingString) throws MappingException {
        StringTokenizer st = new StringTokenizer(mappingString, " ");
        while (st.hasMoreTokens()) {
            StringBuffer sb;
            String attrval;
            StringTokenizer rst;
            String attrs;
            String tok = st.nextToken();
            if (tok.equalsIgnoreCase("haveattr")) {
                if (!st.hasMoreTokens()) {
                    throw new MappingException("haveattr requires attribute type as argument");
                }
                this.haveattr = new DirectoryString(st.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("haveattrval")) {
                StringTokenizer avtok = new StringTokenizer(st.nextToken(), "=");
                if (avtok.countTokens() >= 2) {
                    this.haveattr = new DirectoryString(avtok.nextToken());
                    this.haveattrval = SchemaChecker.getInstance().getAttributeType(this.haveattr).getSyntaxInstance();
                    try {
                        this.haveattrval.setValue(avtok.nextToken().getBytes("UTF8"));
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.haveattrval.setValue(avtok.nextToken().getBytes());
                    }
                    continue;
                }
                throw new MappingException("haveattrval requires an argument specifying attribute=value");
            }
            if (tok.equalsIgnoreCase("matchdn")) {
                if (!st.hasMoreTokens()) {
                    throw new MappingException("matchdn requires a distinguished name argument");
                }
                this.dnendswith = new DirectoryString(st.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("reverse")) {
                this.reverse = true;
                continue;
            }
            if (tok.equalsIgnoreCase("rename")) {
                this.type = MAPPING_RENAME;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("rename requires newattr=oldattr as argument");
                }
                attrs = st.nextToken();
                rst = new StringTokenizer(attrs, "=");
                if (rst.countTokens() < 2) {
                    throw new MappingException("rename requires newattr=oldattr as argument");
                }
                this.attr = new DirectoryString(rst.nextToken());
                this.origAttr = new DirectoryString(rst.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("copy")) {
                this.type = MAPPING_COPY;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("copy requires newattr=oldattr as argument");
                }
                attrs = st.nextToken();
                rst = new StringTokenizer(attrs, "=");
                if (rst.countTokens() < 2) {
                    throw new MappingException("copy requires newattr=oldattr as argument");
                }
                this.attr = new DirectoryString(rst.nextToken());
                this.origAttr = new DirectoryString(rst.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("cappend")) {
                this.type = MAPPING_CAPPEND;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("cappend requires newattr=oldattr as argument");
                }
                attrs = st.nextToken();
                rst = new StringTokenizer(attrs, "=");
                if (rst.countTokens() < 2) {
                    throw new MappingException("cappend requires newattr=oldattr as argument");
                }
                this.attr = new DirectoryString(rst.nextToken());
                this.origAttr = new DirectoryString(rst.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("rappend")) {
                this.type = MAPPING_RAPPEND;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("rappend requires newattr=oldattr as argument");
                }
                attrs = st.nextToken();
                rst = new StringTokenizer(attrs, "=");
                if (rst.countTokens() < 2) {
                    throw new MappingException("rappend requires newattr=oldattr as argument");
                }
                this.attr = new DirectoryString(rst.nextToken());
                this.origAttr = new DirectoryString(rst.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("addvalue")) {
                this.type = MAPPING_ADDVALUE;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("addvalue requires attribute=value as argument");
                }
                attrval = st.nextToken();
                rst = new StringTokenizer(attrval, "=");
                if (rst.countTokens() < 2) {
                    throw new MappingException("addvalue requires attribute=value as argument");
                }
                this.attr = new DirectoryString(rst.nextToken());
                this.values = new Vector();
                sb = new StringBuffer();
                sb.append(rst.nextToken());
                while (st.hasMoreTokens()) {
                    sb.append(" ").append(st.nextToken());
                }
                this.values.addElement(sb.toString());
                continue;
            }
            if (tok.equalsIgnoreCase("deletevalue")) {
                this.type = MAPPING_DELVALUE;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("deletevalue requires attribute=value as argument");
                }
                attrval = st.nextToken();
                rst = new StringTokenizer(attrval, "=");
                if (rst.countTokens() < 2) {
                    throw new MappingException("deletevalue requires attribute=value as argument");
                }
                this.attr = new DirectoryString(rst.nextToken());
                this.values = new Vector();
                sb = new StringBuffer();
                sb.append(rst.nextToken());
                while (st.hasMoreTokens()) {
                    sb.append(" ").append(st.nextToken());
                }
                this.values.addElement(sb.toString());
                continue;
            }
            if (tok.equalsIgnoreCase("replacevalue")) {
                this.type = MAPPING_REPVALUE;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("replacevalue requires attribute=value as argument");
                }
                attrval = st.nextToken();
                rst = new StringTokenizer(attrval, "=");
                if (rst.countTokens() < 2) {
                    throw new MappingException("replacevalue requires attribute=value as argument");
                }
                this.attr = new DirectoryString(rst.nextToken());
                this.values = new Vector();
                sb = new StringBuffer();
                sb.append(rst.nextToken());
                while (st.hasMoreTokens()) {
                    sb.append(" ").append(st.nextToken());
                }
                this.values.addElement(sb.toString());
                continue;
            }
            if (tok.equalsIgnoreCase("setdn")) {
                this.type = MAPPING_SETDN;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("setdn requires a distinguished name constructor as an argument");
                }
                StringBuffer sb2 = new StringBuffer();
                sb2.append(st.nextToken());
                while (st.hasMoreTokens()) {
                    sb2.append(" ").append(st.nextToken());
                }
                this.setdn = sb2.toString();
                continue;
            }
            if (tok.equalsIgnoreCase("splitvals")) {
                this.type = MAPPING_SPLITVALS;
                if (!st.hasMoreTokens()) {
                    throw new MappingException("splitvals requires attribute=delimeter as argument");
                }
                if (st.countTokens() >= 2) {
                    this.attr = new DirectoryString(st.nextToken());
                    this.separator = st.nextToken();
                } else {
                    StringTokenizer rst2 = new StringTokenizer(st.nextToken(), "=", true);
                    if (rst2.countTokens() < 3) {
                        throw new MappingException("splitvals requires attribute=delimeter as argument");
                    }
                    this.attr = new DirectoryString(rst2.nextToken());
                    String junk = rst2.nextToken();
                    this.separator = rst2.nextToken();
                }
                if (!this.separator.equals("\\s")) continue;
                this.separator = new String(" ");
                continue;
            }
            if (tok.equalsIgnoreCase("hideall")) {
                this.type = MAPPING_HIDEALL;
                continue;
            }
            throw new MappingException("unknown operation - " + tok);
        }
    }

    public Entry transform(Entry entry) {
        return this.transform(entry, false);
    }

    public Entry transform(Entry entry, boolean reversed) {
        Vector newval;
        Vector oldval;
        if (this.reverse != reversed) {
            return entry;
        }
        if (this.haveattr != null && entry.get(this.haveattr) == null) {
            return entry;
        }
        if (this.haveattrval != null) {
            Vector vals = entry.get(this.haveattr);
            if (vals == null) {
                return entry;
            }
            if (!vals.contains(this.haveattrval)) {
                return entry;
            }
        }
        if (this.dnendswith != null && !entry.getName().endsWith(this.dnendswith)) {
            return entry;
        }
        if (this.type == MAPPING_HIDEALL) {
            return null;
        }
        if (this.type == MAPPING_RENAME) {
            oldval = entry.get(this.origAttr);
            if (oldval != null) {
                entry.remove(this.origAttr);
                entry.put(this.attr, oldval);
            }
            return entry;
        }
        if (this.type == MAPPING_COPY) {
            oldval = entry.get(this.origAttr);
            if (oldval != null) {
                entry.put(this.attr, oldval);
            }
            return entry;
        }
        if (this.type == MAPPING_RAPPEND) {
            oldval = entry.get(this.origAttr);
            Vector newval2 = entry.get(this.attr);
            if (oldval != null) {
                if (newval2 == null) {
                    entry.put(this.attr, oldval);
                } else {
                    newval2.addAll(oldval);
                }
                entry.remove(this.origAttr);
            }
            return entry;
        }
        if (this.type == MAPPING_CAPPEND) {
            oldval = entry.get(this.origAttr);
            Vector newval3 = entry.get(this.attr);
            if (oldval != null) {
                if (newval3 == null) {
                    entry.put(this.attr, oldval);
                } else {
                    newval3.addAll(oldval);
                }
            }
            return entry;
        }
        if (this.type == MAPPING_ADDVALUE) {
            newval = entry.get(this.attr);
            if (newval == null) {
                newval = new Vector();
            }
            Enumeration vals = this.values.elements();
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                Vector vars = new Vector();
                Perl5Util p5u = new Perl5Util();
                p5u.split(vars, "/(%)/", val);
                Enumeration varenum = vars.elements();
                boolean invar = false;
                StringBuffer tmpstring = new StringBuffer();
                while (varenum.hasMoreElements()) {
                    String one = (String)varenum.nextElement();
                    if (one.equals("%")) {
                        invar = !invar;
                        continue;
                    }
                    if (!invar) {
                        tmpstring.append(one);
                        continue;
                    }
                    Vector components = new Vector();
                    p5u.split(components, "/:/", one);
                    Vector tmpvv = entry.get(new DirectoryString((String)components.elementAt(0)));
                    if (tmpvv == null || tmpvv.isEmpty()) continue;
                    String tmpval = new String(((Syntax)tmpvv.elementAt(0)).getValue());
                    if (components.size() > 1) {
                        String regex = (String)components.elementAt(1);
                        if (!p5u.match(regex, tmpval)) continue;
                        MatchResult mr = p5u.getMatch();
                        tmpstring.append(mr.toString());
                        continue;
                    }
                    tmpstring.append(tmpval);
                }
                if (tmpstring.length() == 0) continue;
                newval.addElement(new DirectoryString(tmpstring.toString()));
            }
            if (!newval.isEmpty()) {
                entry.put(this.attr, newval);
            }
            return entry;
        }
        if (this.type == MAPPING_DELVALUE) {
            newval = entry.get(this.attr);
            if (newval == null) {
                return entry;
            }
            Enumeration vals = this.values.elements();
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                Vector vars = new Vector();
                Perl5Util p5u = new Perl5Util();
                p5u.split(vars, "/(%)/", val);
                Enumeration varenum = vars.elements();
                boolean invar = false;
                StringBuffer tmpstring = new StringBuffer();
                while (varenum.hasMoreElements()) {
                    String one = (String)varenum.nextElement();
                    if (one.equals("%")) {
                        invar = !invar;
                        continue;
                    }
                    if (!invar) {
                        tmpstring.append(one);
                        continue;
                    }
                    Vector components = new Vector();
                    p5u.split(components, "/:/", one);
                    Vector tmpvv = entry.get(new DirectoryString((String)components.elementAt(0)));
                    if (tmpvv == null || tmpvv.isEmpty()) continue;
                    String tmpval = new String(((Syntax)tmpvv.elementAt(0)).getValue());
                    if (components.size() > 1) {
                        String regex = (String)components.elementAt(1);
                        if (!p5u.match(regex, tmpval)) continue;
                        MatchResult mr = p5u.getMatch();
                        tmpstring.append(mr.toString());
                        continue;
                    }
                    tmpstring.append(tmpval);
                }
                newval.removeElement(new DirectoryString(tmpstring.toString()));
            }
            return entry;
        }
        if (this.type == MAPPING_REPVALUE) {
            newval = new Vector();
            Enumeration vals = this.values.elements();
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                Vector vars = new Vector();
                Perl5Util p5u = new Perl5Util();
                p5u.split(vars, "/(%)/", val);
                Enumeration varenum = vars.elements();
                boolean invar = false;
                StringBuffer tmpstring = new StringBuffer();
                while (varenum.hasMoreElements()) {
                    String one = (String)varenum.nextElement();
                    if (one.equals("%")) {
                        invar = !invar;
                        continue;
                    }
                    if (!invar) {
                        tmpstring.append(one);
                        continue;
                    }
                    Vector components = new Vector();
                    p5u.split(components, "/:/", one);
                    Vector tmpvv = entry.get(new DirectoryString((String)components.elementAt(0)));
                    if (tmpvv == null || tmpvv.isEmpty()) continue;
                    String tmpval = new String(((Syntax)tmpvv.elementAt(0)).getValue());
                    if (components.size() > 1) {
                        String regex = (String)components.elementAt(1);
                        if (!p5u.match(regex, tmpval)) continue;
                        MatchResult mr = p5u.getMatch();
                        tmpstring.append(mr.toString());
                        continue;
                    }
                    tmpstring.append(tmpval);
                }
                newval.addElement(new DirectoryString(tmpstring.toString()));
            }
            entry.put(this.attr, newval);
            return entry;
        }
        if (this.type == MAPPING_SPLITVALS) {
            oldval = entry.get(this.attr);
            if (oldval == null) {
                return entry;
            }
            Syntax val = (Syntax)oldval.elementAt(0);
            Perl5Util p5u = new Perl5Util();
            Vector newvals = new Vector();
            p5u.split(newvals, "/" + this.separator + "/", val.toString());
            Vector<DirectoryString> realvals = new Vector<DirectoryString>();
            Enumeration ve = newvals.elements();
            while (ve.hasMoreElements()) {
                String oneval = (String)ve.nextElement();
                if (oneval == null || oneval.length() == 0) continue;
                realvals.addElement(new DirectoryString(oneval));
            }
            entry.put(this.attr, realvals);
            return entry;
        }
        if (this.type == MAPPING_SETDN) {
            Vector curdncomps = DNUtility.getInstance().explodeDN(entry.getName());
            Vector vars = new Vector();
            Perl5Util p5u = new Perl5Util();
            p5u.split(vars, "/(%)/", this.setdn);
            Enumeration varenum = vars.elements();
            boolean invar = false;
            StringBuffer tmpstring = new StringBuffer();
            while (varenum.hasMoreElements()) {
                String one = (String)varenum.nextElement();
                if (one.equals("%")) {
                    invar = !invar;
                } else if (!invar) {
                    tmpstring.append(one);
                } else {
                    Vector components = new Vector();
                    p5u.split(components, "/:/", one);
                    DirectoryString myattr = new DirectoryString((String)components.elementAt(0));
                    if (myattr.equals(ATTR_DN)) {
                        int numcom = curdncomps.size() - 1;
                        if (components.size() > 1 && (numcom = Integer.parseInt((String)components.elementAt(1))) > curdncomps.size()) {
                            numcom = curdncomps.size() - 1;
                        }
                        for (int ct = curdncomps.size() - numcom; ct < curdncomps.size(); ++ct) {
                            tmpstring.append(curdncomps.elementAt(ct));
                            if (ct >= curdncomps.size() - 1) continue;
                            tmpstring.append(",");
                        }
                    } else {
                        Vector tmpvv = entry.get(myattr);
                        if (tmpvv != null && !tmpvv.isEmpty()) {
                            String tmpval = new String(((Syntax)tmpvv.elementAt(0)).getValue());
                            if (components.size() > 1) {
                                String regex = (String)components.elementAt(1);
                                if (p5u.match(regex, tmpval)) {
                                    MatchResult mr = p5u.getMatch();
                                    tmpstring.append(mr.toString());
                                }
                            } else {
                                tmpstring.append(tmpval);
                            }
                        }
                    }
                }
                try {
                    entry.setName(new DirectoryString(tmpstring.toString()));
                }
                catch (InvalidDNException ide) {
                    Logger.getInstance().log(0, this, Messages.getString("Invalid_DN_created_by_mapping_rules___44") + tmpstring);
                }
            }
            return entry;
        }
        return entry;
    }

    public Filter updateFilter(Filter currentFilter) {
        if (currentFilter == null) {
            return currentFilter;
        }
        switch (currentFilter.getSelector()) {
            case 3: {
                DirectoryString matchType = new DirectoryString(currentFilter.getEqualityMatch().getAttributeDesc().toByteArray());
                if (this.attr != null && this.attr.equals(matchType)) {
                    if (this.type == MAPPING_RENAME || this.type == MAPPING_COPY) {
                        currentFilter.getEqualityMatch().setAttributeDesc(new OctetString(this.origAttr.getBytes()));
                    }
                    if (this.type != MAPPING_RAPPEND && this.type != MAPPING_CAPPEND) break;
                    Filter tmpFilter = new Filter();
                    Filter_or tmpor = new Filter_or();
                    tmpFilter.setOr(tmpor);
                    tmpor.addElement(currentFilter);
                    Filter sFilter = new Filter(currentFilter);
                    sFilter.getEqualityMatch().setAttributeDesc(new OctetString(this.origAttr.getBytes()));
                    tmpor.addElement(sFilter);
                    currentFilter = tmpFilter;
                    break;
                }
                if (this.origAttr == null || !this.origAttr.equals(matchType) || this.type != MAPPING_RENAME && this.type != MAPPING_RAPPEND) break;
                currentFilter.getEqualityMatch().setAttributeDesc(UNMATCHABLE_TYPE);
                break;
            }
            case 7: {
                DirectoryString matchType = new DirectoryString(currentFilter.getPresent().toByteArray());
                if (this.attr != null && this.attr.equals(matchType)) {
                    if (this.type == MAPPING_RENAME || this.type == MAPPING_COPY) {
                        currentFilter.setPresent(new OctetString(this.origAttr.getBytes()));
                    }
                    if (this.type != MAPPING_RAPPEND && this.type != MAPPING_CAPPEND) break;
                    Filter tmpFilter = new Filter();
                    Filter_or tmpor = new Filter_or();
                    tmpFilter.setOr(tmpor);
                    tmpor.addElement(currentFilter);
                    Filter sFilter = new Filter(currentFilter);
                    sFilter.setPresent(new OctetString(this.origAttr.getBytes()));
                    tmpor.addElement(sFilter);
                    currentFilter = tmpFilter;
                    break;
                }
                if (this.origAttr == null || !this.origAttr.equals(matchType) || this.type != MAPPING_RENAME && this.type != MAPPING_RAPPEND) break;
                currentFilter.setPresent(UNMATCHABLE_TYPE);
                break;
            }
            case 5: {
                DirectoryString matchType = new DirectoryString(currentFilter.getGreaterOrEqual().getAttributeDesc().toByteArray());
                if (this.attr != null && this.attr.equals(matchType)) {
                    if (this.type == MAPPING_RENAME || this.type == MAPPING_COPY) {
                        currentFilter.getGreaterOrEqual().setAttributeDesc(new OctetString(this.origAttr.getBytes()));
                    }
                    if (this.type != MAPPING_RAPPEND && this.type != MAPPING_CAPPEND) break;
                    Filter tmpFilter = new Filter();
                    Filter_or tmpor = new Filter_or();
                    tmpFilter.setOr(tmpor);
                    tmpor.addElement(currentFilter);
                    Filter sFilter = new Filter(currentFilter);
                    sFilter.getGreaterOrEqual().setAttributeDesc(new OctetString(this.origAttr.getBytes()));
                    tmpor.addElement(sFilter);
                    currentFilter = tmpFilter;
                    break;
                }
                if (this.origAttr == null || !this.origAttr.equals(matchType) || this.type != MAPPING_RENAME && this.type != MAPPING_RAPPEND) break;
                currentFilter.getGreaterOrEqual().setAttributeDesc(UNMATCHABLE_TYPE);
                break;
            }
            case 6: {
                DirectoryString matchType = new DirectoryString(currentFilter.getLessOrEqual().getAttributeDesc().toByteArray());
                if (this.attr != null && this.attr.equals(matchType)) {
                    if (this.type == MAPPING_RENAME || this.type == MAPPING_COPY) {
                        currentFilter.getLessOrEqual().setAttributeDesc(new OctetString(this.origAttr.getBytes()));
                    }
                    if (this.type != MAPPING_RAPPEND && this.type != MAPPING_CAPPEND) break;
                    Filter tmpFilter = new Filter();
                    Filter_or tmpor = new Filter_or();
                    tmpFilter.setOr(tmpor);
                    tmpor.addElement(currentFilter);
                    Filter sFilter = new Filter(currentFilter);
                    sFilter.getLessOrEqual().setAttributeDesc(new OctetString(this.origAttr.getBytes()));
                    tmpor.addElement(sFilter);
                    currentFilter = tmpFilter;
                    break;
                }
                if (this.origAttr == null || !this.origAttr.equals(matchType) || this.type != MAPPING_RENAME && this.type != MAPPING_RAPPEND) break;
                currentFilter.getLessOrEqual().setAttributeDesc(UNMATCHABLE_TYPE);
                break;
            }
            case 4: {
                DirectoryString matchType = new DirectoryString(currentFilter.getSubstrings().getType().toByteArray());
                if (this.attr != null && this.attr.equals(matchType)) {
                    if (this.type == MAPPING_RENAME || this.type == MAPPING_COPY) {
                        currentFilter.getSubstrings().setType(new OctetString(this.origAttr.getBytes()));
                    }
                    if (this.type != MAPPING_RAPPEND && this.type != MAPPING_CAPPEND) break;
                    Filter tmpFilter = new Filter();
                    Filter_or tmpor = new Filter_or();
                    tmpFilter.setOr(tmpor);
                    tmpor.addElement(currentFilter);
                    Filter sFilter = new Filter(currentFilter);
                    sFilter.getSubstrings().setType(new OctetString(this.origAttr.getBytes()));
                    tmpor.addElement(sFilter);
                    currentFilter = tmpFilter;
                    break;
                }
                if (this.origAttr == null || !this.origAttr.equals(matchType) || this.type != MAPPING_RENAME && this.type != MAPPING_RAPPEND) break;
                currentFilter.getSubstrings().setType(UNMATCHABLE_TYPE);
                break;
            }
            case 0: {
                Filter_and newand = new Filter_and();
                Iterator andEnum = currentFilter.getAnd().iterator();
                while (andEnum.hasNext()) {
                    Filter oneand = new Filter((Filter)andEnum.next());
                    if ((oneand = this.updateFilter(oneand)) == null) continue;
                    newand.addElement(oneand);
                }
                currentFilter.setAnd(newand);
                break;
            }
            case 1: {
                Filter_or newor = new Filter_or();
                Iterator orEnum = currentFilter.getOr().iterator();
                while (orEnum.hasNext()) {
                    Filter oneor = new Filter((Filter)orEnum.next());
                    if ((oneor = this.updateFilter(oneor)) == null) continue;
                    newor.addElement(oneor);
                }
                currentFilter.setOr(newor);
            }
        }
        return currentFilter;
    }
}

