/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.backend.standard;

import com.octetstring.vde.Entry;
import com.octetstring.vde.EntryChange;
import com.octetstring.vde.backend.Backend;
import com.octetstring.vde.backend.standard.KeyEidList;
import com.octetstring.vde.backend.standard.KeyPool;
import com.octetstring.vde.backend.standard.KeyPtr;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.IntegerSyntax;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.Logger;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class Index {
    private Map itPres = Collections.synchronizedMap(new HashMap());
    private Map itExact = Collections.synchronizedMap(new HashMap());
    private Map itOrder = Collections.synchronizedMap(new HashMap());
    private Map itSub = Collections.synchronizedMap(new HashMap());
    private Vector presenceIndices = null;
    private Vector exactIndices = null;
    private Vector orderingIndices = null;
    private Vector substringIndices = null;
    private Backend backEnd = null;
    public static final int PRESENCE = 0;
    public static final int EXACT = 1;
    public static final int ORDER_LESS = 2;
    public static final int ORDER_GREATER = 3;
    public static final int SUBSTR_INITIAL = 4;
    public static final int SUBSTR_ANY = 5;
    public static final int SUBSTR_FINAL = 6;
    private static final KeyPtr ALL_STRING = new KeyPtr("*".getBytes());
    private static final String NOENCODING = "";

    public Index(Backend backEnd, Vector presenceIndices, Vector exactIndices, Vector orderingIndices, Vector substringIndices) {
        this.presenceIndices = presenceIndices;
        this.exactIndices = exactIndices;
        this.orderingIndices = orderingIndices;
        this.substringIndices = substringIndices;
        this.backEnd = backEnd;
        Enumeration presMatchEnum = presenceIndices.elements();
        while (presMatchEnum.hasMoreElements()) {
            this.itPres.put((DirectoryString)presMatchEnum.nextElement(), new KeyEidList(ALL_STRING));
        }
        Enumeration equalsMatchEnum = exactIndices.elements();
        while (equalsMatchEnum.hasMoreElements()) {
            this.itExact.put((DirectoryString)equalsMatchEnum.nextElement(), Collections.synchronizedMap(new HashMap()));
        }
        Enumeration orderMatchEnum = orderingIndices.elements();
        while (orderMatchEnum.hasMoreElements()) {
            this.itOrder.put((DirectoryString)orderMatchEnum.nextElement(), Collections.synchronizedSortedMap(new TreeMap()));
        }
        Enumeration subMatchEnum = substringIndices.elements();
        while (subMatchEnum.hasMoreElements()) {
            this.itSub.put((DirectoryString)subMatchEnum.nextElement(), Collections.synchronizedSortedMap(new TreeMap()));
        }
    }

    private int[] concatEids(int[] orig, int[] neweids) {
        int[] full = null;
        if (orig == null) {
            full = new int[neweids.length];
            System.arraycopy(neweids, 0, full, 0, neweids.length);
            return full;
        }
        full = new int[orig.length + neweids.length];
        System.arraycopy(orig, 0, full, 0, orig.length);
        System.arraycopy(neweids, 0, full, orig.length, neweids.length);
        return full;
    }

    private int[] concatEids(int[] orig, int neweid) {
        int[] tmp = new int[]{neweid};
        return this.concatEids(orig, tmp);
    }

    public void delete(Entry entry) {
        int entryId = entry.getID();
        Enumeration keys = entry.keys();
        while (keys.hasMoreElements()) {
            DirectoryString attr = (DirectoryString)keys.nextElement();
            String at = attr.normalize();
            int index = at.indexOf(59);
            if (index >= 0) {
                attr = new DirectoryString(at.substring(0, index));
            }
            Map exactAI = (Map)this.itExact.get(attr);
            Map orderAI = (Map)this.itOrder.get(attr);
            Map substrAI = (Map)this.itSub.get(attr);
            Vector vals = entry.get(attr);
            Enumeration valEnum = vals.elements();
            while (valEnum.hasMoreElements()) {
                KeyEidList kel;
                Syntax aVal = (Syntax)valEnum.nextElement();
                String normVal = aVal.normalize();
                IntegerSyntax valHash = new IntegerSyntax(normVal.hashCode());
                if (exactAI != null && (kel = (KeyEidList)exactAI.get(new KeyEidList(new KeyPtr(valHash.toString().getBytes())))) != null) {
                    kel.removeEid(entryId);
                    if (kel.size() == 0) {
                        exactAI.remove(kel);
                    }
                }
                if (orderAI != null && (kel = (KeyEidList)orderAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(normVal))))) != null) {
                    kel.removeEid(entryId);
                    if (kel.size() == 0) {
                        orderAI.remove(kel);
                    }
                }
                if (substrAI == null || (kel = (KeyEidList)substrAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(aVal.reverse().normalize()))))) == null) continue;
                kel.removeEid(entryId);
                if (kel.size() != 0) continue;
                substrAI.remove(kel);
            }
            KeyEidList kel = (KeyEidList)this.itPres.get(attr);
            if (kel == null) continue;
            kel.removeEid(entryId);
        }
    }

    public int[] getCandidates(int type, DirectoryString cisAttr, Syntax synValue) {
        int[] results = null;
        if (type == 3 || type == 2) {
            if (this.itOrder.containsKey(cisAttr)) {
                String val = synValue.normalize();
                SortedMap attrIndex = (SortedMap)this.itOrder.get(cisAttr);
                SortedMap matches = null;
                matches = type == 3 ? attrIndex.tailMap(new KeyEidList(new KeyPtr(this.getUTFBytes(val)))) : attrIndex.headMap(new KeyEidList(new KeyPtr(this.getUTFBytes(val))));
                Set<KeyEidList> matchEnts = matches.keySet();
                int[] eids = null;
                boolean doit = true;
                while (doit) {
                    try {
                        Iterator enumEnts = matchEnts.iterator();
                        while (enumEnts.hasNext()) {
                            KeyEidList kel = (KeyEidList)enumEnts.next();
                            eids = this.concatEids(eids, kel.getEids());
                        }
                        doit = false;
                    }
                    catch (ConcurrentModificationException cme) {}
                }
                results = eids;
            }
            if (results != null) {
                return results;
            }
            return new int[0];
        }
        if (type == 0) {
            if (this.itPres.containsKey(cisAttr)) {
                KeyEidList kel = (KeyEidList)this.itPres.get(cisAttr);
                return kel.getEids();
            }
            return new int[0];
        }
        if (type == 1) {
            String val = synValue.normalize();
            if (type == 1 && this.itOrder.containsKey(cisAttr)) {
                Map attrIndex = (Map)this.itOrder.get(cisAttr);
                KeyEidList kel = (KeyEidList)attrIndex.get(new KeyEidList(new KeyPtr(this.getUTFBytes(val))));
                if (kel == null) {
                    return results;
                }
                return kel.getEids();
            }
            if (this.itExact.containsKey(cisAttr)) {
                Map attrIndex;
                int[] eids = null;
                IntegerSyntax valHash = null;
                KeyEidList kel = null;
                if (type == 1 && eids == null && (kel = (KeyEidList)(attrIndex = (Map)this.itExact.get(cisAttr)).get((valHash = new IntegerSyntax(val.hashCode())).toString())) == null) {
                    return results;
                }
                eids = kel.getEids();
                for (int i = 0; i < eids.length; ++i) {
                    int currentEid = eids[i];
                    Entry current = this.backEnd.getByID(new Integer(currentEid));
                    if (!current.get(cisAttr).contains(synValue)) continue;
                    results = this.concatEids(results, currentEid);
                }
            }
        }
        if (results != null) {
            return results;
        }
        return new int[0];
    }

    public int[] getCandidates(int type, DirectoryString cisAttr, Syntax synValue, String regex) {
        int[] results;
        block15: {
            SortedMap reverseIndex;
            SortedMap forwardIndex;
            Perl5Util p5u;
            block17: {
                block16: {
                    results = null;
                    if (type != 4 && type != 5 && type != 6) break block15;
                    p5u = null;
                    if (regex != null) {
                        p5u = new Perl5Util();
                    }
                    forwardIndex = null;
                    reverseIndex = null;
                    forwardIndex = (SortedMap)this.itOrder.get(cisAttr);
                    reverseIndex = (SortedMap)this.itSub.get(cisAttr);
                    if (type != 4 || forwardIndex == null) break block16;
                    int[] tmpMatches = null;
                    byte[] valmatch = this.getUTFBytes(synValue.normalize());
                    SortedMap tailMap = forwardIndex.tailMap(new KeyEidList(new KeyPtr(valmatch)));
                    Set<KeyEidList> tail = tailMap.keySet();
                    boolean doit = true;
                    while (doit) {
                        try {
                            KeyEidList kel;
                            Iterator<KeyEidList> iter = tail.iterator();
                            while (iter.hasNext() && (kel = iter.next()).getKeyptr().startsWith(valmatch)) {
                                int[] eids;
                                if (regex != null) {
                                    if (!p5u.match(regex, kel.getKeyptr().toString())) continue;
                                    eids = kel.getEids();
                                    tmpMatches = this.concatEids(tmpMatches, eids);
                                    continue;
                                }
                                eids = kel.getEids();
                                tmpMatches = this.concatEids(tmpMatches, eids);
                            }
                            results = tmpMatches;
                            doit = false;
                        }
                        catch (ConcurrentModificationException cme) {
                            tmpMatches = null;
                        }
                    }
                    break block15;
                }
                if (type != 6 || reverseIndex == null) break block17;
                int[] tmpMatches = null;
                byte[] valmatch = this.getUTFBytes(synValue.reverse().normalize());
                SortedMap tailMap = reverseIndex.tailMap(new KeyEidList(new KeyPtr(valmatch)));
                Set<KeyEidList> tail = tailMap.keySet();
                boolean doit = true;
                while (doit) {
                    try {
                        KeyEidList kel;
                        Iterator<KeyEidList> iter = tail.iterator();
                        while (iter.hasNext() && (kel = iter.next()).getKeyptr().startsWith(valmatch)) {
                            if (regex != null) {
                                StringBuffer tmpsb = new StringBuffer(kel.getKeyptr().toString());
                                if (!p5u.match(regex, tmpsb.reverse().toString())) continue;
                                int[] eids = kel.getEids();
                                tmpMatches = this.concatEids(tmpMatches, eids);
                                continue;
                            }
                            int[] eids = kel.getEids();
                            tmpMatches = this.concatEids(tmpMatches, eids);
                        }
                        results = tmpMatches;
                        doit = false;
                    }
                    catch (ConcurrentModificationException cme) {
                        tmpMatches = null;
                    }
                }
                break block15;
            }
            if ((type != 5 || forwardIndex == null) && (type != 6 || forwardIndex == null || reverseIndex != null) || regex == null) break block15;
            int[] tmpMatches = null;
            SortedMap tailMap = forwardIndex;
            Set tail = tailMap.keySet();
            boolean doit = true;
            while (doit) {
                try {
                    Iterator iter = tail.iterator();
                    while (iter.hasNext()) {
                        KeyEidList kel = (KeyEidList)iter.next();
                        if (!p5u.match(regex, kel.getKeyptr().toString())) continue;
                        int[] eids = kel.getEids();
                        tmpMatches = this.concatEids(tmpMatches, eids);
                    }
                    results = tmpMatches;
                    doit = false;
                }
                catch (ConcurrentModificationException cme) {
                    tmpMatches = null;
                }
            }
        }
        return results;
    }

    public void index(Entry entry) {
        Object eids;
        KeyEidList getKel;
        KeyEidList kel;
        Syntax val;
        Enumeration attrValEnum;
        Map attrIndex;
        Vector attrValVec;
        DirectoryString indexKey;
        int entryId = entry.getID();
        boolean dumpLog = Logger.getInstance().isLogable(11);
        Enumeration indexes = this.presenceIndices.elements();
        while (indexes.hasMoreElements()) {
            indexKey = (DirectoryString)indexes.nextElement();
            attrValVec = entry.get(indexKey);
            if (attrValVec == null) continue;
            if (dumpLog) {
                Logger.getInstance().log(11, this, "presIndex:  " + entry.getName() + " | " + indexKey);
            }
            KeyEidList kel2 = (KeyEidList)this.itPres.get(indexKey);
            kel2.addEid(entryId);
        }
        indexes = this.exactIndices.elements();
        while (indexes.hasMoreElements()) {
            indexKey = (DirectoryString)indexes.nextElement();
            attrValVec = entry.get(indexKey);
            if (attrValVec == null || attrValVec.size() <= 0) continue;
            attrIndex = (Map)this.itExact.get(indexKey);
            attrValEnum = attrValVec.elements();
            while (attrValEnum.hasMoreElements()) {
                String valHash;
                KeyEidList kel3;
                val = (Syntax)attrValEnum.nextElement();
                String normVal = val.normalize();
                if (dumpLog) {
                    Logger.getInstance().log(11, this, "exactIndex:  " + entry.getName() + "\n    " + indexKey + "=" + normVal);
                }
                if ((kel3 = (KeyEidList)attrIndex.get(valHash = new IntegerSyntax(normVal.hashCode()).toString())) == null) {
                    kel3 = new KeyEidList(new KeyPtr(valHash.getBytes()));
                    attrIndex.put(kel3, kel3);
                }
                kel3.addEid(entryId);
            }
        }
        indexes = this.orderingIndices.elements();
        while (indexes.hasMoreElements()) {
            indexKey = (DirectoryString)indexes.nextElement();
            attrValVec = entry.get(indexKey);
            if (attrValVec == null || attrValVec.size() <= 0) continue;
            attrIndex = (Map)this.itOrder.get(indexKey);
            attrValEnum = attrValVec.elements();
            while (attrValEnum.hasMoreElements()) {
                val = (Syntax)attrValEnum.nextElement();
                if (dumpLog) {
                    Logger.getInstance().log(11, this, "orderIndex:  " + entry.getName() + "\n    " + indexKey + "=" + val);
                }
                kel = new KeyEidList(KeyPool.getInstance().get(this.getUTFBytes(val.normalize())));
                getKel = (KeyEidList)attrIndex.get(kel);
                eids = null;
                if (getKel == null) {
                    getKel = kel;
                    attrIndex.put(getKel, getKel);
                }
                getKel.addEid(entryId);
            }
        }
        indexes = this.substringIndices.elements();
        while (indexes.hasMoreElements()) {
            indexKey = (DirectoryString)indexes.nextElement();
            attrValVec = entry.get(indexKey);
            if (attrValVec == null || attrValVec.size() <= 0) continue;
            attrIndex = (Map)this.itSub.get(indexKey);
            attrValEnum = attrValVec.elements();
            while (attrValEnum.hasMoreElements()) {
                val = (Syntax)attrValEnum.nextElement();
                if (dumpLog) {
                    Logger.getInstance().log(11, this, "subStringIndex:  " + entry.getName() + "\n    " + indexKey + "=" + val);
                }
                kel = new KeyEidList(KeyPool.getInstance().get(this.getUTFBytes(val.reverse().normalize())));
                getKel = (KeyEidList)attrIndex.get(kel);
                eids = null;
                if (getKel == null) {
                    getKel = kel;
                    attrIndex.put(getKel, getKel);
                }
                getKel.addEid(entryId);
            }
        }
    }

    public void index(Entry entry, Vector changes) {
        int entryId = entry.getID();
        Enumeration changeEnum = changes.elements();
        while (changeEnum.hasMoreElements()) {
            IntegerSyntax valHash;
            KeyEidList kel;
            KeyEidList kel2;
            String normVal;
            Syntax aVal;
            Enumeration cvals;
            KeyEidList kel3;
            EntryChange change = (EntryChange)changeEnum.nextElement();
            int changeType = change.getModType();
            DirectoryString attr = change.getAttr();
            Vector vals = change.getValues();
            Vector oldvals = entry.get(attr);
            Map exactAI = (Map)this.itExact.get(attr);
            Map orderAI = (Map)this.itOrder.get(attr);
            Map substrAI = (Map)this.itSub.get(attr);
            if (changeType == 0 || changeType == 2) {
                if (this.presenceIndices.contains(attr)) {
                    kel3 = (KeyEidList)this.itPres.get(attr);
                    kel3.addEid(entry.getID());
                }
                if (changeType == 0) {
                    cvals = vals.elements();
                    while (cvals.hasMoreElements()) {
                        aVal = (Syntax)cvals.nextElement();
                        normVal = aVal.normalize();
                        if (orderAI == null) continue;
                        kel2 = (KeyEidList)orderAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(normVal))));
                        if (kel2 == null) {
                            kel2 = new KeyEidList(KeyPool.getInstance().get(this.getUTFBytes(normVal)));
                            orderAI.put(kel2, kel2);
                        }
                        kel2.addEid(entry.getID());
                    }
                }
                if (changeType != 2) continue;
                if (oldvals != null) {
                    Enumeration ov = oldvals.elements();
                    while (ov.hasMoreElements()) {
                        aVal = (Syntax)ov.nextElement();
                        normVal = null;
                        if (exactAI != null && (kel = (KeyEidList)exactAI.get(new KeyEidList(new KeyPtr((valHash = new IntegerSyntax((normVal = aVal.normalize()).hashCode())).toString().getBytes())))) != null) {
                            kel.removeEid(entryId);
                            if (kel.size() == 0) {
                                exactAI.remove(kel);
                            }
                        }
                        if (orderAI != null) {
                            if (normVal == null) {
                                normVal = aVal.normalize();
                            }
                            if ((kel2 = (KeyEidList)orderAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(normVal))))) != null) {
                                kel2.removeEid(entryId);
                                if (kel2.size() == 0) {
                                    orderAI.remove(kel2);
                                }
                            }
                        }
                        if (substrAI == null || (kel2 = (KeyEidList)substrAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(aVal.reverse().normalize()))))) == null) continue;
                        kel2.removeEid(entryId);
                        if (kel2.size() != 0) continue;
                        substrAI.remove(kel2);
                    }
                }
                cvals = vals.elements();
                while (cvals.hasMoreElements()) {
                    aVal = (Syntax)cvals.nextElement();
                    if (changeType != 2 && oldvals != null && oldvals.contains(aVal)) continue;
                    normVal = null;
                    if (exactAI != null) {
                        normVal = aVal.normalize();
                        valHash = new IntegerSyntax(normVal.hashCode());
                        kel = (KeyEidList)exactAI.get(new KeyEidList(new KeyPtr(valHash.toString().getBytes())));
                        if (kel == null) {
                            kel = new KeyEidList(new KeyPtr(valHash.toString().getBytes()));
                            exactAI.put(kel, kel);
                        }
                        kel.addEid(entryId);
                    }
                    if (orderAI != null) {
                        if (normVal == null) {
                            normVal = aVal.normalize();
                        }
                        if ((kel2 = (KeyEidList)orderAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(normVal))))) == null) {
                            kel2 = new KeyEidList(KeyPool.getInstance().get(this.getUTFBytes(aVal.normalize())));
                            orderAI.put(kel2, kel2);
                        }
                        kel2.addEid(entryId);
                    }
                    if (substrAI == null) continue;
                    byte[] revVal = this.getUTFBytes(aVal.reverse().normalize());
                    kel = (KeyEidList)substrAI.get(new KeyEidList(new KeyPtr(revVal)));
                    if (kel == null) {
                        kel = new KeyEidList(KeyPool.getInstance().get(revVal));
                        substrAI.put(kel, kel);
                    }
                    kel.addEid(entryId);
                }
                continue;
            }
            if (changeType != 1) continue;
            cvals = vals.elements();
            while (cvals.hasMoreElements()) {
                aVal = (Syntax)cvals.nextElement();
                if (oldvals == null || !oldvals.contains(aVal)) continue;
                normVal = null;
                if (exactAI != null && (kel = (KeyEidList)exactAI.get(new KeyEidList(new KeyPtr((valHash = new IntegerSyntax((normVal = aVal.normalize()).hashCode())).toString().getBytes())))) != null) {
                    kel.removeEid(entryId);
                    if (kel.size() == 0) {
                        exactAI.remove(kel);
                    }
                }
                if (orderAI != null) {
                    if (normVal == null) {
                        normVal = aVal.normalize();
                    }
                    if ((kel2 = (KeyEidList)orderAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(normVal))))) != null) {
                        kel2.removeEid(entryId);
                        if (kel2.size() == 0) {
                            orderAI.remove(kel2);
                        }
                    }
                }
                if (substrAI != null && (kel2 = (KeyEidList)substrAI.get(new KeyEidList(new KeyPtr(this.getUTFBytes(aVal.reverse().normalize()))))) != null) {
                    kel2.removeEid(entryId);
                    if (kel2.size() == 0) {
                        substrAI.remove(kel2);
                    }
                }
                oldvals.removeElement(aVal);
            }
            if (oldvals != null && oldvals.size() != 0 || (kel3 = (KeyEidList)this.itPres.get(attr)) == null) continue;
            kel3.removeEid(entryId);
        }
    }

    private byte[] getUTFBytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            return str.getBytes();
        }
    }
}

