/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.backend.standard;

import com.octetstring.vde.backend.standard.KeyPool;
import java.io.UnsupportedEncodingException;

public class KeyPtr
implements Comparable {
    public int first = 0;
    public int last = 0;
    public int hashCode = 0;
    public byte[] myKey = null;

    public KeyPtr(int first, int last) {
        this.first = first;
        this.last = last;
        int len = last - first;
        KeyPool kp = KeyPool.getInstance();
        int hc = 0;
        for (int byteNo = 0; byteNo < len; ++byteNo) {
            hc += kp.charAt(byteNo) * 31 ^ len - byteNo + 1;
        }
        this.hashCode = hc;
    }

    public KeyPtr(byte[] key) {
        this.myKey = key;
        int hc = 0;
        for (int byteNo = 0; byteNo < key.length; ++byteNo) {
            hc += key[byteNo] * 31 ^ key.length - byteNo + 1;
        }
        this.hashCode = hc;
        this.first = -1;
    }

    public int compareTo(KeyPtr key) {
        if (this.first == -1 && key.first == -1) {
            int len = this.myKey.length;
            int klen = key.myKey.length;
            int diff = 0;
            for (int i = 0; i < klen && i < len; ++i) {
                diff = this.myKey[i] - key.myKey[i];
                if (diff == 0) continue;
                if (diff > 0) {
                    // empty if block
                }
                return diff;
            }
            if (len == klen) {
                return 0;
            }
            if (len > klen) {
                return 1;
            }
            return -1;
        }
        int len = this.first != -1 ? this.last - this.first : this.myKey.length;
        int klen = key.first != -1 ? key.last - key.first : key.myKey.length;
        KeyPool kp = KeyPool.getInstance();
        int diff = 0;
        byte nc1 = 0;
        byte nc2 = 0;
        for (int i = 0; i < klen && i < len; ++i) {
            nc1 = this.first == -1 ? this.myKey[i] : kp.charAt(this.first + i);
            diff = nc1 - (nc2 = key.first == -1 ? key.myKey[i] : kp.charAt(key.first + i));
            if (diff == 0) continue;
            if (diff > 0) {
                // empty if block
            }
            return diff;
        }
        if (len == klen) {
            return 0;
        }
        if (len > klen) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object obj) {
        if (obj instanceof byte[]) {
            return this.compareTo((byte[])obj);
        }
        return this.compareTo((KeyPtr)obj);
    }

    public int compareTo(byte[] key) {
        if (this.first == -1) {
            int len = this.myKey.length;
            int klen = key.length;
            int diff = 0;
            for (int i = 0; i < klen && i < len; ++i) {
                diff = this.myKey[i] - key[i];
                if (diff == 0) continue;
                if (diff > 0) {
                    // empty if block
                }
                return diff;
            }
            if (len == klen) {
                return 0;
            }
            if (len > klen) {
                return 1;
            }
            return -1;
        }
        int len = this.last - this.first;
        int klen = key.length;
        KeyPool kp = KeyPool.getInstance();
        int diff = 0;
        for (int i = 0; i < klen && i < len; ++i) {
            diff = kp.charAt(this.first + i) - key[i];
            if (diff == 0) continue;
            if (diff > 0) {
                // empty if block
            }
            return diff;
        }
        if (len == klen) {
            return 0;
        }
        if (len > klen) {
            return 1;
        }
        return -1;
    }

    public boolean endsWith(byte[] suffix) {
        if (this.first == -1) {
            if (this.myKey.length < suffix.length) {
                return false;
            }
            for (int i = 0; i < suffix.length; ++i) {
                if (this.myKey[this.myKey.length - i - 1] == suffix[suffix.length - i - 1]) continue;
                return false;
            }
            return true;
        }
        int len = this.last - this.first;
        int slen = suffix.length;
        if (len < slen) {
            return false;
        }
        KeyPool kp = KeyPool.getInstance();
        for (int i = 0; i < slen; ++i) {
            if (kp.charAt(this.last - i - 1) == suffix[slen - i - 1]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(KeyPtr key) {
        int klen;
        if (this.hashCode != key.hashCode()) {
            return false;
        }
        if (this.first != -1 && key.first != -1) {
            return this.first == key.first && this.last == key.last;
        }
        if (this.first == -1 && key.first == -1) {
            if (this.myKey.length != key.myKey.length) {
                return false;
            }
            for (int i = 0; i < this.myKey.length; ++i) {
                if (this.myKey[i] == key.myKey[i]) continue;
                return false;
            }
            return true;
        }
        int len = this.first == -1 ? this.myKey.length : this.last - this.first;
        if (len != (klen = key.first == -1 ? key.myKey.length : key.last - key.first)) {
            return false;
        }
        if (this.first != -1) {
            KeyPool kp = KeyPool.getInstance();
            for (int i = 0; i < len; ++i) {
                if (kp.charAt(i + this.first) == key.myKey[i]) continue;
                return false;
            }
            return true;
        }
        KeyPool kp = KeyPool.getInstance();
        for (int i = 0; i < len; ++i) {
            if (this.myKey[i] == kp.charAt(key.first + i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof byte[]) {
            return this.equals((byte[])obj);
        }
        return this.equals((KeyPtr)obj);
    }

    public boolean equals(byte[] key) {
        if (this.first == -1) {
            if (this.myKey.length != key.length) {
                return false;
            }
            for (int i = 0; i < key.length; ++i) {
                if (this.myKey[i] == key[i]) continue;
                return false;
            }
            return true;
        }
        int len = this.last - this.first;
        int klen = key.length;
        if (len != klen) {
            return false;
        }
        KeyPool kp = KeyPool.getInstance();
        for (int i = 0; i < len; ++i) {
            if (kp.charAt(i + this.first) == key[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean startsWith(byte[] prefix) {
        if (this.first == -1) {
            if (this.myKey.length < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (this.myKey[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }
        int len = this.last - this.first;
        if (len < prefix.length) {
            return false;
        }
        KeyPool kp = KeyPool.getInstance();
        for (int i = 0; i < prefix.length; ++i) {
            if (kp.charAt(this.first + i) == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.first != -1) {
            return KeyPool.getInstance().getString(this.first, this.last);
        }
        try {
            return new String(this.myKey, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(this.myKey);
        }
    }

    public byte[] toByteArray() {
        if (this.first != -1) {
            return KeyPool.getInstance().getBytes(this.first, this.last);
        }
        return this.myKey;
    }
}

