/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.backend.standard;

import com.octetstring.nls.Messages;
import com.octetstring.vde.Entry;
import com.octetstring.vde.backend.standard.DataFile;
import com.octetstring.vde.backend.standard.TransactionLog;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TransactionProcessor
extends Thread {
    private RandomAccessFile tranfile = null;
    private RandomAccessFile posfile = null;
    private DataFile dataFile = null;
    private TransactionLog tlog = null;
    private long tlogsize = 1000000L;
    private String fileName = null;
    private static final String TRANFILE_NAME = ".tran";
    private static final String POSFILE_NAME = ".trpos";
    private static final int CHANGE_ADD = 1;
    private static final int CHANGE_MOD = 2;
    private static final int CHANGE_DEL = 3;
    private static final int CHANGE_REN = 4;
    private boolean moreTransactions = true;

    public TransactionProcessor(DataFile dataFile, String fileName, TransactionLog tlog, long tlogsize) {
        super("VDE Transaction Processor Thread");
        this.setPriority(2);
        this.dataFile = dataFile;
        this.tlog = tlog;
        this.tlogsize = tlogsize;
        this.fileName = fileName;
        this.open();
    }

    public void setTLogSize(long tlogsize) {
        this.tlogsize = tlogsize;
    }

    public int transactionCount() {
        long pos = 0L;
        int count = 0;
        try {
            if (this.posfile.length() > 0L) {
                pos = this.posfile.readLong();
            }
            this.tranfile.seek(pos);
        }
        catch (IOException ioe) {
            Logger.getInstance().printStackTrace(ioe);
            return 0;
        }
        int numneg = 0;
        boolean optype = true;
        int j = 0;
        byte[] ctbytes = new byte[4096];
        int mylen = 0;
        try {
            while ((mylen = this.tranfile.read(ctbytes)) > 0) {
                for (j = 0; j < mylen; ++j) {
                    if (optype) {
                        if (ctbytes[j] == 1) {
                            ++count;
                        }
                        optype = false;
                        continue;
                    }
                    if (ctbytes[j] == -1) {
                        if (++numneg != 4) continue;
                        optype = true;
                        numneg = 0;
                        continue;
                    }
                    numneg = 0;
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return count;
    }

    private void close() {
        try {
            if (this.tranfile != null) {
                this.tranfile.close();
                this.tranfile = null;
            }
        }
        catch (IOException ioe) {
            Logger.getInstance().printStackTrace(ioe);
        }
        try {
            if (this.posfile != null) {
                this.posfile.close();
                this.posfile = null;
            }
        }
        catch (IOException ioe) {
            Logger.getInstance().printStackTrace(ioe);
        }
    }

    protected void finalize() {
        this.close();
    }

    public synchronized void noteChange() {
        this.notify();
    }

    public boolean isMoreTransactions() {
        return this.moreTransactions;
    }

    private void open() {
        try {
            this.tranfile = new RandomAccessFile(this.fileName + TRANFILE_NAME, "rw");
            this.posfile = new RandomAccessFile(this.fileName + POSFILE_NAME, "rw");
        }
        catch (FileNotFoundException fnfe) {
            Logger.getInstance().printStackTrace(fnfe);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            pos = 0L;
            try {
                if (this.posfile.length() > 0L) {
                    this.posfile.seek(0L);
                    pos = this.posfile.readLong();
                }
                this.tranfile.seek(pos);
            }
            catch (IOException ioe) {
                Logger.getInstance().printStackTrace(ioe);
            }
            ctbyte = new byte[1];
            changeType = 0;
            startPos = 0L;
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        if (this.tlogsize != -1L && pos >= this.tlogsize) {
                            this.close();
                            this.tlog.truncate(pos);
                            this.open();
                            pos = 0L;
                            this.writePos(pos);
                        }
                        if (pos + 1L >= this.tlog.getWritepos()) {
                            if (this.tlogsize == -1L) {
                                this.close();
                                this.tlog.truncate(pos);
                                this.open();
                                pos = 0L;
                                this.writePos(pos);
                            }
                            this.waitChange();
                        }
                        this.moreTransactions = true;
                        startPos = pos++;
                        this.tranfile.seek(startPos);
                        this.tranfile.readFully(ctbyte, 0, 1);
                        changeType = ctbyte[0];
                        if (changeType == 1 || changeType == 2) {
                            while (pos + 4L > this.tlog.getWritepos()) {
                                this.waitwrite();
                            }
                            entLength = this.tranfile.readInt();
                            entbytes = new byte[entLength];
                            while (pos + (long)entLength + 8L > this.tlog.getWritepos()) {
                                this.waitwrite();
                            }
                            this.tranfile.readFully(entbytes, 0, entLength);
                            endbytes = new byte[4];
                            this.tranfile.readFully(endbytes, 0, 4);
                            pos = pos + (long)entLength + 8L;
                            ent = new Entry(entbytes);
                            if (endbytes[0] == -1 && endbytes[1] == -1 && endbytes[2] == -1 && endbytes[3] == -1) {
                                if (changeType == 1) {
                                    this.dataFile.addEntry(ent);
                                } else if (changeType == 2) {
                                    this.dataFile.modifyEntry(ent);
                                }
                                this.writePos(pos);
                                Logger.getInstance().log(7, this, Messages.getString("Parsed_Transaction/Wrote_to_DataFile._5"));
                                continue;
                            }
                            pos = this.tlog.getWritepos();
                            Logger.getInstance().log(0, this, Messages.getString("Corrupt_Transaction_@__6") + pos);
                            continue;
                        }
                        if (changeType == 3) {
                            while (pos + 8L > this.tlog.getWritepos()) {
                                this.waitwrite();
                            }
                            deleteId = this.tranfile.readInt();
                            endbytes = new byte[4];
                            this.tranfile.readFully(endbytes, 0, 4);
                            pos += 8L;
                            if (endbytes[0] == -1 && endbytes[1] == -1 && endbytes[2] == -1 && endbytes[3] == -1) {
                                this.dataFile.deleteEntry(deleteId);
                                this.writePos(pos);
                                Logger.getInstance().log(7, this, Messages.getString("Parsed_Transaction/Wrote_7") + Messages.getString("_to_DataFile._8"));
                            } else {
                                pos = this.tlog.getWritepos();
                                Logger.getInstance().log(0, this, Messages.getString("Corrupt_Transaction_@__9") + pos);
                            }
                        }
                        if (changeType != 4) continue;
                        while (pos + 8L > this.tlog.getWritepos()) {
                            this.waitwrite();
                        }
                        renameId = this.tranfile.readInt();
                        newnamelen = this.tranfile.readInt();
                        while (pos + 4L + (long)newnamelen > this.tlog.getWritepos()) {
                            this.waitwrite();
                        }
                        newname = new byte[newnamelen];
                        this.tranfile.readFully(newname, 0, newnamelen);
                        endbytes = new byte[4];
                        this.tranfile.readFully(endbytes, 0, 4);
                        pos = pos + 12L + (long)newnamelen;
                        if (endbytes[0] == -1 && endbytes[1] == -1 && endbytes[2] == -1 && endbytes[3] == -1) {
                            this.dataFile.renameEntry(renameId, new DirectoryString(newname));
                            this.writePos(pos);
                            Logger.getInstance().log(7, this, Messages.getString("Parsed_Transaction/Wrote_to_DataFile._10"));
                            continue;
                        }
                        pos = this.tlog.getWritepos();
                        Logger.getInstance().log(0, this, Messages.getString("Corrupt_Transaction_@__11") + pos);
                    }
                }
                catch (IOException ioe) {
                    pos = this.tlog.getWritepos();
                    this.waitChange();
                }
                catch (Exception e) {
                    pos = this.tlog.getWritepos();
                    Logger.getInstance().printStackTrace(e);
                    Logger.getInstance().log(0, this, Messages.getString("Corrupt_Transaction_@__6") + pos + " " + e);
                    this.waitChange();
                    continue;
                }
                break;
            }
        }
        catch (Throwable var11_17) {
            this.moreTransactions = false;
            this.noteChange();
            throw var11_17;
        }
        ** GOTO lbl-1000
    }

    public void shutdown() {
        this.waitTransactionsCompleted();
        this.close();
    }

    public synchronized void waitTransactionsCompleted() {
        while (this.moreTransactions) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void waitChange() {
        this.moreTransactions = false;
        this.notifyAll();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            Logger.getInstance().printStackTrace(ie);
        }
    }

    private synchronized void waitwrite() {
        try {
            this.wait(100L);
        }
        catch (InterruptedException ie) {
            Logger.getInstance().printStackTrace(ie);
        }
    }

    private void writePos(long pos) {
        try {
            this.posfile.seek(0L);
            this.posfile.writeLong(pos);
        }
        catch (IOException ioe) {
            Logger.getInstance().printStackTrace(ioe);
        }
    }
}

