/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.operation;

import com.asn1c.core.OctetString;
import com.octetstring.ldapv3.AddResponse;
import com.octetstring.ldapv3.AttributeList;
import com.octetstring.ldapv3.AttributeList_Seq;
import com.octetstring.ldapv3.LDAPMessage;
import com.octetstring.ldapv3.LDAPMessage_protocolOp;
import com.octetstring.ldapv3.LDAPURL;
import com.octetstring.ldapv3.Referral;
import com.octetstring.vde.Credentials;
import com.octetstring.vde.Entry;
import com.octetstring.vde.backend.BackendHandler;
import com.octetstring.vde.operation.LDAPResult;
import com.octetstring.vde.operation.Operation;
import com.octetstring.vde.replication.Consumer;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DirectorySchemaViolation;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.UnixCrypt;
import java.util.Iterator;
import java.util.Vector;

public class AddOperation
implements Operation {
    LDAPMessage request = null;
    LDAPMessage response = null;
    Credentials creds = null;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Referral EMPTY_REFERRAL = new Referral();
    private static final OctetString EMPTY_OSTRING = new OctetString();
    private static final DirectoryString USERPASSWORD = new DirectoryString("userPassword");
    static /* synthetic */ Class class$com$octetstring$vde$syntax$DirectoryString;

    public AddOperation(Credentials creds, LDAPMessage request) {
        this.request = request;
        this.creds = creds;
    }

    public LDAPMessage getResponse() {
        return this.response;
    }

    public void perform() {
        AddResponse addResponse;
        block6: {
            this.response = new LDAPMessage();
            addResponse = new AddResponse();
            addResponse.setMatchedDN(EMPTY_OSTRING);
            addResponse.setErrorMessage(EMPTY_OSTRING);
            try {
                Entry newEntry = this.requestToEntry();
                Consumer con = BackendHandler.getInstance().getReplica(newEntry.getName());
                if (con != null && !this.creds.getUser().equals(con.getBinddn())) {
                    addResponse.setResultCode(LDAPResult.REFERRAL);
                    Referral myref = new Referral();
                    myref.addElement(new LDAPURL(new OctetString(con.getMasterURL().getBytes())));
                    addResponse.setReferral(myref);
                } else {
                    boolean oldisroot = this.creds.isRoot();
                    if (con != null) {
                        this.creds.setRoot(true);
                    }
                    addResponse.setResultCode(BackendHandler.getInstance().add(this.creds, newEntry));
                    this.creds.setRoot(oldisroot);
                }
            }
            catch (DirectorySchemaViolation dsv) {
                addResponse.setResultCode(LDAPResult.OBJECT_CLASS_VIOLATION);
                addResponse.setErrorMessage(new OctetString(dsv.getMessage().getBytes()));
            }
            catch (InvalidDNException ide) {
                addResponse.setResultCode(LDAPResult.INVALID_DN_SYNTAX);
                if (ide.getMessage() == null) break block6;
                addResponse.setErrorMessage(new OctetString(ide.getMessage().getBytes()));
            }
        }
        LDAPMessage_protocolOp op = new LDAPMessage_protocolOp();
        op.setAddResponse(addResponse);
        this.response.setMessageID(this.request.getMessageID());
        this.response.setProtocolOp(op);
    }

    public Entry requestToEntry() throws InvalidDNException {
        Entry entry = new Entry(new DirectoryString(this.request.getProtocolOp().getAddRequest().getEntry().toByteArray()));
        AttributeList attrList = this.request.getProtocolOp().getAddRequest().getAttributes();
        Iterator enumAttr = attrList.iterator();
        while (enumAttr.hasNext()) {
            AttributeList_Seq als = (AttributeList_Seq)enumAttr.next();
            if (als.getType() == null) continue;
            DirectoryString type = new DirectoryString(als.getType().toByteArray());
            AttributeType at = SchemaChecker.getInstance().getAttributeType(type);
            Class valClass = null;
            valClass = at != null ? at.getSyntaxClass() : (class$com$octetstring$vde$syntax$DirectoryString == null ? AddOperation.class$("com.octetstring.vde.syntax.DirectoryString") : class$com$octetstring$vde$syntax$DirectoryString);
            Vector<Syntax> values = new Vector<Syntax>();
            Iterator enumVal = als.getVals().iterator();
            while (enumVal.hasNext()) {
                byte[] thisVal = ((OctetString)enumVal.next()).toByteArray();
                if (thisVal.length <= 0) continue;
                try {
                    Syntax synVal = (Syntax)valClass.newInstance();
                    synVal.setValue(thisVal);
                    values.addElement(synVal);
                }
                catch (InstantiationException ie) {
                    Logger.getInstance().printStackTrace(ie);
                }
                catch (IllegalAccessException iae) {
                    Logger.getInstance().printStackTrace(iae);
                }
            }
            if (values.size() <= 0) continue;
            entry.put(type, values, false);
        }
        return entry;
    }

    private byte[] transform(DirectoryString type, byte[] value) {
        if (type.equals(USERPASSWORD)) {
            return ("{crypt}" + UnixCrypt.crypt(new String(value))).getBytes();
        }
        return value;
    }
}

