/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.operation;

import com.asn1c.codec.DataDecoder;
import com.asn1c.codec.DataEncoder;
import com.asn1c.core.BitString;
import com.octetstring.ldapv3.controls.ASN1BERDecoder;
import com.octetstring.ldapv3.controls.ASN1BEREncoder;
import com.octetstring.ldapv3.controls.ASN1Decoder;
import com.octetstring.ldapv3.controls.ASN1Encoder;
import com.octetstring.ldapv3.controls.EntryChangeNotification;
import com.octetstring.ldapv3.controls.PersistentSearch;
import com.octetstring.ldapv3.controls.SortKeyList;
import com.octetstring.ldapv3.controls.SortResult;
import com.octetstring.ldapv3.controls.VLVControlValue;

public class ControlHandler {
    private ASN1Encoder berEncoder = null;
    ASN1Decoder berDecoder = null;
    private DataEncoder de = new DataEncoder();
    private DataDecoder dd = new DataDecoder();
    private int number = 0;
    private static ControlHandler instance = null;

    private ControlHandler() {
        this.berEncoder = new ASN1BEREncoder(this.de);
        this.berDecoder = new ASN1BERDecoder(this.dd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControlHandler getInstance() {
        ControlHandler controlHandler = instance;
        synchronized (controlHandler) {
            if (instance == null) {
                instance = new ControlHandler();
            }
        }
        return instance;
    }

    public ASN1Decoder getBERDecoder() {
        return this.berDecoder;
    }

    public ASN1Encoder getBEREncoder() {
        return this.berEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentSearch getPersistentSearch(byte[] val) throws Exception {
        DataDecoder dataDecoder = this.dd;
        synchronized (dataDecoder) {
            this.dd.setEncodedData(new BitString(val));
            return this.getBERDecoder().readPersistentSearch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPersistentSearchBytes(PersistentSearch ps) throws Exception {
        DataEncoder dataEncoder = this.de;
        synchronized (dataEncoder) {
            this.getBEREncoder().writePersistentSearch(ps);
            return this.de.getAndClearEncodedData().toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryChangeNotification getEntryChangeNotification(byte[] val) throws Exception {
        DataDecoder dataDecoder = this.dd;
        synchronized (dataDecoder) {
            this.dd.setEncodedData(new BitString(val));
            return this.getBERDecoder().readEntryChangeNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEntryChangeNotificationBytes(EntryChangeNotification ecn) throws Exception {
        DataEncoder dataEncoder = this.de;
        synchronized (dataEncoder) {
            this.getBEREncoder().writeEntryChangeNotification(ecn);
            return this.de.getAndClearEncodedData().toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortKeyList getSortKeyList(byte[] val) throws Exception {
        DataDecoder dataDecoder = this.dd;
        synchronized (dataDecoder) {
            this.dd.setEncodedData(new BitString(val));
            return this.getBERDecoder().readSortKeyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSortKeyListBytes(SortKeyList skl) throws Exception {
        DataEncoder dataEncoder = this.de;
        synchronized (dataEncoder) {
            this.getBEREncoder().writeSortKeyList(skl);
            return this.de.getAndClearEncodedData().toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortResult getSortResult(byte[] val) throws Exception {
        DataDecoder dataDecoder = this.dd;
        synchronized (dataDecoder) {
            this.dd.setEncodedData(new BitString(val));
            return this.getBERDecoder().readSortResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSortResultBytes(SortResult sr) throws Exception {
        DataEncoder dataEncoder = this.de;
        synchronized (dataEncoder) {
            this.getBEREncoder().writeSortResult(sr);
            return this.de.getAndClearEncodedData().toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VLVControlValue getVLVControlValue(byte[] val) throws Exception {
        DataDecoder dataDecoder = this.dd;
        synchronized (dataDecoder) {
            this.dd.setEncodedData(new BitString(val));
            return this.getBERDecoder().readVLVControlValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getVLVControlValueBytes(VLVControlValue vlvcv) throws Exception {
        DataEncoder dataEncoder = this.de;
        synchronized (dataEncoder) {
            this.getBEREncoder().writeVLVControlValue(vlvcv);
            return this.de.getAndClearEncodedData().toByteArray();
        }
    }
}

