/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.operation;

import com.asn1c.core.Int8;
import com.asn1c.core.OctetString;
import com.octetstring.ldapv3.AttributeValue;
import com.octetstring.ldapv3.Filter;
import com.octetstring.ldapv3.LDAPMessage;
import com.octetstring.ldapv3.LDAPMessage_protocolOp;
import com.octetstring.ldapv3.PartialAttributeList;
import com.octetstring.ldapv3.PartialAttributeList_Seq;
import com.octetstring.ldapv3.PartialAttributeList_Seq_vals;
import com.octetstring.ldapv3.SearchResultDone;
import com.octetstring.ldapv3.SearchResultEntry;
import com.octetstring.vde.Attribute;
import com.octetstring.vde.Credentials;
import com.octetstring.vde.Entry;
import com.octetstring.vde.EntrySet;
import com.octetstring.vde.backend.BackendHandler;
import com.octetstring.vde.operation.LDAPResult;
import com.octetstring.vde.operation.Operation;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DNUtility;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.ServerConfig;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class SearchOperation
implements Operation {
    LDAPMessage request = null;
    LDAPMessage response = null;
    Credentials creds = null;
    boolean more = true;
    Vector entries = null;
    DirectoryString base = null;
    int nextEntry = 0;
    Enumeration backEnum;
    Vector attributes;
    boolean typesOnly;
    EntrySet currentEntrySet = null;
    static int anonsearchlimit = -1;
    static int authsearchlimit = -1;
    int entrycount = 0;
    int mysearchlimit = 0;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final OctetString EMPTY_OSTRING = new OctetString();
    private static final DirectoryString EMPTY_DS = new DirectoryString("");
    private static final DirectoryString AT_ENTRYLDAPACI = new DirectoryString("entryACI");
    private static final DirectoryString AT_SUBTREELDAPACI = new DirectoryString("subtreeACI");
    private static final DirectoryString SEMICOLON = new DirectoryString(";");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchOperation(Credentials creds, LDAPMessage request) {
        this.request = request;
        this.creds = creds;
        if (anonsearchlimit == -1) {
            SearchOperation searchOperation = this;
            synchronized (searchOperation) {
                String stranonsl = (String)ServerConfig.getInstance().get("vde.searchlimit.anon");
                anonsearchlimit = stranonsl == null ? 100 : new Integer(stranonsl);
                String strauthsl = (String)ServerConfig.getInstance().get("vde.searchlimit.auth");
                authsearchlimit = strauthsl == null ? 1000 : new Integer(strauthsl);
            }
        }
        this.mysearchlimit = creds.isRoot() ? 0 : (!creds.getUser().equals(EMPTY_DS) ? authsearchlimit : anonsearchlimit);
    }

    public boolean isMore() {
        return this.more;
    }

    public LDAPMessage getResponse() {
        return this.response;
    }

    private PartialAttributeList attributeListFromEntry(Entry entry, boolean returnValues, Vector attrs) {
        PartialAttributeList pal = new PartialAttributeList();
        PartialAttributeList_Seq pals = null;
        Attribute curAttr = null;
        Object values = null;
        Syntax curval = null;
        Vector attributes = entry.getAttributes();
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            curAttr = (Attribute)attributes.elementAt(i);
            pals = new PartialAttributeList_Seq();
            if (this.creds.isLdap2()) {
                if (curAttr.type.indexOf(SEMICOLON) < 0) {
                    pals.setType(new OctetString(curAttr.type.getBytes()));
                } else {
                    pals.setType(new OctetString(curAttr.type.substring(0, curAttr.type.indexOf(SEMICOLON)).getBytes()));
                }
            }
            pals.setType(new OctetString(curAttr.type.getBytes()));
            PartialAttributeList_Seq_vals palsv = new PartialAttributeList_Seq_vals();
            pals.setVals(palsv);
            if (!returnValues) {
                int vsize = curAttr.values.size();
                for (int j = 0; j < vsize; ++j) {
                    curval = (Syntax)curAttr.values.elementAt(j);
                    if (curval == null) continue;
                    palsv.addElement(new AttributeValue(new OctetString(curval.getValue())));
                }
            }
            pal.addElement(pals);
        }
        return pal;
    }

    public void perform() {
        SearchResultDone srd;
        this.response = new LDAPMessage();
        LDAPMessage_protocolOp op = new LDAPMessage_protocolOp();
        this.response.setMessageID(this.request.getMessageID());
        if (this.entries == null) {
            try {
                this.base = DNUtility.getInstance().normalize(new DirectoryString(this.request.getProtocolOp().getSearchRequest().getBaseObject().toByteArray()));
            }
            catch (InvalidDNException ide) {
                SearchResultDone srd2 = new SearchResultDone();
                srd2.setResultCode(new Int8((byte)ide.getLDAPErrorCode()));
                srd2.setMatchedDN(EMPTY_OSTRING);
                if (ide.getMessage() != null) {
                    srd2.setErrorMessage(new OctetString(ide.getMessage().getBytes()));
                } else {
                    srd2.setErrorMessage(EMPTY_OSTRING);
                }
                op.setSearchResDone(srd2);
                this.response.setProtocolOp(op);
                this.more = false;
                return;
            }
            int scope = this.request.getProtocolOp().getSearchRequest().getScope().intValue();
            Filter filter = this.request.getProtocolOp().getSearchRequest().getFilter();
            this.typesOnly = this.request.getProtocolOp().getSearchRequest().getTypesOnly().booleanValue();
            this.attributes = new Vector();
            Iterator enumAttrs = this.request.getProtocolOp().getSearchRequest().getAttributes().iterator();
            while (enumAttrs.hasNext()) {
                byte[] anAttr = ((OctetString)enumAttrs.next()).toByteArray();
                if (anAttr.length <= 0) continue;
                DirectoryString oneAttr = new DirectoryString(anAttr);
                this.attributes.addElement(oneAttr);
            }
            try {
                if (this.creds == null) {
                    this.creds = new Credentials();
                }
                this.entries = BackendHandler.getInstance().get(this.creds.getUser(), this.base, scope, filter, this.typesOnly, this.attributes);
            }
            catch (DirectoryException de) {
                srd = new SearchResultDone();
                srd.setResultCode(new Int8((byte)de.getLDAPErrorCode()));
                srd.setMatchedDN(EMPTY_OSTRING);
                if (de.getMessage() != null) {
                    srd.setErrorMessage(new OctetString(de.getMessage().getBytes()));
                } else {
                    srd.setErrorMessage(EMPTY_OSTRING);
                }
                op.setSearchResDone(srd);
                this.response.setProtocolOp(op);
                this.more = false;
                return;
            }
        }
        if (this.backEnum == null) {
            this.backEnum = this.entries.elements();
            if (this.backEnum.hasMoreElements()) {
                this.currentEntrySet = (EntrySet)this.backEnum.nextElement();
            }
            this.nextEntry = 0;
        }
        boolean canProvideResult = false;
        while (!canProvideResult) {
            SearchResultDone srd3;
            if (this.currentEntrySet == null || !this.currentEntrySet.hasMore() && !this.backEnum.hasMoreElements()) {
                srd3 = new SearchResultDone();
                srd3.setResultCode(LDAPResult.SUCCESS);
                srd3.setMatchedDN(EMPTY_OSTRING);
                srd3.setErrorMessage(EMPTY_OSTRING);
                op.setSearchResDone(srd3);
                this.response.setProtocolOp(op);
                this.more = false;
                return;
            }
            if (this.mysearchlimit != 0 && this.entrycount >= this.mysearchlimit) {
                srd3 = new SearchResultDone();
                srd3.setResultCode(LDAPResult.SIZE_LIMIT_EXCEEDED);
                srd3.setMatchedDN(EMPTY_OSTRING);
                srd3.setErrorMessage(EMPTY_OSTRING);
                op.setSearchResDone(srd3);
                this.response.setProtocolOp(op);
                this.more = false;
                return;
            }
            if (!this.currentEntrySet.hasMore()) {
                this.currentEntrySet = (EntrySet)this.backEnum.nextElement();
                this.nextEntry = 0;
            }
            Entry currentEntry = null;
            try {
                currentEntry = this.currentEntrySet.getNext();
                if (currentEntry == null) {
                    if (this.backEnum.hasMoreElements()) {
                        this.currentEntrySet = (EntrySet)this.backEnum.nextElement();
                        this.nextEntry = 0;
                    } else {
                        this.currentEntrySet = null;
                    }
                }
            }
            catch (DirectoryException de) {
                srd = new SearchResultDone();
                srd.setResultCode(new Int8((byte)de.getLDAPErrorCode()));
                srd.setMatchedDN(EMPTY_OSTRING);
                srd.setErrorMessage(EMPTY_OSTRING);
                op.setSearchResDone(srd);
                this.response.setProtocolOp(op);
                this.more = false;
                return;
            }
            if (currentEntry != null && (currentEntry = BackendHandler.getInstance().postSearch(this.creds, currentEntry, this.attributes, this.request.getProtocolOp().getSearchRequest().getFilter(), this.request.getProtocolOp().getSearchRequest().getScope().intValue(), this.base)) != null) {
                ++this.entrycount;
                SearchResultEntry sre = new SearchResultEntry();
                sre.setObjectName(new OctetString(currentEntry.getName().getBytes()));
                sre.setAttributes(this.attributeListFromEntry(currentEntry, this.typesOnly, this.attributes));
                op.setSearchResEntry(sre);
                this.response.setProtocolOp(op);
                ++this.nextEntry;
                return;
            }
            ++this.nextEntry;
        }
    }
}

