/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.replication;

import com.octetstring.ldapv3.Filter;
import com.octetstring.nls.Messages;
import com.octetstring.vde.Entry;
import com.octetstring.vde.EntryChange;
import com.octetstring.vde.EntryChanges;
import com.octetstring.vde.EntryChangesListener;
import com.octetstring.vde.EntrySet;
import com.octetstring.vde.backend.BaseBackend;
import com.octetstring.vde.backend.GenericEntrySet;
import com.octetstring.vde.replication.ChangeLogWriter;
import com.octetstring.vde.replication.Replication;
import com.octetstring.vde.syntax.BinarySyntax;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.IntegerSyntax;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ServerConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class BackendChangeLog
extends BaseBackend
implements EntryChangesListener {
    DirectoryString eclBase = null;
    Vector changesVector = null;
    private String changeFileName = null;
    private String suffix = null;
    private ChangeLogWriter clw = null;
    private volatile int changeLow = 0;
    private volatile int changeHigh = -1;
    private volatile int lowKeep = 0;
    private int changeLogThreshold = 5000;
    private RandomAccessFile indexFile = null;
    private RandomAccessFile changeFile = null;
    private static final String CONFIG_SUFFIX = "suffix";
    private Replication replicationThread = null;

    public BackendChangeLog(Hashtable config, Replication replication) {
        super(config);
        this.suffix = ((DirectoryString)config.get(CONFIG_SUFFIX)).toString();
        this.replicationThread = replication;
        this.changeLogThreshold = Integer.getInteger("weblogic.security.ldap.changeLogThreshold", 5000);
        Logger.getInstance().log(7, this, Messages.getString("Changelog_threshold_6") + this.changeLogThreshold);
        this.changesVector = new Vector();
        this.eclBase = new DirectoryString("");
        String propName = (String)ServerConfig.getInstance().get("vde.changelog.file");
        String ihome = System.getProperty("vde.home");
        this.changeFileName = ihome == null ? propName : ihome + "/" + propName;
        this.clw = new ChangeLogWriter(this.changeFileName);
        this.changeHigh = this.clw.getHighChange();
        this.changeLow = this.clw.getLowChange();
        this.open();
    }

    private synchronized void truncate() {
        if (this.changeLow + this.changeLogThreshold >= this.lowKeep) {
            Logger.getInstance().log(7, this, Messages.getString("Changelog_threshold_7") + this.lowKeep);
            return;
        }
        Logger.getInstance().log(5, this, Messages.getString("Truncating_Changelog_5"));
        Logger.getInstance().log(7, this, Messages.getString("Changelog_threshold_8") + this.lowKeep);
        this.clw.setEndWriter();
        while (this.clw.isRunning()) {
            this.wait1sec();
        }
        try {
            File ifNew = new File(this.changeFileName + ".index-n");
            File cfNew = new File(this.changeFileName + ".data-n");
            if (ifNew.exists() || cfNew.exists()) {
                ifNew.delete();
                ifNew = null;
                cfNew.delete();
                cfNew = null;
            }
            RandomAccessFile nif = new RandomAccessFile(this.changeFileName + ".index-n", "rw");
            RandomAccessFile ncf = new RandomAccessFile(this.changeFileName + ".data-n", "rw");
            nif.seek(0L);
            nif.writeInt(this.lowKeep + 1);
            nif.writeLong(1L);
            if (this.changeHigh > this.lowKeep) {
                this.indexFile.seek(0L);
                int oldLowKeep = this.indexFile.readInt();
                long baseloc = 0L;
                this.indexFile.seek((this.lowKeep - oldLowKeep + 2) * 12);
                baseloc = this.indexFile.readLong();
                this.indexFile.seek((this.lowKeep - oldLowKeep + 2) * 12);
                for (int i = this.lowKeep + 1; i <= this.changeHigh; ++i) {
                    nif.writeLong(this.indexFile.readLong() - baseloc);
                    nif.writeInt(this.indexFile.readInt());
                }
                this.changeFile.seek(baseloc);
                ncf.seek(0L);
                byte[] buf = new byte[10000];
                int len = 0;
                while ((len = this.changeFile.read(buf)) != -1) {
                    ncf.write(buf, 0, len);
                }
            }
            nif.close();
            ncf.close();
            this.close();
            File newif = new File(this.changeFileName + ".index-n");
            File newcf = new File(this.changeFileName + ".data-n");
            File oldif = new File(this.changeFileName + ".index");
            File oldcf = new File(this.changeFileName + ".data");
            oldif.delete();
            oldcf.delete();
            newif.renameTo(oldif);
            newcf.renameTo(oldcf);
            this.clw = new ChangeLogWriter(this.changeFileName);
            this.changeHigh = this.clw.getHighChange();
            this.changeLow = this.clw.getLowChange();
            this.open();
        }
        catch (IOException ioe) {
            Logger.getInstance().log(0, this, Messages.getString("Error_truncating_change_log___14") + ioe.getMessage());
            this.close();
            this.clw = new ChangeLogWriter(this.changeFileName);
            this.changeHigh = this.clw.getHighChange();
            this.changeLow = this.clw.getLowChange();
            this.open();
        }
    }

    private void open() {
        try {
            this.indexFile = new RandomAccessFile(this.changeFileName + ".index", "r");
            this.changeFile = new RandomAccessFile(this.changeFileName + ".data", "r");
        }
        catch (FileNotFoundException fnfe) {
            Logger.getInstance().log(3, this, Messages.getString("Error_opening_changelog_database___19") + fnfe.getMessage());
        }
    }

    private void close() {
        try {
            if (this.indexFile != null) {
                this.indexFile.close();
                this.indexFile = null;
            }
            if (this.changeFile != null) {
                this.changeFile.close();
                this.changeFile = null;
            }
        }
        catch (IOException ioe) {
            Logger.getInstance().log(0, this, Messages.getString("Error_closing_changelog_database___20") + ioe.getMessage());
        }
    }

    public int getChangeHigh() {
        return this.changeHigh;
    }

    public void setLowKeep(int lowKeep) {
        this.lowKeep = lowKeep;
    }

    public boolean bind(DirectoryString dn, BinarySyntax password) {
        return false;
    }

    public boolean doBind() {
        return false;
    }

    private Vector evaluateFilter(Filter currentFilter, DirectoryString base, int scope) {
        Vector<Integer> matchThisFilter = new Vector<Integer>();
        switch (currentFilter.getSelector()) {
            case 3: {
                int intval;
                String matchType = new String(currentFilter.getEqualityMatch().getAttributeDesc().toByteArray());
                String matchVal = new String(currentFilter.getEqualityMatch().getAssertionValue().toByteArray());
                if (Logger.getInstance().isLogable(7)) {
                    Logger.getInstance().log(7, this, "Filter: " + matchType + "=" + matchVal);
                    Logger.getInstance().log(7, this, "Base: " + base);
                }
                if (matchType.equalsIgnoreCase("changenumber") && (intval = new Integer(matchVal).intValue()) >= this.changeLow && intval <= this.changeHigh) {
                    matchThisFilter.addElement(new Integer(intval));
                }
                if (!matchType.equalsIgnoreCase("objectclass") || !matchVal.equalsIgnoreCase("changeLogEntry")) break;
                for (int i = this.changeLow; i <= this.changeHigh; ++i) {
                    matchThisFilter.addElement(new Integer(i));
                }
                break;
            }
            case 7: {
                String matchType = new String(currentFilter.getPresent().toByteArray());
                if (!matchType.equalsIgnoreCase("changenumber") && !matchType.equalsIgnoreCase("objectclass")) break;
                for (int i = this.changeLow; i <= this.changeHigh; ++i) {
                    matchThisFilter.addElement(new Integer(i));
                }
                break;
            }
            case 5: {
                int assertVal;
                String matchType = new String(currentFilter.getGreaterOrEqual().getAttributeDesc().toByteArray());
                String matchVal = new String(currentFilter.getGreaterOrEqual().getAssertionValue().toByteArray());
                if (!matchType.equalsIgnoreCase("changenumber")) break;
                for (int i = assertVal = new Integer(matchVal).intValue(); i <= this.changeHigh; ++i) {
                    matchThisFilter.addElement(new Integer(i));
                }
                break;
            }
            case 6: {
                String matchType = new String(currentFilter.getLessOrEqual().getAttributeDesc().toByteArray());
                String matchVal = new String(currentFilter.getLessOrEqual().getAssertionValue().toByteArray());
                if (!matchType.equalsIgnoreCase("changenumber")) break;
                int assertVal = new Integer(matchVal);
                for (int i = 0; i <= this.changeHigh && i <= assertVal; ++i) {
                    matchThisFilter.addElement(new Integer(i));
                }
                break;
            }
            case 0: {
                boolean firstAnd = true;
                Iterator andEnum = currentFilter.getAnd().iterator();
                while (andEnum.hasNext()) {
                    Vector matched = this.evaluateFilter((Filter)andEnum.next(), base, scope);
                    if (firstAnd) {
                        firstAnd = false;
                        Enumeration matchEnum = matched.elements();
                        while (matchEnum.hasMoreElements()) {
                            matchThisFilter.addElement((Integer)matchEnum.nextElement());
                        }
                        continue;
                    }
                    Vector inBoth = new Vector();
                    Enumeration matchEnum = matched.elements();
                    while (matchEnum.hasMoreElements()) {
                        Object matchObj = matchEnum.nextElement();
                        if (!matchThisFilter.contains(matchObj)) continue;
                        inBoth.addElement(matchObj);
                    }
                    matchThisFilter = inBoth;
                }
                break;
            }
            case 1: {
                Iterator orEnum = currentFilter.getOr().iterator();
                while (orEnum.hasNext()) {
                    Vector matched = this.evaluateFilter((Filter)orEnum.next(), base, scope);
                    Enumeration matchEnum = matched.elements();
                    while (matchEnum.hasMoreElements()) {
                        matchThisFilter.addElement((Integer)matchEnum.nextElement());
                    }
                }
                break;
            }
        }
        return matchThisFilter;
    }

    public void finalize() {
        this.close();
    }

    public EntrySet get(DirectoryString binddn, DirectoryString base, int scope, Filter filter, boolean attrsOnly, Vector attrs) throws DirectoryException {
        Vector entries = this.evaluateFilter(filter, base, scope);
        return new GenericEntrySet(this, entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry getByID(Integer id) {
        if (this.clw == null) {
            throw new IllegalStateException("BackendChangeLog is closed");
        }
        if (id > this.changeHigh || id < this.changeLow) {
            return null;
        }
        Entry oneChange = null;
        try {
            oneChange = new Entry(new DirectoryString("changeNumber=" + id + "," + this.suffix));
        }
        catch (InvalidDNException idne) {
            // empty catch block
        }
        Vector<DirectoryString> ocVec = new Vector<DirectoryString>();
        ocVec.addElement(new DirectoryString("changeLogEntry"));
        ocVec.addElement(new DirectoryString("top"));
        oneChange.put(new DirectoryString("objectClass"), ocVec);
        Vector<IntegerSyntax> cnumVec = new Vector<IntegerSyntax>();
        cnumVec.addElement(new IntegerSyntax(id));
        oneChange.put(new DirectoryString("changeNumber"), cnumVec);
        EntryChanges ec = null;
        byte[] cbytes = null;
        RandomAccessFile randomAccessFile = this.indexFile;
        synchronized (randomAccessFile) {
            try {
                this.indexFile.seek((id + 1 - this.changeLow) * 12);
                long pos = this.indexFile.readLong();
                int len = this.indexFile.readInt();
                this.changeFile.seek(pos);
                cbytes = new byte[len];
                this.changeFile.readFully(cbytes, 0, len);
            }
            catch (IOException ioe) {
                Logger.getInstance().log(0, this, Messages.getString("Error_reading_changelog_entry#___37") + id);
            }
        }
        ec = new EntryChanges(cbytes);
        DirectoryString dn = null;
        DirectoryString cType = null;
        byte[] changes = null;
        if (ec.getChangeType() == 1) {
            dn = ec.getFullEntry().getName();
            cType = new DirectoryString("add");
            changes = ec.getFullEntry().toLDIF().getBytes();
        } else {
            dn = ec.getName();
            if (ec.getChangeType() == 2) {
                cType = new DirectoryString("modify");
                StringBuffer sb = new StringBuffer();
                EntryChange[] entch = ec.getEntryChanges();
                for (int ce = 0; ce < entch.length; ++ce) {
                    sb.append(entch[ce].toLDIF());
                }
                changes = sb.toString().getBytes();
            } else {
                cType = ec.getChangeType() == 3 ? new DirectoryString("delete") : (ec.getChangeType() == 4 ? new DirectoryString("rename") : new DirectoryString("unknown"));
            }
        }
        Vector<DirectoryString> tdnVec = new Vector<DirectoryString>();
        tdnVec.addElement(dn);
        oneChange.put(new DirectoryString("targetDN"), tdnVec);
        Vector<DirectoryString> ctypeVec = new Vector<DirectoryString>();
        ctypeVec.addElement(cType);
        oneChange.put(new DirectoryString("changeType"), ctypeVec);
        if (changes != null) {
            Vector<BinarySyntax> changesVec = new Vector<BinarySyntax>();
            changesVec.addElement(new BinarySyntax(changes));
            oneChange.put(new DirectoryString("changes"), changesVec);
        }
        return oneChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EntryChanges getChange(int cnum) {
        if (this.clw == null) {
            throw new IllegalStateException("BackendChangeLog is closed");
        }
        Object ec = null;
        byte[] cbytes = null;
        RandomAccessFile randomAccessFile = this.indexFile;
        synchronized (randomAccessFile) {
            try {
                this.indexFile.seek((1 + cnum - this.changeLow) * 12);
                long pos = this.indexFile.readLong();
                int len = this.indexFile.readInt();
                this.changeFile.seek(pos);
                cbytes = new byte[len];
                this.changeFile.readFully(cbytes, 0, len);
            }
            catch (IOException ioe) {
                Logger.getInstance().log(0, this, Messages.getString("Error_reading_changelog_entry#___46") + cnum);
            }
        }
        return new EntryChanges(cbytes);
    }

    public DirectoryString getECLBase() {
        return this.eclBase;
    }

    public synchronized void receiveEntryChanges(EntryChanges entryChanges) {
        if (this.clw == null) {
            throw new IllegalStateException("BackendChangeLog is closed");
        }
        this.truncate();
        this.changeHigh = this.clw.addChange(entryChanges);
        this.replicationThread.wakeUp();
    }

    private synchronized void wait1sec() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void shutdown() {
        if (this.clw != null) {
            this.clw.shutdown();
            this.clw = null;
        }
        this.close();
    }
}

