/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.replication;

import com.octetstring.nls.Messages;
import com.octetstring.vde.backend.BackendHandler;
import com.octetstring.vde.replication.BackendChangeLog;
import com.octetstring.vde.replication.Consumer;
import com.octetstring.vde.replication.Replicator;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.LDIF;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ServerConfig;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.Subject;

public class Replication
extends Thread {
    BackendChangeLog bcl = null;
    Vector agreements = null;
    String replicadataPath = null;
    private boolean reloadConfig = false;
    private Properties reloadOverrideProps;
    private Object lock = new Object();
    private Subject sslSubject = null;
    private boolean running = false;

    public Replication() {
        super("VDE Replication Thread");
    }

    public void init() {
        this.init(null, null);
    }

    public void init(Properties overrideProps, Subject sslSubject) {
        this.sslSubject = sslSubject;
        if (((String)ServerConfig.getInstance().get("vde.changelog")).equals("1")) {
            Hashtable<String, DirectoryString> bclConfig = new Hashtable<String, DirectoryString>();
            DirectoryString suffix = new DirectoryString((String)ServerConfig.getInstance().get("vde.changelog.suffix"));
            bclConfig.put("suffix", suffix);
            this.bcl = new BackendChangeLog(bclConfig, this);
            BackendHandler.getInstance().registerBackend(suffix, this.bcl);
            BackendHandler.getInstance().registerEntryChangesListener(this.bcl);
        }
        this.initAgreements(overrideProps);
        if (this.bcl != null) {
            this.start();
        }
    }

    private void initAgreements(Properties overrideProps) {
        String nag;
        ServerConfig serverConfig = ServerConfig.getInstance();
        String myid = (String)serverConfig.get("vde.server.name");
        String ihome = System.getProperty("vde.home");
        Properties replicaProp = new Properties();
        try {
            String name = (String)serverConfig.get("vde.replicas");
            String fullname = ihome == null ? name : ihome + "/" + name;
            this.replicadataPath = ihome == null ? "replicadata" : ihome + "/replicadata";
            FileInputStream is = new FileInputStream(fullname);
            replicaProp.load(is);
            is.close();
        }
        catch (Exception e) {
            Logger.getInstance().log(0, this, Messages.getString("Error_parsing_Replication_properties._7"));
        }
        if (overrideProps != null) {
            Iterator<Object> it = overrideProps.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                replicaProp.setProperty(key, overrideProps.getProperty(key));
            }
        }
        File rdpf = new File(this.replicadataPath);
        if (this.bcl != null && !rdpf.exists()) {
            rdpf.mkdir();
            Logger.getInstance().log(5, this, Messages.getString("Created_Replica_Data_Directory._8"));
        }
        if ((nag = System.getProperty("replica.num")) == null) {
            nag = (String)replicaProp.get("replica.num");
        }
        int rags = new Integer(nag);
        this.agreements = new Vector();
        for (int raCount = 0; raCount < rags; ++raCount) {
            String configKey;
            String key;
            String replicaKeyPrefix = "replica." + raCount + ".";
            int prefixLen = replicaKeyPrefix.length();
            Enumeration<Object> keys = replicaProp.keys();
            Hashtable<String, Object> raConfig = new Hashtable<String, Object>();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.startsWith(replicaKeyPrefix)) continue;
                configKey = key.substring(prefixLen);
                raConfig.put(configKey, replicaProp.get(key));
            }
            keys = System.getProperties().keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.startsWith(replicaKeyPrefix)) continue;
                configKey = key.substring(prefixLen);
                raConfig.put(configKey, System.getProperty(key));
            }
            BackendHandler.getInstance().clearReplicas();
            Consumer con = new Consumer(raConfig);
            if (con.getMasterID().equals(myid)) {
                try {
                    DataInputStream dis = new DataInputStream(new FileInputStream(this.replicadataPath + "/" + con.getAgreementName() + ".status"));
                    int lastSent = dis.readInt();
                    con.setChangeSent(lastSent);
                    dis.close();
                }
                catch (IOException ioe) {
                    Logger.getInstance().log(3, this, Messages.getString("Consumer____17") + con.getAgreementName() + Messages.getString("____No_record_of_changes_transmitted._18"));
                }
                this.agreements.addElement(con);
                continue;
            }
            if (!con.getConsumerID().equals(myid)) continue;
            BackendHandler.getInstance().addReplica(con.getReplicaBase(), con);
        }
    }

    public void setupAgreement(String agreementname) {
        this.setupAgreement(agreementname, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupAgreement(String agreementname, String filename) {
        BackendHandler.getInstance().lockWrites();
        try {
            int ch = this.getChangeHigh();
            DirectoryString base = this.getReplicaBase(agreementname);
            String sbase = null;
            if (base == null) {
                Logger.getInstance().log(0, this, Messages.getString("Unable_to_locate_agreement___19") + agreementname);
                return;
            }
            sbase = base.toString();
            String ihome = System.getProperty("vde.home");
            String replicadataPath = ihome == null ? "replicadata" : ihome + "/replicadata";
            try {
                FileOutputStream fos = new FileOutputStream(replicadataPath + "/" + agreementname + ".status");
                DataOutputStream dos = new DataOutputStream(fos);
                dos.writeInt(ch);
                dos.close();
                Consumer ag = this.getReplicaByName(agreementname);
                ag.setChangeSent(ch);
            }
            catch (IOException ioe) {
                Logger.getInstance().log(0, this, Messages.getString("Could_not_update_replica_status_file_for__25") + agreementname);
                Logger.getInstance().printStackTrace(ioe);
                BackendHandler.getInstance().unlockWrites();
                return;
            }
            String replicaLDIF = filename != null ? filename : replicadataPath + "/" + agreementname + ".init.ldif";
            new LDIF().exportLDIF(sbase, replicaLDIF);
        }
        finally {
            BackendHandler.getInstance().unlockWrites();
        }
    }

    public int getChangeHigh() {
        if (this.bcl != null) {
            return this.bcl.getChangeHigh();
        }
        return -1;
    }

    public DirectoryString getReplicaBase(String agName) {
        Enumeration agEnum = this.agreements.elements();
        while (agEnum.hasMoreElements()) {
            Consumer oneAg = (Consumer)agEnum.nextElement();
            if (!oneAg.getAgreementName().equals(agName)) continue;
            return oneAg.getReplicaBase();
        }
        return null;
    }

    public Consumer getReplicaByName(String agName) {
        Enumeration agEnum = this.agreements.elements();
        while (agEnum.hasMoreElements()) {
            Consumer oneAg = (Consumer)agEnum.nextElement();
            if (!oneAg.getAgreementName().equals(agName)) continue;
            return oneAg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.agreements == null || this.agreements.isEmpty()) {
            return;
        }
        this.running = true;
        while (this.running) {
            try {
                if (this.reloadConfig) {
                    this.reloadConfig = false;
                    this.initAgreements(this.reloadOverrideProps);
                    this.reloadOverrideProps = null;
                    if (this.agreements == null || this.agreements.isEmpty()) {
                        this.running = false;
                        return;
                    }
                }
                int high = this.bcl.getChangeHigh();
                Enumeration agEnum = this.agreements.elements();
                int curlowkeep = -1;
                while (agEnum.hasMoreElements()) {
                    Consumer oneAg = (Consumer)agEnum.nextElement();
                    if (curlowkeep == -1 || oneAg.getChangeSent() < curlowkeep) {
                        curlowkeep = oneAg.getChangeSent();
                    }
                    if (!oneAg.isActive() || !oneAg.isImmediate() || high <= oneAg.getChangeSent()) continue;
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.running) {
                            return;
                        }
                        Replicator repl = oneAg.getReplicator();
                        if (repl == null) {
                            repl = new Replicator(this.replicadataPath, oneAg, this.bcl);
                            repl.setSSLSubject(this.sslSubject);
                            oneAg.setReplicator(repl);
                        }
                        try {
                            repl.run();
                        }
                        catch (Exception e) {
                            oneAg.setReplicator(null);
                            throw e;
                        }
                    }
                }
                this.bcl.setLowKeep(curlowkeep);
                this.wait30sec(high);
            }
            catch (Exception e) {
                Logger.getInstance().log(3, this, Messages.getString("Error_replicating_error_is") + e.getMessage());
                Logger.getInstance().printStackTraceLog(e);
            }
        }
    }

    public void reload() {
        this.reload(null);
    }

    public void reload(Properties overrideProps) {
        this.reloadOverrideProps = overrideProps;
        this.reloadConfig = true;
        if (!this.running) {
            this.initAgreements(overrideProps);
            overrideProps = null;
            this.start();
        }
    }

    private synchronized void wait30sec(int high) {
        try {
            if (this.bcl.getChangeHigh() > high) {
                return;
            }
            this.wait(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addReplica(Hashtable raConfig) {
        String myid = (String)ServerConfig.getInstance().get("vde.server.name");
        Consumer con = new Consumer(raConfig);
        if (con.getMasterID().equals(myid)) {
            try {
                String statusFile = this.replicadataPath + "/" + con.getAgreementName() + ".status";
                DataInputStream dis = new DataInputStream(new FileInputStream(statusFile));
                int lastSent = dis.readInt();
                con.setChangeSent(lastSent);
                dis.close();
            }
            catch (IOException ioe) {
                Logger.getInstance().log(3, this, Messages.getString("Consumer____17") + con.getAgreementName() + Messages.getString("____No_record_of_changes_transmitted._18"));
            }
            this.agreements.addElement(con);
        }
    }

    public synchronized void wakeUp() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            if (this.bcl != null) {
                this.bcl.shutdown();
            }
        }
    }
}

