/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.schema;

import com.octetstring.nls.Messages;
import com.octetstring.vde.Entry;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.ObjectClass;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.DirectorySchemaViolation;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ServerConfig;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SchemaChecker {
    private static Hashtable attributeTypes = null;
    private static Hashtable objectClasses = null;
    private static Hashtable oidmap = null;
    private static Hashtable revoidmap = null;
    private static Hashtable fullOCTable = null;
    private static SchemaChecker instance;
    private static boolean schemaCheckOn;
    private static String schemaFilename;
    private static final DirectoryString OBJECTCLASSATTR;
    private static final DirectoryString DOT;

    private SchemaChecker() {
        objectClasses = new Hashtable();
        attributeTypes = new Hashtable();
        fullOCTable = new Hashtable();
        oidmap = new Hashtable();
        revoidmap = new Hashtable();
        if (ServerConfig.getInstance().get("vde.schemacheck").equals("0")) {
            schemaCheckOn = false;
        }
    }

    public static SchemaChecker getInstance() {
        if (instance == null) {
            instance = new SchemaChecker();
        }
        return instance;
    }

    public Hashtable getAttributeTypes() {
        return attributeTypes;
    }

    public Hashtable getObjectClasses() {
        return objectClasses;
    }

    public void setSchemaFilename(String filename) {
        schemaFilename = filename;
    }

    public String getSchemaFilename() {
        return schemaFilename;
    }

    public boolean isSchemaCheckOn() {
        return schemaCheckOn;
    }

    public void setSchemaCheckOn(boolean schemaCheckOn) {
        SchemaChecker.schemaCheckOn = schemaCheckOn;
    }

    public void addAttributeType(AttributeType attributeType) {
        attributeTypes.put(attributeType.getName(), attributeType);
        oidmap.put(attributeType.getOid(), attributeType.getName());
        revoidmap.put(attributeType.getName(), attributeType.getOid());
    }

    public void addObjectClass(ObjectClass objectClass) {
        objectClasses.put(objectClass.getName(), objectClass);
    }

    public void checkEntry(Entry entry) throws DirectorySchemaViolation {
        ObjectClass oc;
        if (!this.isSchemaCheckOn()) {
            return;
        }
        Vector objectClass = entry.get(OBJECTCLASSATTR);
        if (objectClass == null) {
            throw new DirectorySchemaViolation(Messages.getString("Missing_Object_Class_4"));
        }
        Vector<DirectoryString> missingAttr = new Vector<DirectoryString>();
        Vector<DirectoryString> invalidAttr = new Vector<DirectoryString>();
        Enumeration ocEnum = objectClass.elements();
        while (ocEnum.hasMoreElements()) {
            DirectoryString ocname = (DirectoryString)ocEnum.nextElement();
            if (Logger.getInstance().isLogable(9)) {
                Logger.getInstance().log(9, this, Messages.getString("Checking_Class___5") + ocname);
            }
            if ((oc = this.getObjectClass(ocname)) == null) {
                Logger.getInstance().log(7, this, Messages.getString("Object_Class_Not_Found___6") + ocname);
                throw new DirectorySchemaViolation(Messages.getString("Object_Class_Not_Found___7") + ocname);
            }
            Vector must = null;
            if (oc != null) {
                must = oc.getMust();
            }
            if (must != null) {
                Enumeration mustEnum = must.elements();
                while (mustEnum.hasMoreElements()) {
                    DirectoryString aMust = (DirectoryString)mustEnum.nextElement();
                    if (entry.containsKey(aMust) && !entry.get(aMust).isEmpty()) continue;
                    missingAttr.addElement(aMust);
                }
            }
            while (oc != null && oc.getSuperior() != null && !objectClass.contains(oc.getSuperior())) {
                DirectoryString aSup = oc.getSuperior();
                objectClass.addElement(aSup);
                oc = this.getObjectClass(aSup);
            }
        }
        ocEnum = objectClass.elements();
        boolean firstOC = true;
        while (ocEnum.hasMoreElements()) {
            oc = this.getObjectClass((DirectoryString)ocEnum.nextElement());
            Vector tmpInvalidAttr = null;
            Enumeration attrEnum = null;
            if (firstOC) {
                attrEnum = entry.keys();
                firstOC = false;
            } else {
                tmpInvalidAttr = (Vector)invalidAttr.clone();
                attrEnum = tmpInvalidAttr.elements();
            }
            while (attrEnum.hasMoreElements()) {
                DirectoryString attr = (DirectoryString)attrEnum.nextElement();
                if (oc != null && (oc.getMust().contains(attr) || oc.getMay().contains(attr))) {
                    if (!invalidAttr.contains(attr)) continue;
                    invalidAttr.removeElement(attr);
                    continue;
                }
                if (invalidAttr.contains(attr)) continue;
                invalidAttr.addElement(attr);
            }
        }
        if (!invalidAttr.isEmpty() || !missingAttr.isEmpty()) {
            Logger.getInstance().log(7, this, Messages.getString("Missing_Attribues___8") + missingAttr.toString() + Messages.getString(",_Not_Allowed_Attributes___9") + invalidAttr.toString());
            throw new DirectorySchemaViolation(Messages.getString("Missing_Attributes___10") + missingAttr.toString() + Messages.getString(",_Not_Allowed_Attributes___11") + invalidAttr.toString());
        }
    }

    public AttributeType getAttributeType(DirectoryString attributeType) {
        if (attributeType.indexOf(DOT) == -1) {
            return (AttributeType)attributeTypes.get(attributeType);
        }
        DirectoryString an = (DirectoryString)oidmap.get(attributeType.toString());
        if (an != null) {
            return (AttributeType)attributeTypes.get(an);
        }
        return null;
    }

    public ObjectClass getObjectClass(DirectoryString objectClass) {
        if (objectClass.indexOf(DOT) == -1) {
            return (ObjectClass)objectClasses.get(objectClass);
        }
        DirectoryString on = (DirectoryString)oidmap.get(objectClass.toString());
        if (on != null) {
            return (ObjectClass)objectClasses.get(on);
        }
        return null;
    }

    public void removeAttributeType(DirectoryString name) {
        attributeTypes.remove(name);
    }

    public void removeObjectClass(DirectoryString name) {
        objectClasses.remove(name);
    }

    public DirectoryString nameFromOID(DirectoryString oid) {
        return (DirectoryString)oidmap.get(oid.toString());
    }

    static {
        schemaCheckOn = true;
        schemaFilename = null;
        OBJECTCLASSATTR = new DirectoryString("objectclass");
        DOT = new DirectoryString(".");
    }
}

