/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.util;

import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.InvalidDNException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class DNUtility {
    private static DNUtility instance = null;

    private DNUtility() {
    }

    public static DNUtility getInstance() {
        if (instance == null) {
            instance = new DNUtility();
        }
        return instance;
    }

    public DirectoryString createDN(Vector rdnComponents) throws InvalidDNException {
        StringBuffer dn = new StringBuffer(64);
        Enumeration rdnEnum = rdnComponents.elements();
        while (rdnEnum.hasMoreElements()) {
            String rdn = (String)rdnEnum.nextElement();
            if (rdn.indexOf("=") < 0) {
                throw new InvalidDNException();
            }
            dn.append(rdn.trim());
            if (!rdnEnum.hasMoreElements()) continue;
            dn.append(",");
        }
        return new DirectoryString(dn.toString());
    }

    public Vector explodeDN(DirectoryString dn) {
        Vector<String> rdnComponents = new Vector<String>();
        StringTokenizer dnTok = new StringTokenizer(dn.toString(), ",;");
        String lasttoken = null;
        while (dnTok.hasMoreTokens()) {
            String rdn = dnTok.nextToken();
            while (rdn.endsWith("\\") && !rdn.endsWith("\\\\") && dnTok.hasMoreTokens()) {
                rdn = rdn.concat(",");
                rdn = rdn.concat(dnTok.nextToken().trim());
            }
            rdn = rdn.trim();
            if (lasttoken != null && (lasttoken.indexOf("=") < 0 || rdn.indexOf("=") < 0)) {
                lasttoken = lasttoken + "," + rdn;
                continue;
            }
            if (lasttoken != null) {
                rdnComponents.addElement(lasttoken);
            }
            lasttoken = rdn;
        }
        if (lasttoken != null) {
            rdnComponents.addElement(lasttoken);
        }
        return rdnComponents;
    }

    public DirectoryString normalize(DirectoryString dn) throws InvalidDNException {
        return this.createDN(this.explodeDN(dn));
    }
}

