/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.util;

import com.octetstring.ldapv3.Filter;
import com.octetstring.nls.Messages;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.ParseFilter;
import java.util.StringTokenizer;
import java.util.Vector;

public class LDAPURL {
    private String host = null;
    private int port = 389;
    private DirectoryString base = null;
    private Vector attributes = null;
    private int scope = 0;
    private Filter filter = null;
    private String extensions = null;

    public LDAPURL() {
    }

    public LDAPURL(String ldapurl) {
        try {
            LDAPURL url = LDAPURL.fromString(ldapurl);
            this.host = url.getHost();
            this.port = url.getPort();
            this.base = url.getBase();
            this.attributes = url.getAttributes();
            this.scope = url.getScope();
            this.filter = url.getFilter();
        }
        catch (DirectoryException de) {
            return;
        }
    }

    public static LDAPURL fromString(String ldapurl) throws DirectoryException {
        LDAPURL url = new LDAPURL();
        StringTokenizer st = new StringTokenizer(ldapurl, "/", true);
        try {
            String scheme = st.nextToken();
            if (!scheme.equals("ldap:")) {
                throw new DirectoryException(2, Messages.getString("Not_an_LDAP_URL_3"));
            }
            String discard = st.nextToken();
            discard = st.nextToken();
            String hostport = st.nextToken();
            int colon = hostport.indexOf(":");
            if (colon < 0) {
                url.setHost(hostport);
            } else {
                url.setHost(hostport.substring(0, colon));
                url.setPort(new Integer(hostport.substring(colon + 1)));
            }
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreElements()) {
                sb.append(st.nextElement());
            }
            String criteria = sb.toString();
            st = new StringTokenizer(criteria, "?", true);
            int qmnum = 0;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals("?")) {
                    ++qmnum;
                    continue;
                }
                if (qmnum == 0) {
                    url.setBase(new DirectoryString(tok));
                    continue;
                }
                if (qmnum == 1) {
                    StringTokenizer ast = new StringTokenizer(tok, ",");
                    Vector<DirectoryString> attrs = new Vector<DirectoryString>();
                    while (ast.hasMoreTokens()) {
                        attrs.addElement(new DirectoryString(ast.nextToken()));
                    }
                    url.setAttributes(attrs);
                    continue;
                }
                if (qmnum == 2) {
                    if (tok.equals("one")) {
                        url.setScope(1);
                        continue;
                    }
                    if (!tok.equals("sub")) continue;
                    url.setScope(2);
                    continue;
                }
                if (qmnum != 3) continue;
                url.setFilter(ParseFilter.parse(tok));
            }
        }
        catch (Exception e) {
            throw new DirectoryException(2, Messages.getString("Invalid_LDAP_URL_10"));
        }
        return url;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String v) {
        this.host = v;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int v) {
        this.port = v;
    }

    public DirectoryString getBase() {
        return this.base;
    }

    public void setBase(DirectoryString v) {
        this.base = v;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int v) {
        this.scope = v;
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Vector v) {
        this.attributes = v;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter v) {
        this.filter = v;
    }
}

