/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.util;

import com.asn1c.core.Int8;
import com.octetstring.ldapv3.Filter;
import com.octetstring.nls.Messages;
import com.octetstring.vde.Credentials;
import com.octetstring.vde.Entry;
import com.octetstring.vde.EntrySet;
import com.octetstring.vde.acl.ACLChecker;
import com.octetstring.vde.backend.BackendHandler;
import com.octetstring.vde.backend.Mapper;
import com.octetstring.vde.operation.LDAPResult;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.InitSchema;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.Base64;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.DirectorySchemaViolation;
import com.octetstring.vde.util.DuplicateEntryCollection;
import com.octetstring.vde.util.EncryptionHelper;
import com.octetstring.vde.util.ErrorCollection;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ParseFilter;
import com.octetstring.vde.util.ServerConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public class LDIF {
    private static final DirectoryString DN_ATTR = new DirectoryString("dn");

    public static void main(String[] args) {
        try {
            ServerConfig.getInstance().init();
        }
        catch (IOException ioe) {
            System.out.println("Error initializing " + ioe);
            System.exit(-1);
        }
        new InitSchema().init();
        ACLChecker.getInstance().initialize();
        BackendHandler.getInstance();
        new LDIF().importLDIF(args[0]);
        System.exit(0);
    }

    public synchronized void exportLDIF(String base, String filename) {
        this.exportLDIF(base, null, filename, null, null, null);
    }

    public synchronized boolean exportLDIF(String base, String search, String filename, String[] encryptedAttribs, EncryptionHelper encrypter, ErrorCollection errors) {
        return this.exportLDIF(base, search, filename, encryptedAttribs, encrypter, errors, false);
    }

    public synchronized boolean exportLDIF(String base, String search, String filename, String[] encryptedAttribs, EncryptionHelper encrypter, ErrorCollection errors, boolean ignoreGuid) {
        Credentials creds = new Credentials();
        creds.setUser(new DirectoryString((String)ServerConfig.getInstance().get("vde.rootuser")));
        creds.setRoot(true);
        Mapper mapper = new Mapper();
        String filter = "(objectclass=*)";
        boolean searchSucceeded = false;
        if (search != null) {
            filter = "(&" + filter + search + ")";
        }
        Vector returnattrs = new Vector();
        Vector entrysets = null;
        DirectoryString realbase = new DirectoryString(base);
        Filter tmpfilter = null;
        try {
            tmpfilter = ParseFilter.parse(filter);
        }
        catch (DirectoryException de) {
            if (errors != null) {
                IOException ioe = new IOException(Messages.getString("Bad_LDAP_Filter___3") + filter);
                errors.add(ioe);
            } else {
                Logger.getInstance().log(0, this, Messages.getString("Bad_LDAP_Filter___3") + filter);
            }
            return false;
        }
        int realscope = 2;
        Logger.getInstance().log(5, this, Messages.getString("Exporting____4") + base + Messages.getString("___branch_to_LDIF___5") + filename);
        try {
            entrysets = BackendHandler.getInstance().get(creds.getUser(), realbase, realscope, tmpfilter, false, returnattrs);
        }
        catch (DirectoryException de) {
            if (errors != null) {
                EOFException ioe = new EOFException(Messages.getString("Failed_LDAP_Search___6") + de.getMessage());
                errors.add(ioe);
            } else {
                Logger.getInstance().log(0, this, Messages.getString("Failed_LDAP_Search___6") + de.getMessage());
            }
            return false;
        }
        boolean haveentry = false;
        boolean hasmore = true;
        Enumeration entsetenum = entrysets.elements();
        EntrySet myEntrySet = null;
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        }
        catch (IOException ioe) {
            if (errors != null) {
                errors.add(ioe);
            } else {
                Logger.getInstance().log(0, this, Messages.getString("Error_opening____7") + filename + Messages.getString("___for_writing___8") + ioe.getMessage());
            }
            return false;
        }
        while (hasmore) {
            if (myEntrySet != null && !myEntrySet.hasMore()) {
                haveentry = false;
            }
            while (!haveentry) {
                if (entsetenum.hasMoreElements()) {
                    myEntrySet = (EntrySet)entsetenum.nextElement();
                    if (!myEntrySet.hasMore()) continue;
                    haveentry = true;
                    continue;
                }
                hasmore = false;
                haveentry = true;
            }
            if (!hasmore) continue;
            try {
                Entry myEntry = myEntrySet.getNext();
                if (myEntry == null) continue;
                pw.println("dn: " + myEntry.getName());
                pw.println(myEntry.toLDIF(encryptedAttribs, encrypter, ignoreGuid));
                searchSucceeded = true;
            }
            catch (DirectoryException de) {
                if (errors != null) {
                    IOException ioe = new IOException(Messages.getString("Database_Export_Failed___10") + de.getMessage());
                    errors.add(ioe);
                } else {
                    Logger.getInstance().log(0, this, Messages.getString("Database_Export_Failed___10") + de.getMessage());
                }
                pw.flush();
                pw.close();
                return false;
            }
        }
        pw.flush();
        pw.close();
        Logger.getInstance().log(5, this, Messages.getString("Database_Export_to_LDIF_Complete_11"));
        if (search != null && !searchSucceeded) {
            if (errors != null) {
                EOFException ioe = new EOFException(Messages.getString("Failed_LDAP_Search___6") + Messages.getString("Search_filter_yielded_no_data"));
                errors.add(ioe);
            } else {
                Logger.getInstance().log(0, this, Messages.getString("Failed_LDAP_Search___6") + Messages.getString("Search_filter_yielded_no_data"));
            }
            return false;
        }
        return true;
    }

    public synchronized void importLDIF(String filename) {
        this.importLDIF(filename, null, false, null, null, null, null);
    }

    public synchronized boolean importLDIF(String filename, InputStream inputStream, boolean ignoreDuplicateErrors) {
        return this.importLDIF(filename, inputStream, ignoreDuplicateErrors, null, null, null, null);
    }

    public synchronized boolean importLDIF(String filename, InputStream inputStream, boolean ignoreDuplicateErrors, String[] encryptedAttribs, EncryptionHelper encrypter, ErrorCollection errors, DuplicateEntryCollection duplicates) {
        boolean success = true;
        if (inputStream == null) {
            Logger.getInstance().log(5, this, Messages.getString("Importing_from_LDIF___12") + filename);
        } else {
            Logger.getInstance().log(5, this, Messages.getString("Importing_from_LDIF___12") + " inputstream");
        }
        Credentials creds = new Credentials();
        creds.setUser(new DirectoryString((String)ServerConfig.getInstance().get("vde.rootuser")));
        creds.setRoot(true);
        try {
            IOException ioe;
            Int8 lr;
            Entry ent;
            BufferedReader br = null;
            br = inputStream == null ? new BufferedReader(new FileReader(filename)) : new BufferedReader(new InputStreamReader(inputStream));
            String line = br.readLine();
            StringBuffer curentry = new StringBuffer();
            while (line != null) {
                Logger.getInstance().log(5, this, "Read import line: " + line);
                if (line.length() == 0) {
                    ent = LDIF.toEntry(curentry, encryptedAttribs, encrypter);
                    if (ent.getName() != null) {
                        try {
                            lr = BackendHandler.getInstance().add(creds, ent);
                            if (!(lr == LDAPResult.SUCCESS || lr == LDAPResult.ENTRY_ALREADY_EXISTS && ignoreDuplicateErrors)) {
                                if (duplicates != null && lr == LDAPResult.ENTRY_ALREADY_EXISTS) {
                                    duplicates.add(ent.getName().toString());
                                } else if (errors != null) {
                                    ioe = new IOException(Messages.getString("Error_adding_entry___13") + ent.getName());
                                    errors.add(ioe);
                                } else {
                                    Logger.getInstance().log(0, this, Messages.getString("Error_adding_entry___13") + ent.getName());
                                }
                                success = false;
                            }
                        }
                        catch (DirectorySchemaViolation dsv) {
                            if (errors != null) {
                                ioe = new IOException(Messages.getString("Schema_Violation_adding____14") + ent.getName() + "': " + dsv.getMessage());
                                errors.add(ioe);
                            } else {
                                Logger.getInstance().log(0, this, Messages.getString("Schema_Violation_adding____14") + ent.getName() + "': " + dsv.getMessage());
                            }
                            success = false;
                        }
                    }
                    curentry = new StringBuffer();
                } else {
                    curentry.append(line);
                    curentry.append("\n");
                }
                line = br.readLine();
            }
            if (curentry.length() > 0 && (ent = LDIF.toEntry(curentry, encryptedAttribs, encrypter)).getName() != null) {
                try {
                    lr = BackendHandler.getInstance().add(creds, ent);
                    if (!(lr == LDAPResult.SUCCESS || lr == LDAPResult.ENTRY_ALREADY_EXISTS && ignoreDuplicateErrors)) {
                        if (duplicates != null && lr == LDAPResult.ENTRY_ALREADY_EXISTS) {
                            duplicates.add(ent.getName().toString());
                        } else if (errors != null) {
                            ioe = new IOException(Messages.getString("Error_adding_entry___17") + ent.getName());
                            errors.add(ioe);
                        } else {
                            Logger.getInstance().log(0, this, Messages.getString("Error_adding_entry___17") + ent.getName());
                        }
                        success = false;
                    }
                }
                catch (DirectorySchemaViolation dsv) {
                    if (errors != null) {
                        ioe = new IOException(Messages.getString("Schema_Violation_adding____18") + ent.getName() + "': " + dsv.getMessage());
                        errors.add(ioe);
                    } else {
                        Logger.getInstance().log(0, this, Messages.getString("Schema_Violation_adding____18") + ent.getName() + "': " + dsv.getMessage());
                    }
                    success = false;
                }
            }
            br.close();
        }
        catch (IOException ioe) {
            if (errors != null) {
                errors.add(ioe);
            } else {
                Logger.getInstance().log(0, this, Messages.getString("Error_reading_input___20") + ioe.getMessage());
            }
            success = false;
        }
        Logger.getInstance().log(5, this, Messages.getString("Finished_Importing_from_LDIF_21"));
        return success;
    }

    public static Entry toEntry(StringBuffer sb) {
        return LDIF.toEntry(sb, null, null);
    }

    public static Entry toEntry(StringBuffer sb, String[] encryptedAttribs, EncryptionHelper encrypter) {
        Entry entry = new Entry();
        int len = sb.length();
        char[] ic = new char[len];
        sb.getChars(0, len, ic, 0);
        StringBuffer curattr = new StringBuffer();
        StringBuffer curval = new StringBuffer();
        boolean binary = false;
        boolean newline = true;
        boolean inattr = true;
        boolean lastcolon = false;
        boolean firstval = false;
        for (int i = 0; i < len; ++i) {
            if (ic[i] == '\r' || ic[i] == '\n') {
                newline = true;
                continue;
            }
            if (newline) {
                if (ic[i] == ' ') {
                    newline = false;
                    continue;
                }
                if (curattr.length() > 0) {
                    DirectoryString atname = new DirectoryString(curattr.toString());
                    if (!atname.equals(DN_ATTR)) {
                        AttributeType at = SchemaChecker.getInstance().getAttributeType(atname);
                        Syntax atval = null;
                        atval = at == null ? new DirectoryString() : at.getSyntaxInstance();
                        if (encryptedAttribs != null && encrypter != null) {
                            LDIF.doEncryption(atname, curval, binary, atval, encryptedAttribs, encrypter);
                        } else if (binary) {
                            byte[] binval = Base64.decode(curval.toString().trim());
                            atval.setValue(binval);
                        } else {
                            try {
                                atval.setValue(curval.toString().getBytes("UTF8"));
                            }
                            catch (UnsupportedEncodingException uee) {
                                atval.setValue(curval.toString().getBytes());
                            }
                        }
                        Vector<Syntax> vals = entry.get(atname);
                        if (vals == null) {
                            vals = new Vector<Syntax>();
                            entry.put(atname, vals);
                        }
                        vals.addElement(atval);
                    } else {
                        try {
                            entry.setName(new DirectoryString(curval.toString()));
                        }
                        catch (InvalidDNException ide) {
                            return null;
                        }
                    }
                    curattr = new StringBuffer();
                    curval = new StringBuffer();
                }
                newline = false;
                inattr = true;
                binary = false;
                firstval = false;
                lastcolon = false;
                curattr.append(ic[i]);
                continue;
            }
            if (inattr) {
                if (ic[i] == ':') {
                    if (!lastcolon) {
                        lastcolon = true;
                    }
                    inattr = false;
                    firstval = true;
                    continue;
                }
                curattr.append(ic[i]);
                continue;
            }
            if (ic[i] == ':' && lastcolon) {
                binary = true;
                lastcolon = false;
                continue;
            }
            lastcolon = false;
            if (firstval) {
                if (ic[i] != ' ') {
                    curval.append(ic[i]);
                }
                firstval = false;
                continue;
            }
            curval.append(ic[i]);
        }
        if (curattr.length() > 0) {
            DirectoryString atname = new DirectoryString(curattr.toString());
            if (!atname.equals(DN_ATTR)) {
                AttributeType at = SchemaChecker.getInstance().getAttributeType(atname);
                Syntax atval = null;
                atval = at == null ? new DirectoryString() : at.getSyntaxInstance();
                if (encryptedAttribs != null && encrypter != null) {
                    LDIF.doEncryption(atname, curval, binary, atval, encryptedAttribs, encrypter);
                } else if (binary) {
                    byte[] binval = Base64.decode(curval.toString().trim());
                    atval.setValue(binval);
                } else {
                    try {
                        atval.setValue(curval.toString().getBytes("UTF8"));
                    }
                    catch (UnsupportedEncodingException uee) {
                        atval.setValue(curval.toString().getBytes());
                    }
                }
                Vector<Syntax> vals = entry.get(atname);
                if (vals == null) {
                    vals = new Vector<Syntax>();
                    entry.put(atname, vals);
                }
                vals.addElement(atval);
            } else {
                try {
                    entry.setName(new DirectoryString(curval.toString()));
                }
                catch (InvalidDNException ide) {
                    return null;
                }
            }
        }
        return entry;
    }

    private static void doEncryption(DirectoryString atname, StringBuffer curval, boolean binary, Syntax atval, String[] encryptedAttribs, EncryptionHelper encrypter) {
        byte[] byteval;
        boolean doEncrypt = false;
        String attrName = atname.getDirectoryString();
        for (int i = 0; i < encryptedAttribs.length; ++i) {
            if (!encryptedAttribs[i].equals(attrName)) continue;
            doEncrypt = true;
            break;
        }
        if (binary) {
            byteval = Base64.decode(curval.toString().trim());
        } else {
            try {
                byteval = curval.toString().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                byteval = curval.toString().getBytes();
            }
        }
        if (doEncrypt) {
            String strval;
            try {
                strval = new String(byteval, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                strval = new String(byteval);
            }
            if (!encrypter.isEncrypted(strval)) {
                try {
                    byteval = encrypter.encrypt(strval).getBytes("UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    byteval = encrypter.encrypt(strval).getBytes();
                }
            }
        }
        atval.setValue(byteval);
    }
}

