/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.util;

import com.asn1c.core.OctetString;
import com.octetstring.ldapv3.AttributeValueAssertion;
import com.octetstring.ldapv3.Filter;
import com.octetstring.ldapv3.Filter_and;
import com.octetstring.ldapv3.Filter_or;
import com.octetstring.ldapv3.SubstringFilter;
import com.octetstring.ldapv3.SubstringFilter_substrings;
import com.octetstring.ldapv3.SubstringFilter_substrings_Seq;
import com.octetstring.nls.Messages;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.DirectoryException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ParseFilter {
    public static Filter parse(String filter) throws DirectoryException {
        Filter fil = null;
        Filter cfil = null;
        int settype = -1;
        Vector<Filter> branch = new Vector<Filter>();
        int parencount = 0;
        int level = 0;
        StringTokenizer st = new StringTokenizer(filter, "(", true);
        Filter emptyfilter = new Filter();
        while (st.hasMoreTokens()) {
            Filter afil;
            String token = st.nextToken();
            if (token.equals("(")) {
                ++parencount;
                continue;
            }
            if (token.equals("&")) {
                afil = new Filter();
                Filter_and myand = new Filter_and();
                afil.setAnd(myand);
                if (settype == -1) {
                    fil = afil;
                    cfil = afil;
                } else if (settype == 0) {
                    cfil.getAnd().addElement(afil);
                } else if (settype == 1) {
                    cfil.getOr().addElement(afil);
                } else if (settype == 2) {
                    if (cfil.getNot() != null) {
                        throw new DirectoryException(2, Messages.getString("Bad_LDAP_Filter_14"));
                    }
                    cfil.setNot(afil);
                }
                branch.addElement(afil);
                settype = 0;
                cfil = afil;
                ++level;
                continue;
            }
            if (token.equals("|")) {
                afil = new Filter();
                afil.setOr(new Filter_or());
                if (settype == -1) {
                    fil = afil;
                    cfil = afil;
                } else if (settype == 0) {
                    cfil.getAnd().addElement(afil);
                } else if (settype == 1) {
                    cfil.getOr().addElement(afil);
                } else if (settype == 2) {
                    if (cfil.getNot() != null) {
                        throw new DirectoryException(2, Messages.getString("Bad_LDAP_Filter_14"));
                    }
                    cfil.setNot(afil);
                }
                branch.addElement(afil);
                settype = 1;
                cfil = afil;
                ++level;
                continue;
            }
            if (token.equals("!")) {
                afil = new Filter();
                afil.setNot(null);
                if (settype == -1) {
                    fil = afil;
                    cfil = afil;
                } else if (settype == 0) {
                    cfil.getAnd().addElement(afil);
                } else if (settype == 1) {
                    cfil.getOr().addElement(afil);
                } else if (settype == 2) {
                    if (cfil.getNot() != null) {
                        throw new DirectoryException(2, Messages.getString("Bad_LDAP_Filter_14"));
                    }
                    cfil.setNot(afil);
                }
                branch.addElement(afil);
                settype = 2;
                cfil = afil;
                ++level;
                continue;
            }
            Filter nfilt = null;
            StringTokenizer nst = new StringTokenizer(token, ")", true);
            int nup = 0;
            while (nst.hasMoreTokens()) {
                String val;
                String attr;
                String ntok = nst.nextToken();
                if (ntok.equals(")")) {
                    ++nup;
                    continue;
                }
                int loc = 0;
                loc = ntok.indexOf(">=");
                if (loc != -1) {
                    attr = ntok.substring(0, loc);
                    val = ntok.substring(loc + 2);
                    val = ParseFilter.unescapeValue(val);
                    nfilt = new Filter();
                    AttributeValueAssertion ge = new AttributeValueAssertion();
                    nfilt.setGreaterOrEqual(ge);
                    ge.setAttributeDesc(new OctetString(attr.getBytes()));
                    try {
                        ge.setAssertionValue(new OctetString(val.getBytes("UTF8")));
                    }
                    catch (UnsupportedEncodingException uee) {
                        ge.setAssertionValue(new OctetString(val.getBytes()));
                    }
                } else {
                    loc = ntok.indexOf("<=");
                    if (loc != -1) {
                        attr = ntok.substring(0, loc);
                        val = ntok.substring(loc + 2);
                        val = ParseFilter.unescapeValue(val);
                        nfilt = new Filter();
                        AttributeValueAssertion lt = new AttributeValueAssertion();
                        nfilt.setLessOrEqual(lt);
                        lt.setAttributeDesc(new OctetString(attr.getBytes()));
                        try {
                            lt.setAssertionValue(new OctetString(val.getBytes("UTF8")));
                        }
                        catch (UnsupportedEncodingException uee) {
                            lt.setAssertionValue(new OctetString(val.getBytes()));
                        }
                    } else {
                        loc = ntok.indexOf("=");
                        if (loc != -1) {
                            attr = ntok.substring(0, loc);
                            val = ntok.substring(loc + 1);
                            if (val.equals("*")) {
                                nfilt = new Filter();
                                nfilt.setPresent(new OctetString(attr.getBytes()));
                            } else if (val.indexOf("*") < 0) {
                                nfilt = new Filter();
                                AttributeValueAssertion em = new AttributeValueAssertion();
                                nfilt.setEqualityMatch(em);
                                em.setAttributeDesc(new OctetString(attr.getBytes()));
                                val = ParseFilter.unescapeValue(val);
                                try {
                                    em.setAssertionValue(new OctetString(val.getBytes("UTF8")));
                                }
                                catch (UnsupportedEncodingException uee) {
                                    em.setAssertionValue(new OctetString(val.getBytes()));
                                }
                            } else {
                                SubstringFilter_substrings_Seq ssc;
                                StringTokenizer vst = new StringTokenizer(val, "*", true);
                                String initialsub = null;
                                String anysub = null;
                                String finalsub = null;
                                String firstTok = vst.nextToken();
                                if (!firstTok.equals("*")) {
                                    initialsub = firstTok;
                                    String skipnext = vst.nextToken();
                                }
                                if (vst.hasMoreTokens()) {
                                    String nextTok = vst.nextToken();
                                    if (!vst.hasMoreTokens()) {
                                        finalsub = nextTok;
                                    } else {
                                        anysub = nextTok;
                                        String skipnext = vst.nextToken();
                                        if (vst.hasMoreTokens()) {
                                            finalsub = vst.nextToken();
                                        }
                                    }
                                }
                                nfilt = new Filter();
                                SubstringFilter sf = new SubstringFilter();
                                nfilt.setSubstrings(sf);
                                sf.setType(new OctetString(attr.getBytes()));
                                SubstringFilter_substrings ss = new SubstringFilter_substrings();
                                if (initialsub != null) {
                                    ssc = new SubstringFilter_substrings_Seq();
                                    initialsub = ParseFilter.unescapeValue(initialsub);
                                    try {
                                        ssc.setInitial(new OctetString(initialsub.getBytes("UTF8")));
                                    }
                                    catch (UnsupportedEncodingException uee) {
                                        ssc.setInitial(new OctetString(initialsub.getBytes()));
                                    }
                                    ss.addElement(ssc);
                                }
                                if (anysub != null) {
                                    ssc = new SubstringFilter_substrings_Seq();
                                    anysub = ParseFilter.unescapeValue(anysub);
                                    try {
                                        ssc.setAny(new OctetString(anysub.getBytes("UTF8")));
                                    }
                                    catch (UnsupportedEncodingException uee) {
                                        ssc.setAny(new OctetString(anysub.getBytes()));
                                    }
                                    ss.addElement(ssc);
                                }
                                if (finalsub != null) {
                                    ssc = new SubstringFilter_substrings_Seq();
                                    finalsub = ParseFilter.unescapeValue(finalsub);
                                    try {
                                        ssc.setFinal_(new OctetString(finalsub.getBytes("UTF8")));
                                    }
                                    catch (UnsupportedEncodingException uee) {
                                        ssc.setFinal_(new OctetString(finalsub.getBytes()));
                                    }
                                    ss.addElement(ssc);
                                }
                                sf.setSubstrings(ss);
                            }
                        }
                    }
                }
                if (nfilt == null) {
                    throw new DirectoryException(2, Messages.getString("Bad_LDAP_Filter_14"));
                }
                if (settype == -1) {
                    fil = nfilt;
                    continue;
                }
                if (settype == 0) {
                    cfil.getAnd().addElement(nfilt);
                    continue;
                }
                if (settype == 1) {
                    cfil.getOr().addElement(nfilt);
                    continue;
                }
                if (settype != 2) continue;
                if (cfil.getNot() != null) {
                    throw new DirectoryException(2, Messages.getString("Bad_LDAP_Filter_14"));
                }
                cfil.setNot(nfilt);
            }
            if (nup <= true) continue;
            level = level - nup + 1;
            parencount -= nup;
            if (level < 1) {
                return fil;
            }
            cfil = (Filter)branch.elementAt(level - 1);
            settype = cfil.getSelector();
            branch.setSize(level);
        }
        return fil;
    }

    public static String filterToString(Filter currentFilter) {
        String filterString = null;
        switch (currentFilter.getSelector()) {
            case 3: {
                DirectoryString matchType = new DirectoryString(currentFilter.getEqualityMatch().getAttributeDesc().toByteArray());
                String matchVal = new String(currentFilter.getEqualityMatch().getAssertionValue().toByteArray());
                filterString = new String(matchType + "=" + matchVal);
                break;
            }
            case 7: {
                DirectoryString matchType = new DirectoryString(currentFilter.getPresent().toByteArray());
                filterString = new String(matchType + "=*");
                break;
            }
            case 5: {
                DirectoryString matchType = new DirectoryString(currentFilter.getGreaterOrEqual().getAttributeDesc().toByteArray());
                String matchVal = new String(currentFilter.getGreaterOrEqual().getAssertionValue().toByteArray());
                filterString = new String(matchType + ">=" + matchVal);
                break;
            }
            case 6: {
                DirectoryString matchType = new DirectoryString(currentFilter.getLessOrEqual().getAttributeDesc().toByteArray());
                String matchVal = new String(currentFilter.getLessOrEqual().getAssertionValue().toByteArray());
                filterString = new String(matchType + "<=" + matchVal);
                break;
            }
            case 4: {
                DirectoryString matchType = new DirectoryString(currentFilter.getSubstrings().getType().toByteArray());
                String subfilter = new String();
                Iterator substrEnum = currentFilter.getSubstrings().getSubstrings().iterator();
                while (substrEnum.hasNext()) {
                    SubstringFilter_substrings_Seq oneSubFilter = (SubstringFilter_substrings_Seq)substrEnum.next();
                    if (oneSubFilter.getSelector() == 0) {
                        subfilter = subfilter.concat(new String(oneSubFilter.getInitial().toByteArray()) + "*");
                        continue;
                    }
                    if (oneSubFilter.getSelector() == 1) {
                        if (subfilter.length() == 0) {
                            subfilter = subfilter.concat("*");
                        }
                        subfilter = subfilter.concat(new String(oneSubFilter.getAny().toByteArray()) + "*");
                        continue;
                    }
                    if (oneSubFilter.getSelector() != 2) continue;
                    if (subfilter.length() == 0) {
                        subfilter = subfilter.concat("*");
                    }
                    subfilter = subfilter.concat(new String(oneSubFilter.getFinal_().toByteArray()));
                }
                filterString = new String(matchType + "=" + subfilter);
                break;
            }
            case 0: {
                filterString = new String("(&");
                Iterator andEnum = currentFilter.getAnd().iterator();
                while (andEnum.hasNext()) {
                    String fs = ParseFilter.filterToString((Filter)andEnum.next());
                    if (fs == null) continue;
                    if (fs.charAt(0) == '(') {
                        filterString = filterString.concat(fs);
                        continue;
                    }
                    filterString = filterString.concat("(" + fs + ")");
                }
                filterString = filterString.concat(")");
                break;
            }
            case 1: {
                filterString = new String("(|");
                Iterator orEnum = currentFilter.getOr().iterator();
                while (orEnum.hasNext()) {
                    String fs = ParseFilter.filterToString((Filter)orEnum.next());
                    if (fs == null) continue;
                    if (fs.charAt(0) == '(') {
                        filterString = filterString.concat(fs);
                        continue;
                    }
                    filterString = filterString.concat("(" + fs + ")");
                }
                filterString = filterString.concat(")");
                break;
            }
            case 2: {
                filterString = new String("(!");
                String nfs = ParseFilter.filterToString(currentFilter.getNot());
                if (nfs != null) {
                    filterString = nfs.charAt(0) == '(' ? filterString.concat(nfs) : filterString.concat("(" + nfs + ")");
                }
                filterString = filterString.concat(")");
                break;
            }
            case 8: {
                DirectoryString matchType = new DirectoryString(currentFilter.getApproxMatch().getAttributeDesc().toByteArray());
                String matchVal = new String(currentFilter.getApproxMatch().getAssertionValue().toByteArray());
                filterString = matchType + "~=" + matchVal;
                break;
            }
            case 9: {
                StringBuffer fsb = new StringBuffer();
                if (currentFilter.getExtensibleMatch().getType() != null) {
                    fsb.append(new String(currentFilter.getExtensibleMatch().getType().toByteArray()));
                    fsb.append(":");
                }
                if (currentFilter.getExtensibleMatch().getDnAttributes().booleanValue()) {
                    fsb.append("dn:");
                }
                fsb.append(new String(currentFilter.getExtensibleMatch().getMatchingRule().toByteArray()));
                fsb.append(":=");
                fsb.append(new String(currentFilter.getExtensibleMatch().getMatchValue().toByteArray()));
                filterString = fsb.toString();
            }
        }
        return filterString;
    }

    public static String unescapeValue(String value) {
        if (value == null) {
            return value;
        }
        int idx = value.indexOf(92);
        if (idx < 0) {
            return value;
        }
        int len = value.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\' && i < len - 2) {
                char ch2 = value.charAt(i + 1);
                char ch3 = value.charAt(i + 2);
                i += 2;
                if (ch2 == '2' && (ch3 == 'a' || ch3 == 'A')) {
                    buf.append('*');
                    continue;
                }
                if (ch2 == '2' && ch3 == '8') {
                    buf.append('(');
                    continue;
                }
                if (ch2 == '2' && ch3 == '9') {
                    buf.append(')');
                    continue;
                }
                if (ch2 == '5' && (ch3 == 'c' || ch3 == 'C')) {
                    buf.append('\\');
                    continue;
                }
                if (ch2 == '0' && ch3 == '0') {
                    buf.append('\u0000');
                    continue;
                }
                buf.append(ch);
                buf.append(ch2);
                buf.append(ch3);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }
}

