/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.util;

import com.octetstring.nls.Messages;
import com.octetstring.vde.util.Base64;
import com.octetstring.vde.util.EncryptionHelper;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.UnixCrypt;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class PasswordEncryptor {
    private static final String UTF8 = "UTF8";
    static EncryptionHelper externalEncryptor = null;

    private PasswordEncryptor() {
    }

    public static boolean compare(String attempt, String value) {
        byte[] attemptBytes = PasswordEncryptor.getUTFBytes(attempt);
        return PasswordEncryptor.compare(attemptBytes, value);
    }

    public static boolean compare(byte[] attempt, String value) {
        if (!value.startsWith("{")) {
            return PasswordEncryptor.getUTFString(attempt).equals(value);
        }
        int end = value.indexOf("}");
        String type = value.substring(1, end);
        String encval = value.substring(end + 1);
        if (Logger.getInstance().isLogable(9)) {
            Logger.getInstance().log(9, new PasswordEncryptor(), Messages.getString("Encrypted_password_type____3") + type + Messages.getString("___encoded_as____4") + encval + "'");
        }
        if (type.equalsIgnoreCase("crypt")) {
            String crypted = PasswordEncryptor.doCrypt(PasswordEncryptor.getUTFString(attempt), encval.substring(0, 2));
            if (crypted == null) {
                return false;
            }
            return crypted.equals(encval);
        }
        if (type.equalsIgnoreCase("sha")) {
            String hashed = PasswordEncryptor.doSHA(attempt);
            if (hashed == null) {
                return false;
            }
            return encval.equals(hashed);
        }
        if (type.equalsIgnoreCase("ssha")) {
            byte[][] hs = PasswordEncryptor.split(Base64.decode(encval), 20);
            byte[] hash = hs[0];
            byte[] salt = hs[1];
            String myenc = PasswordEncryptor.doSSHA(attempt, salt);
            if (myenc == null) {
                return false;
            }
            return myenc.equals(encval);
        }
        if (externalEncryptor != null) {
            String plain = externalEncryptor.decrypt(value);
            return PasswordEncryptor.getUTFString(attempt).equals(plain);
        }
        return false;
    }

    public static String doSHA(String plain) {
        byte[] plainBytes = PasswordEncryptor.getUTFBytes(plain);
        return PasswordEncryptor.doSHA(plainBytes);
    }

    public static String doSHA(byte[] plain) {
        try {
            MessageDigest md2 = MessageDigest.getInstance("SHA-1");
            md2.update(plain);
            return Base64.encode(md2.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    public static String doSSHA(String plain) {
        byte[] plainBytes = PasswordEncryptor.getUTFBytes(plain);
        return PasswordEncryptor.doSSHA(plainBytes);
    }

    public static String doSSHA(byte[] plain) {
        try {
            MessageDigest md2 = MessageDigest.getInstance("SHA-1");
            md2.update(plain);
            byte[] salt = PasswordEncryptor.genSalt(4);
            md2.update(salt);
            byte[] dig = md2.digest();
            byte[] full = new byte[dig.length + salt.length];
            System.arraycopy(dig, 0, full, 0, dig.length);
            System.arraycopy(salt, 0, full, dig.length, salt.length);
            return Base64.encode(full);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    public static String doSSHA(String plain, byte[] salt) {
        byte[] plainBytes = PasswordEncryptor.getUTFBytes(plain);
        return PasswordEncryptor.doSSHA(plainBytes, salt);
    }

    public static String doSSHA(byte[] plain, byte[] salt) {
        try {
            MessageDigest md2 = MessageDigest.getInstance("SHA-1");
            md2.update(plain);
            md2.update(salt);
            byte[] dig = md2.digest();
            byte[] full = new byte[dig.length + salt.length];
            System.arraycopy(dig, 0, full, 0, dig.length);
            System.arraycopy(salt, 0, full, dig.length, salt.length);
            return Base64.encode(full);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    public static String doCrypt(String plain) {
        return UnixCrypt.crypt(plain);
    }

    public static String doCrypt(String plain, String salt) {
        return UnixCrypt.crypt(salt, plain);
    }

    public static String doExternal(String plain) {
        if (externalEncryptor != null) {
            return externalEncryptor.encrypt(plain);
        }
        return null;
    }

    public static void setExternalEncryptionHelper(EncryptionHelper encryptor) {
        externalEncryptor = encryptor;
    }

    private static byte[] genSalt(int numBytes) {
        byte[] salt = new byte[numBytes];
        new Random().nextBytes(salt);
        return salt;
    }

    private static byte[][] split(byte[] src, int n) {
        byte[] r;
        byte[] l;
        if (src.length <= n) {
            l = src;
            r = new byte[]{};
        } else {
            l = new byte[n];
            r = new byte[src.length - n];
            System.arraycopy(src, 0, l, 0, n);
            System.arraycopy(src, n, r, 0, r.length);
        }
        byte[][] lr = new byte[][]{l, r};
        return lr;
    }

    public static byte[] getUTFBytes(String aString) {
        byte[] value;
        try {
            value = aString.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException ueExc) {
            value = aString.getBytes();
        }
        return value;
    }

    public static String getUTFString(byte[] bytes) {
        String value;
        try {
            value = new String(bytes, UTF8);
        }
        catch (UnsupportedEncodingException ueExc) {
            value = new String(bytes);
        }
        return value;
    }
}

