/*
 * Decompiled with CFR 0.152.
 */
package com.octetstring.vde.util.guid;

import com.octetstring.vde.util.guid.GuidClock;
import com.octetstring.vde.util.guid.GuidParamGenerator;
import com.octetstring.vde.util.guid.GuidParams;

final class GuidStateManager {
    private long lastTimeStamp;
    private short clockSequence;
    private byte[] nodeID;
    private static GuidStateManager instance = new GuidStateManager();

    private GuidStateManager() {
        this.initializeGUIDParameters();
    }

    static GuidStateManager getInstance() {
        return instance;
    }

    GuidParams nextGUIDParams() {
        GuidParams nextGuidParams = new GuidParams();
        nextGuidParams.setTimeStamp(this.getTimeStamp());
        nextGuidParams.setClockSequence(this.getClockSequence());
        nextGuidParams.setNodeID(this.nodeID);
        return nextGuidParams;
    }

    private void initializeGUIDParameters() {
        this.nodeID = GuidParamGenerator.generateNodeID();
        this.clockSequence = GuidParamGenerator.generateClockSequence();
        this.lastTimeStamp = GuidClock.getInstance().getTime();
    }

    private long getTimeStamp() {
        long currentTimeStamp = GuidClock.getInstance().getTime();
        if (this.isTimeSetBackward(currentTimeStamp)) {
            this.incrementClockSequence();
        }
        this.lastTimeStamp = currentTimeStamp;
        return currentTimeStamp;
    }

    boolean isTimeSetBackward(long currentTimeStamp) {
        return currentTimeStamp < this.lastTimeStamp;
    }

    void incrementClockSequence() {
        this.clockSequence = (short)(this.clockSequence + 1);
    }

    private short getClockSequence() {
        return this.clockSequence;
    }
}

