/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl.impl;

import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.impl.HandshakeListenerShunt;
import javax.net.ssl.impl.SSLSessionImpl;
import javax.net.ssl.impl.StringID;

public final class SSLLayeredSocket
extends SSLSocket {
    private TLSSystem system;
    private Socket socket;
    private boolean autoClose;
    public TLSConnectionImpl connection = null;

    SSLLayeredSocket(Socket socket, TLSSystem tLSSystem, String string, int n, boolean bl) throws IOException {
        this.socket = socket;
        this.autoClose = bl;
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        String string2 = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
        this.connection = (TLSConnectionImpl)tLSSystem.createClient((SSLSocket)this, inputStream, outputStream, (Serializable)new StringID(string2));
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.connection.setEnabledProtocols(stringArray);
    }

    public String[] getEnabledProtocols() {
        return this.connection.getEnabledProtocols();
    }

    public String[] getSupportedProtocols() {
        return this.connection.getSupportedProtocols();
    }

    public boolean getWantClientAuth() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getWantClientAuth()");
    }

    public void setWantClientAuth(boolean bl) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".setWantClientAuth(boolean)");
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.socket.setSoLinger(bl, n);
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.connection.close();
        }
        finally {
            if (this.autoClose) {
                this.socket.close();
            }
            super.close();
        }
    }

    public String[] getSupportedCipherSuites() {
        SSLLayeredSocket sSLLayeredSocket = this;
        return sSLLayeredSocket.system.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.connection.getEnabledCipherSuites();
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.connection.setEnabledCipherSuites(stringArray);
    }

    public SSLSession getSession() {
        return new SSLSessionImpl((TLSSessionImpl)this.connection.getSession());
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        HandshakeListenerShunt handshakeListenerShunt = new HandshakeListenerShunt(handshakeCompletedListener, this);
        this.connection.addHandshakeCompletedListener(handshakeListenerShunt);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        HandshakeListenerShunt handshakeListenerShunt = new HandshakeListenerShunt(handshakeCompletedListener, this);
        this.connection.removeHandshakeCompletedListener(handshakeListenerShunt);
    }

    public void startHandshake() throws IOException {
        this.connection.completeHandshake();
    }

    public void setUseClientMode(boolean bl) {
        this.connection.setClient(bl);
    }

    public boolean getUseClientMode() {
        return this.connection.isClient();
    }

    public void setNeedClientAuth(boolean bl) {
        this.connection.setNeedClientAuth(bl);
    }

    public boolean getNeedClientAuth() {
        return this.connection.getNeedClientAuth();
    }

    public void setEnableSessionCreation(boolean bl) {
        this.connection.setEnableSessionCreation(bl);
    }

    public boolean getEnableSessionCreation() {
        return this.connection.getEnableSessionCreation();
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }
}

