/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl.impl;

import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.impl.SSLServerSocketImpl;

public final class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private TLSSystem system;
    private String[] defaultSuites;
    private boolean bNio = false;

    public SSLServerSocketFactoryImpl() {
        this.system = new TLSSystem();
        this.defaultSuites = this.system.getEnabledCipherSuites();
    }

    public SSLServerSocketFactoryImpl(TLSSystem tLSSystem) {
        this.system = tLSSystem;
        this.defaultSuites = tLSSystem.getEnabledCipherSuites();
    }

    public SSLServerSocketFactoryImpl(TLSSystem tLSSystem, boolean bl) {
        this.system = tLSSystem;
        this.bNio = bl;
        this.defaultSuites = tLSSystem.getEnabledCipherSuites();
    }

    private boolean isNioEnabled() {
        return this.bNio;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (!this.isNioEnabled()) {
            return new SSLServerSocketImpl(this.system, n);
        }
        SSLServerSocketImpl sSLServerSocketImpl = new SSLServerSocketImpl(this.system);
        sSLServerSocketImpl.bindNioChannel(n, -1, null);
        return sSLServerSocketImpl;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        if (!this.isNioEnabled()) {
            return new SSLServerSocketImpl(this.system, n, n2);
        }
        SSLServerSocketImpl sSLServerSocketImpl = new SSLServerSocketImpl(this.system);
        sSLServerSocketImpl.bindNioChannel(n, n2, null);
        return sSLServerSocketImpl;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        if (!this.isNioEnabled()) {
            return new SSLServerSocketImpl(this.system, n, n2, inetAddress);
        }
        SSLServerSocketImpl sSLServerSocketImpl = new SSLServerSocketImpl(this.system);
        sSLServerSocketImpl.bindNioChannel(n, n2, inetAddress);
        return sSLServerSocketImpl;
    }

    public String[] getDefaultCipherSuites() {
        return this.defaultSuites;
    }

    public String[] getSupportedCipherSuites() {
        SSLServerSocketFactoryImpl sSLServerSocketFactoryImpl = this;
        return sSLServerSocketFactoryImpl.system.getSupportedCipherSuites();
    }
}

