/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl.impl;

import com.bea.sslplus.SSLNioSocket;
import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.impl.SSLSocketImpl;

public final class SSLServerSocketImpl
extends SSLServerSocket {
    TLSSystem system;
    boolean useClientMode = false;
    boolean enableSessionCreation = true;
    boolean needClientAuth = false;
    private boolean bNio = false;
    private ServerSocketChannel ssc;
    private ServerSocket delegateSock = null;

    public boolean isNioEnabled() {
        return this.bNio;
    }

    SSLServerSocketImpl(TLSSystem tLSSystem) throws IOException {
        this.system = tLSSystem;
    }

    protected void bindNioChannel(int n, int n2, InetAddress inetAddress) throws IOException {
        this.bNio = true;
        this.ssc = ServerSocketChannel.open();
        this.ssc.configureBlocking(true);
        ServerSocket serverSocket = this.ssc.socket();
        InetSocketAddress inetSocketAddress = inetAddress != null ? new InetSocketAddress(inetAddress, n) : new InetSocketAddress(n);
        if (n2 > 0) {
            serverSocket.bind(inetSocketAddress, n2);
        } else {
            serverSocket.bind(inetSocketAddress);
        }
        this.delegateSock = serverSocket;
    }

    public ServerSocketChannel getChannel() {
        if (this.bNio) {
            return this.ssc;
        }
        return super.getChannel();
    }

    SSLServerSocketImpl(TLSSystem tLSSystem, int n) throws IOException {
        super(n);
        this.system = tLSSystem;
    }

    SSLServerSocketImpl(TLSSystem tLSSystem, int n, int n2) throws IOException {
        super(n, n2);
        this.system = tLSSystem;
    }

    SSLServerSocketImpl(TLSSystem tLSSystem, int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.system = tLSSystem;
    }

    public void setEnabledProtocols(String[] stringArray) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".setEnabledProtocols(String[])");
    }

    public String[] getEnabledProtocols() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getEnabledProtocols()");
    }

    public String[] getSupportedProtocols() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getSupportedProtocols()");
    }

    public boolean getWantClientAuth() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getWantClientAuth()");
    }

    public void setWantClientAuth(boolean bl) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".setWantClientAuth(boolean)");
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.system.setEnabledCipherSuites(stringArray);
    }

    public void setUseClientMode(boolean bl) {
        this.useClientMode = bl;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        if (this.isNioEnabled()) {
            SocketChannel socketChannel = this.ssc.accept();
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Accepted collection from client: " + socketChannel.socket().getInetAddress().getHostAddress(), null);
            }
            socketChannel.configureBlocking(true);
            boolean bl = true;
            SSLNioSocket sSLNioSocket = null;
            try {
                Socket socket = socketChannel.socket();
                sSLNioSocket = new SSLNioSocket(socket, this.system, socket.getInetAddress().getHostAddress(), socket.getPort(), true, true);
                sSLNioSocket.setEnableSessionCreation(this.enableSessionCreation);
                sSLNioSocket.setNeedClientAuth(this.needClientAuth);
                bl = false;
                SSLNioSocket sSLNioSocket2 = sSLNioSocket;
                return sSLNioSocket2;
            }
            finally {
                if (bl && sSLNioSocket != null) {
                    sSLNioSocket.close();
                }
            }
        }
        SSLSocketImpl sSLSocketImpl = null;
        boolean bl = true;
        try {
            sSLSocketImpl = new SSLSocketImpl(this.system);
            this.implAccept(sSLSocketImpl);
            sSLSocketImpl.resetConnection(this.useClientMode);
            sSLSocketImpl.setEnableSessionCreation(this.enableSessionCreation);
            sSLSocketImpl.setNeedClientAuth(this.needClientAuth);
            bl = false;
            SSLSocketImpl sSLSocketImpl2 = sSLSocketImpl;
            return sSLSocketImpl2;
        }
        finally {
            if (bl && sSLSocketImpl != null) {
                sSLSocketImpl.close();
            }
        }
    }

    public String[] getSupportedCipherSuites() {
        SSLServerSocketImpl sSLServerSocketImpl = this;
        return sSLServerSocketImpl.system.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.system.getAuthenticatedEnabledCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.delegateSock == null) {
            super.bind(socketAddress);
        } else {
            this.delegateSock.bind(socketAddress);
        }
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (this.delegateSock == null) {
            super.bind(socketAddress, n);
        } else {
            this.delegateSock.bind(socketAddress, n);
        }
    }

    public InetAddress getInetAddress() {
        if (this.delegateSock == null) {
            return super.getInetAddress();
        }
        return this.delegateSock.getInetAddress();
    }

    public int getLocalPort() {
        if (this.delegateSock == null) {
            return super.getLocalPort();
        }
        return this.delegateSock.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.delegateSock == null) {
            return super.getLocalSocketAddress();
        }
        return this.delegateSock.getLocalSocketAddress();
    }

    public void close() throws IOException {
        if (this.delegateSock == null) {
            super.close();
        } else {
            this.delegateSock.close();
        }
    }

    public boolean isBound() {
        if (this.delegateSock == null) {
            return super.isBound();
        }
        return this.delegateSock.isBound();
    }

    public boolean isClosed() {
        if (this.delegateSock == null) {
            return super.isClosed();
        }
        return this.delegateSock.isClosed();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.delegateSock == null) {
            super.setSoTimeout(n);
        } else {
            this.delegateSock.setSoTimeout(n);
        }
    }

    public synchronized int getSoTimeout() throws IOException {
        if (this.delegateSock == null) {
            return super.getSoTimeout();
        }
        return this.delegateSock.getSoTimeout();
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.delegateSock == null) {
            super.setReuseAddress(bl);
        } else {
            this.delegateSock.setReuseAddress(bl);
        }
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.delegateSock == null) {
            return super.getReuseAddress();
        }
        return this.delegateSock.getReuseAddress();
    }

    public String toString() {
        if (this.delegateSock == null) {
            return super.toString();
        }
        return this.delegateSock.toString();
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        if (this.delegateSock == null) {
            super.setReceiveBufferSize(n);
        } else {
            this.delegateSock.setReceiveBufferSize(n);
        }
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.delegateSock == null) {
            return super.getReceiveBufferSize();
        }
        return this.delegateSock.getReceiveBufferSize();
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
        if (this.delegateSock == null) {
            super.setPerformancePreferences(n, n2, n3);
        } else {
            this.delegateSock.setPerformancePreferences(n, n2, n3);
        }
    }
}

