/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl.impl;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.net.ssl.SSLSessionExtension;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import java.security.Principal;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.impl.SSLSessionContextImpl;
import javax.security.cert.X509Certificate;

public final class SSLSessionImpl
implements SSLSessionExtension {
    private TLSSessionImpl session;

    public SSLSessionImpl(TLSSessionImpl tLSSessionImpl) {
        this.session = tLSSessionImpl;
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public void putValue(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
        this.session.putValue(string, object);
    }

    public void removeValue(String string) {
        Object object = this.session.removeValue(string);
        if (object instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    public TLSSessionImpl getTLSSession() {
        return this.session;
    }

    public byte[] getId() {
        return this.session.getSessionID().getID();
    }

    public SSLSessionContext getSessionContext() {
        return new SSLSessionContextImpl(this.session.getSessionDB());
    }

    public long getCreationTime() {
        return this.session.getCreationTime().getTime();
    }

    public long getLastAccessedTime() {
        return this.session.getLastConnectionCreationTime().getTime();
    }

    public Object getValue(String string) {
        return this.session.getValue(string);
    }

    public String[] getValueNames() {
        return this.session.getValueNames();
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificates();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        X509Certificate[] x509CertificateArray = null;
        Certificate[] certificateArray = this.session.getPeerCertificates();
        if (certificateArray != null) {
            try {
                x509CertificateArray = new X509Certificate[certificateArray.length];
                for (int i = 0; i < certificateArray.length; ++i) {
                    x509CertificateArray[i] = X509Certificate.getInstance(certificateArray[i].getEncoded());
                }
            }
            catch (Exception exception) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, "Failed to convert peer certificate chain", exception);
                }
                throw new RuntimeException("Failed to convert peer certificate chain");
            }
        }
        return x509CertificateArray;
    }

    public Certificate[] getLocalCertificates() {
        return this.session.getPeerCertificates();
    }

    public String getProtocol() {
        return this.session.getProtocol();
    }

    public int getApplicationBufferSize() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getApplicationBufferSize()");
    }

    public int getPacketBufferSize() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getPacketBufferSize()");
    }

    public int getPeerPort() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getPeerport()");
    }

    public Principal getLocalPrincipal() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getLocalPrincipal()");
    }

    public Principal getPeerPrincipal() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getPeerPrincipal()");
    }

    public boolean isValid() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".isValid()");
    }

    public String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    public String getPeerHost() {
        return this.session.getPeerID().toString();
    }

    public byte[] getMasterSecret() {
        return this.session.getMasterSecret();
    }

    public String getProtocolVersion() {
        return this.session.getProtocolVersion().toString();
    }
}

