/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl.impl;

import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.impl.SSLLayeredSocket;
import javax.net.ssl.impl.SSLSocketImpl;

public final class SSLSocketFactoryImpl
extends SSLSocketFactory {
    private TLSSystem system;
    private String[] defaultSuites;

    public SSLSocketFactoryImpl() {
        this.system = new TLSSystem();
        this.defaultSuites = this.system.getEnabledCipherSuites();
    }

    public SSLSocketFactoryImpl(TLSSystem tLSSystem) {
        this.system = tLSSystem;
        this.defaultSuites = tLSSystem.getEnabledCipherSuites();
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return new SSLSocketImpl(this.system, string, n);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return new SSLSocketImpl(this.system, inetAddress, n);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return new SSLSocketImpl(this.system, string, n, inetAddress, n2);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return new SSLSocketImpl(this.system, inetAddress, n, inetAddress2, n2);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return new SSLLayeredSocket(socket, this.system, string, n, bl);
    }

    public String[] getDefaultCipherSuites() {
        return this.defaultSuites;
    }

    public String[] getSupportedCipherSuites() {
        SSLSocketFactoryImpl sSLSocketFactoryImpl = this;
        return sSLSocketFactoryImpl.system.getSupportedCipherSuites();
    }
}

