/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl.impl;

import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.impl.HandshakeListenerShunt;
import javax.net.ssl.impl.SSLSessionImpl;
import javax.net.ssl.impl.StringID;

public final class SSLSocketImpl
extends SSLSocket {
    private TLSSystem system;
    private TLSConnectionImpl connection = null;

    SSLSocketImpl(TLSSystem tLSSystem) {
        this.system = tLSSystem;
    }

    SSLSocketImpl(TLSSystem tLSSystem, String string, int n) throws IOException, UnknownHostException {
        super(string, n);
        this.system = tLSSystem;
        this.resetConnection(true);
    }

    SSLSocketImpl(TLSSystem tLSSystem, InetAddress inetAddress, int n) throws IOException, UnknownHostException {
        super(inetAddress, n);
        this.system = tLSSystem;
        this.resetConnection(true);
    }

    SSLSocketImpl(TLSSystem tLSSystem, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        super(string, n, inetAddress, n2);
        this.system = tLSSystem;
        this.resetConnection(true);
    }

    SSLSocketImpl(TLSSystem tLSSystem, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException, UnknownHostException {
        super(inetAddress, n, inetAddress2, n2);
        this.system = tLSSystem;
        this.resetConnection(true);
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.connection.setEnabledProtocols(stringArray);
    }

    public String[] getEnabledProtocols() {
        return this.connection.getEnabledProtocols();
    }

    public String[] getSupportedProtocols() {
        return this.connection.getSupportedProtocols();
    }

    public boolean getWantClientAuth() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getWantClientAuth()");
    }

    public void setWantClientAuth(boolean bl) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".setWantClientAuth(boolean)");
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.connection.setEnabledCipherSuites(stringArray);
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        HandshakeListenerShunt handshakeListenerShunt = new HandshakeListenerShunt(handshakeCompletedListener, this);
        this.connection.addHandshakeCompletedListener(handshakeListenerShunt);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        HandshakeListenerShunt handshakeListenerShunt = new HandshakeListenerShunt(handshakeCompletedListener, this);
        this.connection.removeHandshakeCompletedListener(handshakeListenerShunt);
    }

    public void startHandshake() throws IOException {
        this.connection.completeHandshake();
    }

    public void setUseClientMode(boolean bl) {
        this.connection.setClient(bl);
    }

    public void setNeedClientAuth(boolean bl) {
        this.connection.setNeedClientAuth(bl);
    }

    public void setEnableSessionCreation(boolean bl) {
        this.connection.setEnableSessionCreation(bl);
    }

    void resetConnection(boolean bl) throws IOException {
        InputStream inputStream = super.getInputStream();
        OutputStream outputStream = super.getOutputStream();
        String string = this.getInetAddress().getHostAddress() + ":" + this.getPort();
        try {
            super.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            throw new ProtocolException(socketException.getMessage());
        }
        this.connection = bl ? (TLSConnectionImpl)this.system.createClient((SSLSocket)this, inputStream, outputStream, (Serializable)new StringID(string)) : (TLSConnectionImpl)this.system.createServer((SSLSocket)this, inputStream, outputStream, (Serializable)new StringID(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        finally {
            super.close();
        }
    }

    public String[] getSupportedCipherSuites() {
        SSLSocketImpl sSLSocketImpl = this;
        return sSLSocketImpl.system.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.connection.getEnabledCipherSuites();
    }

    public SSLSession getSession() {
        return new SSLSessionImpl((TLSSessionImpl)this.connection.getSession());
    }

    public boolean getUseClientMode() {
        return this.connection.isClient();
    }

    public boolean getNeedClientAuth() {
        return this.connection.getNeedClientAuth();
    }

    public boolean getEnableSessionCreation() {
        return this.connection.getEnableSessionCreation();
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(this.connection.toString());
        return stringBuffer.toString();
    }
}

