/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.util.Vector;
import netscape.ldap.util.BadFilterException;
import netscape.ldap.util.LDAPFilter;

public class LDAPIntFilterList {
    private Vector m_vFilter;
    private String m_strMatchPattern;
    private Perl5Pattern m_patMatch = null;
    private Perl5Matcher m_matcher;
    private Perl5Compiler m_compiler;

    LDAPIntFilterList(LDAPFilter lDAPFilter) throws BadFilterException {
        this.m_strMatchPattern = lDAPFilter.getMatchPattern();
        this.m_matcher = new Perl5Matcher();
        this.m_compiler = new Perl5Compiler();
        try {
            this.m_patMatch = (Perl5Pattern)this.m_compiler.compile(this.m_strMatchPattern);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new BadFilterException("The Regular Expression for this filter is bad. Line number: " + lDAPFilter.getLineNumber());
        }
        this.m_vFilter = new Vector();
        this.m_vFilter.addElement(lDAPFilter);
    }

    void AddFilter(LDAPFilter lDAPFilter) {
        this.m_vFilter.addElement(lDAPFilter);
    }

    boolean MatchFilter(PatternMatcherInput patternMatcherInput) {
        patternMatcherInput.setCurrentOffset(patternMatcherInput.getBeginOffset());
        return this.m_matcher.contains(patternMatcherInput, (Pattern)this.m_patMatch);
    }

    LDAPFilter getFilter(int n) {
        return (LDAPFilter)this.m_vFilter.elementAt(n);
    }

    int numFilters() {
        return this.m_vFilter.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("    Match Pattern: \"" + this.m_strMatchPattern + "\"\n");
        int n = 0;
        while (n < this.m_vFilter.size()) {
            stringBuffer.append(((LDAPFilter)this.m_vFilter.elementAt(n)).toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

