/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.util.Vector;
import netscape.ldap.util.BadFilterException;
import netscape.ldap.util.LDAPFilter;
import netscape.ldap.util.LDAPIntFilterList;

public class LDAPIntFilterSet {
    private Vector m_vLDAPIntFilterList;
    private String m_strTag;
    private PatternMatcherInput m_matcherTag = null;
    private Perl5Matcher m_matcher = null;

    public LDAPIntFilterSet(String string) {
        this.m_strTag = string;
        this.m_vLDAPIntFilterList = new Vector();
    }

    void appendFilter(LDAPFilter lDAPFilter) {
        ((LDAPIntFilterList)this.m_vLDAPIntFilterList.lastElement()).AddFilter(lDAPFilter);
    }

    Vector getFilters(Perl5Pattern perl5Pattern, PatternMatcherInput patternMatcherInput) {
        Vector<LDAPFilter> vector = new Vector<LDAPFilter>();
        if (this.m_matcherTag == null) {
            this.m_matcher = new Perl5Matcher();
            this.m_matcherTag = new PatternMatcherInput(this.m_strTag);
        } else {
            this.m_matcherTag.setCurrentOffset(this.m_matcherTag.getBeginOffset());
        }
        if (this.m_matcher.contains(this.m_matcherTag, (Pattern)perl5Pattern)) {
            int n = 0;
            while (n < this.m_vLDAPIntFilterList.size()) {
                LDAPIntFilterList lDAPIntFilterList = (LDAPIntFilterList)this.m_vLDAPIntFilterList.elementAt(n);
                if (lDAPIntFilterList.MatchFilter(patternMatcherInput)) {
                    int n2 = 0;
                    while (n2 < lDAPIntFilterList.numFilters()) {
                        vector.addElement(lDAPIntFilterList.getFilter(n2));
                        ++n2;
                    }
                    return vector;
                }
                ++n;
            }
        }
        return vector;
    }

    boolean match(String string) {
        Perl5Pattern perl5Pattern;
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            perl5Pattern = (Perl5Pattern)perl5Compiler.compile(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            return false;
        }
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(this.m_strTag);
        return perl5Matcher.contains(patternMatcherInput, (Pattern)perl5Pattern);
    }

    void newFilter(LDAPFilter lDAPFilter) throws BadFilterException {
        LDAPIntFilterList lDAPIntFilterList = new LDAPIntFilterList(lDAPFilter);
        this.m_vLDAPIntFilterList.addElement(lDAPIntFilterList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("  strTag: " + this.m_strTag + "\n");
        int n = 0;
        while (n < this.m_vLDAPIntFilterList.size()) {
            stringBuffer.append("  filter #: " + n + "\n");
            stringBuffer.append(((LDAPIntFilterList)this.m_vLDAPIntFilterList.elementAt(n)).toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

