/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassOutput;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.DebuggableEngineImpl;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.ListenerArray;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeMath;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebugReader;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.debug.Debugger;

public class Context {
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    static final String defaultResource = "org.mozilla.javascript.resources.Messages";
    static final boolean printTrees = false;
    private static Class codegenClass;
    private static ClassNameHelper nameHelper;
    private static boolean requireSecurityDomain;
    private static boolean resourceMissing;
    static final String securityResourceName = "org.mozilla.javascript.resources.Security";
    static final boolean useJSObject = false;
    NativeCall currentActivation;
    Hashtable iterating;
    Object interpreterSecurityDomain;
    int version;
    int errorCount;
    static boolean isCachingEnabled;
    private SecuritySupport securitySupport;
    private ErrorReporter errorReporter;
    private Thread currentThread;
    private static Hashtable threadContexts;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int optimizationLevel;
    WrapHandler wrapHandler;
    Debugger debugger;
    DebuggableEngine debuggableEngine;
    boolean inLineStepMode;
    Stack frameStack;
    private int enterCount;
    private Object[] listeners;
    private Hashtable hashtable;
    private Hashtable activationNames;
    private static final Object staticDataLock;
    private static Object[] contextListeners;
    int interpreterLine;
    String interpreterSourceFile;
    int instructionCount;
    int instructionThreshold;
    static /* synthetic */ Class class$org$mozilla$javascript$Interpreter;

    static {
        Object object;
        try {
            codegenClass = Class.forName("org.mozilla.javascript.optimizer.Codegen");
            object = Class.forName("org.mozilla.javascript.optimizer.OptClassNameHelper");
            nameHelper = (ClassNameHelper)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            codegenClass = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            codegenClass = null;
        }
        catch (InstantiationException instantiationException) {
            codegenClass = null;
        }
        requireSecurityDomain = true;
        resourceMissing = false;
        try {
            object = ResourceBundle.getBundle(securityResourceName);
            String string = ((ResourceBundle)object).getString("security.requireSecurityDomain");
            requireSecurityDomain = string.equals("true");
        }
        catch (MissingResourceException missingResourceException) {
            requireSecurityDomain = true;
            resourceMissing = true;
        }
        catch (SecurityException securityException) {
            requireSecurityDomain = true;
        }
        isCachingEnabled = true;
        threadContexts = new Hashtable(11);
        staticDataLock = new Object();
    }

    public Context() {
        this.init();
    }

    public Context(SecuritySupport securitySupport) {
        this.securitySupport = securitySupport;
        this.init();
    }

    public void addActivationName(String string) {
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(string, string);
    }

    public static void addContextListener(ContextListener contextListener) {
        Object object = staticDataLock;
        synchronized (object) {
            contextListeners = ListenerArray.add(contextListeners, contextListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.add(this.listeners, propertyChangeListener);
        }
    }

    public static final void checkSecurityDomainRequired() {
        if (requireSecurityDomain) {
            String string = "Required security context not found";
            if (resourceMissing) {
                string = String.valueOf(string) + ". Didn't find properties file at org.mozilla.javascript.resources.Security";
            }
            throw new SecurityException(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Object compile(Scriptable scriptable, Reader reader, String string, int n, Object object, boolean bl) throws IOException {
        if (this.debugger != null && reader != null) {
            reader = new DebugReader(reader);
        }
        TokenStream tokenStream = new TokenStream(reader, scriptable, string, n);
        return this.compile(scriptable, tokenStream, object, reader, bl);
    }

    private Object compile(Scriptable scriptable, TokenStream tokenStream, Object object, Reader reader, boolean bl) throws IOException {
        Object object2;
        Interpreter interpreter = this.optimizationLevel == -1 ? new Interpreter() : this.getCompiler();
        this.errorCount = 0;
        IRFactory iRFactory = interpreter.createIRFactory(tokenStream, nameHelper, scriptable);
        Parser parser2 = new Parser(iRFactory);
        Node node = (Node)parser2.parse(tokenStream);
        if (node == null) {
            return null;
        }
        node = interpreter.transform(node, tokenStream, scriptable);
        if (bl) {
            object2 = node.getFirstChild();
            if (object2 == null) {
                return null;
            }
            node = (Node)((Node)object2).getProp(5);
            if (node == null) {
                return null;
            }
        }
        if (reader instanceof DebugReader) {
            object2 = (DebugReader)reader;
            node.putProp(31, ((DebugReader)object2).getSaved());
        }
        object2 = interpreter.compile(this, scriptable, node, object, this.securitySupport, nameHelper);
        return this.errorCount == 0 ? object2 : null;
    }

    public Function compileFunction(Scriptable scriptable, String string, String string2, int n, Object object) {
        StringReader stringReader = new StringReader(string);
        try {
            return (Function)this.compile(scriptable, stringReader, string2, n, object, true);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public Script compileReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        return (Script)this.compile(scriptable, reader, string, n, object, false);
    }

    public String decompileFunction(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(this, n, false);
        }
        return "function " + function.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public String decompileFunctionBody(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(this, n, true);
        }
        return "[native code]\n";
    }

    public String decompileScript(Script script, Scriptable scriptable, int n) {
        NativeScript nativeScript = (NativeScript)script;
        nativeScript.initScript(scriptable);
        return nativeScript.decompile(this, n, false);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context context) {
        Object[] objectArray;
        Thread thread2 = Thread.currentThread();
        Object[] objectArray2 = (Object[])threadContexts.get(thread2);
        if (objectArray2 != null) {
            objectArray = objectArray2;
            synchronized (objectArray) {
                ++objectArray2.enterCount;
            }
        }
        if (context != null) {
            objectArray = context;
            synchronized (objectArray) {
                if (context.currentThread == null) {
                    context.currentThread = thread2;
                    threadContexts.put(thread2, context);
                    ++context.enterCount;
                }
            }
            objectArray2 = context;
        } else {
            objectArray2 = new Context();
            objectArray2.currentThread = thread2;
            threadContexts.put(thread2, objectArray2);
            objectArray2.enterCount = 1;
        }
        objectArray = contextListeners;
        if (objectArray != null) {
            int n = objectArray.length;
            while (n-- != 0) {
                ((ContextListener)objectArray[n]).contextEntered((Context)objectArray2);
            }
        }
        return objectArray2;
    }

    public Object evaluateReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException, JavaScriptException {
        Script script = this.compileReader(scriptable, reader, string, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public Object evaluateString(Scriptable scriptable, String string, String string2, int n, Object object) throws JavaScriptException {
        try {
            StringReader stringReader = new StringReader(string);
            return this.evaluateReader(scriptable, stringReader, string2, n, object);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public static void exit() {
        Object[] objectArray = Context.getCurrentContext();
        boolean bl = false;
        if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            synchronized (objectArray2) {
                if (--objectArray.enterCount == 0) {
                    threadContexts.remove(objectArray.currentThread);
                    objectArray.currentThread = null;
                    bl = true;
                }
            }
            objectArray2 = contextListeners;
            if (objectArray2 != null) {
                int n = objectArray2.length;
                while (n-- != 0) {
                    ContextListener contextListener = (ContextListener)objectArray2[n];
                    contextListener.contextExited((Context)objectArray);
                    if (!bl) continue;
                    contextListener.contextReleased((Context)objectArray);
                }
            }
        }
    }

    void firePropertyChange(String string, Object object, Object object2) {
        Object[] objectArray = this.listeners;
        if (objectArray != null) {
            this.firePropertyChangeImpl(objectArray, string, object, object2);
        }
    }

    private void firePropertyChangeImpl(Object[] objectArray, String string, Object object, Object object2) {
        int n = objectArray.length;
        while (n-- != 0) {
            Object object3 = objectArray[n];
            if (!(object3 instanceof PropertyChangeListener)) continue;
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object3;
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public ClassOutput getClassOutput() {
        return nameHelper == null ? null : nameHelper.getClassOutput();
    }

    private Interpreter getCompiler() {
        if (codegenClass != null) {
            try {
                return (Interpreter)codegenClass.newInstance();
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return new Interpreter();
    }

    static Context getContext() {
        Thread thread2 = Thread.currentThread();
        Context context = (Context)threadContexts.get(thread2);
        if (context == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return context;
    }

    public static Context getCurrentContext() {
        Thread thread2 = Thread.currentThread();
        return (Context)threadContexts.get(thread2);
    }

    public DebuggableEngine getDebuggableEngine() {
        if (this.debuggableEngine == null) {
            this.debuggableEngine = new DebuggableEngineImpl(this);
        }
        return this.debuggableEngine;
    }

    public Object[] getElements(Scriptable scriptable) {
        double d = NativeArray.getLengthProperty(scriptable);
        if (d != d) {
            return null;
        }
        int n = (int)d;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = scriptable.get(n2, scriptable);
            objectArray[n2] = object == Scriptable.NOT_FOUND ? Undefined.instance : object;
            ++n2;
        }
        return objectArray;
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = new DefaultErrorReporter();
        }
        return this.errorReporter;
    }

    public String getImplementationVersion() {
        return "Rhino 1.5 release 2 2001 07 27";
    }

    public int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public Object getInterpreterSecurityDomain() {
        return this.interpreterSecurityDomain;
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    static String getMessage(String string, Object[] objectArray) {
        String string2;
        Context context = Context.getCurrentContext();
        Locale locale = context != null ? context.getLocale() : Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(defaultResource, locale);
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    static String getMessage0(String string) {
        return Context.getMessage(string, null);
    }

    static String getMessage1(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return Context.getMessage(string, objectArray);
    }

    static String getMessage2(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return Context.getMessage(string, objectArray);
    }

    static String getMessage3(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return Context.getMessage(string, objectArray);
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    RegExpProxy getRegExpProxy() {
        if (this.regExpProxy == null) {
            try {
                Class<?> clazz = Class.forName("org.mozilla.javascript.regexp.RegExpImpl");
                this.regExpProxy = (RegExpProxy)clazz.newInstance();
                return this.regExpProxy;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return this.regExpProxy;
    }

    Object getSecurityDomainForStackDepth(int n) {
        Class[] classArray;
        Object object = null;
        if (this.securitySupport != null && (classArray = this.securitySupport.getClassContext()) != null) {
            if (n != -1) {
                int n2 = n + 1;
                object = this.getSecurityDomainFromClass(classArray[n2]);
            } else {
                int n3 = 1;
                while (n3 < classArray.length) {
                    object = this.getSecurityDomainFromClass(classArray[n3]);
                    if (object != null) break;
                    ++n3;
                }
            }
        }
        if (object != null) {
            return object;
        }
        if (requireSecurityDomain) {
            Context.checkSecurityDomainRequired();
        }
        return null;
    }

    Object getSecurityDomainFromClass(Class clazz) {
        if (clazz == (class$org$mozilla$javascript$Interpreter != null ? class$org$mozilla$javascript$Interpreter : (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")))) {
            return this.interpreterSecurityDomain;
        }
        return this.securitySupport.getSecurityDomain(clazz);
    }

    SecuritySupport getSecuritySupport() {
        return this.securitySupport;
    }

    static String getSourcePositionFromStack(int[] nArray) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            return null;
        }
        if (context.interpreterLine > 0 && context.interpreterSourceFile != null) {
            nArray[0] = context.interpreterLine;
            return context.interpreterSourceFile;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        RuntimeException runtimeException = new RuntimeException();
        runtimeException.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == ':') {
                n3 = n4;
            } else if (c == '(') {
                n = n4;
            } else if (c == ')') {
                n2 = n4;
            } else if (c == '\n' && n != -1 && n2 != -1 && n3 != -1 && n < n3 && n3 < n2) {
                String string2 = string.substring(n + 1, n3);
                if (string2.endsWith(".js")) {
                    String string3 = string.substring(n3 + 1, n2);
                    try {
                        nArray[0] = Integer.parseInt(string3);
                        return string2;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                n3 = -1;
                n2 = -1;
                n = -1;
            }
            ++n4;
        }
        return null;
    }

    public String getTargetClassFileName() {
        return nameHelper == null ? null : nameHelper.getTargetClassFileName();
    }

    public String getTargetPackage() {
        return nameHelper == null ? null : nameHelper.getTargetPackage();
    }

    public Object getThreadLocal(Object object) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(object);
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public WrapHandler getWrapHandler() {
        return this.wrapHandler;
    }

    public boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public boolean hasFeature(int n) {
        if (n == 1) {
            return this.version == 100 || this.version == 110 || this.version == 120;
        }
        throw new RuntimeException("Bad feature index: " + n);
    }

    private void init() {
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
        Object[] objectArray = contextListeners;
        if (objectArray != null) {
            int n = objectArray.length;
            while (n-- != 0) {
                ((ContextListener)objectArray[n]).contextCreated(this);
            }
        }
    }

    public Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        return this.initStandardObjects(scriptableObject, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        if (scriptableObject == null) {
            scriptableObject = new NativeObject();
        }
        BaseFunction.init(this, scriptableObject, bl);
        NativeObject.init(this, scriptableObject, bl);
        Scriptable scriptable = ScriptableObject.getObjectPrototype(scriptableObject);
        Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptableObject);
        scriptable2.setPrototype(scriptable);
        if (scriptableObject.getPrototype() == null) {
            scriptableObject.setPrototype(scriptable);
        }
        NativeError.init(this, scriptableObject, bl);
        NativeGlobal.init(this, scriptableObject, bl);
        NativeArray.init(this, scriptableObject, bl);
        NativeString.init(this, scriptableObject, bl);
        NativeBoolean.init(this, scriptableObject, bl);
        NativeNumber.init(this, scriptableObject, bl);
        NativeDate.init(this, scriptableObject, bl);
        NativeMath.init(this, scriptableObject, bl);
        NativeWith.init(this, scriptableObject, bl);
        NativeCall.init(this, scriptableObject, bl);
        NativeScript.init(this, scriptableObject, bl);
        new LazilyLoadedCtor(scriptableObject, "RegExp", "org.mozilla.javascript.regexp.NativeRegExp", bl);
        new LazilyLoadedCtor(scriptableObject, "Packages", "org.mozilla.javascript.NativeJavaPackage", bl);
        new LazilyLoadedCtor(scriptableObject, "java", "org.mozilla.javascript.NativeJavaPackage", bl);
        new LazilyLoadedCtor(scriptableObject, "getClass", "org.mozilla.javascript.NativeJavaPackage", bl);
        String string = "org.mozilla.javascript.JavaAdapter";
        String string2 = "JavaAdapter";
        try {
            string = System.getProperty(string, string);
            string2 = System.getProperty("org.mozilla.javascript.JavaAdapterClassName", string2);
        }
        catch (SecurityException securityException) {}
        new LazilyLoadedCtor(scriptableObject, string2, string, bl);
        return scriptableObject;
    }

    public boolean isActivationNeeded(String string) {
        if ("arguments".equals(string)) {
            return true;
        }
        return this.activationNames != null && this.activationNames.containsKey(string);
    }

    public boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public boolean isInterpreterClass(Class clazz) {
        return clazz == (class$org$mozilla$javascript$Interpreter != null ? class$org$mozilla$javascript$Interpreter : (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")));
    }

    public static boolean isSecurityDomainRequired() {
        return requireSecurityDomain;
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    public Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    public Scriptable newArray(Scriptable scriptable, Object[] objectArray) {
        NativeArray nativeArray = new NativeArray(objectArray);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    private void newArrayHelper(Scriptable scriptable, Scriptable scriptable2) {
        scriptable2.setParentScope(scriptable);
        Object object = ScriptRuntime.getTopLevelProp(scriptable, "Array");
        if (object != null && object instanceof Scriptable) {
            Scriptable scriptable3 = (Scriptable)object;
            scriptable2.setPrototype((Scriptable)scriptable3.get("prototype", scriptable3));
        }
    }

    public Scriptable newObject(Scriptable scriptable) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, "Object", null);
    }

    public Scriptable newObject(Scriptable scriptable, String string) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, string, null);
    }

    public Scriptable newObject(Scriptable scriptable, String string, Object[] objectArray) throws PropertyException, NotAFunctionException, JavaScriptException {
        Object object = ScriptRuntime.getTopLevelProp(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            String string2 = Context.getMessage1("msg.ctor.not.found", string);
            throw new PropertyException(string2);
        }
        if (!(object instanceof Function)) {
            String string3 = Context.getMessage1("msg.not.ctor", string);
            throw new NotAFunctionException(string3);
        }
        Function function = (Function)object;
        return function.construct(this, function.getParentScope(), objectArray == null ? ScriptRuntime.emptyArgs : objectArray);
    }

    protected void observeInstructionCount(int n) {
    }

    void popFrame() {
        this.frameStack.pop();
    }

    void pushFrame(DebugFrame debugFrame) {
        if (this.frameStack == null) {
            this.frameStack = new Stack();
        }
        this.frameStack.push(debugFrame);
    }

    public void putThreadLocal(Object object, Object object2) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(object, object2);
    }

    public void removeActivationName(String string) {
        if (this.activationNames != null) {
            this.activationNames.remove(string);
        }
    }

    public static void removeContextListener(ContextListener contextListener) {
        Object object = staticDataLock;
        synchronized (object) {
            contextListeners = ListenerArray.remove(contextListeners, contextListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Context context = this;
        synchronized (context) {
            this.listeners = ListenerArray.remove(this.listeners, propertyChangeListener);
        }
    }

    public void removeThreadLocal(Object object) {
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(object);
    }

    public static void reportError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
        } else {
            throw new EvaluatorException(string);
        }
        context.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string);
    }

    static EvaluatorException reportRuntimeError0(String string) {
        return Context.reportRuntimeError(Context.getMessage0(string));
    }

    static EvaluatorException reportRuntimeError1(String string, Object object) {
        return Context.reportRuntimeError(Context.getMessage1(string, object));
    }

    static EvaluatorException reportRuntimeError2(String string, Object object, Object object2) {
        return Context.reportRuntimeError(Context.getMessage2(string, object, object2));
    }

    static EvaluatorException reportRuntimeError3(String string, Object object, Object object2, Object object3) {
        return Context.reportRuntimeError(Context.getMessage3(string, object, object2, object3));
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        context.getErrorReporter().warning(string, string2, n, string3, n2);
    }

    public static void setCachingEnabled(boolean bl) {
        if (isCachingEnabled && !bl) {
            JavaMembers.classTable = new Hashtable();
            nameHelper.reset();
        }
        isCachingEnabled = bl;
        FunctionObject.setCachingEnabled(bl);
    }

    public void setClassOutput(ClassOutput classOutput) {
        if (nameHelper != null) {
            nameHelper.setClassOutput(classOutput);
        }
    }

    public void setCompileFunctionsWithDynamicScope(boolean bl) {
        this.compileFunctionsWithDynamicScopeFlag = bl;
    }

    public ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        ErrorReporter errorReporter2 = this.errorReporter;
        Object[] objectArray = this.listeners;
        if (objectArray != null && this.errorReporter != errorReporter) {
            this.firePropertyChangeImpl(objectArray, errorReporterProperty, this.errorReporter, errorReporter);
        }
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public void setGeneratingDebug(boolean bl) {
        this.generatingDebugChanged = true;
        if (bl) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public void setGeneratingSource(boolean bl) {
        this.generatingSource = bl;
    }

    public void setInstructionObserverThreshold(int n) {
        this.instructionThreshold = n;
    }

    public void setLanguageVersion(int n) {
        Object[] objectArray = this.listeners;
        if (objectArray != null && n != this.version) {
            this.firePropertyChangeImpl(objectArray, languageVersionProperty, new Integer(this.version), new Integer(n));
        }
        this.version = n;
    }

    public Locale setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    public void setOptimizationLevel(int n) {
        if (n < 0) {
            n = -1;
        } else if (n > 9) {
            n = 9;
        }
        if (codegenClass == null) {
            n = -1;
        }
        this.optimizationLevel = n;
    }

    public synchronized void setSecuritySupport(SecuritySupport securitySupport) {
        if (this.securitySupport != null) {
            throw new SecurityException("Cannot overwrite existing SecuritySupport object");
        }
        this.securitySupport = securitySupport;
    }

    public void setTargetClassFileName(String string) {
        if (nameHelper != null) {
            nameHelper.setTargetClassFileName(string);
        }
    }

    public void setTargetExtends(Class clazz) {
        if (nameHelper != null) {
            nameHelper.setTargetExtends(clazz);
        }
    }

    public void setTargetImplements(Class[] classArray) {
        if (nameHelper != null) {
            nameHelper.setTargetImplements(classArray);
        }
    }

    public void setTargetPackage(String string) {
        if (nameHelper != null) {
            nameHelper.setTargetPackage(string);
        }
    }

    public void setWrapHandler(WrapHandler wrapHandler) {
        this.wrapHandler = wrapHandler;
    }

    public synchronized boolean stringIsCompilableUnit(String string) {
        StringReader stringReader = new StringReader(string);
        TokenStream tokenStream = new TokenStream(stringReader, null, null, 1);
        ErrorReporter errorReporter = this.setErrorReporter(new DefaultErrorReporter());
        boolean bl = false;
        try {
            try {
                IRFactory iRFactory = new IRFactory(tokenStream, null);
                Parser parser2 = new Parser(iRFactory);
                parser2.parse(tokenStream);
            }
            catch (IOException iOException) {
                bl = true;
            }
            catch (EvaluatorException evaluatorException) {
                bl = true;
            }
            Object var7_8 = null;
            this.setErrorReporter(errorReporter);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.setErrorReporter(errorReporter);
            throw throwable;
        }
        return !bl || !tokenStream.eof();
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object, null);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable, Class clazz) {
        if (object == null && clazz != null) {
            return null;
        }
        return ScriptRuntime.toObject(scriptable, object, clazz);
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }
}

