/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class FlattenedObject {
    private Scriptable obj;

    public FlattenedObject(Scriptable scriptable) {
        this.obj = scriptable;
    }

    public Object call(Context context, Scriptable scriptable, Object[] objectArray) throws NotAFunctionException, JavaScriptException {
        if (!(this.obj instanceof Function)) {
            throw new NotAFunctionException();
        }
        return ScriptRuntime.call(context, this.obj, scriptable, objectArray, (Function)this.obj);
    }

    public Object callMethod(Object object, Object[] objectArray) throws PropertyException, NotAFunctionException, JavaScriptException {
        if (!this.hasProperty(object)) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        Object object2 = this.getProperty(object);
        if (object2 instanceof FlattenedObject) {
            return ((FlattenedObject)object2).call(Context.getContext(), this.obj, objectArray);
        }
        throw new NotAFunctionException();
    }

    public Scriptable construct(Context context, Object[] objectArray) throws NotAFunctionException, JavaScriptException {
        if (!(this.obj instanceof Function)) {
            throw new NotAFunctionException();
        }
        return ScriptRuntime.newObject(context, (Object)this.obj, objectArray, null);
    }

    public boolean deleteProperty(Object object) {
        String string = ScriptRuntime.getStringId(object);
        if (string == null) {
            int n = ScriptRuntime.getIntId(object);
            Scriptable scriptable = FlattenedObject.getBase(this.obj, n);
            if (scriptable == null) {
                return true;
            }
            scriptable.delete(n);
            return scriptable.has(n, scriptable) ^ true;
        }
        Scriptable scriptable = FlattenedObject.getBase(this.obj, string);
        if (scriptable == null) {
            return true;
        }
        scriptable.delete(string);
        return scriptable.has(string, scriptable) ^ true;
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            if (scriptable2.has(n, scriptable)) {
                return scriptable2;
            }
            scriptable2 = scriptable2.getPrototype();
        }
        return null;
    }

    private static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            if (scriptable2.has(string, scriptable)) {
                return scriptable2;
            }
            scriptable2 = scriptable2.getPrototype();
        }
        return null;
    }

    public Object[] getIds() {
        Object[] objectArray;
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>(11);
        Scriptable scriptable = this.obj;
        while (scriptable != null) {
            objectArray = scriptable.getIds();
            int n = 0;
            while (n < objectArray.length) {
                hashtable.put(objectArray[n], Boolean.TRUE);
                ++n;
            }
            scriptable = scriptable.getPrototype();
        }
        objectArray = hashtable.keys();
        Object[] objectArray2 = new Object[hashtable.size()];
        int n = 0;
        while (objectArray.hasMoreElements()) {
            Object e = objectArray.nextElement();
            objectArray2[n++] = e;
        }
        return objectArray2;
    }

    public Scriptable getObject() {
        return this.obj;
    }

    public Object getProperty(Object object) {
        Object object2;
        block2: {
            String string = ScriptRuntime.getStringId(object);
            int n = string == null ? ScriptRuntime.getIntId(object) : 0;
            Scriptable scriptable = this.obj;
            do {
                Object object3 = object2 = string == null ? scriptable.get(n, this.obj) : scriptable.get(string, this.obj);
                if (object2 != Scriptable.NOT_FOUND) break block2;
            } while ((scriptable = scriptable.getPrototype()) != null);
            return Undefined.instance;
        }
        if (object2 instanceof Scriptable) {
            return new FlattenedObject((Scriptable)object2);
        }
        return object2;
    }

    public boolean hasProperty(Object object) {
        String string = ScriptRuntime.toString(object);
        String string2 = ScriptRuntime.getStringId(string);
        if (string2 == null) {
            return FlattenedObject.getBase(this.obj, ScriptRuntime.getIntId(string)) != null;
        }
        return FlattenedObject.getBase(this.obj, string2) != null;
    }

    public void putProperty(Object object, Object object2) {
        String string = ScriptRuntime.getStringId(object);
        if (object2 instanceof FlattenedObject) {
            object2 = ((FlattenedObject)object2).getObject();
        }
        if (string == null) {
            int n = ScriptRuntime.getIntId(object);
            Scriptable scriptable = FlattenedObject.getBase(this.obj, n);
            if (scriptable == null) {
                scriptable = this.obj;
            }
            scriptable.put(n, this.obj, object2);
            return;
        }
        Scriptable scriptable = FlattenedObject.getBase(this.obj, string);
        if (scriptable == null) {
            scriptable = this.obj;
        }
        scriptable.put(string, this.obj, object2);
    }
}

