/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class IdScriptable
extends ScriptableObject
implements IdFunctionMaster {
    protected static final Object NULL_TAG = new Object();
    private int maxId;
    private Object[] idMapData;
    private byte[] attributesArray;
    private static final boolean CACHE_NAMES = true;
    private int lastIdCache;
    private static final int USE_DYNAMIC_SCOPE_FLAG = 1;
    private static final int SEAL_FUNCTIONS_FLAG = 2;
    private byte setupFlags;
    private byte extraIdAttributes;

    public IdScriptable() {
        this.activateIdMap(this.maxInstanceId());
    }

    protected void activateIdMap(int n) {
        this.maxId = n;
    }

    public void addAsPrototype(int n, Context context, Scriptable scriptable, boolean bl) {
        this.activateIdMap(n);
        this.setSealFunctionsFlag(bl);
        this.setFunctionParametrs(context);
        int n2 = this.mapNameToId("constructor");
        if (n2 == 0) {
            throw new RuntimeException("No id for constructor property");
        }
        IdFunction idFunction = this.newIdFunction(n2);
        idFunction.initAsConstructor(scriptable, this);
        this.fillConstructorProperties(context, idFunction, bl);
        if (bl) {
            idFunction.sealObject();
            idFunction.addPropertyAttribute(1);
        }
        this.setParentScope(idFunction);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.cacheIdValue(n2, idFunction);
        if (bl) {
            this.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, this.getClassName(), idFunction, 2);
    }

    protected void addIdFunctionProperty(Scriptable scriptable, int n, boolean bl) {
        IdFunction idFunction = this.newIdFunction(n);
        if (bl) {
            idFunction.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, this.getIdName(n), idFunction, 2);
    }

    synchronized void addPropertyAttribute(int n) {
        this.extraIdAttributes = (byte)(this.extraIdAttributes | (byte)n);
        super.addPropertyAttribute(n);
    }

    protected Object cacheIdValue(int n, Object object) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] objectArray = this.ensureIdData();
            Object object2 = objectArray[n - 1];
            if (object2 == null) {
                objectArray[n - 1] = object != null ? object : NULL_TAG;
            } else {
                object = object2;
            }
        }
        return object;
    }

    public void defineProperty(String string, Object object, int n) {
        int n2;
        if (this.maxId != 0 && (n2 = this.mapNameToId(string)) != 0) {
            int n3 = this.getIdDefaultAttributes(n2);
            if ((n3 & 1) != 0) {
                throw new RuntimeException("Attempt to redefine read-only id " + string);
            }
            this.setAttributes(n2, n);
            this.setIdValue(n2, object);
            return;
        }
        super.defineProperty(string, object, n);
    }

    public void delete(String string) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0 && !this.isSealed()) {
            int n2 = this.getAttributes(n);
            if ((n2 & 4) == 0) {
                this.deleteIdValue(n);
            }
            return;
        }
        super.delete(string);
    }

    protected void deleteIdValue(int n) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            this.ensureIdData()[n - 1] = Scriptable.NOT_FOUND;
        }
    }

    private Object[] ensureIdData() {
        Object[] objectArray = this.idMapData;
        if (objectArray == null) {
            objectArray = new Object[this.maxId * 2];
            this.idMapData = objectArray;
        }
        return objectArray;
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        throw IdFunction.onBadMethodId(this, n);
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
    }

    public Object get(String string, Scriptable scriptable) {
        block8: {
            Object object;
            int n;
            Object[] objectArray;
            block10: {
                int n2;
                block9: {
                    n2 = this.maxId;
                    if (n2 == 0) break block8;
                    objectArray = this.idMapData;
                    if (objectArray != null) break block9;
                    int n3 = this.mapNameToId(string);
                    if (n3 != 0) {
                        return this.getIdValue(n3);
                    }
                    break block8;
                }
                n = this.lastIdCache;
                if (objectArray[n - 1 + n2] == string) break block10;
                n = this.mapNameToId(string);
                if (n == 0) break block8;
                objectArray[n - 1 + n2] = string;
                this.lastIdCache = n;
            }
            if ((object = objectArray[n - 1]) == null) {
                object = this.getIdValue(n);
            } else if (object == NULL_TAG) {
                object = null;
            }
            return object;
        }
        return super.get(string, scriptable);
    }

    private int getAttributes(int n) {
        int n2 = this.getIdDefaultAttributes(n) | this.extraIdAttributes;
        byte[] byArray = this.attributesArray;
        if (byArray != null) {
            n2 |= 0xFF & byArray[n - 1];
        }
        return n2;
    }

    public int getAttributes(String string, Scriptable scriptable) throws PropertyException {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0 && this.hasValue(n)) {
            return this.getAttributes(n);
        }
        return super.getAttributes(string, scriptable);
    }

    protected int getIdDefaultAttributes(int n) {
        return 2;
    }

    protected abstract String getIdName(int var1);

    protected Object getIdValue(int n) {
        IdFunction idFunction = this.newIdFunction(n);
        idFunction.setParentScope(this.getParentScope());
        return this.cacheIdValue(n, idFunction);
    }

    Object[] getIds(boolean bl) {
        Object[] objectArray = super.getIds(bl);
        if (this.maxId != 0) {
            Object[] objectArray2 = null;
            int n = 0;
            int n2 = this.maxId;
            while (n2 != 0) {
                if (this.hasValue(n2) && (bl || (this.getAttributes(n2) & 2) == 0)) {
                    if (n == 0) {
                        objectArray2 = new Object[n2];
                    }
                    objectArray2[n++] = this.getIdName(n2);
                }
                --n2;
            }
            if (n != 0) {
                if (objectArray.length == 0 && objectArray2.length == n) {
                    objectArray = objectArray2;
                } else {
                    Object[] objectArray3 = new Object[objectArray.length + n];
                    System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                    System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, n);
                    objectArray = objectArray3;
                }
            }
        }
        return objectArray;
    }

    public boolean has(String string, Scriptable scriptable) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0) {
            return this.hasValue(n);
        }
        return super.has(string, scriptable);
    }

    protected boolean hasIdValue(int n) {
        return true;
    }

    private boolean hasValue(int n) {
        Object object;
        Object[] objectArray = this.idMapData;
        if (objectArray == null || (object = objectArray[n - 1]) == null) {
            return this.hasIdValue(n);
        }
        return object != Scriptable.NOT_FOUND;
    }

    protected abstract int mapNameToId(String var1);

    protected int maxInstanceId() {
        return 0;
    }

    public int methodArity(int n) {
        return -1;
    }

    protected IdFunction newIdFunction(int n) {
        IdFunction idFunction = new IdFunction(this, this.getIdName(n), n);
        if ((this.setupFlags & 2) != 0) {
            idFunction.sealObject();
        }
        return idFunction;
    }

    protected Scriptable nextInstanceCheck(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        if (bl && (this.setupFlags & 1) != 0 && (scriptable = scriptable.getPrototype()) != null) {
            return scriptable;
        }
        throw NativeGlobal.typeError1("msg.incompat.call", idFunction.getFunctionName(), idFunction);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0) {
            int n2 = this.getAttributes(n);
            if ((n2 & 1) == 0) {
                if (scriptable == this) {
                    this.setIdValue(n, object);
                } else {
                    scriptable.put(string, scriptable, object);
                }
            }
            return;
        }
        super.put(string, scriptable, object);
    }

    private void setAttributes(int n, int n2) {
        int n3 = this.getIdDefaultAttributes(n);
        if ((n2 & n3) != n3) {
            throw new RuntimeException("Attempt to unset default attributes");
        }
        byte[] byArray = this.attributesArray;
        if (byArray == null && (n2 &= ~n3) != 0) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                byArray = this.attributesArray;
                if (byArray == null) {
                    this.attributesArray = byArray = new byte[this.maxId];
                }
            }
        }
        if (byArray != null) {
            byArray[n - 1] = (byte)n2;
        }
    }

    public void setAttributes(String string, Scriptable scriptable, int n) throws PropertyException {
        int n2;
        if (this.maxId != 0 && (n2 = this.mapNameToId(string)) != 0 && this.hasValue(n2)) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                this.setAttributes(n2, n);
            }
            return;
        }
        super.setAttributes(string, scriptable, n);
    }

    protected void setFunctionParametrs(Context context) {
        this.setSetupFlag(1, context.hasCompileFunctionsWithDynamicScope());
    }

    protected void setIdValue(int n, Object object) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            this.ensureIdData()[n - 1] = object != null ? object : NULL_TAG;
        }
    }

    protected void setSealFunctionsFlag(boolean bl) {
        this.setSetupFlag(2, bl);
    }

    private void setSetupFlag(int n, boolean bl) {
        this.setupFlags = (byte)(bl ? this.setupFlags | n : this.setupFlags & ~n);
    }

    protected final Object wrap_boolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected final Object wrap_double(double d) {
        return d == d ? new Double(d) : ScriptRuntime.NaNobj;
    }

    protected final Object wrap_int(int n) {
        byte by = (byte)n;
        if (by == n) {
            return new Byte(by);
        }
        return new Integer(n);
    }

    protected final Object wrap_long(long l) {
        int n = (int)l;
        if ((long)n == l) {
            return this.wrap_int(n);
        }
        return new Long(l);
    }
}

