/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeMath
extends IdScriptable {
    private static final int Id_abs = 1;
    private static final int Id_acos = 2;
    private static final int Id_asin = 3;
    private static final int Id_atan = 4;
    private static final int Id_atan2 = 5;
    private static final int Id_ceil = 6;
    private static final int Id_cos = 7;
    private static final int Id_exp = 8;
    private static final int Id_floor = 9;
    private static final int Id_log = 10;
    private static final int Id_max = 11;
    private static final int Id_min = 12;
    private static final int Id_pow = 13;
    private static final int Id_random = 14;
    private static final int Id_round = 15;
    private static final int Id_sin = 16;
    private static final int Id_sqrt = 17;
    private static final int Id_tan = 18;
    private static final int LAST_METHOD_ID = 18;
    private static final int Id_E = 19;
    private static final int Id_PI = 20;
    private static final int Id_LN10 = 21;
    private static final int Id_LN2 = 22;
    private static final int Id_LOG2E = 23;
    private static final int Id_LOG10E = 24;
    private static final int Id_SQRT1_2 = 25;
    private static final int Id_SQRT2 = 26;
    private static final int MAX_INSTANCE_ID = 26;
    private static final double E = Math.E;
    private static final double PI = Math.PI;
    private static final double LN10 = 2.302585092994046;
    private static final double LN2 = 0.6931471805599453;
    private static final double LOG2E = 1.4426950408889634;
    private static final double LOG10E = 0.4342944819032518;
    private static final double SQRT1_2 = 0.7071067811865476;
    private static final double SQRT2 = 1.4142135623730951;

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        switch (n) {
            case 1: {
                return this.wrap_double(this.js_abs(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 2: {
                return this.wrap_double(this.js_acos(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 3: {
                return this.wrap_double(this.js_asin(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 4: {
                return this.wrap_double(this.js_atan(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 5: {
                return this.wrap_double(this.js_atan2(ScriptRuntime.toNumber(objectArray, 0), ScriptRuntime.toNumber(objectArray, 1)));
            }
            case 6: {
                return this.wrap_double(this.js_ceil(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 7: {
                return this.wrap_double(this.js_cos(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 8: {
                return this.wrap_double(this.js_exp(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 9: {
                return this.wrap_double(this.js_floor(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 10: {
                return this.wrap_double(this.js_log(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 11: {
                return this.wrap_double(this.js_max(objectArray));
            }
            case 12: {
                return this.wrap_double(this.js_min(objectArray));
            }
            case 13: {
                return this.wrap_double(this.js_pow(ScriptRuntime.toNumber(objectArray, 0), ScriptRuntime.toNumber(objectArray, 1)));
            }
            case 14: {
                return this.wrap_double(this.js_random());
            }
            case 15: {
                return this.wrap_double(this.js_round(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 16: {
                return this.wrap_double(this.js_sin(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 17: {
                return this.wrap_double(this.js_sqrt(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 18: {
                return this.wrap_double(this.js_tan(ScriptRuntime.toNumber(objectArray, 0)));
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    public String getClassName() {
        return "Math";
    }

    private double getField(int n) {
        switch (n) {
            case 19: {
                return Math.E;
            }
            case 20: {
                return Math.PI;
            }
            case 21: {
                return 2.302585092994046;
            }
            case 22: {
                return 0.6931471805599453;
            }
            case 23: {
                return 1.4426950408889634;
            }
            case 24: {
                return 0.4342944819032518;
            }
            case 25: {
                return 0.7071067811865476;
            }
            case 26: {
                return 1.4142135623730951;
            }
        }
        return 0.0;
    }

    protected int getIdDefaultAttributes(int n) {
        if (n > 18) {
            return 7;
        }
        return super.getIdDefaultAttributes(n);
    }

    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "abs";
            }
            case 2: {
                return "acos";
            }
            case 3: {
                return "asin";
            }
            case 4: {
                return "atan";
            }
            case 5: {
                return "atan2";
            }
            case 6: {
                return "ceil";
            }
            case 7: {
                return "cos";
            }
            case 8: {
                return "exp";
            }
            case 9: {
                return "floor";
            }
            case 10: {
                return "log";
            }
            case 11: {
                return "max";
            }
            case 12: {
                return "min";
            }
            case 13: {
                return "pow";
            }
            case 14: {
                return "random";
            }
            case 15: {
                return "round";
            }
            case 16: {
                return "sin";
            }
            case 17: {
                return "sqrt";
            }
            case 18: {
                return "tan";
            }
            case 19: {
                return "E";
            }
            case 20: {
                return "PI";
            }
            case 21: {
                return "LN10";
            }
            case 22: {
                return "LN2";
            }
            case 23: {
                return "LOG2E";
            }
            case 24: {
                return "LOG10E";
            }
            case 25: {
                return "SQRT1_2";
            }
            case 26: {
                return "SQRT2";
            }
        }
        return null;
    }

    protected Object getIdValue(int n) {
        if (n > 18) {
            return this.cacheIdValue(n, this.wrap_double(this.getField(n)));
        }
        return super.getIdValue(n);
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeMath nativeMath = new NativeMath();
        nativeMath.setSealFunctionsFlag(bl);
        nativeMath.setFunctionParametrs(context);
        nativeMath.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        nativeMath.setParentScope(scriptable);
        if (bl) {
            nativeMath.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "Math", nativeMath, 2);
    }

    private double js_abs(double d) {
        return d == 0.0 ? 0.0 : (d < 0.0 ? -d : d);
    }

    private double js_acos(double d) {
        return d == d && d >= -1.0 && d <= 1.0 ? Math.acos(d) : Double.NaN;
    }

    private double js_asin(double d) {
        return d == d && d >= -1.0 && d <= 1.0 ? Math.asin(d) : Double.NaN;
    }

    private double js_atan(double d) {
        return Math.atan(d);
    }

    private double js_atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    private double js_ceil(double d) {
        return Math.ceil(d);
    }

    private double js_cos(double d) {
        return Math.cos(d);
    }

    private double js_exp(double d) {
        return d == Double.POSITIVE_INFINITY ? d : (d == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d));
    }

    private double js_floor(double d) {
        return Math.floor(d);
    }

    private double js_log(double d) {
        return d < 0.0 ? Double.NaN : Math.log(d);
    }

    private double js_max(Object[] objectArray) {
        double d = Double.NEGATIVE_INFINITY;
        if (objectArray.length == 0) {
            return d;
        }
        int n = 0;
        while (n < objectArray.length) {
            double d2 = ScriptRuntime.toNumber(objectArray[n]);
            if (d2 != d2) {
                return d2;
            }
            d = Math.max(d, d2);
            ++n;
        }
        return d;
    }

    private double js_min(Object[] objectArray) {
        double d = Double.POSITIVE_INFINITY;
        if (objectArray.length == 0) {
            return d;
        }
        int n = 0;
        while (n < objectArray.length) {
            double d2 = ScriptRuntime.toNumber(objectArray[n]);
            if (d2 != d2) {
                return d2;
            }
            d = Math.min(d, d2);
            ++n;
        }
        return d;
    }

    private double js_pow(double d, double d2) {
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d == 0.0 && d2 < 0.0) {
            if (1.0 / d > 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            int n = (int)d2;
            if ((double)n == d2 && (n & 1) != 0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Math.pow(d, d2);
    }

    private double js_random() {
        return Math.random();
    }

    private double js_round(double d) {
        if (d != d) {
            return d;
        }
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        long l = Math.round(d);
        if (l == 0L) {
            if (d < 0.0) {
                return ScriptRuntime.negativeZero;
            }
            return d == 0.0 ? d : 0.0;
        }
        return l;
    }

    private double js_sin(double d) {
        return Math.sin(d);
    }

    private double js_sqrt(double d) {
        return Math.sqrt(d);
    }

    private double js_tan(double d) {
        return Math.tan(d);
    }

    /*
     * Exception decompiling
     */
    protected int mapNameToId(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int maxInstanceId() {
        return 26;
    }

    public int methodArity(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 1;
            }
            case 18: {
                return 1;
            }
        }
        return super.methodArity(n);
    }
}

