/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Source;
import org.mozilla.javascript.TokenStream;

class Parser {
    private int lastExprEndLine;
    private IRFactory nf;
    private ErrorReporter er;
    private boolean ok;

    public Parser(IRFactory iRFactory) {
        this.nf = iRFactory;
    }

    private Object addExpr(TokenStream tokenStream, Source source) throws IOException, JavaScriptException {
        int n;
        Object object = this.mulExpr(tokenStream, source);
        while ((n = tokenStream.getToken()) == 23 || n == 24) {
            source.append((char)n);
            object = this.nf.createBinary(n, object, this.mulExpr(tokenStream, source));
        }
        tokenStream.ungetToken(n);
        return object;
    }

    private Object andExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitOrExpr(tokenStream, source, bl);
        if (tokenStream.matchToken(101)) {
            source.append('e');
            object = this.nf.createBinary(101, object, this.andExpr(tokenStream, source, bl));
        }
        return object;
    }

    private Object argumentList(TokenStream tokenStream, Source source, Object object) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        boolean bl = tokenStream.matchToken(95);
        tokenStream.flags &= 0xFFFFFFEF;
        if (!bl) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    source.append('`');
                }
                bl2 = false;
                this.nf.addChildToBack(object, this.assignExpr(tokenStream, source, false));
            } while (tokenStream.matchToken(96));
            this.mustMatchToken(tokenStream, 95, "msg.no.paren.arg");
        }
        source.append('_');
        return object;
    }

    private Object assignExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.condExpr(tokenStream, source, bl);
        if (tokenStream.matchToken(97)) {
            source.append('a');
            source.append((char)tokenStream.getOp());
            object = this.nf.createBinary(97, tokenStream.getOp(), object, this.assignExpr(tokenStream, source, bl));
        }
        return object;
    }

    private Object bitAndExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.eqExpr(tokenStream, source, bl);
        while (tokenStream.matchToken(13)) {
            source.append('\r');
            object = this.nf.createBinary(13, object, this.eqExpr(tokenStream, source, bl));
        }
        return object;
    }

    private Object bitOrExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitXorExpr(tokenStream, source, bl);
        while (tokenStream.matchToken(11)) {
            source.append('\u000b');
            object = this.nf.createBinary(11, object, this.bitXorExpr(tokenStream, source, bl));
        }
        return object;
    }

    private Object bitXorExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitAndExpr(tokenStream, source, bl);
        while (tokenStream.matchToken(12)) {
            source.append('\f');
            object = this.nf.createBinary(12, object, this.bitAndExpr(tokenStream, source, bl));
        }
        return object;
    }

    private Object condExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.orExpr(tokenStream, source, bl);
        if (tokenStream.matchToken(98)) {
            source.append('b');
            Object object2 = this.assignExpr(tokenStream, source, false);
            this.mustMatchToken(tokenStream, 99, "msg.no.colon.cond");
            source.append('c');
            Object object3 = this.assignExpr(tokenStream, source, bl);
            return this.nf.createTernary(object, object2, object3);
        }
        return object;
    }

    private Object condition(TokenStream tokenStream, Source source) throws IOException, JavaScriptException {
        this.mustMatchToken(tokenStream, 94, "msg.no.paren.cond");
        source.append('^');
        Object object = this.expr(tokenStream, source, false);
        this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.cond");
        source.append('_');
        return object;
    }

    private Object eqExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.relExpr(tokenStream, source, bl);
        while (tokenStream.matchToken(102)) {
            source.append('f');
            source.append((char)tokenStream.getOp());
            object = this.nf.createBinary(102, tokenStream.getOp(), object, this.relExpr(tokenStream, source, bl));
        }
        return object;
    }

    private Object expr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.assignExpr(tokenStream, source, bl);
        while (tokenStream.matchToken(96)) {
            source.append('`');
            object = this.nf.createBinary(96, object, this.assignExpr(tokenStream, source, bl));
        }
        return object;
    }

    private Object function(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        String string = null;
        Object object = this.nf.createLeaf(94);
        int n = tokenStream.getLineno();
        source.append('n');
        source.append(source.functionNumber);
        source.functionNumber = (char)(source.functionNumber + '\u0001');
        source = new Source();
        source.append('n');
        if (tokenStream.matchToken(44)) {
            string = tokenStream.getString();
            source.addString(44, string);
        }
        this.mustMatchToken(tokenStream, 94, "msg.no.paren.parms");
        source.append('^');
        if (!tokenStream.matchToken(95)) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    source.append('`');
                }
                bl2 = false;
                this.mustMatchToken(tokenStream, 44, "msg.no.parm");
                String string2 = tokenStream.getString();
                this.nf.addChildToBack(object, this.nf.createName(string2));
                source.addString(44, string2);
            } while (tokenStream.matchToken(96));
            this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.parms");
        }
        source.append('_');
        this.mustMatchToken(tokenStream, 92, "msg.no.brace.body");
        source.append('\\');
        source.append('\u0001');
        Object object2 = this.parseFunctionBody(tokenStream, source);
        this.mustMatchToken(tokenStream, 93, "msg.no.brace.after.body");
        source.append(']');
        return this.nf.createFunction(string, object, object2, tokenStream.getSourceName(), n, tokenStream.getLineno(), source.buf.toString(), bl);
    }

    private String matchLabel(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n = tokenStream.getLineno();
        String string = null;
        int n2 = tokenStream.peekTokenSameLine();
        if (n2 == 44) {
            tokenStream.getToken();
            string = tokenStream.getString();
        }
        if (n == tokenStream.getLineno()) {
            this.wellTerminated(tokenStream, -1);
        }
        return string;
    }

    private Object memberExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object;
        tokenStream.flags |= 0x10;
        int n = tokenStream.peekToken();
        tokenStream.flags &= 0xFFFFFFEF;
        if (n == 30) {
            tokenStream.getToken();
            source.append('\u001e');
            object = this.nf.createLeaf(30);
            this.nf.addChildToBack(object, this.memberExpr(tokenStream, source, false));
            if (tokenStream.matchToken(94)) {
                source.append('^');
                object = this.argumentList(tokenStream, source, object);
            }
            if ((n = tokenStream.peekToken()) == 92) {
                this.nf.addChildToBack(object, this.primaryExpr(tokenStream, source));
            }
        } else {
            object = this.primaryExpr(tokenStream, source);
        }
        this.lastExprEndLine = tokenStream.getLineno();
        while ((n = tokenStream.getToken()) > 0) {
            if (n == 108) {
                source.append('l');
                this.mustMatchToken(tokenStream, 44, "msg.no.name.after.dot");
                String string = tokenStream.getString();
                source.addString(44, string);
                object = this.nf.createBinary(108, object, this.nf.createName(tokenStream.getString()));
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            if (n == 90) {
                source.append('Z');
                object = this.nf.createBinary(90, object, this.expr(tokenStream, source, false));
                this.mustMatchToken(tokenStream, 91, "msg.no.bracket.index");
                source.append('[');
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            if (bl && n == 94) {
                object = this.nf.createUnary(43, object);
                source.append('^');
                object = this.argumentList(tokenStream, source, object);
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            tokenStream.ungetToken(n);
            break;
        }
        return object;
    }

    private Object mulExpr(TokenStream tokenStream, Source source) throws IOException, JavaScriptException {
        int n;
        Object object = this.unaryExpr(tokenStream, source);
        while ((n = tokenStream.peekToken()) == 25 || n == 26 || n == 27) {
            n = tokenStream.getToken();
            source.append((char)n);
            object = this.nf.createBinary(n, object, this.unaryExpr(tokenStream, source));
        }
        return object;
    }

    private void mustMatchToken(TokenStream tokenStream, int n, String string) throws IOException, JavaScriptException {
        int n2 = tokenStream.getToken();
        if (n2 != n) {
            this.reportError(tokenStream, string);
            tokenStream.ungetToken(n2);
        }
    }

    private Object orExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.andExpr(tokenStream, source, bl);
        if (tokenStream.matchToken(100)) {
            source.append('d');
            object = this.nf.createBinary(100, object, this.orExpr(tokenStream, source, bl));
        }
        return object;
    }

    public Object parse(TokenStream tokenStream) throws IOException {
        this.ok = true;
        Source source = new Source();
        int n = tokenStream.getLineno();
        Object object = this.nf.createLeaf(133);
        while (true) {
            tokenStream.flags |= 0x10;
            int n2 = tokenStream.getToken();
            tokenStream.flags &= 0xFFFFFFEF;
            if (n2 <= 0) break;
            if (n2 == 110) {
                try {
                    this.nf.addChildToBack(object, this.function(tokenStream, source, false));
                    source.append('\u0001');
                    this.wellTerminated(tokenStream, 110);
                    continue;
                }
                catch (JavaScriptException javaScriptException) {
                    this.ok = false;
                    break;
                }
            }
            tokenStream.ungetToken(n2);
            this.nf.addChildToBack(object, this.statement(tokenStream, source));
        }
        if (!this.ok) {
            return null;
        }
        Object object2 = this.nf.createScript(object, tokenStream.getSourceName(), n, tokenStream.getLineno(), source.buf.toString());
        return object2;
    }

    private Object parseFunctionBody(TokenStream tokenStream, Source source) throws IOException {
        int n = tokenStream.flags;
        tokenStream.flags &= 0xFFFFFFF3;
        tokenStream.flags |= 2;
        Object object = this.nf.createBlock(tokenStream.getLineno());
        try {
            try {
                int n2;
                while ((n2 = tokenStream.peekToken()) > 0 && n2 != 93) {
                    if (n2 == 110) {
                        tokenStream.getToken();
                        this.nf.addChildToBack(object, this.function(tokenStream, source, false));
                        source.append('\u0001');
                        this.wellTerminated(tokenStream, 110);
                        continue;
                    }
                    this.nf.addChildToBack(object, this.statement(tokenStream, source));
                }
            }
            catch (JavaScriptException javaScriptException) {
                this.ok = false;
            }
            Object var6_6 = null;
            tokenStream.flags = n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            tokenStream.flags = n;
            throw throwable;
        }
        return object;
    }

    private Object primaryExpr(TokenStream tokenStream, Source source) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        int n = tokenStream.getToken();
        tokenStream.flags &= 0xFFFFFFEF;
        switch (n) {
            case 110: {
                return this.function(tokenStream, source, true);
            }
            case 90: {
                source.append('Z');
                Object object = this.nf.createLeaf(134);
                tokenStream.flags |= 0x10;
                boolean bl = tokenStream.matchToken(91);
                tokenStream.flags &= 0xFFFFFFEF;
                if (!bl) {
                    boolean bl2 = true;
                    do {
                        tokenStream.flags |= 0x10;
                        n = tokenStream.peekToken();
                        tokenStream.flags &= 0xFFFFFFEF;
                        if (!bl2) {
                            source.append('`');
                        } else {
                            bl2 = false;
                        }
                        if (n == 91) break;
                        if (n == 96) {
                            this.nf.addChildToBack(object, this.nf.createLeaf(109, 74));
                            continue;
                        }
                        this.nf.addChildToBack(object, this.assignExpr(tokenStream, source, false));
                    } while (tokenStream.matchToken(96));
                    this.mustMatchToken(tokenStream, 91, "msg.no.bracket.arg");
                }
                source.append('[');
                return this.nf.createArrayLiteral(object);
            }
            case 92: {
                Object object = this.nf.createLeaf(135);
                source.append('\\');
                if (!tokenStream.matchToken(93)) {
                    boolean bl = true;
                    block19: do {
                        Object object2;
                        if (!bl) {
                            source.append('`');
                        } else {
                            bl = false;
                        }
                        n = tokenStream.getToken();
                        switch (n) {
                            case 44: 
                            case 46: {
                                String string = tokenStream.getString();
                                source.addString(44, string);
                                object2 = this.nf.createString(tokenStream.getString());
                                break;
                            }
                            case 45: {
                                Number number = tokenStream.getNumber();
                                source.addNumber(number);
                                object2 = this.nf.createNumber(number);
                                break;
                            }
                            case 93: {
                                tokenStream.ungetToken(n);
                                break block19;
                            }
                            default: {
                                this.reportError(tokenStream, "msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(tokenStream, 99, "msg.no.colon.prop");
                        source.append('\u0087');
                        this.nf.addChildToBack(object, object2);
                        this.nf.addChildToBack(object, this.assignExpr(tokenStream, source, false));
                    } while (tokenStream.matchToken(96));
                    this.mustMatchToken(tokenStream, 93, "msg.no.brace.prop");
                }
                source.append(']');
                return this.nf.createObjectLiteral(object);
            }
            case 94: {
                source.append('^');
                Object object = this.expr(tokenStream, source, false);
                source.append('_');
                this.mustMatchToken(tokenStream, 95, "msg.no.paren");
                return object;
            }
            case 44: {
                String string = tokenStream.getString();
                source.addString(44, string);
                return this.nf.createName(string);
            }
            case 45: {
                Number number = tokenStream.getNumber();
                source.addNumber(number);
                return this.nf.createNumber(number);
            }
            case 46: {
                String string = tokenStream.getString();
                source.addString(46, string);
                return this.nf.createString(string);
            }
            case 56: {
                String string = tokenStream.regExpFlags;
                tokenStream.regExpFlags = null;
                String string2 = tokenStream.getString();
                source.addString(56, String.valueOf('/') + string2 + '/' + string);
                return this.nf.createRegExp(string2, string);
            }
            case 109: {
                source.append('m');
                source.append((char)tokenStream.getOp());
                return this.nf.createLeaf(109, tokenStream.getOp());
            }
            case 127: {
                this.reportError(tokenStream, "msg.reserved.id");
                break;
            }
            default: {
                this.reportError(tokenStream, "msg.syntax");
            }
            case -1: 
        }
        return null;
    }

    private Object relExpr(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.shiftExpr(tokenStream, source);
        while (tokenStream.matchToken(103)) {
            int n = tokenStream.getOp();
            if (bl && n == 63) {
                tokenStream.ungetToken(103);
                break;
            }
            source.append('g');
            source.append((char)n);
            object = this.nf.createBinary(103, n, object, this.shiftExpr(tokenStream, source));
        }
        return object;
    }

    private void reportError(TokenStream tokenStream, String string) throws JavaScriptException {
        this.ok = false;
        tokenStream.reportSyntaxError(string, null);
        throw new JavaScriptException((Object)string);
    }

    private Object shiftExpr(TokenStream tokenStream, Source source) throws IOException, JavaScriptException {
        Object object = this.addExpr(tokenStream, source);
        while (tokenStream.matchToken(104)) {
            source.append('h');
            source.append((char)tokenStream.getOp());
            object = this.nf.createBinary(tokenStream.getOp(), object, this.addExpr(tokenStream, source));
        }
        return object;
    }

    private Object statement(TokenStream tokenStream, Source source) throws IOException {
        try {
            return this.statementHelper(tokenStream, source);
        }
        catch (JavaScriptException javaScriptException) {
            int n;
            int n2 = tokenStream.getLineno();
            while ((n = tokenStream.getToken()) != 89 && n != 1 && n != 0 && n != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error"), n2);
        }
    }

    private Object statementHelper(TokenStream tokenStream, Source source) throws IOException, JavaScriptException {
        Object object = null;
        boolean bl = false;
        int n = 0;
        int n2 = tokenStream.getToken();
        switch (n2) {
            case 113: {
                bl = true;
                source.append('q');
                int n3 = tokenStream.getLineno();
                Object object2 = this.condition(tokenStream, source);
                source.append('\\');
                source.append('\u0001');
                Object object3 = this.statement(tokenStream, source);
                Object object4 = null;
                if (tokenStream.matchToken(114)) {
                    source.append(']');
                    source.append('r');
                    source.append('\\');
                    source.append('\u0001');
                    object4 = this.statement(tokenStream, source);
                }
                source.append(']');
                source.append('\u0001');
                object = this.nf.createIf(object2, object3, object4, n3);
                break;
            }
            case 115: {
                bl = true;
                source.append('s');
                object = this.nf.createSwitch(tokenStream.getLineno());
                Object object5 = null;
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.switch");
                source.append('^');
                this.nf.addChildToBack(object, this.expr(tokenStream, source, false));
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.switch");
                source.append('_');
                this.mustMatchToken(tokenStream, 92, "msg.no.brace.switch");
                source.append('\\');
                source.append('\u0001');
                while ((n2 = tokenStream.getToken()) != 93 && n2 != 0) {
                    switch (n2) {
                        case 116: {
                            source.append('t');
                            object5 = this.nf.createUnary(116, this.expr(tokenStream, source, false));
                            source.append('c');
                            source.append('\u0001');
                            break;
                        }
                        case 117: {
                            object5 = this.nf.createLeaf(117);
                            source.append('u');
                            source.append('c');
                            source.append('\u0001');
                            break;
                        }
                        default: {
                            this.reportError(tokenStream, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(tokenStream, 99, "msg.no.colon.case");
                    Object object6 = this.nf.createLeaf(133);
                    while ((n2 = tokenStream.peekToken()) != 93 && n2 != 116 && n2 != 117 && n2 != 0) {
                        this.nf.addChildToBack(object6, this.statement(tokenStream, source));
                    }
                    this.nf.addChildToBack(object5, object6);
                    this.nf.addChildToBack(object, object5);
                }
                source.append(']');
                source.append('\u0001');
                break;
            }
            case 118: {
                bl = true;
                source.append('v');
                int n4 = tokenStream.getLineno();
                Object object7 = this.condition(tokenStream, source);
                source.append('\\');
                source.append('\u0001');
                Object object8 = this.statement(tokenStream, source);
                source.append(']');
                source.append('\u0001');
                object = this.nf.createWhile(object7, object8, n4);
                break;
            }
            case 119: {
                source.append('w');
                source.append('\\');
                source.append('\u0001');
                int n5 = tokenStream.getLineno();
                Object object9 = this.statement(tokenStream, source);
                source.append(']');
                this.mustMatchToken(tokenStream, 118, "msg.no.while.do");
                source.append('v');
                Object object10 = this.condition(tokenStream, source);
                object = this.nf.createDoWhile(object9, object10, n5);
                break;
            }
            case 120: {
                Object object11;
                Object object12;
                bl = true;
                source.append('x');
                int n6 = tokenStream.getLineno();
                Object object13 = null;
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.for");
                source.append('^');
                n2 = tokenStream.peekToken();
                if (n2 == 89) {
                    object12 = this.nf.createLeaf(132);
                } else if (n2 == 123) {
                    tokenStream.getToken();
                    object12 = this.variables(tokenStream, source, true);
                } else {
                    object12 = this.expr(tokenStream, source, true);
                }
                n2 = tokenStream.peekToken();
                if (n2 == 103 && tokenStream.getOp() == 63) {
                    tokenStream.matchToken(103);
                    source.append('?');
                    object11 = this.expr(tokenStream, source, false);
                } else {
                    this.mustMatchToken(tokenStream, 89, "msg.no.semi.for");
                    source.append('Y');
                    object11 = tokenStream.peekToken() == 89 ? this.nf.createLeaf(132) : this.expr(tokenStream, source, false);
                    this.mustMatchToken(tokenStream, 89, "msg.no.semi.for.cond");
                    source.append('Y');
                    object13 = tokenStream.peekToken() == 95 ? this.nf.createLeaf(132) : this.expr(tokenStream, source, false);
                }
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.for.ctrl");
                source.append('_');
                source.append('\\');
                source.append('\u0001');
                Object object14 = this.statement(tokenStream, source);
                source.append(']');
                source.append('\u0001');
                if (object13 == null) {
                    object = this.nf.createForIn(object12, object11, object14, n6);
                    break;
                }
                object = this.nf.createFor(object12, object11, object13, object14, n6);
                break;
            }
            case 75: {
                int n7 = tokenStream.getLineno();
                Object object15 = null;
                Object object16 = null;
                bl = true;
                source.append('K');
                source.append('\\');
                source.append('\u0001');
                Object object17 = this.statement(tokenStream, source);
                source.append(']');
                source.append('\u0001');
                object15 = this.nf.createLeaf(133);
                boolean bl2 = false;
                int n8 = tokenStream.peekToken();
                if (n8 == 125) {
                    while (tokenStream.matchToken(125)) {
                        if (bl2) {
                            this.reportError(tokenStream, "msg.catch.unreachable");
                        }
                        source.append('}');
                        this.mustMatchToken(tokenStream, 94, "msg.no.paren.catch");
                        source.append('^');
                        this.mustMatchToken(tokenStream, 44, "msg.bad.catchcond");
                        String string = tokenStream.getString();
                        source.addString(44, string);
                        Object object18 = null;
                        if (tokenStream.matchToken(113)) {
                            source.append('q');
                            object18 = this.expr(tokenStream, source, false);
                        } else {
                            bl2 = true;
                        }
                        this.mustMatchToken(tokenStream, 95, "msg.bad.catchcond");
                        source.append('_');
                        this.mustMatchToken(tokenStream, 92, "msg.no.brace.catchblock");
                        source.append('\\');
                        source.append('\u0001');
                        this.nf.addChildToBack(object15, this.nf.createCatch(string, object18, this.statements(tokenStream, source), tokenStream.getLineno()));
                        this.mustMatchToken(tokenStream, 93, "msg.no.brace.after.body");
                        source.append(']');
                        source.append('\u0001');
                    }
                } else if (n8 != 126) {
                    this.mustMatchToken(tokenStream, 126, "msg.try.no.catchfinally");
                }
                if (tokenStream.matchToken(126)) {
                    source.append('~');
                    source.append('\\');
                    source.append('\u0001');
                    object16 = this.statement(tokenStream, source);
                    source.append(']');
                    source.append('\u0001');
                }
                object = this.nf.createTryCatchFinally(object17, object15, object16, n7);
                break;
            }
            case 62: {
                int n9 = tokenStream.getLineno();
                source.append('>');
                object = this.nf.createThrow(this.expr(tokenStream, source, false), n9);
                if (n9 != tokenStream.getLineno()) break;
                this.wellTerminated(tokenStream, -1);
                break;
            }
            case 121: {
                int n10 = tokenStream.getLineno();
                source.append('y');
                String string = this.matchLabel(tokenStream);
                if (string != null) {
                    source.addString(44, string);
                }
                object = this.nf.createBreak(string, n10);
                break;
            }
            case 122: {
                int n11 = tokenStream.getLineno();
                source.append('z');
                String string = this.matchLabel(tokenStream);
                if (string != null) {
                    source.addString(44, string);
                }
                object = this.nf.createContinue(string, n11);
                break;
            }
            case 124: {
                bl = true;
                source.append('|');
                int n12 = tokenStream.getLineno();
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.with");
                source.append('^');
                Object object19 = this.expr(tokenStream, source, false);
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.with");
                source.append('_');
                source.append('\\');
                source.append('\u0001');
                Object object20 = this.statement(tokenStream, source);
                source.append(']');
                source.append('\u0001');
                object = this.nf.createWith(object19, object20, n12);
                break;
            }
            case 123: {
                int n13 = tokenStream.getLineno();
                object = this.variables(tokenStream, source, false);
                if (tokenStream.getLineno() != n13) break;
                this.wellTerminated(tokenStream, -1);
                break;
            }
            case 5: {
                Object object21 = null;
                int n14 = 0;
                source.append('\u0005');
                if ((tokenStream.flags & 2) == 0) {
                    this.reportError(tokenStream, "msg.bad.return");
                }
                tokenStream.flags |= 0x10;
                n2 = tokenStream.peekTokenSameLine();
                tokenStream.flags &= 0xFFFFFFEF;
                if (n2 != 0 && n2 != 1 && n2 != 89 && n2 != 93) {
                    n14 = tokenStream.getLineno();
                    object21 = this.expr(tokenStream, source, false);
                    if (tokenStream.getLineno() == n14) {
                        this.wellTerminated(tokenStream, -1);
                    }
                    tokenStream.flags |= 4;
                } else {
                    tokenStream.flags |= 8;
                }
                object = this.nf.createReturn(object21, n14);
                break;
            }
            case 92: {
                bl = true;
                object = this.statements(tokenStream, source);
                this.mustMatchToken(tokenStream, 93, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 89: {
                object = this.nf.createLeaf(132);
                bl = true;
                break;
            }
            default: {
                n = n2;
                int n15 = tokenStream.getTokenno();
                tokenStream.ungetToken(n2);
                int n16 = tokenStream.getLineno();
                object = this.expr(tokenStream, source, false);
                if (tokenStream.peekToken() == 99) {
                    if (n != 44 || tokenStream.getTokenno() != n15) {
                        this.reportError(tokenStream, "msg.bad.label");
                    }
                    tokenStream.getToken();
                    String string = tokenStream.getString();
                    object = this.nf.createLabel(string, n16);
                    source.append('c');
                    source.append('\u0001');
                    return object;
                }
                if (n == 110) {
                    this.nf.setFunctionExpressionStatement(object);
                }
                object = this.nf.createExprStatement(object, n16);
                if (tokenStream.getLineno() != n16 && (n != 110 || tokenStream.getLineno() != this.lastExprEndLine)) break;
                this.wellTerminated(tokenStream, n);
            }
        }
        tokenStream.matchToken(89);
        if (!bl) {
            source.append('Y');
            source.append('\u0001');
        }
        return object;
    }

    private Object statements(TokenStream tokenStream, Source source) throws IOException {
        int n;
        Object object = this.nf.createBlock(tokenStream.getLineno());
        while ((n = tokenStream.peekToken()) > 0 && n != 93) {
            this.nf.addChildToBack(object, this.statement(tokenStream, source));
        }
        return object;
    }

    private Object unaryExpr(TokenStream tokenStream, Source source) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        int n = tokenStream.getToken();
        tokenStream.flags &= 0xFFFFFFEF;
        switch (n) {
            case 105: {
                source.append('i');
                source.append((char)tokenStream.getOp());
                return this.nf.createUnary(105, tokenStream.getOp(), this.unaryExpr(tokenStream, source));
            }
            case 23: 
            case 24: {
                source.append('i');
                source.append((char)n);
                return this.nf.createUnary(105, n, this.unaryExpr(tokenStream, source));
            }
            case 106: 
            case 107: {
                source.append((char)n);
                return this.nf.createUnary(n, 130, this.memberExpr(tokenStream, source, true));
            }
            case 31: {
                source.append('\u001f');
                return this.nf.createUnary(31, this.unaryExpr(tokenStream, source));
            }
            default: {
                tokenStream.ungetToken(n);
                int n2 = tokenStream.getLineno();
                Object object = this.memberExpr(tokenStream, source, true);
                int n3 = tokenStream.peekToken();
                if ((n3 == 106 || n3 == 107) && tokenStream.getLineno() == n2) {
                    int n4 = tokenStream.getToken();
                    source.append((char)n4);
                    return this.nf.createUnary(n4, 131, object);
                }
                return object;
            }
            case -1: 
        }
        return this.nf.createName("err");
    }

    private Object variables(TokenStream tokenStream, Source source, boolean bl) throws IOException, JavaScriptException {
        Object object = this.nf.createVariables(tokenStream.getLineno());
        boolean bl2 = true;
        source.append('{');
        do {
            this.mustMatchToken(tokenStream, 44, "msg.bad.var");
            String string = tokenStream.getString();
            if (!bl2) {
                source.append('`');
            }
            bl2 = false;
            source.addString(44, string);
            Object object2 = this.nf.createName(string);
            if (tokenStream.matchToken(97)) {
                if (tokenStream.getOp() != 128) {
                    this.reportError(tokenStream, "msg.bad.var.init");
                }
                source.append('a');
                source.append('\u0080');
                Object object3 = this.assignExpr(tokenStream, source, bl);
                this.nf.addChildToBack(object2, object3);
            }
            this.nf.addChildToBack(object, object2);
        } while (tokenStream.matchToken(96));
        return object;
    }

    private boolean wellTerminated(TokenStream tokenStream, int n) throws IOException, JavaScriptException {
        int n2 = tokenStream.peekTokenSameLine();
        if (n2 == -1) {
            return false;
        }
        if (n2 != 0 && n2 != 1 && n2 != 89 && n2 != 93) {
            int n3 = Context.getContext().getLanguageVersion();
            if ((n2 == 110 || n == 110) && n3 < 120) {
                return true;
            }
            this.reportError(tokenStream, "msg.no.semi.stmt");
        }
        return true;
    }
}

